/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;
import oracle.sdovis.util.Base64InputStream;

public class ImageUtils {
    private static final Component sComponent = new Component(){};
    private static final MediaTracker sTracker = new MediaTracker(sComponent);
    private static int sID = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean waitForImage(Image image, long l) {
        int n;
        Component component = sComponent;
        synchronized (component) {
            n = sID++;
        }
        sTracker.addImage(image, n);
        try {
            sTracker.waitForID(n, l);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace(System.err);
            return false;
        }
        return !sTracker.isErrorID(n);
    }

    public static boolean waitForImage(Image image) {
        return ImageUtils.waitForImage(image, 0L);
    }

    public static void removeImageFromTracker(Image image) {
        if (image != null) {
            sTracker.removeImage(image);
        }
    }

    public static Image blockingLoad(String string, long l) {
        Image image = Toolkit.getDefaultToolkit().getImage(string);
        if (!ImageUtils.waitForImage(image, l)) {
            return null;
        }
        return image;
    }

    public static Image blockingLoad(String string) {
        return ImageUtils.blockingLoad(string, 0L);
    }

    public static Image blockingLoad(URL uRL, long l) {
        Image image = Toolkit.getDefaultToolkit().getImage(uRL);
        if (!ImageUtils.waitForImage(image, l)) {
            return null;
        }
        return image;
    }

    public static Image blockingLoad(URL uRL) {
        return ImageUtils.blockingLoad(uRL, 0L);
    }

    public static BufferedImage makeBufferedImage(Image image) {
        return ImageUtils.makeBufferedImage(image, 1);
    }

    public static BufferedImage makeBufferedImage(Image image, int n) {
        if (!ImageUtils.waitForImage(image)) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), n);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, null, null);
        return bufferedImage;
    }

    public static int[] grabPixels(Image image, int n, int n2) {
        int[] nArray = new int[n * n2];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n, n2, nArray, 0, n);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            System.err.println("interrupted waiting for pixels!");
            return null;
        }
        if ((pixelGrabber.getStatus() & 0x80) != 0) {
            System.err.println("image fetch aborted or error detected");
            return null;
        }
        return nArray;
    }

    public static Frame getNonClearingFrame(String string, Component component) {
        final Frame frame = new Frame(string){

            public void update(Graphics graphics) {
                this.paint(graphics);
            }
        };
        ImageUtils.sizeContainerToComponent(frame, component);
        ImageUtils.centerFrame(frame);
        frame.setLayout(new BorderLayout());
        frame.add(component, "Center");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                frame.dispose();
            }
        });
        return frame;
    }

    public static void sizeContainerToComponent(Container container, Component component) {
        if (!container.isDisplayable()) {
            container.addNotify();
        }
        Insets insets = container.getInsets();
        Dimension dimension = component.getPreferredSize();
        int n = insets.left + insets.right + dimension.width;
        int n2 = insets.top + insets.bottom + dimension.height;
        container.setSize(n, n2);
    }

    public static void centerFrame(Frame frame) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = frame.getSize();
        int n = (dimension.width - dimension2.width) / 2;
        int n2 = (dimension.height - dimension2.height) / 2;
        frame.setLocation(n, n2);
    }

    public static Image loadFromBase64(String string) {
        try {
            Base64InputStream base64InputStream = new Base64InputStream(new ByteArrayInputStream(string.getBytes()));
            byte[] byArray = new byte[65535];
            int n = base64InputStream.read(byArray);
            if (n <= 0) {
                return null;
            }
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, 0, n);
            return Toolkit.getDefaultToolkit().createImage(byArray2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public static BufferedImage duplicateBufferedImage(BufferedImage bufferedImage, int n, int n2) {
        ColorModel colorModel = bufferedImage.getColorModel();
        int[] nArray = ImageUtils.grabPixels(bufferedImage, n, n2);
        MemoryImageSource memoryImageSource = new MemoryImageSource(n, n2, colorModel, nArray, 0, n);
        SampleModel sampleModel = colorModel.createCompatibleSampleModel(n, n2);
        DataBufferInt dataBufferInt = new DataBufferInt(nArray, n * n2);
        WritableRaster writableRaster = WritableRaster.createWritableRaster(sampleModel, dataBufferInt, new Point(0, 0));
        return new BufferedImage(colorModel, writableRaster, false, null);
    }

    public static void main(String[] stringArray) {
        String string = "http://localhost:7777/mapviewer/images/omsmap601.png";
        BufferedImage bufferedImage = new BufferedImage(640, 460, 2);
        Graphics2D graphics2D = (Graphics2D)((Image)bufferedImage).getGraphics();
        graphics2D.drawLine(0, 0, 400, 400);
        graphics2D.dispose();
        ImageUtils.removeImageFromTracker(null);
    }
}

