/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.util;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.logging.Logger;
import oracle.mapviewer.share.style.StyleUtils;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.MapTable;
import oracle.sdovis.ThemeTable;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.style.AllStyleTable;
import oracle.sdovis.style.StyleTable;
import oracle.sdovis.util.Base64OutputStream;
import oracle.sdovis.util.XMLDOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class MMExport {
    static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    static String delim = "|";
    static String ESC = "&#124;";
    static String styleTable = "USER_SDO_STYLES";
    static String themeTable = "USER_SDO_THEMES";
    static String mapTable = "USER_SDO_MAPS";
    static String tileTable = "USER_SDO_CACHED_MAPS";
    static String DS_NAME = "MMExport_temp_ds";
    static String[] baseMapList = null;

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 5 && stringArray.length != 8 && stringArray.length != 6) {
            System.out.println("Usage: java MMExport <host> <sid> <port> <user> <password>\n Or \n       java MMExport <host> <sid> <port> <user> <password> <style_table> <theme_table> <map_table>\n Or \n       java MMExport <host> <sid> <port> <user> <password> maps=basemap1,basemap2");
            System.exit(1);
        }
        if (stringArray.length == 8) {
            styleTable = stringArray[5];
            themeTable = stringArray[6];
            mapTable = stringArray[7];
        }
        System.out.println("metadata tables: " + styleTable + "," + themeTable + "," + mapTable);
        if (stringArray.length == 6) {
            String string = stringArray[5].substring(5);
            baseMapList = string.split(",");
        }
        System.out.println("connecting to " + stringArray[0] + "...");
        DSManager.registerOracleJdbcDS(DS_NAME, stringArray[0], stringArray[2], stringArray[1], stringArray[3], stringArray[4], "thin", 3);
        System.out.println("connected.");
        MMExport.export(stringArray);
        DSManager.remove(DS_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void export(String[] stringArray) throws IOException, SQLException {
        FileOutputStream fileOutputStream = new FileOutputStream("mapmeta.dat");
        PrintStream printStream = new PrintStream(fileOutputStream);
        try {
            if (baseMapList == null) {
                MMExport.exportStyles(printStream, null);
                MMExport.exportThemes(printStream, null, null);
                MMExport.exportMaps(printStream);
            } else {
                MMExport.exportBaseMaps(baseMapList, printStream);
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace(System.err);
        }
        finally {
            printStream.close();
        }
        System.out.println("export of map metadata done. output is mapmeta.dat");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exportMetadata(String string, String string2, boolean bl, boolean bl2, boolean bl3) throws IOException, SQLException {
        if (string == null || string2 == null) {
            return false;
        }
        if (DSManager.get(string) == null) {
            return false;
        }
        DS_NAME = string;
        FileOutputStream fileOutputStream = new FileOutputStream(string2);
        PrintStream printStream = new PrintStream(fileOutputStream);
        try {
            if (bl) {
                MMExport.exportStyles(printStream, null);
            }
            if (bl2) {
                MMExport.exportThemes(printStream, null, null);
            }
            if (bl3) {
                MMExport.exportMaps(printStream);
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace(System.err);
            boolean bl4 = false;
            return bl4;
        }
        finally {
            printStream.close();
        }
        log.info("export of map metadata done. output is " + string2);
        return true;
    }

    public static void exportStyles(PrintStream printStream, Hashtable hashtable) throws SQLException, IOException {
        log.info("exporting styles...");
        printStream.println("--------STYLES BEGIN--------");
        StyleTable styleTable = null;
        styleTable = MMExport.styleTable.equalsIgnoreCase("ALL_SDO_STYLES") ? new AllStyleTable(DS_NAME, MMExport.styleTable) : new StyleTable(DS_NAME, MMExport.styleTable);
        styleTable.query("select * from " + MMExport.styleTable);
        int n = 0;
        while (styleTable.next()) {
            String string = styleTable.getName().toUpperCase();
            if (hashtable != null && hashtable.get(string) == null) continue;
            printStream.println(styleTable.getName() + delim);
            printStream.println(StyleUtils.getTypeNameFromCode(styleTable.getType()) + delim);
            printStream.println(MMExport.escape(styleTable.getDescription()) + delim);
            printStream.println(MMExport.escape(styleTable.getDefinition().toString()) + delim);
            byte[] byArray = styleTable.getImageData();
            if (byArray == null) {
                printStream.println("null" + delim);
            } else {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                Base64OutputStream base64OutputStream = new Base64OutputStream(byteArrayOutputStream, false);
                base64OutputStream.write(byArray);
                base64OutputStream.flush();
                printStream.println(byteArrayOutputStream.toString() + delim);
                base64OutputStream.close();
            }
            ++n;
        }
        styleTable.closeQuery();
        printStream.println("--------STYLES END--------");
        log.info("# of Styles exported: " + n);
    }

    public static void exportThemes(PrintStream printStream, Hashtable hashtable, Hashtable hashtable2) throws SQLException {
        log.info("exporting themes...\n");
        printStream.println("--------THEMES BEGIN--------");
        ThemeTable themeTable = new ThemeTable(DS_NAME, MMExport.themeTable);
        themeTable.query("select * from " + MMExport.themeTable);
        int n = 0;
        while (themeTable.next()) {
            String string = themeTable.getName().toUpperCase();
            if (hashtable != null && hashtable.get(string) == null) continue;
            printStream.println(themeTable.getName() + delim);
            printStream.println(MMExport.escape(themeTable.getDescription()) + delim);
            printStream.println(themeTable.getBaseTable() + delim);
            printStream.println(themeTable.getSpatialColumn() + delim);
            printStream.println(MMExport.escape(themeTable.getStylingRules()) + delim);
            if (hashtable != null && hashtable2 != null) {
                MMExport.populateStyleList(themeTable.getStylingRules(), hashtable2);
            }
            ++n;
        }
        themeTable.closeQuery();
        printStream.println("--------THEMES END--------");
        log.info("# of Themes exported: " + n);
    }

    public static void exportMaps(PrintStream printStream) throws SQLException {
        log.info("exporting base maps...");
        printStream.println("--------MAPS BEGIN--------");
        MapTable mapTable = new MapTable(DS_NAME, MMExport.mapTable);
        mapTable.query("select * from " + MMExport.mapTable);
        int n = 0;
        while (mapTable.next()) {
            printStream.println(mapTable.getName() + delim);
            printStream.println(mapTable.getDescription() + delim);
            printStream.println(mapTable.getMapDefinition() + delim);
            ++n;
        }
        mapTable.closeQuery();
        printStream.println("--------MAPS END--------");
        log.info("# of Base maps exported: " + n);
    }

    public static String escape(String string) {
        if (string == null) {
            return null;
        }
        return string.replaceAll("\\|", "&#124;");
    }

    public static void exportBaseMaps(String[] stringArray, PrintStream printStream) throws SQLException, IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(16000);
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream(16000);
        ByteArrayOutputStream byteArrayOutputStream3 = new ByteArrayOutputStream(4000);
        PrintStream printStream2 = new PrintStream(byteArrayOutputStream3);
        PrintStream printStream3 = new PrintStream(byteArrayOutputStream);
        PrintStream printStream4 = new PrintStream(byteArrayOutputStream2);
        System.out.println("Exporting selected base maps: " + stringArray.length);
        printStream2.println("--------MAPS BEGIN--------");
        MapTable mapTable = new MapTable(DS_NAME, MMExport.mapTable);
        mapTable.query("select * from " + MMExport.mapTable);
        int n = 0;
        Hashtable hashtable = new Hashtable(37);
        Hashtable hashtable2 = new Hashtable(37);
        while (mapTable.next()) {
            String string = mapTable.getName();
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equalsIgnoreCase(string)) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            System.out.print("exporting base map '" + string + "' ...");
            printStream2.println(mapTable.getName() + delim);
            printStream2.println(mapTable.getDescription() + delim);
            printStream2.println(mapTable.getMapDefinition() + delim);
            MMExport.populateThemeList(mapTable.getMapDefinition(), hashtable);
            ++n;
        }
        mapTable.closeQuery();
        printStream2.println("--------MAPS END--------");
        MMExport.exportThemes(printStream4, hashtable, hashtable2);
        MMExport.exportStyles(printStream3, hashtable2);
        System.out.println("" + n);
        printStream2.flush();
        printStream4.flush();
        printStream3.flush();
        byteArrayOutputStream3.close();
        byteArrayOutputStream2.close();
        byteArrayOutputStream.close();
        printStream.println(byteArrayOutputStream.toString());
        printStream.println(byteArrayOutputStream2.toString());
        printStream.println(byteArrayOutputStream3.toString());
    }

    protected static void populateThemeList(String string, Hashtable hashtable) {
        System.out.println("Map definition is:\n" + string);
        XMLDOMParser xMLDOMParser = new XMLDOMParser();
        boolean bl = xMLDOMParser.parse(string);
        if (!bl) {
            System.err.println("Error: cannot parse base map definition!");
            return;
        }
        Document document = xMLDOMParser.getDocument();
        Node node = xMLDOMParser.getElementNode("map_definition");
        ArrayList arrayList = XMLDOMParser.getSubElements(node, "theme");
        if (arrayList == null || arrayList.size() == 0) {
            return;
        }
        int n = 0;
        for (n = 0; n < arrayList.size(); ++n) {
            Node node2 = (Node)arrayList.get(n);
            String string2 = XMLDOMParser.getAttribute(node2, "name");
            hashtable.put(string2.toUpperCase(), string2.toUpperCase());
        }
        System.out.println("" + n + " themes added to list for export.");
    }

    protected static void populateStyleList(String string, Hashtable hashtable) {
        System.out.println("Theme definition is:\n" + string);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        string = string.toUpperCase();
        n = string.indexOf("STYLE=\"");
        while (n > 0) {
            n2 = string.indexOf("\"", n + 8);
            String string2 = string.substring(n + 7, n2);
            hashtable.put(string2, string2);
            ++n3;
            string = string.substring(n2 + 1);
            n = string.indexOf("STYLE=\"");
        }
        System.out.println("" + n3 + " styles added to list for export.");
    }
}

