/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.util;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.util.ChunkStream;

public class PNGMaker {
    public static final int ROW_FILTER_NONE = 0;
    public static final int ROW_FILTER_SUB = 1;
    public static final int ROW_FILTER_UP = 2;
    public static final int ROW_FILTER_AVERAGE = 3;
    public static final int ROW_FILTER_PAETH = 4;
    private static final Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private static final byte[] PNG_MAGIC = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    private static final int COLOR_GRAY = 0;
    private static final int COLOR_RGB = 2;
    private static final int COLOR_PALETTE = 3;
    private static final int COLOR_GRAY_ALPHA = 4;
    private static final int COLOR_RGB_ALPHA = 6;
    private static final int COMPRESSION_DEFLATE = 0;
    private static final int FILTER_ADAPTIVE = 0;
    private static final int INTERLACE_NONE = 0;
    private static final int INTERLACE_ADAM7 = 1;
    private DataOutputStream dos = null;
    private RenderedImage image = null;
    private Deflater deflater = null;
    private int width = 0;
    private int height = 0;
    private int bitDepth = 0;
    private int colorType = 0;
    private int numOutBands = 0;
    private SampleModel sm = null;
    private ColorModel cm = null;
    private Color transparentColor = null;
    private int filterType = 0;

    public PNGMaker(OutputStream outputStream) {
        this.dos = new DataOutputStream(outputStream);
        this.deflater = new Deflater(3);
    }

    public PNGMaker(OutputStream outputStream, int n) {
        this.dos = new DataOutputStream(outputStream);
        this.deflater = new Deflater(n);
    }

    public PNGMaker(OutputStream outputStream, Deflater deflater) {
        this.dos = new DataOutputStream(outputStream);
        this.deflater = deflater;
    }

    public void setTransparentColor(Color color) {
        this.transparentColor = color;
    }

    public void encode(RenderedImage renderedImage) throws IOException {
        this.image = renderedImage;
        this.width = this.image.getWidth();
        this.height = this.image.getHeight();
        this.sm = this.image.getSampleModel();
        this.cm = this.image.getColorModel();
        if (this.cm instanceof IndexColorModel) {
            this.colorType = 3;
            this.bitDepth = ((IndexColorModel)this.cm).getPixelSize();
            this.numOutBands = 1;
        } else if (this.sm.getNumBands() < 3) {
            this.bitDepth = this.cm instanceof ComponentColorModel ? this.cm.getComponentSize(0) : this.sm.getSampleSize(0);
            if (this.cm.hasAlpha()) {
                this.colorType = 4;
                this.numOutBands = 2;
            } else {
                this.colorType = 0;
                this.numOutBands = 1;
            }
        } else {
            this.bitDepth = this.sm.getSampleSize(0);
            if (this.cm.hasAlpha()) {
                this.colorType = 6;
                this.numOutBands = 4;
            } else {
                this.colorType = 2;
                this.numOutBands = 3;
            }
        }
        if (this.bitDepth > 2 && this.bitDepth <= 4) {
            this.bitDepth = 4;
        } else if (this.bitDepth > 4 && this.bitDepth <= 8) {
            this.bitDepth = 8;
        } else if (this.bitDepth > 8 && this.bitDepth <= 16) {
            this.bitDepth = 16;
        } else if (this.bitDepth > 16) {
            throw new RuntimeException("Bit depth too large for PNG encoding");
        }
        this.writeMagic();
        this.writeIHDR();
        this.writePLTE();
        this.writeTRNS();
        this.writeIDAT();
        this.writeIEND();
        this.dos.flush();
        this.dos.close();
        this.transparentColor = null;
    }

    public int getFilterType() {
        return this.filterType;
    }

    public void setFilterType(int n) {
        this.filterType = n;
    }

    private void writeMagic() throws IOException {
        this.dos.write(PNG_MAGIC);
    }

    private void writeIHDR() throws IOException {
        ChunkStream chunkStream = new ChunkStream("IHDR");
        chunkStream.writeInt(this.width);
        chunkStream.writeInt(this.height);
        chunkStream.writeByte(this.bitDepth);
        chunkStream.writeByte(this.colorType);
        chunkStream.writeByte(0);
        chunkStream.writeByte(0);
        chunkStream.writeByte(0);
        chunkStream.writeToStream(this.dos);
    }

    private void writePLTE() throws IOException {
        if (this.colorType != 3) {
            return;
        }
        IndexColorModel indexColorModel = (IndexColorModel)this.cm;
        int n = indexColorModel.getMapSize();
        if (n > 256) {
            throw new RuntimeException("Palette too large for PNG encoding");
        }
        byte[] byArray = new byte[n];
        indexColorModel.getReds(byArray);
        byte[] byArray2 = new byte[n];
        indexColorModel.getGreens(byArray2);
        byte[] byArray3 = new byte[n];
        indexColorModel.getBlues(byArray3);
        ChunkStream chunkStream = new ChunkStream("PLTE");
        for (int i = 0; i < n; ++i) {
            chunkStream.writeByte(byArray[i]);
            chunkStream.writeByte(byArray2[i]);
            chunkStream.writeByte(byArray3[i]);
        }
        chunkStream.writeToStream(this.dos);
    }

    private void writeTRNS() throws IOException {
        if (this.colorType == 3) {
            IndexColorModel indexColorModel = (IndexColorModel)this.cm;
            int n = indexColorModel.getMapSize();
            if (n > 256) {
                log.severe("Alpha palette too large for PNG8 encoding");
            }
            byte[] byArray = new byte[n];
            indexColorModel.getAlphas(byArray);
            for (int i = n - 1; i >= 0; --i) {
                if (byArray[i] == -1) continue;
                ChunkStream chunkStream = new ChunkStream("tRNS");
                for (int j = 0; j <= i; ++j) {
                    chunkStream.writeByte(byArray[j]);
                }
                chunkStream.writeToStream(this.dos);
                break;
            }
        } else if (this.colorType == 2 && this.transparentColor != null) {
            ChunkStream chunkStream = new ChunkStream("tRNS");
            int n = this.transparentColor.getRed();
            int n2 = this.transparentColor.getGreen();
            int n3 = this.transparentColor.getBlue();
            chunkStream.writeShort(n);
            chunkStream.writeShort(n2);
            chunkStream.writeShort(n3);
            chunkStream.writeToStream(this.dos);
        }
    }

    private void writeIDAT() throws IOException {
        ChunkStream chunkStream = new ChunkStream("IDAT");
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)chunkStream, this.deflater);
        Raster raster = this.image instanceof BufferedImage ? ((BufferedImage)this.image).getRaster() : this.image.getData();
        int n = raster.getMinX();
        int n2 = raster.getMinY();
        int n3 = 8 / this.bitDepth;
        int n4 = 0;
        if (this.bitDepth < 8) {
            n4 = n3 - this.width % n3;
        }
        int[] nArray = new int[this.width * this.sm.getNumBands() + n4];
        int n5 = this.width * this.numOutBands;
        if (this.bitDepth < 8) {
            n5 = (this.width + n3 - 1) / n3;
        } else if (this.bitDepth == 16) {
            n5 *= 2;
        }
        byte[] byArray = new byte[n5];
        for (int i = 0; i < this.height; ++i) {
            this.getScanline(raster, n, n2 + i, nArray, byArray);
            deflaterOutputStream.write(0);
            deflaterOutputStream.write(byArray);
        }
        deflaterOutputStream.finish();
        chunkStream.writeToStream(this.dos);
    }

    private void writeIEND() throws IOException {
        ChunkStream chunkStream = new ChunkStream("IEND");
        chunkStream.writeToStream(this.dos);
    }

    private void getScanline(Raster raster, int n, int n2, int[] nArray, byte[] byArray) {
        raster.getPixels(n, n2, this.width, 1, nArray);
        int n3 = 0;
        switch (this.bitDepth) {
            case 1: {
                for (int i = 0; i < byArray.length; ++i) {
                    byArray[i] = (byte)((nArray[n3++] & 1) << 7 | (nArray[n3++] & 1) << 6 | (nArray[n3++] & 1) << 5 | (nArray[n3++] & 1) << 4 | (nArray[n3++] & 1) << 3 | (nArray[n3++] & 1) << 2 | (nArray[n3++] & 1) << 1 | nArray[n3++] & 1);
                }
                break;
            }
            case 2: {
                for (int i = 0; i < byArray.length; ++i) {
                    byArray[i] = (byte)((nArray[n3++] & 3) << 6 | (nArray[n3++] & 3) << 4 | (nArray[n3++] & 3) << 2 | nArray[n3++] & 3);
                }
                break;
            }
            case 4: {
                for (int i = 0; i < byArray.length; ++i) {
                    byArray[i] = (byte)((nArray[n3++] & 0xF) << 4 | nArray[n3++] & 0xF);
                }
                break;
            }
            case 8: {
                for (int i = 0; i < byArray.length; ++i) {
                    byArray[i] = (byte)nArray[i];
                }
                break;
            }
            case 16: {
                for (int i = 0; i < nArray.length; ++i) {
                    byArray[n3++] = (byte)(nArray[i] >> 8);
                    byArray[n3++] = (byte)(nArray[i] & 0xFF);
                }
                break;
            }
        }
    }
}

