/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.util;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Hashtable;

public class Quantizer {
    private static final int RGB_HIST_DEPTH = 5;
    private static final int ARGB_HIST_DEPTH = 4;

    public static RenderedImage rgb24to8(RenderedImage renderedImage) {
        return Quantizer.rgb24to8(renderedImage, false, 1, null, false);
    }

    public static RenderedImage rgb24to8(RenderedImage renderedImage, Color color) {
        return Quantizer.rgb24to8(renderedImage, false, 1, color, false);
    }

    public static RenderedImage rgb24to8(RenderedImage renderedImage, Color color, boolean bl) {
        return Quantizer.rgb24to8(renderedImage, false, 1, color, bl);
    }

    private static RenderedImage rgb24to8(RenderedImage renderedImage, boolean bl, int n, Color color, boolean bl2) {
        Object[] objectArray = null;
        if (!bl) {
            objectArray = new Object[1];
        }
        int[] nArray = bl2 ? new int[1] : null;
        byte[][] byArray = Quantizer.computeRGBLUTMedian(renderedImage, n, 256, objectArray, color, nArray);
        byte[][][] byArray2 = null;
        if (!bl) {
            byArray2 = (byte[][][])objectArray[0];
        }
        if (color != null && nArray != null && nArray[0] == 0) {
            int n2 = color.getRed();
            int n3 = color.getGreen();
            int n4 = color.getBlue();
            int n5 = byArray[0][0];
            int n6 = byArray[1][0];
            int n7 = byArray[2][0];
            if (n5 < 0) {
                n5 += 256;
            }
            if (n6 < 0) {
                n6 += 256;
            }
            if (n7 < 0) {
                n7 += 256;
            }
            if (n2 != n5 || n3 != n6 || n4 != n7) {
                bl2 = false;
            }
        }
        IndexColorModel indexColorModel = bl2 ? new IndexColorModel(8, byArray[0].length, byArray[0], byArray[1], byArray[2], nArray[0]) : new IndexColorModel(8, byArray[0].length, byArray[0], byArray[1], byArray[2]);
        BufferedImage bufferedImage = new BufferedImage(renderedImage.getWidth(), renderedImage.getHeight(), 13, indexColorModel);
        Quantizer.quantize24Bits(renderedImage, bufferedImage, byArray, byArray2);
        return bufferedImage;
    }

    public static RenderedImage rgb24to4(RenderedImage renderedImage) {
        return Quantizer.rgb24to4(renderedImage, false, 1, null);
    }

    private static RenderedImage rgb24to4(RenderedImage renderedImage, boolean bl, int n, Color color) {
        Object[] objectArray = null;
        if (!bl) {
            objectArray = new Object[1];
        }
        byte[][] byArray = Quantizer.computeRGBLUTMedian(renderedImage, n, 16, objectArray, color);
        byte[][][] byArray2 = null;
        if (!bl) {
            byArray2 = (byte[][][])objectArray[0];
        }
        IndexColorModel indexColorModel = new IndexColorModel(4, byArray[0].length, byArray[0], byArray[1], byArray[2]);
        BufferedImage bufferedImage = new BufferedImage(renderedImage.getWidth(), renderedImage.getHeight(), 13, indexColorModel);
        Quantizer.quantize24Bits(renderedImage, bufferedImage, byArray, byArray2);
        return bufferedImage;
    }

    private static byte[][] computeRGBLUTMedian(RenderedImage renderedImage, int n, int n2, Object[] objectArray, Color color) {
        return Quantizer.computeRGBLUTMedian(renderedImage, n, n2, objectArray, color, null);
    }

    private static byte[][] computeRGBLUTMedian(RenderedImage renderedImage, int n, int n2, Object[] objectArray, Color color, int[] nArray) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int[][][] nArray2 = new int[32][32][32];
        Quantizer.fillRGBHistogram(renderedImage, nArray2, n);
        Cube[] cubeArray = new Cube[n2];
        cubeArray[0] = new Cube(0, 0, 0, 31, 31, 31, nArray2);
        int n8 = 1;
        while (n8 < n2) {
            int n9 = -1;
            n7 = Integer.MAX_VALUE;
            for (n6 = 0; n6 < n8; ++n6) {
                if (cubeArray[n6].generation >= n7 || !cubeArray[n6].canSplit()) continue;
                n9 = n6;
                n7 = cubeArray[n9].generation;
            }
            if (n9 < 0) break;
            n6 = cubeArray[n9].findSplit();
            if (n6 == 0) {
                throw new RuntimeException("Cube split inconsistency");
            }
            switch (n6) {
                case 1: {
                    cubeArray[n8++] = cubeArray[n9].splitRed(nArray2);
                    break;
                }
                case 2: {
                    cubeArray[n8++] = cubeArray[n9].splitGreen(nArray2);
                    break;
                }
                case 3: {
                    cubeArray[n8++] = cubeArray[n9].splitBlue(nArray2);
                }
            }
        }
        byte[][] byArray = new byte[3][n2];
        for (n7 = 0; n7 < n8; ++n7) {
            n6 = cubeArray[n7].color(nArray2);
            byArray[0][n7] = (byte)(n6 >> 16 & 0xFF);
            byArray[1][n7] = (byte)(n6 >> 8 & 0xFF);
            byArray[2][n7] = (byte)(n6 & 0xFF);
        }
        if (color != null) {
            n7 = 8 - Quantizer.numColorsToBits(nArray2.length);
            n6 = color.getRed();
            n5 = color.getGreen();
            n4 = color.getBlue();
            n3 = n6 >> n7;
            int n10 = n5 >> n7;
            int n11 = n4 >> n7;
            for (int i = 0; i < n8; ++i) {
                if (!cubeArray[i].inCube(n3, n10, n11)) continue;
                byArray[0][i] = (byte)n6;
                byArray[1][i] = (byte)n5;
                byArray[2][i] = (byte)n4;
                if (nArray == null) break;
                nArray[0] = i;
                break;
            }
        }
        if (objectArray != null) {
            byte[][][] byArray2 = new byte[32][32][32];
            for (n6 = 0; n6 < n8; ++n6) {
                for (n5 = cubeArray[n6].rmin; n5 <= cubeArray[n6].rmax; ++n5) {
                    for (n4 = cubeArray[n6].gmin; n4 <= cubeArray[n6].gmax; ++n4) {
                        for (n3 = cubeArray[n6].bmin; n3 <= cubeArray[n6].bmax; ++n3) {
                            byArray2[n5][n4][n3] = (byte)n6;
                        }
                    }
                }
            }
            objectArray[0] = byArray2;
        }
        return byArray;
    }

    private static void fillRGBHistogram(RenderedImage renderedImage, int[][][] nArray, int n) {
        int n2 = renderedImage.getMinX();
        int n3 = renderedImage.getMinY();
        int n4 = renderedImage.getWidth();
        int n5 = renderedImage.getHeight();
        int n6 = renderedImage.getSampleModel().getNumBands();
        if (n6 < 3) {
            throw new RuntimeException("Insufficient bit depth in fillRGBHistogram input image");
        }
        int[] nArray2 = new int[n4 * n6];
        int n7 = 8 - Quantizer.numColorsToBits(nArray.length);
        int n8 = n;
        int n9 = n6 * n;
        for (int i = n3; i < n3 + n5; i += n8) {
            Raster raster = renderedImage.getData(new Rectangle(n2, i, n4, 1));
            raster.getPixels(n2, i, n4, 1, nArray2);
            for (int j = 0; j < n6 * n4; j += n9) {
                int n10 = nArray2[j] >> n7;
                int n11 = nArray2[j + 1] >> n7;
                int n12 = nArray2[j + 2] >> n7;
                int[] nArray3 = nArray[n10][n11];
                int n13 = n12;
                nArray3[n13] = nArray3[n13] + 1;
            }
        }
    }

    private static void quantize24Bits(RenderedImage renderedImage, BufferedImage bufferedImage, byte[][] byArray, byte[][][] byArray2) {
        int n;
        int n2 = 0;
        if (byArray2 != null) {
            n2 = 8 - Quantizer.numColorsToBits(byArray2.length);
        }
        Hashtable hashtable = null;
        if (byArray2 == null) {
            hashtable = new Hashtable();
        }
        if ((n = renderedImage.getSampleModel().getNumBands()) < 3) {
            throw new RuntimeException("Insufficient bit depth in quantize24Bits input image");
        }
        int n3 = renderedImage.getMinX();
        int n4 = renderedImage.getMinY();
        int n5 = renderedImage.getWidth();
        int n6 = renderedImage.getHeight();
        int[] nArray = new int[n5 * n];
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n7 = 0;
        for (int i = n4; i < n4 + n6; ++i) {
            int n8;
            int n9;
            Raster raster = renderedImage.getData(new Rectangle(n3, i, n5, 1));
            raster.getPixels(n3, i, n5, 1, nArray);
            int n10 = 0;
            if (byArray2 != null) {
                for (n9 = 0; n9 < n * n5; n9 += n) {
                    n8 = byArray2[nArray[n9] >> n2][nArray[n9 + 1] >> n2][nArray[n9 + 2] >> n2];
                    writableRaster.setSample(n10++, n7, 0, n8);
                }
            } else {
                for (n9 = 0; n9 < n * n5; n9 += n) {
                    n8 = Quantizer.findNearestRGBIndex(nArray[n9], nArray[n9 + 1], nArray[n9 + 2], byArray, hashtable);
                    writableRaster.setSample(n10++, n7, 0, n8);
                }
            }
            ++n7;
        }
    }

    private static int findNearestRGBIndex(int n, int n2, int n3, byte[][] byArray, Hashtable hashtable) {
        Integer n4 = null;
        n4 = new Integer(n << 16 | n2 << 8 | n3);
        Integer n5 = (Integer)hashtable.get(n4);
        if (n5 != null) {
            return n5;
        }
        int n6 = 196608;
        int n7 = 0;
        for (int i = 0; i < byArray[0].length; ++i) {
            int n8 = (n - (byArray[0][i] & 0xFF)) * (n - (byArray[0][i] & 0xFF)) + (n2 - (byArray[1][i] & 0xFF)) * (n2 - (byArray[1][i] & 0xFF)) + (n3 - (byArray[2][i] & 0xFF)) * (n3 - (byArray[2][i] & 0xFF));
            if (n8 == 0) {
                n7 = i;
                break;
            }
            if (n8 >= n6) continue;
            n7 = i;
            n6 = n8;
        }
        hashtable.put(n4, new Integer(n7));
        return n7;
    }

    private static int findNearestRGBIndex(int n, int n2, int n3, byte[][] byArray) {
        int n4 = 196608;
        int n5 = 0;
        for (int i = 0; i < byArray[0].length; ++i) {
            int n6 = (n - (byArray[0][i] & 0xFF)) * (n - (byArray[0][i] & 0xFF)) + (n2 - (byArray[1][i] & 0xFF)) * (n2 - (byArray[1][i] & 0xFF)) + (n3 - (byArray[2][i] & 0xFF)) * (n3 - (byArray[2][i] & 0xFF));
            if (n6 == 0) {
                return i;
            }
            if (n6 >= n4) continue;
            n5 = i;
            n4 = n6;
        }
        return n5;
    }

    private static int numColorsToBits(int n) {
        int n2 = 0;
        --n;
        while (n > 0) {
            n = (n & Integer.MAX_VALUE) >> 1;
            ++n2;
        }
        return n2;
    }

    static class Cube {
        int rmin;
        int rmax;
        int gmin;
        int gmax;
        int bmin;
        int bmax;
        int generation = 0;
        int population = 0;

        boolean inCube(Color color, int n) {
            int n2 = color.getRed();
            int n3 = color.getGreen();
            int n4 = color.getBlue();
            return (n2 >>= n) >= this.rmin && n2 <= this.rmax && (n3 >>= n) >= this.gmin && n3 <= this.gmax && (n4 >>= n) >= this.bmin && n4 <= this.bmax;
        }

        boolean inCube(int n, int n2, int n3) {
            return n >= this.rmin && n <= this.rmax && n2 >= this.gmin && n2 <= this.gmax && n3 >= this.bmin && n3 <= this.bmax;
        }

        Cube(int n, int n2, int n3, int n4, int n5, int n6, int[][][] nArray) {
            this.rmin = n;
            this.rmax = n4;
            this.gmin = n2;
            this.gmax = n5;
            this.bmin = n3;
            this.bmax = n6;
            this.shrink(nArray);
        }

        int color(int[][][] nArray) {
            int n;
            int n2;
            int n3;
            int n4 = 256 / nArray.length;
            long l = 0L;
            long l2 = 0L;
            long l3 = 0L;
            long l4 = 0L;
            for (n3 = this.rmin; n3 <= this.rmax; ++n3) {
                for (n2 = this.gmin; n2 <= this.gmax; ++n2) {
                    for (n = this.bmin; n <= this.bmax; ++n) {
                        if (nArray[n3][n2][n] == 0) continue;
                        l += (long)(n3 * nArray[n3][n2][n]);
                        l2 += (long)(n2 * nArray[n3][n2][n]);
                        l3 += (long)(n * nArray[n3][n2][n]);
                        l4 += (long)nArray[n3][n2][n];
                    }
                }
            }
            n3 = (int)(l * (long)n4 / l4);
            n2 = (int)(l2 * (long)n4 / l4);
            n = (int)(l3 * (long)n4 / l4);
            int n5 = (nArray.length - 1) * n4;
            if (n3 == n5) {
                n3 = 255;
            }
            if (n2 == n5) {
                n2 = 255;
            }
            if (n == n5) {
                n = 255;
            }
            return n3 << 16 | n2 << 8 | n;
        }

        void shrink(int[][][] nArray) {
            int n = this.rmax;
            int n2 = this.rmin;
            int n3 = this.gmax;
            int n4 = this.gmin;
            int n5 = this.bmax;
            int n6 = this.bmin;
            for (int i = this.rmin; i <= this.rmax; ++i) {
                for (int j = this.gmin; j <= this.gmax; ++j) {
                    for (int k = this.bmin; k <= this.bmax; ++k) {
                        if (nArray[i][j][k] == 0) continue;
                        if (i < n) {
                            n = i;
                        }
                        if (j < n3) {
                            n3 = j;
                        }
                        if (k < n5) {
                            n5 = k;
                        }
                        if (i > n2) {
                            n2 = i;
                        }
                        if (j > n4) {
                            n4 = j;
                        }
                        if (k > n6) {
                            n6 = k;
                        }
                        this.population += nArray[i][j][k];
                    }
                }
            }
            this.rmin = n;
            this.rmax = n2;
            this.gmin = n3;
            this.gmax = n4;
            this.bmin = n5;
            this.bmax = n6;
        }

        boolean canSplit() {
            if (this.rmax - this.rmin == 0 && this.gmax - this.gmin == 0 && this.bmax - this.bmin == 0) {
                return false;
            }
            return this.population >= 2;
        }

        int findSplit() {
            int n = this.rmax - this.rmin;
            int n2 = this.gmax - this.gmin;
            int n3 = this.bmax - this.bmin;
            if (!this.canSplit()) {
                return 0;
            }
            if (n2 >= n && n2 >= n3) {
                return 2;
            }
            if (n >= n3) {
                return 1;
            }
            return 3;
        }

        Cube splitRed(int[][][] nArray) {
            int n;
            if (this.rmax - this.rmin == 1) {
                n = this.rmax;
            } else {
                int n2 = 0;
                int n3 = this.population / 2;
                for (n = this.rmin; n < this.rmax && n2 < n3; ++n) {
                    for (int i = this.gmin; i <= this.gmax && n2 < n3; ++i) {
                        for (int j = this.bmin; j <= this.bmax && n2 < n3; n2 += nArray[n][i][j], ++j) {
                        }
                    }
                }
            }
            if (n == this.rmin) {
                ++n;
            }
            Cube cube = new Cube(n, this.gmin, this.bmin, this.rmax, this.gmax, this.bmax, nArray);
            cube.generation = this.generation + 1;
            ++this.generation;
            this.population = 0;
            this.rmax = n - 1;
            this.shrink(nArray);
            return cube;
        }

        Cube splitGreen(int[][][] nArray) {
            int n;
            if (this.gmax - this.gmin == 1) {
                n = this.gmax;
            } else {
                int n2 = 0;
                int n3 = this.population / 2;
                for (n = this.gmin; n < this.gmax && n2 < n3; ++n) {
                    for (int i = this.rmin; i <= this.rmax && n2 < n3; ++i) {
                        for (int j = this.bmin; j <= this.bmax && n2 < n3; n2 += nArray[i][n][j], ++j) {
                        }
                    }
                }
            }
            if (n == this.gmin) {
                ++n;
            }
            Cube cube = new Cube(this.rmin, n, this.bmin, this.rmax, this.gmax, this.bmax, nArray);
            cube.generation = this.generation + 1;
            ++this.generation;
            this.population = 0;
            this.gmax = n - 1;
            this.shrink(nArray);
            return cube;
        }

        Cube splitBlue(int[][][] nArray) {
            int n;
            if (this.bmax - this.bmin == 1) {
                n = this.bmax;
            } else {
                int n2 = 0;
                int n3 = this.population / 2;
                for (n = this.bmin; n < this.bmax && n2 < n3; ++n) {
                    for (int i = this.rmin; i <= this.rmax && n2 < n3; ++i) {
                        for (int j = this.gmin; j <= this.gmax && n2 < n3; n2 += nArray[i][j][n], ++j) {
                        }
                    }
                }
            }
            if (n == this.bmin) {
                ++n;
            }
            Cube cube = new Cube(this.rmin, this.gmin, n, this.rmax, this.gmax, this.bmax, nArray);
            cube.generation = this.generation + 1;
            ++this.generation;
            this.population = 0;
            this.bmax = n - 1;
            this.shrink(nArray);
            return cube;
        }

        public String toString() {
            String string = "(" + this.rmin + ", " + this.gmin + ", " + this.bmin + ") (" + this.rmax + ", " + this.gmax + ", " + this.bmax + "); gen = " + this.generation + "; pop = " + this.population;
            return string;
        }
    }
}

