/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.util;

import java.awt.geom.Rectangle2D;
import java.util.Vector;
import oracle.sdovis.util.ConflictResolver;

public class RectArray
implements ConflictResolver {
    int[] rects;
    int size = 0;
    int capacity = 0;
    int initialSize = 256;
    int scale = 1;

    public RectArray(int n, int n2) {
        if (n > 0) {
            this.initialSize = n;
        }
        this.capacity = this.initialSize;
        this.rects = new int[4 * this.capacity];
        this.scale = n2;
    }

    public RectArray(int n) {
        if (n > 0) {
            this.initialSize = n;
        }
        this.capacity = this.initialSize;
        this.rects = new int[4 * this.capacity];
    }

    public void freeAll() {
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    public Rectangle2D elementAt(int n) {
        if (n < 0 || n >= this.size) {
            return null;
        }
        int n2 = this.rects[n *= 4];
        int n3 = this.rects[n + 1];
        int n4 = this.rects[n + 2] - n2;
        int n5 = this.rects[n + 3] - n3;
        return new Rectangle2D.Double(n2, n3, n4, n5);
    }

    public void reset() {
        this.rects = null;
        this.size = 0;
        this.capacity = 0;
    }

    public void insert(int n, int n2, int n3, int n4) {
        if (n3 <= 0 || n4 <= 0) {
            return;
        }
        if (this.capacity == 0) {
            this.capacity = this.initialSize;
            this.rects = new int[4 * this.capacity];
        }
        if (this.size >= this.capacity) {
            this.capacity *= 2;
            int[] nArray = new int[this.capacity * 4];
            System.arraycopy(this.rects, 0, nArray, 0, this.size * 4);
            this.rects = nArray;
        }
        int n5 = this.size * 4;
        this.rects[n5] = n;
        this.rects[n5 + 1] = n2;
        this.rects[n5 + 2] = n + n3;
        this.rects[n5 + 3] = n2 + n4;
        ++this.size;
    }

    public void insert(double d, double d2, double d3, double d4) {
        if (d3 <= 0.0 || d4 <= 0.0) {
            return;
        }
        if (this.capacity == 0) {
            this.capacity = this.initialSize;
            this.rects = new int[4 * this.capacity];
        }
        if (this.size >= this.capacity) {
            this.capacity *= 2;
            int[] nArray = new int[this.capacity * 4];
            System.arraycopy(this.rects, 0, nArray, 0, this.size * 4);
            this.rects = nArray;
        }
        int n = this.size * 4;
        this.rects[n] = (int)(d * (double)this.scale);
        this.rects[n + 1] = (int)(d2 * (double)this.scale);
        this.rects[n + 2] = (int)((d + d3) * (double)this.scale);
        this.rects[n + 3] = (int)((d2 + d4) * (double)this.scale);
        ++this.size;
    }

    public void insert(Rectangle2D rectangle2D) {
        this.insert((int)(rectangle2D.getMinX() * (double)this.scale), (int)(rectangle2D.getMinY() * (double)this.scale), (int)(rectangle2D.getWidth() * (double)this.scale), (int)(rectangle2D.getHeight() * (double)this.scale));
    }

    public void addAll(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            this.insert((Rectangle2D)vector.elementAt(i));
        }
    }

    public void addAll(RectArray rectArray) {
        if (rectArray != null && rectArray.size > 0) {
            for (int i = 0; i < rectArray.size; ++i) {
                this.insert(rectArray.rects[i * 4], rectArray.rects[i * 4 + 1], rectArray.rects[i * 4 + 2] - rectArray.rects[i * 4], rectArray.rects[i * 4 + 3] - rectArray.rects[i * 4 + 1]);
            }
        }
    }

    public boolean conflicts(int n, int n2, int n3, int n4) {
        if (n3 <= 0 && n4 <= 0) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            int n5 = i * 4;
            int n6 = this.rects[n5];
            int n7 = this.rects[n5 + 1];
            int n8 = this.rects[n5 + 2];
            int n9 = this.rects[n5 + 3];
            if (n + n3 <= n6 || n2 + n4 <= n7 || n >= n8 || n2 >= n9) continue;
            return true;
        }
        return false;
    }

    public boolean conflicts(double d, double d2, double d3, double d4) {
        if (d3 <= 0.0 && d4 <= 0.0) {
            return false;
        }
        int n = (int)(d * (double)this.scale);
        int n2 = (int)(d2 * (double)this.scale);
        int n3 = (int)((d + d3) * (double)this.scale);
        int n4 = (int)((d2 + d4) * (double)this.scale);
        for (int i = 0; i < this.size; ++i) {
            int n5 = i * 4;
            int n6 = this.rects[n5];
            int n7 = this.rects[n5 + 1];
            int n8 = this.rects[n5 + 2];
            int n9 = this.rects[n5 + 3];
            if (n3 <= n6 || n4 <= n7 || n >= n8 || n2 >= n9) continue;
            return true;
        }
        return false;
    }

    public boolean conflicts(Rectangle2D rectangle2D) {
        return this.conflicts(rectangle2D.getMinX(), rectangle2D.getMinY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public Object clone() {
        RectArray rectArray = new RectArray(Math.max(this.size, this.initialSize), this.scale);
        rectArray.rects = (int[])this.rects.clone();
        rectArray.capacity = this.capacity;
        rectArray.size = this.size;
        return rectArray;
    }
}

