/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.util;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.VisContext;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleLine;
import oracle.sdovis.stylex.BucketStyle;
import oracle.sdovis.stylex.ColorSchemeStyle;
import oracle.sdovis.stylex.VariableMarkerStyle;
import oracle.sdovis.stylex.VariablePieChartStyle;
import oracle.sdovis.util.ShapeUtil;

public class RenderingUtils {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);

    public static final void smartDraw(Shape shape, Graphics2D graphics2D, VisContext visContext) {
        Rectangle rectangle = shape.getBounds();
        if (visContext == null && rectangle.getWidth() < 5000.0 && rectangle.getHeight() < 5000.0) {
            graphics2D.draw(shape);
            return;
        }
        Rectangle2D rectangle2D = null;
        rectangle2D = visContext != null ? visContext.getDeviceWindow() : graphics2D.getDeviceConfiguration().getBounds();
        if (ShapeUtil.intersectsShapeSegments(rectangle2D, shape, rectangle)) {
            if (rectangle2D.contains(rectangle)) {
                graphics2D.draw(shape);
                return;
            }
            Shape shape2 = ShapeUtil.clipLineString(rectangle2D, shape, rectangle);
            if (shape2 != null) {
                graphics2D.draw(shape2);
            }
        }
    }

    public static final boolean hasCasedLineStyle(String[] stringArray, String string, VisContext visContext) {
        boolean bl = false;
        if (stringArray == null || stringArray.length == 0 || string == null || visContext == null) {
            return bl;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            boolean bl2;
            String string2 = stringArray[i];
            Style style = visContext.resolveStyle(string2, string);
            if (style != null && !(bl2 = style.resolveStyles(DSManager.getStyleCache(string), visContext.getDynamicStyles()))) {
                log.warning("cannot resolve referenced styles for style " + style.getModel().getName());
            }
            if (style == null || !(style instanceof StyleLine ? ((StyleLine)style).supportCasedLine() : style instanceof BucketStyle && !(style instanceof ColorSchemeStyle) && !(style instanceof VariableMarkerStyle) && !(style instanceof VariablePieChartStyle) && ((BucketStyle)style).hasCasedLineStyles())) continue;
            return true;
        }
        return false;
    }
}

