/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.util.HttpConnection;
import oracle.sdovis.util.HttpGetThread;
import oracle.sdovis.util.HttpPostThread;
import oracle.sdovis.util.Util;
import oracle.sdovis.util.WfsFeatureType;
import oracle.sdovis.util.XMLDOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WfsCapabilities {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private String version = "1.0.0";
    private int updateSequence = 0;
    private Hashtable xmlnsValues = new Hashtable();
    private String serviceName = null;
    private String serviceTitle = null;
    private String serviceAbstract = null;
    private String serviceKeywords = null;
    private String serviceOnlineResource = null;
    private String serviceFees = null;
    private String serviceAccessConstraints = null;
    private String getCapabilities_getURL = null;
    private String getCapabilities_postURL = null;
    private String describeFeatureType_getURL = null;
    private String describeFeatureType_postURL = null;
    private String getFeature_getURL = null;
    private String getFeature_postURL = null;
    private String getFeatureWithLock_getURL = null;
    private String getFeatureWithLock_postURL = null;
    private String transaction_getURL = null;
    private String transaction_postURL = null;
    private String lockFeature_getURL = null;
    private String lockFeature_postURL = null;
    private ArrayList featureFormats = new ArrayList();
    private ArrayList featurewithlockFormats = new ArrayList();
    private ArrayList serviceOperations = new ArrayList();
    private Vector featureTypes = new Vector();
    private ArrayList spatialOperators = new ArrayList();
    private ArrayList logicalOperators = new ArrayList();
    private ArrayList comparisonOperators = new ArrayList();
    private ArrayList arithmeticOperators = new ArrayList();

    public WfsCapabilities() {
        this.xmlnsValues.put("xmlns", "http://www.opengis.net/wfs");
        this.xmlnsValues.put("xmlns:wfs", "http://www.opengis.net/wfs");
        this.xmlnsValues.put("xmlns:ogc", "http://www.opengis.net/ogc");
    }

    public void reset() {
        this.version = "1.0.0";
        this.updateSequence = 0;
        this.xmlnsValues = new Hashtable();
        this.xmlnsValues.put("xmlns", "http://www.opengis.net/wfs");
        this.xmlnsValues.put("xmlns:wfs", "http://www.opengis.net/wfs");
        this.xmlnsValues.put("xmlns:ogc", "http://www.opengis.net/ogc");
        this.serviceName = null;
        this.serviceTitle = null;
        this.serviceAbstract = null;
        this.serviceKeywords = null;
        this.serviceOnlineResource = null;
        this.serviceFees = null;
        this.serviceAccessConstraints = null;
        this.getCapabilities_getURL = null;
        this.getCapabilities_postURL = null;
        this.describeFeatureType_getURL = null;
        this.describeFeatureType_postURL = null;
        this.getFeature_getURL = null;
        this.getFeature_postURL = null;
        this.getFeatureWithLock_getURL = null;
        this.getFeatureWithLock_postURL = null;
        this.transaction_getURL = null;
        this.transaction_postURL = null;
        this.lockFeature_getURL = null;
        this.lockFeature_postURL = null;
        this.featureFormats.clear();
        this.featurewithlockFormats.clear();
        this.serviceOperations.clear();
        this.featureTypes.clear();
        this.spatialOperators.clear();
        this.logicalOperators.clear();
        this.comparisonOperators.clear();
        this.arithmeticOperators.clear();
    }

    public boolean readUsingHttpGet(String string, long l) {
        String string2;
        block9: {
            this.reset();
            if (string == null || string.trim().length() == 0) {
                return false;
            }
            String string3 = string.trim();
            if (string3.lastIndexOf(63) > -1) {
                if (!string3.endsWith("?") && !string3.endsWith("&")) {
                    string3 = string3 + "&";
                }
            } else if (!string3.endsWith("&")) {
                string3 = string3 + "?";
            }
            string3 = string3 + "VERSION=1.0.0&SERVICE=WFS&REQUEST=GetCapabilities";
            log.info("GetCapabilities request: " + string3);
            string2 = "";
            try {
                if (l <= 0L) {
                    string2 = Util.issueHttpGetRequest(string3);
                    break block9;
                }
                HttpGetThread httpGetThread = new HttpGetThread(string3);
                httpGetThread.start();
                httpGetThread.checkTimeout(l);
                if (httpGetThread.isCompleted()) {
                    string2 = httpGetThread.getResponse();
                    break block9;
                }
                log.info("Request timeout.");
                httpGetThread = null;
                return false;
            }
            catch (IOException iOException) {
                log.severe("GetCapabilities using Http Get failed: " + iOException.getMessage());
                return false;
            }
        }
        return this.decodeCapabilities(string2);
    }

    public boolean readUsingHttpPost(String string, long l) {
        String string2;
        block5: {
            if (string == null || string.trim().length() == 0) {
                return false;
            }
            String string3 = string.trim();
            String string4 = "<?xml version=\"1.0\" ?>\n<GetCapabilities\n   service=\"WFS\"\n   version=\"1.0.0\"\n   xmlns=\"http://www.opengis.net/wfs\" />";
            log.info("Request: " + string4);
            string2 = "";
            try {
                if (l <= 0L) {
                    HttpConnection httpConnection = new HttpConnection();
                    httpConnection.connect(string3);
                    httpConnection.sendXMLRequest("", string4);
                    string2 = httpConnection.getXMLResponse();
                    break block5;
                }
                HttpPostThread httpPostThread = new HttpPostThread(string3, string4, null);
                httpPostThread.start();
                httpPostThread.checkTimeout(l);
                if (httpPostThread.isCompleted()) {
                    string2 = httpPostThread.getResponse();
                    break block5;
                }
                log.info("Request timeout.");
                httpPostThread = null;
                return false;
            }
            catch (Exception exception) {
                log.severe("GetCapabilities using Http Post failed: " + exception.getMessage());
                return false;
            }
        }
        return this.decodeCapabilities(string2);
    }

    private boolean decodeCapabilities(String string) {
        if (string == null) {
            return false;
        }
        try {
            NodeList nodeList;
            Object object;
            XMLDOMParser xMLDOMParser = new XMLDOMParser();
            if (!xMLDOMParser.parse(string)) {
                log.info("Unable to parse capabilities request");
                return false;
            }
            Document document = xMLDOMParser.getDocument();
            Node node = document.getFirstChild();
            if (node == null) {
                log.info("Invalid XML response for GetCapabilities. Root node not found.");
                return false;
            }
            if (!node.getNodeName().equalsIgnoreCase("WFS_Capabilities")) {
                object = document.getElementsByTagName("WFS_Capabilities");
                if (object != null && object.getLength() > 0) {
                    node = object.item(0);
                } else {
                    log.info("WFS_Capabilities node not found.");
                    return false;
                }
            }
            if ((object = XMLDOMParser.getAttribute(node, "version")) != null && ((String)object).trim().length() > 0) {
                if (!((String)object).trim().equalsIgnoreCase("1.0.0")) {
                    log.info("Unsupported capabilities version: " + ((String)object).trim());
                }
                this.version = ((String)object).trim();
            }
            if ((object = XMLDOMParser.getAttribute(node, "updateSequence")) != null && ((String)object).trim().length() > 0) {
                try {
                    int n;
                    this.updateSequence = n = Integer.parseInt(((String)object).trim());
                }
                catch (Exception exception) {
                    this.updateSequence = 0;
                }
            }
            if ((object = XMLDOMParser.getAttribute(node, "xmlns")) != null && ((String)object).trim().length() > 0) {
                this.xmlnsValues.put("xmlns", ((String)object).trim());
            }
            if ((object = XMLDOMParser.getAttribute(node, "xmlns:wfs")) != null && ((String)object).trim().length() > 0) {
                this.xmlnsValues.put("xmlns:wfs", ((String)object).trim());
            }
            if ((object = XMLDOMParser.getAttribute(node, "xmlns:ogc")) != null && ((String)object).trim().length() > 0) {
                this.xmlnsValues.put("xmlns:ogc", ((String)object).trim());
            }
            if ((nodeList = node.getChildNodes()) != null) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node2 = nodeList.item(i);
                    if (node2.getNodeName().equalsIgnoreCase("Service")) {
                        this.updateServiceParameters(node2);
                        continue;
                    }
                    if (node2.getNodeName().equalsIgnoreCase("Capability")) {
                        this.updateCapabilityParameters(xMLDOMParser, node2);
                        continue;
                    }
                    if (!node2.getNodeName().equalsIgnoreCase("FeatureTypeList")) continue;
                    this.updateFeatureTypeParameters(xMLDOMParser, node2);
                    for (int j = 0; j < this.featureTypes.size(); ++j) {
                        WfsFeatureType wfsFeatureType = (WfsFeatureType)this.featureTypes.get(j);
                        if (wfsFeatureType.getNameSpaceAlias() == null) continue;
                        String string2 = wfsFeatureType.getNameSpaceAlias();
                        if (wfsFeatureType.getNameSpaceAliasURL() == null) {
                            object = XMLDOMParser.getAttribute(node, "xmlns:" + string2);
                            if (object == null || ((String)object).trim().length() <= 0) continue;
                            wfsFeatureType.setNameSpaceAliasURL(((String)object).trim());
                            this.xmlnsValues.put("xmlns:" + string2, ((String)object).trim());
                            continue;
                        }
                        this.xmlnsValues.put("xmlns:" + string2, wfsFeatureType.getNameSpaceAliasURL());
                    }
                }
            }
        }
        catch (Exception exception) {
            log.severe("Decode GetCapabilities failed: " + exception.getMessage());
            return false;
        }
        return true;
    }

    public String getVersion() {
        return this.version;
    }

    public int getUpdateSequence() {
        return this.updateSequence;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getServiceTitle() {
        return this.serviceTitle;
    }

    public String getServiceAbstract() {
        return this.serviceAbstract;
    }

    public String getServiceKeywords() {
        return this.serviceKeywords;
    }

    public String getServiceOnlineResource() {
        return this.serviceOnlineResource;
    }

    public String getServiceFees() {
        return this.serviceFees;
    }

    public String getServiceAccessConstraints() {
        return this.serviceAccessConstraints;
    }

    public String getCapabilitiesGetURL() {
        return this.getCapabilities_getURL;
    }

    public String getCapabilitiesPostURL() {
        return this.getCapabilities_postURL;
    }

    public String describeFeatureTypeGetURL() {
        return this.describeFeatureType_getURL;
    }

    public String describeFeatureTypePostURL() {
        return this.describeFeatureType_postURL;
    }

    public String getFeatureGetURL() {
        return this.getFeature_getURL;
    }

    public String getFeaturePostURL() {
        return this.getFeature_postURL;
    }

    public String getFeatureWithLockGetURL() {
        return this.getFeatureWithLock_getURL;
    }

    public String getFeatureWithLockPostURL() {
        return this.getFeatureWithLock_postURL;
    }

    public String getTransactionGetURL() {
        return this.transaction_getURL;
    }

    public String getTransactionPostURL() {
        return this.transaction_postURL;
    }

    public String getLockFeatureGetURL() {
        return this.lockFeature_getURL;
    }

    public String getLocFeaturePostURL() {
        return this.lockFeature_postURL;
    }

    public ArrayList getFeatureFormat() {
        return this.featureFormats;
    }

    public ArrayList getFeatureWithLockFormat() {
        return this.featurewithlockFormats;
    }

    public ArrayList getServiceOperations() {
        return this.serviceOperations;
    }

    public WfsFeatureType[] getFeatureTypesAsArray() {
        if (this.featureTypes.size() <= 0) {
            return null;
        }
        return this.featureTypes.toArray(new WfsFeatureType[this.featureTypes.size()]);
    }

    public Vector getFeatureTypes() {
        return this.featureTypes;
    }

    public ArrayList getSpatialOperators() {
        return this.spatialOperators;
    }

    public ArrayList getLogicalOperators() {
        return this.logicalOperators;
    }

    public ArrayList getComparisonOperators() {
        return this.comparisonOperators;
    }

    public ArrayList getArithmeticOperators() {
        return this.arithmeticOperators;
    }

    private void updateServiceParameters(Node node) {
        if (node == null) {
            return;
        }
        NodeList nodeList = node.getChildNodes();
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                Node node3 = node2.getFirstChild();
                String string = "";
                if (node3 != null) {
                    string = node3.getNodeValue().trim();
                }
                if (node2.getNodeName().equalsIgnoreCase("Name")) {
                    this.serviceName = string;
                    continue;
                }
                if (node2.getNodeName().equalsIgnoreCase("Title")) {
                    this.serviceTitle = string;
                    continue;
                }
                if (node2.getNodeName().equalsIgnoreCase("Abstract")) {
                    this.serviceAbstract = string;
                    continue;
                }
                if (node2.getNodeName().equalsIgnoreCase("Keywords")) {
                    this.serviceKeywords = string;
                    continue;
                }
                if (node2.getNodeName().equalsIgnoreCase("OnlineResource")) {
                    this.serviceOnlineResource = string;
                    continue;
                }
                if (node2.getNodeName().equalsIgnoreCase("Fees")) {
                    this.serviceFees = string;
                    continue;
                }
                if (!node2.getNodeName().equalsIgnoreCase("AccessConstraints")) continue;
                this.serviceAccessConstraints = string;
            }
        }
    }

    private void updateCapabilityParameters(XMLDOMParser xMLDOMParser, Node node) {
        if (xMLDOMParser == null || node == null) {
            return;
        }
        NodeList nodeList = node.getChildNodes();
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                if (!node2.getNodeName().equalsIgnoreCase("Request")) continue;
                NodeList nodeList2 = node2.getChildNodes();
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    int n;
                    String[] stringArray;
                    String[] stringArray2;
                    Node node3 = nodeList2.item(j);
                    if (node3.getNodeName().equalsIgnoreCase("GetCapabilities")) {
                        stringArray2 = this.getHttpAddresses(xMLDOMParser, node3);
                        if (stringArray2 == null) continue;
                        this.getCapabilities_getURL = stringArray2[0];
                        this.getCapabilities_postURL = stringArray2[1];
                        continue;
                    }
                    if (node3.getNodeName().equalsIgnoreCase("DescribeFeatureType")) {
                        stringArray2 = this.getHttpAddresses(xMLDOMParser, node3);
                        if (stringArray2 == null) continue;
                        this.describeFeatureType_getURL = stringArray2[0];
                        this.describeFeatureType_postURL = stringArray2[1];
                        continue;
                    }
                    if (node3.getNodeName().equalsIgnoreCase("GetFeature")) {
                        stringArray2 = this.getHttpAddresses(xMLDOMParser, node3);
                        if (stringArray2 != null) {
                            this.getFeature_getURL = stringArray2[0];
                            this.getFeature_postURL = stringArray2[1];
                        }
                        stringArray = this.getResultFormats(node3);
                        this.featureFormats.clear();
                        if (stringArray == null) continue;
                        for (n = 0; n < stringArray.length; ++n) {
                            this.featureFormats.add(stringArray[n]);
                        }
                        continue;
                    }
                    if (node3.getNodeName().equalsIgnoreCase("GetFeatureWithLock")) {
                        stringArray2 = this.getHttpAddresses(xMLDOMParser, node3);
                        if (stringArray2 != null) {
                            this.getFeatureWithLock_getURL = stringArray2[0];
                            this.getFeatureWithLock_postURL = stringArray2[1];
                        }
                        stringArray = this.getResultFormats(node3);
                        this.featurewithlockFormats.clear();
                        if (stringArray == null) continue;
                        for (n = 0; n < stringArray.length; ++n) {
                            this.featurewithlockFormats.add(stringArray[n]);
                        }
                        continue;
                    }
                    if (node3.getNodeName().equalsIgnoreCase("Transaction")) {
                        stringArray2 = this.getHttpAddresses(xMLDOMParser, node3);
                        if (stringArray2 == null) continue;
                        this.transaction_getURL = stringArray2[0];
                        this.transaction_postURL = stringArray2[1];
                        continue;
                    }
                    if (!node3.getNodeName().equalsIgnoreCase("LockFeature") || (stringArray2 = this.getHttpAddresses(xMLDOMParser, node3)) == null) continue;
                    this.lockFeature_getURL = stringArray2[0];
                    this.lockFeature_postURL = stringArray2[1];
                }
                break;
            }
        }
    }

    private String[] getHttpAddresses(XMLDOMParser xMLDOMParser, Node node) {
        if (node == null || xMLDOMParser == null) {
            return null;
        }
        NodeList nodeList = node.getChildNodes();
        if (nodeList == null) {
            return null;
        }
        String[] stringArray = new String[]{null, null};
        for (int i = 0; i < nodeList.getLength(); ++i) {
            NodeList nodeList2;
            Node node2 = nodeList.item(i);
            if (!node2.getNodeName().equalsIgnoreCase("DCPType") || (nodeList2 = node2.getChildNodes()) == null) continue;
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                NodeList nodeList3;
                Node node3 = nodeList2.item(j);
                if (!node3.getNodeName().equalsIgnoreCase("HTTP") || (nodeList3 = node3.getChildNodes()) == null) continue;
                for (int k = 0; k < nodeList3.getLength(); ++k) {
                    String string;
                    Node node4 = nodeList3.item(k);
                    if (node4.getNodeName().equalsIgnoreCase("Get")) {
                        string = XMLDOMParser.getAttribute(node4, "onlineResource");
                        if (string == null) continue;
                        stringArray[0] = string;
                        continue;
                    }
                    if (!node4.getNodeName().equalsIgnoreCase("Post")) continue;
                    string = XMLDOMParser.getAttribute(node4, "onlineResource");
                    if (string == null) continue;
                    stringArray[1] = string;
                }
            }
        }
        return stringArray;
    }

    private String[] getResultFormats(Node node) {
        if (node == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        NodeList nodeList = node.getChildNodes();
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                NodeList nodeList2;
                Node node2 = nodeList.item(i);
                if (!node2.getNodeName().equalsIgnoreCase("ResultFormat") || (nodeList2 = node2.getChildNodes()) == null) continue;
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Node node3 = nodeList2.item(j);
                    String string = node3.getNodeName();
                    if (string == null || string.trim().length() <= 0 || string.trim().equalsIgnoreCase("#text")) continue;
                    arrayList.add(string.trim());
                }
                break;
            }
        }
        if (arrayList.size() == 0) {
            arrayList = null;
            return null;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private void updateFeatureTypeParameters(XMLDOMParser xMLDOMParser, Node node) {
        if (xMLDOMParser == null || node == null) {
            return;
        }
        Object var3_3 = null;
        if (!node.getNodeName().equalsIgnoreCase("FeatureTypeList")) {
            return;
        }
        this.featureTypes.clear();
        NodeList nodeList = node.getChildNodes();
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Object object;
                Object object2;
                Node node2 = nodeList.item(i);
                if (this.normalize(node2.getNodeName()).equalsIgnoreCase("Operations")) {
                    this.serviceOperations.clear();
                    object2 = node2.getChildNodes();
                    if (object2 == null) continue;
                    for (int j = 0; j < object2.getLength(); ++j) {
                        Node node3 = object2.item(j);
                        object = node3.getNodeName();
                        if (object == null || ((String)object).trim().length() <= 0 || ((String)object).trim().equalsIgnoreCase("#text")) continue;
                        this.serviceOperations.add(((String)object).trim());
                    }
                    continue;
                }
                if (!this.normalize(node2.getNodeName()).equalsIgnoreCase("FeatureType")) continue;
                object2 = new WfsFeatureType();
                NodeList nodeList2 = node2.getChildNodes();
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    String string;
                    Object object3;
                    String string2;
                    object = nodeList2.item(j);
                    Node node4 = object.getFirstChild();
                    if (this.normalize(object.getNodeName()).equalsIgnoreCase("Name")) {
                        string2 = node4.getNodeValue().trim();
                        int n = string2.indexOf(":");
                        if (n > -1) {
                            ((WfsFeatureType)object2).setNameSpaceAlias(string2.substring(0, n));
                            ((WfsFeatureType)object2).setName(string2.substring(n + 1, string2.length()));
                            object3 = XMLDOMParser.getAttribute((Node)object, "xmlns:" + string2.substring(0, n));
                            if (object3 == null || ((String)object3).trim().length() <= 0) continue;
                            ((WfsFeatureType)object2).setNameSpaceAliasURL(((String)object3).trim());
                            continue;
                        }
                        ((WfsFeatureType)object2).setName(string2);
                        continue;
                    }
                    if (this.normalize(object.getNodeName()).equalsIgnoreCase("Title")) {
                        ((WfsFeatureType)object2).setTitle(node4.getNodeValue().trim());
                        continue;
                    }
                    if (this.normalize(object.getNodeName()).equalsIgnoreCase("Abstract")) {
                        ((WfsFeatureType)object2).setAbstract(node4.getNodeValue().trim());
                        continue;
                    }
                    if (this.normalize(object.getNodeName()).equalsIgnoreCase("Keyword")) {
                        ((WfsFeatureType)object2).setKeywords(node4.getNodeValue().trim());
                        continue;
                    }
                    if (this.normalize(object.getNodeName()).equalsIgnoreCase("SRS")) {
                        ((WfsFeatureType)object2).setSRS(node4.getNodeValue().trim());
                        continue;
                    }
                    if (this.normalize(object.getNodeName()).equalsIgnoreCase("LatLongBoundingBox")) {
                        string2 = XMLDOMParser.getAttribute((Node)object, "minx");
                        String string3 = XMLDOMParser.getAttribute((Node)object, "miny");
                        object3 = XMLDOMParser.getAttribute((Node)object, "maxx");
                        String string4 = XMLDOMParser.getAttribute((Node)object, "maxy");
                        if (string2 == null || string3 == null || object3 == null || string4 == null) continue;
                        double[] dArray = new double[4];
                        try {
                            dArray[0] = Double.parseDouble(string2);
                            dArray[1] = Double.parseDouble(string3);
                            dArray[2] = Double.parseDouble((String)object3);
                            dArray[3] = Double.parseDouble(string4);
                            ((WfsFeatureType)object2).setLatLongBoundingBox(dArray);
                        }
                        catch (Exception exception) {
                            dArray = null;
                        }
                        continue;
                    }
                    if (!this.normalize(object.getNodeName()).equalsIgnoreCase("MetadataURL")) continue;
                    string2 = XMLDOMParser.getAttribute((Node)object, "type");
                    if (string2 != null && string2.trim().length() > 0) {
                        ((WfsFeatureType)object2).setMetadataType(string2.trim());
                    }
                    if ((string = XMLDOMParser.getAttribute((Node)object, "format")) != null && string.trim().length() > 0) {
                        ((WfsFeatureType)object2).setMetadataFormat(string.trim());
                    }
                    if ((object3 = object.getFirstChild()) == null) continue;
                    ((WfsFeatureType)object2).setMetadataURL(object3.getNodeValue().trim());
                }
                if (((WfsFeatureType)object2).getNameSpaceAlias() != null) {
                    String string = XMLDOMParser.getAttribute(node2, "xmlns");
                    if (string != null && string.trim().length() > 0) {
                        ((WfsFeatureType)object2).setXMLNameSpace(string.trim());
                    }
                    if ((object = XMLDOMParser.getAttribute(node2, "xmlns:" + ((WfsFeatureType)object2).getNameSpaceAlias())) != null && ((String)object).trim().length() > 0) {
                        ((WfsFeatureType)object2).setNameSpaceAliasURL(((String)object).trim());
                    }
                }
                this.featureTypes.add(object2);
            }
        }
    }

    public String normalize(String string) {
        if (string == null) {
            return null;
        }
        if (string.indexOf(":") >= 0) {
            return string.substring(string.indexOf(":") + 1);
        }
        return string;
    }

    public WfsFeatureType getFeatureType(String string) {
        if (string == null || this.featureTypes.size() < 1) {
            return null;
        }
        for (int i = 0; i < this.featureTypes.size(); ++i) {
            WfsFeatureType wfsFeatureType = (WfsFeatureType)this.featureTypes.get(i);
            if (wfsFeatureType.getName() == null || !wfsFeatureType.getName().equalsIgnoreCase(string)) continue;
            return wfsFeatureType;
        }
        return null;
    }

    public String getXmlNameSpace(String string) {
        if (string == null) {
            return null;
        }
        return (String)this.xmlnsValues.get(string);
    }
}

