/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.util.HttpConnection;
import oracle.sdovis.util.HttpGetThread;
import oracle.sdovis.util.HttpPostThread;
import oracle.sdovis.util.Util;
import oracle.sdovis.util.WfsUtil;
import oracle.sdovis.util.XMLDOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WfsFeatureType {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private String name = null;
    private String nsAlias = null;
    private String nsAliasURL = null;
    private String xmlns = "http://www.opengis.net/wfs";
    private String title = null;
    private String abstractText = null;
    private String keywords = null;
    private String srs = null;
    private ArrayList operations = new ArrayList();
    private double[] latlongBoundingBox = null;
    private String metadataURL = null;
    private String metadataType = null;
    private String metadataFormat = null;
    private Hashtable attributeTypes = null;

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getNameSpaceAlias() {
        return this.nsAlias;
    }

    public void setNameSpaceAlias(String string) {
        this.nsAlias = string;
    }

    public String getNameSpaceAliasURL() {
        return this.nsAliasURL;
    }

    public void setNameSpaceAliasURL(String string) {
        this.nsAliasURL = string;
    }

    public String getXMLNameSpace() {
        return this.xmlns;
    }

    public void setXMLNameSpace(String string) {
        this.xmlns = string;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getAbstract() {
        return this.abstractText;
    }

    public void setAbstract(String string) {
        this.abstractText = string;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public void setKeywords(String string) {
        this.keywords = string;
    }

    public String getSRS() {
        return this.srs;
    }

    public void setSRS(String string) {
        this.srs = string;
    }

    public ArrayList getOperations() {
        return this.operations;
    }

    public void addOperation(String string) {
        if (string == null) {
            return;
        }
        this.operations.add(string);
    }

    public void removeOperation(String string) {
        if (string == null) {
            return;
        }
        this.operations.remove(string);
    }

    public void clearOperations() {
        this.operations.clear();
    }

    public double[] getLatLongBoundingBox() {
        return this.latlongBoundingBox;
    }

    public void setLatLongBoundingBox(double[] dArray) {
        this.latlongBoundingBox = dArray;
    }

    public String getMetadataURL() {
        return this.metadataURL;
    }

    public void setMetadataURL(String string) {
        this.metadataURL = string;
    }

    public String getMetadataType() {
        return this.metadataType;
    }

    public void setMetadataType(String string) {
        this.metadataType = string;
    }

    public String getMetadataFormat() {
        return this.metadataFormat;
    }

    public void setMetadataFormat(String string) {
        this.metadataFormat = string;
    }

    public Hashtable getAttributeTypes() {
        return this.attributeTypes;
    }

    public void setAttributeTypes(Hashtable hashtable) {
        this.attributeTypes = hashtable;
    }

    public String[] getAttributeNames() {
        if (this.attributeTypes == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration enumeration = this.attributeTypes.keys();
        while (enumeration.hasMoreElements()) {
            arrayList.add((String)enumeration.nextElement());
        }
        if (arrayList.size() == 0) {
            return null;
        }
        Collections.sort(arrayList);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public Hashtable readAttributesWithTypesUsingHttpGet(String string, long l) {
        String string2;
        block10: {
            if (string == null || string.trim().length() == 0 || this.name == null) {
                return null;
            }
            String string3 = "";
            if (this.nsAlias != null) {
                string3 = string3 + this.nsAlias + ":";
            }
            string3 = string3 + this.name;
            String string4 = string.trim();
            if (string4.lastIndexOf(63) > -1) {
                if (!string4.endsWith("?") && !string4.endsWith("&")) {
                    string4 = string4 + "&";
                }
            } else if (!string4.endsWith("&")) {
                string4 = string4 + "?";
            }
            string4 = string4 + "VERSION=1.0.0&SERVICE=WFS&REQUEST=DescribeFeatureType&TYPENAME=" + string3;
            log.info("Request: " + string4);
            string2 = "";
            try {
                if (l <= 0L) {
                    string2 = Util.issueHttpGetRequest(string4);
                    break block10;
                }
                HttpGetThread httpGetThread = new HttpGetThread(string4);
                httpGetThread.start();
                httpGetThread.checkTimeout(l);
                if (httpGetThread.isCompleted()) {
                    string2 = httpGetThread.getResponse();
                    break block10;
                }
                log.info("Request timeout.");
                httpGetThread = null;
                return null;
            }
            catch (Exception exception) {
                log.info(exception.getMessage());
                return null;
            }
        }
        this.attributeTypes = this.processAttributeTypesRequest(string2);
        return this.attributeTypes;
    }

    public Hashtable readAttributesWithTypesUsingHttpPost(String string, long l) {
        String string2;
        block7: {
            if (string == null || string.trim().length() == 0 || this.name == null) {
                return null;
            }
            String string3 = string.trim();
            String string4 = "";
            if (this.nsAlias != null) {
                string4 = string4 + this.nsAlias + ":";
            }
            string4 = string4 + this.name;
            String string5 = "";
            if (this.nsAlias != null && this.nsAliasURL != null) {
                string5 = "   xmlns:" + this.nsAlias + "=\"" + this.nsAliasURL + "\"\n";
            }
            String string6 = "<?xml version=\"1.0\" ?>\n<wfs:DescribeFeatureType\n   service=\"WFS\"\n   version=\"1.0.0\"\n   xmlns:wfs=\"" + this.xmlns + "\"\n" + string5 + "   xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n" + "   xmlns:xd=\"http://www.w3.org/2001/XMLSchema\"\n" + "   xsi:schemaLocation=\"http://www.opengis.net/wfs ../wfs/1.0.0/WFS-basic.xsd\">\n";
            string6 = string6 + "   <wfs:TypeName>" + string4 + "</wfs:TypeName>\n";
            string6 = string6 + "</wfs:DescribeFeatureType>\n";
            log.info("Request: " + string6);
            string2 = "";
            try {
                if (l <= 0L) {
                    HttpConnection httpConnection = new HttpConnection();
                    httpConnection.connect(string3);
                    httpConnection.sendXMLRequest("", string6);
                    string2 = httpConnection.getXMLResponse();
                    break block7;
                }
                HttpPostThread httpPostThread = new HttpPostThread(string3, string6, null);
                httpPostThread.start();
                httpPostThread.checkTimeout(l);
                if (httpPostThread.isCompleted()) {
                    string2 = httpPostThread.getResponse();
                    break block7;
                }
                log.info("Request timeout.");
                httpPostThread = null;
                return null;
            }
            catch (Exception exception) {
                log.info(exception.getMessage());
                return null;
            }
        }
        this.attributeTypes = this.processAttributeTypesRequest(string2);
        return this.attributeTypes;
    }

    private Hashtable processAttributeTypesRequest(String string) {
        if (string == null) {
            return null;
        }
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        try {
            Object object;
            Object object2;
            int n;
            Object object3;
            Object object4;
            int n2;
            Object object5;
            XMLDOMParser xMLDOMParser = new XMLDOMParser();
            if (!xMLDOMParser.parse(string)) {
                log.info("Unable to parse describe feature type result.");
                return null;
            }
            Document document = xMLDOMParser.getDocument();
            Object object6 = document.getFirstChild();
            if (object6 == null) {
                log.info("No root node found while processing attribute types.");
                return null;
            }
            if (object6.getNodeName().indexOf("schema") < 0) {
                object5 = document.getChildNodes();
                if (object5 == null || object5.getLength() < 1) {
                    log.info("Unable to find schema node.");
                    return null;
                }
                boolean bl = false;
                for (n2 = 0; n2 < object5.getLength(); ++n2) {
                    object4 = object5.item(n2);
                    if (object4.getNodeName().indexOf("schema") <= -1) continue;
                    object6 = object4;
                    bl = true;
                    break;
                }
                if (!bl) {
                    log.info("Unable to find schema node.");
                    return null;
                }
            }
            object5 = "";
            String string2 = object6.getNodeName();
            n2 = string2.indexOf(":");
            if (n2 > -1) {
                object5 = string2.substring(0, n2) + ":";
            } else {
                object4 = XMLDOMParser.getRealChildNodes((Node)object6);
                if (object4 != null) {
                    for (int i = 0; i < ((ArrayList)object4).size(); ++i) {
                        object3 = (Node)((ArrayList)object4).get(i);
                        n = object3.getNodeName().indexOf(":element");
                        if (n <= -1) continue;
                        object5 = object3.getNodeName().substring(0, n + 1);
                        break;
                    }
                }
            }
            object4 = WfsUtil.getChildNodes((Node)object6, (String)object5 + "element");
            String string3 = null;
            if (object4 != null) {
                for (int i = 0; i < ((Vector)object4).size(); ++i) {
                    Node node = (Node)((Vector)object4).get(i);
                    object2 = XMLDOMParser.getAttribute(node, "name");
                    if (object2 == null || !((String)object2).trim().equalsIgnoreCase((String)object2)) continue;
                    object = XMLDOMParser.getAttribute(node, "type");
                    if (object == null) continue;
                    string3 = Util.normalize(((String)object).trim());
                    break;
                }
            }
            if (string3 == null) {
                log.info("Unable to find feature type attribute.");
                return null;
            }
            object4 = WfsUtil.getChildNodes((Node)object6, (String)object5 + "complexType");
            object3 = null;
            if (object4 != null) {
                for (n = 0; n < ((Vector)object4).size(); ++n) {
                    object2 = (Node)((Vector)object4).get(n);
                    object = XMLDOMParser.getAttribute((Node)object2, "name");
                    if (object == null || !((String)object).trim().equalsIgnoreCase(string3)) continue;
                    object3 = object2;
                    break;
                }
            }
            if (object3 == null) {
                log.info("Unable to find feature node.");
                return null;
            }
            object4 = WfsUtil.getChildNodes((Node)object3, (String)object5 + "complexContent");
            if (object4 == null) {
                return null;
            }
            Node node = (Node)((Vector)object4).get(0);
            if ((object4 = WfsUtil.getChildNodes(node, (String)object5 + "extension")) == null) {
                log.info("Unable to find extension node.");
                return null;
            }
            object2 = (Node)((Vector)object4).get(0);
            if ((object4 = WfsUtil.getChildNodes((Node)object2, (String)object5 + "sequence")) == null) {
                log.info("Unable to find sequence node.");
                return null;
            }
            object = (Node)((Vector)object4).get(0);
            if ((object4 = WfsUtil.getChildNodes((Node)object, (String)object5 + "element")) == null) {
                log.info("Unable to find element nodes.");
                return null;
            }
            for (int i = 0; i < ((Vector)object4).size(); ++i) {
                NodeList nodeList;
                Object object7;
                Object object8;
                Node node2;
                Object object9;
                Node node3 = (Node)((Vector)object4).get(i);
                String string4 = XMLDOMParser.getAttribute(node3, "ref");
                if (string4 != null) {
                    if (string4.indexOf("gml:") == -1) {
                        hashtable.put(Util.normalize(string4), string4);
                        continue;
                    }
                    hashtable.put(string4, string4);
                    continue;
                }
                String string5 = XMLDOMParser.getAttribute(node3, "name");
                if (string5 == null) continue;
                String string6 = XMLDOMParser.getAttribute(node3, "type");
                if (string6 != null) {
                    object9 = Util.normalize(string6.trim());
                    hashtable.put(string5.trim(), object9);
                    continue;
                }
                object9 = WfsUtil.getChildNodes(node3, (String)object5 + "simpleType");
                if (object9 != null) {
                    node2 = (Node)((Vector)object9).get(0);
                    if ((object9 = WfsUtil.getChildNodes(node2, (String)object5 + "restriction")) == null) continue;
                    object8 = (Node)((Vector)object9).get(0);
                    string6 = XMLDOMParser.getAttribute((Node)object8, "base");
                    if (string6 == null) continue;
                    object7 = Util.normalize(string6.trim());
                    hashtable.put(string5.trim(), object7);
                    continue;
                }
                object9 = WfsUtil.getChildNodes(node3, (String)object5 + "complexType");
                if (object9 == null || (object8 = WfsUtil.getChildNodes(node2 = (Node)((Vector)object9).get(0), (String)object5 + "choice")) == null || (nodeList = (object7 = (Node)((Vector)object8).get(0)).getChildNodes()) == null) continue;
                String string7 = null;
                for (int j = 0; j < nodeList.getLength(); ++j) {
                    Node node4 = nodeList.item(j);
                    if (!Util.normalize(node4.getNodeName()).equalsIgnoreCase("element")) continue;
                    String string8 = XMLDOMParser.getAttribute(node4, "ref");
                    if (string8 == null || string8.trim().length() <= 0) continue;
                    if (string7 == null) {
                        if (string8.indexOf("gml:") == -1) {
                            string7 = Util.normalize(string8.trim());
                            continue;
                        }
                        string7 = string8.trim();
                        continue;
                    }
                    string7 = string8.indexOf("gml:") == -1 ? string7 + "," + Util.normalize(string8.trim()) : string7 + "," + string8.trim();
                }
                if (string7 == null) continue;
                hashtable.put(string5.trim(), string7);
            }
        }
        catch (Exception exception) {
            log.info("Exception in processAttributeTypesRequest: " + exception.getMessage());
            return null;
        }
        return hashtable;
    }
}

