/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.util;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XMLDOMParser {
    Document doc;
    DocumentBuilder parser;

    public XMLDOMParser() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setIgnoringComments(true);
            documentBuilderFactory.setIgnoringElementContentWhitespace(true);
            documentBuilderFactory.setCoalescing(true);
            documentBuilderFactory.setNamespaceAware(true);
            this.parser = documentBuilderFactory.newDocumentBuilder();
        }
        catch (Error error) {
            error.printStackTrace(System.err);
            System.err.println("Cannot create XMLDOMParser due to an error.");
            throw new IllegalArgumentException(error.getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            System.err.println("Cannot create XMLDOMParser due to an exception.");
            throw new IllegalArgumentException(exception.getMessage());
        }
    }

    public void close() {
        this.parser = null;
        this.doc = null;
    }

    public boolean parse(Reader reader) {
        try {
            this.doc = this.parser.parse(new InputSource(reader));
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return false;
        }
    }

    public boolean parse(String string) {
        return this.parse(new StringReader(string));
    }

    public Document getDocument() {
        return this.doc;
    }

    public Node getElementNode(String string) {
        NodeList nodeList = this.doc.getElementsByTagName(string);
        if (nodeList != null && nodeList.getLength() > 0) {
            return nodeList.item(0);
        }
        return null;
    }

    public Node getElementNode(String string, int n) {
        NodeList nodeList = this.doc.getElementsByTagName(string);
        if (nodeList != null && nodeList.getLength() >= n) {
            return nodeList.item(n);
        }
        return null;
    }

    public NodeList getElementNodes(String string) {
        return this.doc.getElementsByTagName(string);
    }

    public Node getLastElement(String string) {
        NodeList nodeList = this.doc.getElementsByTagName(string);
        if (nodeList != null && nodeList.getLength() > 0) {
            return nodeList.item(nodeList.getLength() - 1);
        }
        return null;
    }

    public Node getElementWithAttr(String string, String string2, String string3) {
        NodeList nodeList = this.doc.getElementsByTagName(string);
        if (nodeList != null && nodeList.getLength() > 0) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!string3.equals(XMLDOMParser.getAttribute(node, string2))) continue;
                return node;
            }
        }
        return null;
    }

    public static String getElementValue(Node node) {
        if (node == null) {
            return null;
        }
        NodeList nodeList = node.getChildNodes();
        if (nodeList == null || nodeList.getLength() == 0) {
            String string = node.getNodeValue();
            if (string == null) {
                return null;
            }
            return string;
        }
        String string = "";
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string2;
            Node node2 = nodeList.item(i);
            short s = node2.getNodeType();
            if (s != 3 && s != 6 && s != 4 && s != 5 && s != 12 || (string2 = node2.getNodeValue()) == null) continue;
            string = string + string2;
        }
        return (string = string.trim()) == null || string.length() == 0 ? null : string;
    }

    public String getElementValue(String string) {
        NodeList nodeList = this.doc.getElementsByTagName(string);
        if (nodeList != null && nodeList.getLength() > 0) {
            Node node = nodeList.item(0).getFirstChild();
            if (node == null) {
                return null;
            }
            return XMLDOMParser.getElementValue(node);
        }
        return null;
    }

    public String getAttribute(String string, String string2) {
        NodeList nodeList = this.doc.getElementsByTagName(string);
        if (nodeList != null && nodeList.getLength() > 0) {
            NamedNodeMap namedNodeMap = nodeList.item(0).getAttributes();
            if (namedNodeMap == null) {
                return null;
            }
            Node node = namedNodeMap.getNamedItem(string2);
            if (node != null) {
                return node.getNodeValue();
            }
            return null;
        }
        return null;
    }

    public String getElementValue(String string, int n) {
        NodeList nodeList = this.doc.getElementsByTagName(string);
        if (nodeList != null && nodeList.getLength() >= n) {
            Node node = nodeList.item(n);
            return XMLDOMParser.getElementValue(node);
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    public static Document parseToDoc(String var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String getSubElementValue(Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!node2.getNodeName().equals(string)) continue;
            return XMLDOMParser.getElementValue(node2);
        }
        return null;
    }

    public static Node getSubElement(Node node, String string) {
        if (node == null) {
            return null;
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!node2.getNodeName().equals(string)) continue;
            return node2;
        }
        return null;
    }

    public static Node getSubElementStartsWith(Node node, String string) {
        if (node == null) {
            return null;
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!node2.getNodeName().startsWith(string)) continue;
            return node2;
        }
        return null;
    }

    public static ArrayList getSubElements(Node node, String string) {
        int n = 0;
        ArrayList<Node> arrayList = null;
        NodeList nodeList = node.getChildNodes();
        n = nodeList.getLength();
        if (n <= 0) {
            return null;
        }
        arrayList = new ArrayList<Node>(n);
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            if (!node2.getNodeName().equals(string)) continue;
            arrayList.add(node2);
        }
        return arrayList;
    }

    public static ArrayList getRealChildNodes(Node node) {
        if (!node.hasChildNodes()) {
            return null;
        }
        NodeList nodeList = node.getChildNodes();
        ArrayList<Node> arrayList = new ArrayList<Node>(nodeList.getLength());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            arrayList.add(node2);
        }
        return arrayList;
    }

    public static Node getFirstRealChildNode(Node node) {
        if (!node.hasChildNodes()) {
            return null;
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            return node2;
        }
        return null;
    }

    public static Vector getSubNodesWithTagName(Node node, String string) {
        int n = 0;
        Vector<Node> vector = null;
        NodeList nodeList = node.getChildNodes();
        n = nodeList.getLength();
        if (n <= 0) {
            return null;
        }
        vector = new Vector<Node>(n);
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            if (!node2.getNodeName().equals(string)) continue;
            vector.add(node);
        }
        return vector;
    }

    public static Node getAnySubElement(Node node, String string) {
        NodeList nodeList;
        if (node.getNodeName().equals(string)) {
            return node;
        }
        if (node.hasChildNodes() && (nodeList = node.getChildNodes()) != null && nodeList.getLength() > 0) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = XMLDOMParser.getAnySubElement(nodeList.item(i), string);
                if (node2 == null) continue;
                return node2;
            }
        }
        return null;
    }

    public static String getValue(Node node) {
        return XMLDOMParser.getElementValue(node);
    }

    public static String getAttribute(Node node, String string) {
        if (node == null) {
            return null;
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap == null || namedNodeMap.getLength() == 0) {
            return null;
        }
        Node node2 = namedNodeMap.getNamedItem(string);
        return node2 != null ? node2.getNodeValue() : null;
    }

    public static void dumpNode(Node node) {
        System.out.println("Node name:  " + node.getNodeName());
        System.out.println("Node type:  " + XMLDOMParser.getNodeTypeName(node));
        String string = node.getNodeValue();
        if (string != null) {
            string = string.trim();
        }
        if (string != null && string.length() == 0) {
            System.out.println("Node value: \"\"");
        } else {
            System.out.println("Node value: " + string);
        }
    }

    public static void dumpAllNodes(Node node) {
        Node node2;
        XMLDOMParser.dumpNode(node);
        if (node.hasChildNodes()) {
            System.out.print("\n");
            node2 = node.getFirstChild();
            XMLDOMParser.dumpAllNodes(node2);
        }
        if ((node2 = node.getNextSibling()) != null) {
            System.out.print("\n");
            XMLDOMParser.dumpAllNodes(node2);
        }
    }

    public static void dumpAllDescendants(Node node) {
        XMLDOMParser.dumpNode(node);
        if (node.hasChildNodes()) {
            System.out.print("\n");
            Node node2 = node.getFirstChild();
            XMLDOMParser.dumpAllDescendants(node2);
        }
    }

    public static String getNodeTypeName(Node node) {
        short s = node.getNodeType();
        switch (s) {
            case 1: {
                return "Element";
            }
            case 2: {
                return "Attribute";
            }
            case 3: {
                return "Text";
            }
            case 4: {
                return "CDATA Section";
            }
            case 5: {
                return "Entity Reference";
            }
            case 6: {
                return "Entity";
            }
            case 7: {
                return "Processing Instruction";
            }
            case 8: {
                return "Comment";
            }
            case 9: {
                return "Document";
            }
            case 10: {
                return "Document Type Declaration";
            }
            case 11: {
                return "Document Fragment";
            }
            case 12: {
                return "Notation";
            }
        }
        return "Unknown Type";
    }
}

