/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.olapi.data.full;

import java.util.ArrayList;
import java.util.List;
import oracle.express.ExpressServerException;
import oracle.express.ObjectClosedException;
import oracle.express.TaskInterruptedException;
import oracle.express.idl.ExpressModule.ExpressException;
import oracle.express.idl.ExpressModule.InvalidMetadataException;
import oracle.express.idl.ExpressModule.RemoteObjectClosedException;
import oracle.express.idl.ExpressModule.RemoteTaskInterruptedException;
import oracle.express.idl.ExpressOlapiDataCursorModule.CursorManagerInterface;
import oracle.express.idl.ExpressOlapiDataSourceModule.UnmatchedInputsException;
import oracle.express.idl.util.InterfaceStub;
import oracle.express.idl.util.WstringHolder;
import oracle.express.idl.util.XMLWriter;
import oracle.express.olapi.data.full.BaseCursorManager;
import oracle.express.olapi.data.full.CursorLockReleaser;
import oracle.express.olapi.data.full.DefinitionManager;
import oracle.express.olapi.data.full.ParameterToXMLConverter;
import oracle.express.olapi.data.full.SourceConverter;
import oracle.olapi.data.source.CursorLockException;
import oracle.olapi.data.source.Parameter;
import oracle.olapi.data.source.SQLCursorManager;
import oracle.olapi.data.source.Source;
import oracle.olapi.transaction.Transaction;
import org.omg.CORBA.NO_IMPLEMENT;

public class ExpressSQLCursorManager
extends BaseCursorManager
implements SQLCursorManager {
    ExpressSQLCursorManager(Source source, CursorManagerInterface cursorManagerInterface, long l, DefinitionManager definitionManager, List list) {
        super(source, cursorManagerInterface, l, definitionManager, list);
    }

    public final String generateSQL() {
        StringBuffer stringBuffer = new StringBuffer();
        this.generateSQL(stringBuffer);
        return stringBuffer.toString();
    }

    public final void generateSQL(StringBuffer stringBuffer) {
        Object object;
        String string;
        if (this.getParameters().size() == 0) {
            string = " ";
        } else {
            Object object22;
            object = new ParameterToXMLConverter();
            XMLWriter xMLWriter = new XMLWriter((InterfaceStub)((Object)this.getCursorManagerInterface()));
            ((ParameterToXMLConverter)object).setWriter(xMLWriter);
            xMLWriter.beginElement("ClientData");
            xMLWriter.closeTag();
            xMLWriter.beginElement("SourceDefinitions");
            xMLWriter.closeTag();
            for (Object object22 : this.getParameters()) {
                ((ParameterToXMLConverter)object).visitParameter((Parameter)object22);
            }
            xMLWriter.endElement("SourceDefinitions");
            xMLWriter.newLine();
            xMLWriter.endElement("ClientData");
            object22 = new StringBuffer(xMLWriter.getStringLength());
            StringBuffer[] stringBufferArray = xMLWriter.getSegmentedStrings();
            for (int i = 0; i < stringBufferArray.length; ++i) {
                ((StringBuffer)object22).append(stringBufferArray[i]);
            }
            string = ((StringBuffer)object22).toString();
        }
        object = new WstringHolder();
        try {
            this.getCursorManagerInterface().generateSQL(string, (WstringHolder)object);
        }
        catch (ExpressException expressException) {
            throw new ExpressServerException(expressException);
        }
        catch (RemoteObjectClosedException remoteObjectClosedException) {
            this._closed();
            throw new ObjectClosedException(remoteObjectClosedException.toString());
        }
        catch (RemoteTaskInterruptedException remoteTaskInterruptedException) {
            throw new TaskInterruptedException(remoteTaskInterruptedException.toString());
        }
        catch (NO_IMPLEMENT nO_IMPLEMENT) {
            this._closed();
            throw new ObjectClosedException(nO_IMPLEMENT.toString());
        }
        catch (UnmatchedInputsException unmatchedInputsException) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < unmatchedInputsException.ids.length; ++i) {
                arrayList.add(unmatchedInputsException.ids[i]);
            }
            throw new oracle.olapi.data.source.UnmatchedInputsException(arrayList);
        }
        catch (InvalidMetadataException invalidMetadataException) {
            throw new oracle.olapi.metadata.InvalidMetadataException(invalidMetadataException);
        }
        stringBuffer.append(((WstringHolder)object).value);
    }

    protected final void localCreateDefinitionSequence(Transaction transaction, SourceConverter sourceConverter) {
        boolean bl = false;
        Source[] sourceArray = new Source[]{};
        try {
            sourceConverter.convertDefinitionTree(this.getSource().getDefinition(), sourceArray, bl, this.getCursorManagerID(), false, this.getParameters());
        }
        catch (CursorLockException cursorLockException) {
            CursorLockReleaser.releaseCursorLock(this.getSource().getDefinition(), this.getDefinitionManager());
            throw cursorLockException;
        }
    }
}

