/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata;

import java.util.List;
import java.util.Set;
import oracle.olapi.metadata.BaseMetadataObject;
import oracle.olapi.metadata.MetadataObject;
import oracle.olapi.metadata.MetadataObjectHolder;
import oracle.olapi.metadata.MetadataToXMLConverter;
import oracle.olapi.metadata.MetadataToXMLConverterSince10105;
import oracle.olapi.metadata.XMLTag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class MetadataProperty {
    private XMLTag m_PropertyTag = null;

    MetadataProperty(XMLTag xMLTag) {
        this.setPropertyTag(xMLTag);
    }

    MetadataProperty(MetadataProperty metadataProperty) {
        this.setPropertyTag(metadataProperty.getPropertyTag());
    }

    abstract boolean addChildrenToXMLWriter(MetadataToXMLConverter var1, List var2);

    abstract void gatherReferencedSources(List var1);

    abstract void appendXMLString(MetadataToXMLConverter var1, BaseMetadataObject var2);

    abstract void appendIncrementalXMLString(MetadataToXMLConverter var1, BaseMetadataObject var2);

    XMLTag getPropertyTag() {
        return this.m_PropertyTag;
    }

    abstract boolean isAttribute(MetadataToXMLConverter var1, BaseMetadataObject var2);

    private final void setPropertyTag(XMLTag xMLTag) {
        this.m_PropertyTag = xMLTag;
    }

    abstract MetadataProperty cloneProperty(boolean var1);

    public final int getXMLFormatType() {
        return this.getPropertyTag().getXMLType();
    }

    abstract void updateFromChild(MetadataProperty var1);

    abstract void updateFromParent(MetadataProperty var1);

    final boolean isXMLWriteable(MetadataToXMLConverter metadataToXMLConverter, BaseMetadataObject baseMetadataObject) {
        if (metadataToXMLConverter.getXMLFormat().is10gMode()) {
            return true;
        }
        if (this.getPropertyTag().getXMLType() == 8) {
            return false;
        }
        if (!this.getPropertyTag().isWritableForVersion(metadataToXMLConverter)) {
            return false;
        }
        if (this.getPropertyTag().getXMLType() == 3) {
            return true;
        }
        if (metadataToXMLConverter.getXMLFormat().is11gFullXMLMode() && metadataToXMLConverter.isModifiedObject(baseMetadataObject)) {
            return true;
        }
        if (metadataToXMLConverter.getXMLFormat().is11gPartialXMLMode() && this.isModification(metadataToXMLConverter, baseMetadataObject)) {
            return true;
        }
        return this.getPropertyTag().isXMLContainedObject();
    }

    final boolean isXMLWriteableContainedObject(MetadataToXMLConverter metadataToXMLConverter, BaseMetadataObject baseMetadataObject, MetadataObject metadataObject) {
        if (metadataToXMLConverter.getXMLFormat().is10gMode()) {
            return true;
        }
        if (!(metadataObject instanceof BaseMetadataObject) || !(metadataToXMLConverter instanceof MetadataToXMLConverterSince10105)) {
            return true;
        }
        if (metadataToXMLConverter.getXMLFormat().is11gFullXMLMode() && metadataToXMLConverter.isModifiedObject(baseMetadataObject)) {
            metadataToXMLConverter.addMetadataObject((BaseMetadataObject)metadataObject);
            return true;
        }
        return ((MetadataToXMLConverterSince10105)metadataToXMLConverter).isObjectInModifiedTree((BaseMetadataObject)metadataObject);
    }

    boolean isModification(MetadataToXMLConverter metadataToXMLConverter, BaseMetadataObject baseMetadataObject) {
        return metadataToXMLConverter.isModifiedObject(baseMetadataObject);
    }

    abstract boolean isServerSendable(MetadataProperty var1);

    void getRemovedElements(Set set) {
    }

    void getAssociatedObjects(List list) {
    }

    void updatePersistentState(short s) {
    }

    void revertPersistentState() {
    }

    abstract boolean isLocal();

    void gatherMetadataObjects(List<MetadataObjectHolder> list) {
    }
}

