/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.javacompiler;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.ide.util.Assert;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.parser.java.v2.JavaParser;
import oracle.javatools.parser.java.v2.JdkVersion;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.javatools.parser.java.v2.model.SourceMemberVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceTypeArgument;
import oracle.javatools.parser.java.v2.model.SourceTypeParameter;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.jdevimpl.javacompiler.FileReadTextBuffer;

public class JavaDependencyProvider {
    private Set<Data> data = new LinkedHashSet<Data>();
    private Map<String, Set<File>> classNameUsedBy = new HashMap<String, Set<File>>();
    private Map<File, Data> fileToData = new HashMap<File, Data>();
    private String sourceJDK;
    private String encoding;
    private boolean collectCdiHashCodes;
    private long timeToCollectCdiHashCodes;
    private static final int MAGIC_HEADER_10_1_3 = 0x10010300;
    private static final int elementCount_10_1_3 = 7;
    private static final int MAGIC_HEADER_11_1_2 = 0x10011120;
    private static final int elementCount_11_1_2 = 8;
    private static final int MAGIC_HEADER_12_1_1 = 0x10012110;
    private static final int elementCount_12_1_1 = 9;
    private long tickHolder;
    private static List<Listener> listeners;

    public JavaDependencyProvider() {
    }

    public JavaDependencyProvider(String encoding, boolean collectCdiHashCodes) {
        this.encoding = encoding;
        this.collectCdiHashCodes = collectCdiHashCodes;
    }

    public void reinit() {
        this.data.clear();
        this.classNameUsedBy.clear();
        this.fileToData.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectSourceFile(SourceFile sf, File path, boolean dependant, Data currentData) throws IOException {
        Data newData = new Data();
        newData.fileName = path.getPath();
        newData.lastModified = path.lastModified();
        newData.packageName = sf.getPackageName();
        newData.isDependency = dependant;
        List typeList = sf.getPossibleTypes();
        String[] typeArray = new String[typeList.size()];
        typeList.toArray(typeArray);
        Data.access$502(newData, typeArray);
        List classList = sf.getSourceClasses();
        Iterator it = classList.iterator();
        String[] classArray = new String[classList.size()];
        int i = 0;
        while (it.hasNext()) {
            classArray[i] = ((SourceClass)it.next()).getName();
            ++i;
        }
        Data.access$602(newData, classArray);
        List imports = sf.getSourceImports();
        it = imports.iterator();
        String[] importArray = new String[imports.size()];
        int i2 = 0;
        while (it.hasNext()) {
            importArray[i2] = ((SourceImport)it.next()).getName();
            ++i2;
        }
        Data.access$702(newData, importArray);
        long hashCode = 0L;
        if (this.collectCdiHashCodes) {
            this.startTiming();
            it = classList.iterator();
            int i3 = 0;
            while (it.hasNext()) {
                SourceClass sourceClass = (SourceClass)it.next();
                try {
                    hashCode += this.collectClassHashcode(sourceClass);
                }
                catch (Exception ex) {
                    Assert.printStackTrace((String)"Collecting hashcode of class signature");
                }
                ++i3;
            }
            this.timeToCollectCdiHashCodes += this.elapsedTimeMs();
        }
        newData.signaturesHashcode = hashCode;
        if (currentData == null) {
            this.data.add(newData);
        } else {
            newData.auditFlag = currentData.auditFlag;
            if (newData.signaturesHashcode != 0L && currentData.signaturesHashcode != 0L && newData.signaturesHashcode != currentData.signaturesHashcode) {
                JavaDependencyProvider javaDependencyProvider = this;
                synchronized (javaDependencyProvider) {
                    if (listeners != null) {
                        ArrayList<String> classNames = new ArrayList<String>();
                        it = classList.iterator();
                        int i4 = 0;
                        while (it.hasNext()) {
                            SourceClass sourceClass = (SourceClass)it.next();
                            String className = sourceClass.getRawName();
                            if (className != null) {
                                classNames.add(className);
                            }
                            ++i4;
                        }
                        for (Listener listener : listeners) {
                            listener.classSignaturesChanged(classNames);
                        }
                    }
                }
            }
            this.data.remove(currentData);
            this.data.add(newData);
        }
    }

    private long collectClassHashcode(SourceClass sourceClass) {
        if (sourceClass == null) {
            return 0L;
        }
        long hashCode = 0L;
        List classes = sourceClass.getSourceClasses();
        Iterator classIter = classes.iterator();
        while (classIter.hasNext()) {
            hashCode += this.collectClassHashcode((SourceClass)classIter.next());
        }
        if (sourceClass.isPrivate() || sourceClass.isPackagePrivate()) {
            return hashCode;
        }
        hashCode += (long)sourceClass.getModifiers();
        String name = sourceClass.getName();
        hashCode += name == null ? 0L : (long)name.hashCode();
        List typeParameters = sourceClass.getSourceTypeParameters();
        Iterator typeParamIter = typeParameters.iterator();
        while (typeParamIter.hasNext()) {
            hashCode += this.collectTypeParameterHashCode((SourceTypeParameter)typeParamIter.next());
        }
        SourceTypeReference superClass = sourceClass.getSourceSuperclass();
        hashCode += this.collectTypeReferenceHashCode(superClass);
        List interfaces = sourceClass.getSourceInterfaces();
        for (SourceTypeReference oneInterface : interfaces) {
            hashCode += this.collectTypeReferenceHashCode(oneInterface);
        }
        Collection variables = sourceClass.getSourceMemberVariables();
        for (SourceMemberVariable field : variables) {
            if (field.isPrivate() || field.isPackagePrivate()) continue;
            hashCode += this.collectVariableHashCode((SourceVariable)field);
        }
        List constructors = sourceClass.getSourceConstructors();
        for (SourceMethod constructor : constructors) {
            if (constructor.isPrivate() || constructor.isPackagePrivate()) continue;
            hashCode += this.collectMethodHashCode(constructor);
        }
        List methods = sourceClass.getSourceMethods();
        for (SourceMethod method : methods) {
            if (method.isPrivate() || method.isPackagePrivate()) continue;
            hashCode += this.collectMethodHashCode(method);
        }
        return hashCode;
    }

    private long collectVariableHashCode(SourceVariable variable) {
        if (variable == null) {
            return 0L;
        }
        long hashCode = 0L;
        hashCode += (long)variable.getModifiers();
        String name = variable.getName();
        hashCode += name == null ? 0L : (long)name.hashCode();
        return hashCode += this.collectTypeReferenceHashCode(variable.getSourceType());
    }

    private long collectMethodHashCode(SourceMethod method) {
        if (method == null) {
            return 0L;
        }
        long hashCode = 0L;
        hashCode += (long)method.getModifiers();
        String name = method.getName();
        hashCode += name == null ? 0L : (long)name.hashCode();
        hashCode += this.collectTypeReferenceHashCode(method.getSourceReturnType());
        List sourceTypeParams = method.getSourceTypeParameters();
        for (SourceTypeParameter typeParam : sourceTypeParams) {
            hashCode += this.collectTypeParameterHashCode(typeParam);
        }
        List params = method.getSourceParameters();
        for (SourceVariable param : params) {
            hashCode += this.collectVariableHashCode(param);
        }
        return hashCode;
    }

    private long collectTypeArgumentHashCode(SourceTypeArgument typeArgument) {
        if (typeArgument == null) {
            return 0L;
        }
        long hashCode = 0L;
        SourceTypeReference reference = typeArgument.getSourceType();
        hashCode += this.collectTypeReferenceHashCode(reference);
        return hashCode += (long)typeArgument.getBound();
    }

    private long collectTypeReferenceHashCode(SourceTypeReference type) {
        if (type == null) {
            return 0L;
        }
        long hashCode = 0L;
        String name = type.getName();
        hashCode += name == null ? 0L : (long)name.hashCode();
        if (type.isGeneric()) {
            List arguments = type.getTypeArguments();
            for (SourceTypeArgument argument : arguments) {
                hashCode += this.collectTypeArgumentHashCode(argument);
            }
        }
        return hashCode;
    }

    private long collectTypeParameterHashCode(SourceTypeParameter typeParameter) {
        if (typeParameter == null) {
            return 0L;
        }
        long hashCode = 0L;
        String name = typeParameter.getName();
        hashCode += name == null ? 0L : (long)name.hashCode();
        List bounds = typeParameter.getSourceBounds();
        for (SourceTypeReference bound : bounds) {
            hashCode += this.collectTypeReferenceHashCode(bound);
        }
        return hashCode;
    }

    private static String[] resolveTypes(String pkgName, String[] types, String[] imports, Set<String> pkgs, Map<String, Set<File>> classNameUsedBy) {
        int i;
        HashMap<String, String> importSuffixes = new HashMap<String, String>();
        ArrayList<String> wideImports = new ArrayList<String>();
        boolean javaLangFound = false;
        for (i = 0; i < imports.length; ++i) {
            String imp = imports[i];
            int lastDot = imp.lastIndexOf(46);
            if (lastDot < 0) continue;
            if (imp.endsWith("*")) {
                String wideImport = imp.substring(0, lastDot);
                if (pkgs.contains(wideImport)) {
                    wideImports.add(wideImport);
                }
                javaLangFound = wideImport.equals("java.lang");
                continue;
            }
            importSuffixes.put(imp.substring(lastDot + 1), imp);
        }
        if (!javaLangFound && pkgs.contains("java.lang")) {
            wideImports.add("java.lang");
        }
        for (i = 0; i < types.length; ++i) {
            String clsName;
            String match;
            String type = types[i];
            int dot = type.indexOf(46);
            if (dot >= 0) {
                if (classNameUsedBy.get(type) != null) continue;
                type = type.substring(0, dot);
            }
            if ((match = (String)importSuffixes.get(type)) != null) {
                types[i] = match;
                continue;
            }
            boolean found = false;
            for (int j = 0; j < wideImports.size(); ++j) {
                String qName = (String)wideImports.get(j) + type;
                if (classNameUsedBy.get(qName) == null) continue;
                types[i] = qName;
                found = true;
                break;
            }
            if (found || classNameUsedBy.get(clsName = pkgName + '.' + type) == null) continue;
            types[i] = clsName;
        }
        return types;
    }

    private void computeDependencies() {
        Set<File> usedBy;
        String pkgName;
        this.classNameUsedBy.clear();
        HashSet<String> pkgs = new HashSet<String>(this.data.size() * 2);
        HashMap<String, Data> classNameToData = new HashMap<String, Data>(this.data.size() * 2);
        for (Data currentData : this.data) {
            pkgName = currentData.packageName;
            pkgs.add(pkgName);
            File file = currentData.getFile();
            String[] classes = currentData.definedClasses;
            for (int j = 0; j < classes.length; ++j) {
                String className = pkgName + '.' + classes[j];
                usedBy = this.classNameUsedBy.get(className);
                classNameToData.put(className, currentData);
                if (usedBy == null) {
                    usedBy = new LinkedHashSet<File>();
                    usedBy.add(file);
                    this.classNameUsedBy.put(className, usedBy);
                    continue;
                }
                Iterator<File> usedByIter = usedBy.iterator();
                File otherSource = usedByIter.next();
                if (file.getPath().equals(otherSource.getPath())) continue;
                System.out.println("------  DependencyProvider Error: class " + className + " from source " + file.getPath() + " already defined in source " + otherSource.getPath());
            }
        }
        for (Data currentData : this.data) {
            pkgName = currentData.packageName;
            String[] typeList = currentData.typeReferences;
            String[] imports = currentData.imports;
            Data.access$502(currentData, JavaDependencyProvider.resolveTypes(pkgName, typeList, imports, pkgs, this.classNameUsedBy));
        }
        for (Data currentData : this.data) {
            File file = currentData.getFile();
            for (String typeReference : currentData.typeReferences) {
                usedBy = this.classNameUsedBy.get(typeReference);
                if (usedBy == null) continue;
                usedBy.add(file);
            }
        }
    }

    private static String[] readStringArray(DataInputStream is, ArrayList strArray) throws IOException {
        String[] a = new String[is.readInt()];
        for (int i = 0; i < a.length; ++i) {
            a[i] = (String)strArray.get(is.readInt());
        }
        return a;
    }

    public void load(File dependencyFile) throws IOException {
        try {
            this.loadImpl(dependencyFile);
        }
        catch (IOException iox) {
            throw iox;
        }
        catch (Exception ex) {
            Assert.printStackTrace((Throwable)ex);
            throw new IOException("Corrupt CDI file");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadImpl(File dependencyFile) throws Exception {
        byte[] ba;
        ArrayList<String> strArray;
        int magicSignature;
        FileInputStream fileInput = null;
        FilterInputStream dataInput = null;
        try {
            int read;
            fileInput = new FileInputStream(dependencyFile);
            dataInput = new DataInputStream(fileInput);
            magicSignature = ((DataInputStream)dataInput).readInt();
            if (magicSignature != 0x10010300 && magicSignature != 0x10011120 && magicSignature != 0x10012110) {
                String msg = "Unknown magic cdi file signature: 0X" + Integer.toHexString(magicSignature);
                System.out.println(msg);
                throw new IOException(msg);
            }
            int strCount = ((DataInputStream)dataInput).readInt();
            strArray = new ArrayList<String>(strCount);
            for (int i = 0; i < strCount; ++i) {
                strArray.add(((DataInputStream)dataInput).readUTF());
            }
            int len = ((DataInputStream)dataInput).readInt();
            ba = new byte[len];
            int base = 0;
            do {
                if ((read = ((DataInputStream)dataInput).read(ba, base, len)) < 0) {
                    break;
                }
                base += read;
            } while ((len -= read) > 0);
        }
        finally {
            if (dataInput != null) {
                dataInput.close();
            } else if (fileInput != null) {
                fileInput.close();
            }
        }
        dataInput = null;
        ByteArrayInputStream byteInput = null;
        try {
            byteInput = new ByteArrayInputStream(ba);
            dataInput = new DataInputStream(byteInput);
            int dataCount = ((DataInputStream)dataInput).readInt();
            int elementCount = magicSignature == 0x10010300 ? 7 : (magicSignature == 0x10011120 ? 8 : 9);
            assert (dataCount % elementCount == 0);
            for (int i = 0; i < dataCount; i += elementCount) {
                Data currentData = new Data();
                currentData.fileName = (String)strArray.get(((DataInputStream)dataInput).readInt());
                currentData.lastModified = ((DataInputStream)dataInput).readLong();
                currentData.packageName = (String)strArray.get(((DataInputStream)dataInput).readInt());
                Data.access$502(currentData, JavaDependencyProvider.readStringArray((DataInputStream)dataInput, strArray));
                Data.access$602(currentData, JavaDependencyProvider.readStringArray((DataInputStream)dataInput, strArray));
                Data.access$702(currentData, JavaDependencyProvider.readStringArray((DataInputStream)dataInput, strArray));
                boolean dep = ((DataInputStream)dataInput).readBoolean();
                currentData.isDependency = dep;
                if (magicSignature >= 0x10011120) {
                    currentData.auditFlag = ((DataInputStream)dataInput).readByte();
                }
                if (magicSignature >= 0x10012110) {
                    currentData.signaturesHashcode = ((DataInputStream)dataInput).readLong();
                }
                this.data.add(currentData);
            }
        }
        finally {
            if (dataInput != null) {
                dataInput.close();
            } else if (byteInput != null) {
                byteInput.close();
            }
        }
    }

    private static int indexedStr(String str, HashMap strMap, ArrayList strArray) {
        Integer I = (Integer)strMap.get(str);
        if (I != null) {
            return I;
        }
        int i = strArray.size();
        strArray.add(str);
        strMap.put(str, i);
        return i;
    }

    private static void writeStringArray(String[] strs, DataOutputStream os, HashMap strMap, ArrayList strArray) throws IOException {
        os.writeInt(strs.length);
        for (int i = 0; i < strs.length; ++i) {
            os.writeInt(JavaDependencyProvider.indexedStr(strs[i], strMap, strArray));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File cdiFile) throws IOException {
        FileOutputStream fileOutput = null;
        FilterOutputStream dataOutput = null;
        ByteArrayOutputStream byteArray = null;
        HashMap strMap = new HashMap();
        ArrayList strArray = new ArrayList();
        try {
            byteArray = new ByteArrayOutputStream(this.data.size() / 9 * 64);
            dataOutput = new DataOutputStream(byteArray);
            ((DataOutputStream)dataOutput).writeInt(this.data.size() * 9);
            for (Data currentData : this.data) {
                ((DataOutputStream)dataOutput).writeInt(JavaDependencyProvider.indexedStr(currentData.fileName, strMap, strArray));
                ((DataOutputStream)dataOutput).writeLong(currentData.lastModified);
                ((DataOutputStream)dataOutput).writeInt(JavaDependencyProvider.indexedStr(currentData.packageName, strMap, strArray));
                JavaDependencyProvider.writeStringArray(currentData.typeReferences, (DataOutputStream)dataOutput, strMap, strArray);
                JavaDependencyProvider.writeStringArray(currentData.definedClasses, (DataOutputStream)dataOutput, strMap, strArray);
                JavaDependencyProvider.writeStringArray(currentData.imports, (DataOutputStream)dataOutput, strMap, strArray);
                ((DataOutputStream)dataOutput).writeBoolean(currentData.isDependency);
                ((DataOutputStream)dataOutput).writeByte(currentData.auditFlag);
                ((DataOutputStream)dataOutput).writeLong(currentData.signaturesHashcode);
            }
        }
        finally {
            if (dataOutput != null) {
                dataOutput.close();
            } else if (byteArray != null) {
                byteArray.close();
            }
        }
        dataOutput = null;
        try {
            fileOutput = new FileOutputStream(cdiFile);
            dataOutput = new DataOutputStream(fileOutput);
            ((DataOutputStream)dataOutput).writeInt(0x10012110);
            ((DataOutputStream)dataOutput).writeInt(strArray.size());
            for (int j = 0; j < strMap.size(); ++j) {
                ((DataOutputStream)dataOutput).writeUTF((String)strArray.get(j));
            }
            ((DataOutputStream)dataOutput).writeInt(byteArray.size());
            dataOutput.write(byteArray.toByteArray());
        }
        finally {
            if (dataOutput != null) {
                dataOutput.close();
            } else if (fileOutput != null) {
                fileOutput.close();
            }
        }
    }

    public ArrayList<File> updateData(ArrayList<File> fileList, boolean rebuild, String sourcePath) throws IOException {
        String[] sourcePaths;
        ArrayList<File> newParses = new ArrayList<File>();
        JdkVersion javaParserJdkVersion = this.getJavaParserJdkVersion();
        if (sourcePath != null && !sourcePath.trim().isEmpty()) {
            sourcePaths = sourcePath.split(File.pathSeparator);
            for (int x = 0; x < sourcePaths.length; ++x) {
                sourcePaths[x] = sourcePaths[x].replace('\\', '/') + '/';
            }
        } else {
            sourcePaths = new String[]{};
        }
        ArrayList<Data> toRemove = new ArrayList<Data>();
        this.fileToData.clear();
        for (Data currentData : this.data) {
            File currentDataFile = currentData.getFile();
            String filePath = currentDataFile.getPath().replace('\\', '/');
            boolean found = false;
            for (String oneSourcePath : sourcePaths) {
                if (!filePath.startsWith(oneSourcePath)) continue;
                found = true;
                break;
            }
            if (!found) {
                Assert.println((String)("------  Removing dependency info from file with invalid path: " + currentData.getFile().getPath()));
                toRemove.add(currentData);
                continue;
            }
            this.fileToData.put(currentDataFile, currentData);
        }
        for (Data currentData : toRemove) {
            this.data.remove(currentData);
        }
        int filesParsed = 0;
        this.startTiming();
        for (File file : fileList) {
            long d2;
            long d1;
            if (Thread.currentThread().isInterrupted()) {
                return new ArrayList<File>(0);
            }
            Data currentData = this.fileToData.get(file);
            if (!rebuild && currentData != null && (d1 = currentData.lastModified) >= (d2 = file.lastModified())) continue;
            FileReadTextBuffer buffer = FileReadTextBuffer.init(file, this.encoding);
            if (buffer != null) {
                SourceFile sf = JavaParser.parse((ReadTextBuffer)buffer, (JdkVersion)javaParserJdkVersion);
                if (sf == null) continue;
                this.collectSourceFile(sf, file, false, currentData);
                newParses.add(file);
                ++filesParsed;
                continue;
            }
            Assert.println((String)("------  Error: unable to open: " + file.getPath()));
        }
        Assert.println((String)("Time to parse and collect " + filesParsed + " files " + this.elapsedTimeMs() + "ms"));
        this.startTiming();
        this.computeDependencies();
        Assert.println((String)("Time to compute dependencies on " + this.data.size() + " files " + this.elapsedTimeMs() + "ms"));
        if (this.timeToCollectCdiHashCodes > 0L) {
            Assert.println((String)("Time to compute cdi hash codes: " + this.timeToCollectCdiHashCodes + "ms"));
        }
        this.fileToData.clear();
        for (Data currentData : this.data) {
            this.fileToData.put(currentData.getFile(), currentData);
        }
        return newParses;
    }

    public Collection getDependants(ArrayList fileList, boolean includeSelf) {
        HashSet<File> dependents = new HashSet<File>();
        for (int i = 0; i < fileList.size(); ++i) {
            Data currentData;
            File file = (File)fileList.get(i);
            if (includeSelf) {
                dependents.add(file);
            }
            if ((currentData = this.fileToData.get(file)) == null) continue;
            String[] classes = currentData.definedClasses;
            for (int j = 0; j < classes.length; ++j) {
                String className = currentData.packageName + '.' + classes[j];
                Set<File> usedBy = this.classNameUsedBy.get(className);
                Iterator<File> it = usedBy.iterator();
                if (it.hasNext()) {
                    it.next();
                }
                while (it.hasNext()) {
                    dependents.add(it.next());
                }
            }
        }
        return dependents;
    }

    void rebaseCdiFile(File cdiFile, String oldBasePath, String newBasePath) throws IOException {
        try {
            this.load(cdiFile);
        }
        catch (IOException e) {
            this.reinit();
        }
        boolean updateFileSeparator = oldBasePath.substring(0, 3).indexOf(File.separatorChar) < 0;
        char oldFileSeparator = '\u0000';
        if (updateFileSeparator) {
            oldFileSeparator = '\\' == File.separatorChar ? (char)'/' : '\\';
        }
        int entriesSkipped = 0;
        int entriesModified = 0;
        for (Data currentData : this.data) {
            if (currentData.fileName.startsWith(oldBasePath)) {
                String tail = currentData.fileName.substring(oldBasePath.length());
                if (updateFileSeparator) {
                    tail = tail.replace(oldFileSeparator, File.separatorChar);
                }
                currentData.fileName = newBasePath + tail;
                ++entriesModified;
                continue;
            }
            System.out.println("Entry skipped: " + currentData.fileName);
            ++entriesSkipped;
        }
        this.save(cdiFile);
    }

    public void setSourceJdk(String sourceJDK) {
        if (sourceJDK != null) {
            this.sourceJDK = sourceJDK;
        }
    }

    public static void persistAuditFlags(File cdiFile, Map<File, Byte> flags) throws IOException {
        if (cdiFile == null || flags == null) {
            assert (cdiFile != null && flags != null) : "Need valid arguments in persistAuditFlags";
            return;
        }
        JavaDependencyProvider provider = new JavaDependencyProvider(null, false);
        try {
            provider.load(cdiFile);
        }
        catch (IOException e) {
            provider.reinit();
        }
        boolean saveFile = false;
        Iterator<Data> i$ = provider.data.iterator();
        while (i$.hasNext()) {
            Data oneData;
            Byte flag = flags.get((oneData = i$.next()).getFile());
            oneData.auditFlag = flag == null ? (byte)0 : flag;
            saveFile |= flag != null;
        }
        if (saveFile) {
            provider.save(cdiFile);
        }
    }

    public static Map<File, Byte> getAuditFlags(File cdiFile, Set<File> files) throws IOException {
        assert (cdiFile != null) : "Need a valid CDI file in getAuditFlags";
        if (cdiFile == null) {
            return Collections.emptyMap();
        }
        JavaDependencyProvider provider = new JavaDependencyProvider(null, false);
        try {
            provider.load(cdiFile);
        }
        catch (IOException e) {
            provider.reinit();
        }
        HashMap<File, Byte> flags = new HashMap<File, Byte>();
        for (Data oneData : provider.data) {
            File file = oneData.getFile();
            if (files != null && !files.contains(file)) continue;
            flags.put(file, oneData.auditFlag);
        }
        return flags;
    }

    private JdkVersion getJavaParserJdkVersion() {
        if (this.sourceJDK == null) {
            return JavaParser.getJdkVersion();
        }
        if (this.sourceJDK.startsWith("1.")) {
            if (this.sourceJDK.equals("1.8")) {
                return JdkVersion.JDK_1_8;
            }
            if (this.sourceJDK.equals("1.7")) {
                return JdkVersion.JDK_1_7;
            }
            if (this.sourceJDK.equals("1.6")) {
                return JdkVersion.JDK_1_6;
            }
            if (this.sourceJDK.equals("1.5")) {
                return JdkVersion.JDK_1_5;
            }
            if (this.sourceJDK.equals("1.4")) {
                return JdkVersion.JDK_1_4;
            }
            if (this.sourceJDK.equals("1.3")) {
                return JdkVersion.JDK_1_3;
            }
            return JavaParser.getJdkVersion();
        }
        if (this.sourceJDK.startsWith("8.")) {
            return JdkVersion.JDK_1_8;
        }
        if (this.sourceJDK.startsWith("7.")) {
            return JdkVersion.JDK_1_7;
        }
        if (this.sourceJDK.startsWith("6.")) {
            return JdkVersion.JDK_1_6;
        }
        if (this.sourceJDK.startsWith("5.")) {
            return JdkVersion.JDK_1_5;
        }
        return JavaParser.getJdkVersion();
    }

    private void startTiming() {
        this.tickHolder = System.currentTimeMillis();
    }

    private long elapsedTimeMs() {
        return System.currentTimeMillis() - this.tickHolder;
    }

    public static synchronized void addListener(Listener listener) {
        if (listeners == null) {
            listeners = new ArrayList<Listener>();
        }
        listeners.add(listener);
    }

    public static synchronized void removeListener(Listener listener) {
        if (listeners != null) {
            listeners.remove(listener);
            if (listeners.isEmpty()) {
                listeners = null;
            }
        }
    }

    public static interface Listener {
        public void classSignaturesChanged(List<String> var1);
    }

    private class Data {
        private File cachedFile;
        private String fileName;
        private long lastModified;
        private String packageName;
        private String[] typeReferences;
        private String[] definedClasses;
        private String[] imports;
        private boolean isDependency;
        private byte auditFlag;
        private long signaturesHashcode;

        private Data() {
        }

        File getFile() {
            if (this.cachedFile == null) {
                this.cachedFile = new File(this.fileName);
            }
            return this.cachedFile;
        }

        static /* synthetic */ String[] access$502(Data x0, String[] x1) {
            x0.typeReferences = x1;
            return x1;
        }

        static /* synthetic */ String[] access$602(Data x0, String[] x1) {
            x0.definedClasses = x1;
            return x1;
        }

        static /* synthetic */ String[] access$702(Data x0, String[] x1) {
            x0.imports = x1;
            return x1;
        }
    }
}

