/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.javacompiler;

import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import oracle.jdevimpl.javacompiler.JavaCompilerLog;

class LogDiagnosticListener<E>
implements DiagnosticListener<E> {
    private JavaCompilerLog log;
    private Locale locale;
    private boolean interrupted;
    private Set<String> previousMessages;

    LogDiagnosticListener(JavaCompilerLog log, Locale locale) {
        this.log = log;
        this.locale = locale;
        this.previousMessages = new HashSet<String>();
    }

    @Override
    public void report(Diagnostic<? extends E> diagnostic) {
        long column;
        if (this.interrupted) {
            return;
        }
        if (Thread.currentThread().isInterrupted()) {
            this.interrupted = true;
            return;
        }
        Diagnostic.Kind kind = diagnostic.getKind();
        String msg = diagnostic.getMessage(this.locale);
        long line = diagnostic.getLineNumber();
        if (line < 0L) {
            line = 0L;
        }
        if ((column = diagnostic.getColumnNumber()) < 0L) {
            column = 0L;
        }
        switch (kind) {
            case ERROR: {
                this.log.error(diagnostic.getSource(), line, column, -1, msg);
                break;
            }
            case MANDATORY_WARNING: 
            case WARNING: {
                this.log.warning(diagnostic.getSource(), line, column, -1, msg);
                break;
            }
            default: {
                if (this.previousMessages.contains(msg)) break;
                this.previousMessages.add(msg);
                this.log.println(msg);
            }
        }
    }

    void release() {
        this.previousMessages.clear();
    }
}

