/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xsql;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.xsql.Res;
import oracle.xml.xsql.XSQLActionHandler;
import oracle.xml.xsql.XSQLConfigManager;
import oracle.xml.xsql.XSQLDOMException;
import oracle.xml.xsql.XSQLPage;
import oracle.xml.xsql.XSQLPageRequest;
import oracle.xml.xsql.XSQLStylesheetPI;
import oracle.xml.xsql.XSQLUtil;
import oracle.xml.xsql.actions.XSQLExtensionActionHandler;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.SAXException;

final class XSQLDocHandler {
    public static final String XSQL_NS_URI = "urn:oracle-xsql";
    public static final String XSQL_ERR_MSG = "message";
    public static final String XSQL_ERR_STM = "operation";
    private static final String STYLE_PI = "xml-stylesheet";
    private static final String ALLOW_CLIENT_STYLE = "allow-client-style";
    private static final String ERROR_HANDLER = "errorHandler";
    private Document XSQLDoc = null;
    private XSQLPageRequest env = null;
    private Vector topLevelPIs = null;
    private XSQLStylesheetPI requestPI = null;
    private String connectionName = null;
    private String errorHandlerClass = null;
    private boolean allowXSLOverride = XSQLConfigManager.getManager().defaultAllowClientOverride();
    private Element firstInsertTag = null;
    private boolean pageTiming = false;
    private boolean actionTiming = false;
    private long cacheSeconds = 0L;
    private static final int NUMBER_OF_HANDLERS = 19;
    private static final String P = "oracle.xml.xsql.actions.XSQL";
    private static final String H = "Handler";
    private static final String QUERY = "query";
    private static final String QUERY_HANDLER = "oracle.xml.xsql.actions.XSQLQueryHandler";
    private static final String PARAM = "include-param";
    private static final String PARAM_HANDLER = "oracle.xml.xsql.actions.XSQLGetParameterHandler";
    private static final String INSREQ = "insert-request";
    private static final String INSREQ_HANDLER = "oracle.xml.xsql.actions.XSQLInsertRequestHandler";
    private static final String UPDREQ = "update-request";
    private static final String UPDREQ_HANDLER = "oracle.xml.xsql.actions.XSQLUpdateRequestHandler";
    private static final String DELREQ = "delete-request";
    private static final String DELREQ_HANDLER = "oracle.xml.xsql.actions.XSQLDeleteRequestHandler";
    private static final String DML = "dml";
    private static final String DML_HANDLER = "oracle.xml.xsql.actions.XSQLDMLHandler";
    private static final String ACTION = "action";
    private static final String ACTION_HANDLER = "oracle.xml.xsql.actions.XSQLExtensionActionHandler";
    private static final String SHEETPARAM = "set-stylesheet-param";
    private static final String SHEETPARAM_HANDLER = "oracle.xml.xsql.actions.XSQLStylesheetParameterHandler";
    private static final String INCXML = "include-xml";
    private static final String INCXML_HANDLER = "oracle.xml.xsql.actions.XSQLIncludeXMLHandler";
    private static final String INCOWA = "include-owa";
    private static final String INCOWA_HANDLER = "oracle.xml.xsql.actions.XSQLIncludeOWAHandler";
    private static final String INCXSQL = "include-xsql";
    private static final String INCXSQL_HANDLER = "oracle.xml.xsql.actions.XSQLIncludeXSQLHandler";
    private static final String INCREQ = "include-request-params";
    private static final String INCREQ_HANDLER = "oracle.xml.xsql.actions.XSQLIncludeRequestHandler";
    private static final String PAGEPARAM = "set-page-param";
    private static final String PAGEPARAM_HANDLER = "oracle.xml.xsql.actions.XSQLSetPageParamHandler";
    private static final String SESSPARAM = "set-session-param";
    private static final String SESSPARAM_HANDLER = "oracle.xml.xsql.actions.XSQLSetSessionParamHandler";
    private static final String COOKPARAM = "set-cookie";
    private static final String COOKPARAM_HANDLER = "oracle.xml.xsql.actions.XSQLSetCookieHandler";
    private static final String REFCURSOR = "ref-cursor-function";
    private static final String REFCURSOR_HANDLER = "oracle.xml.xsql.actions.XSQLRefCursorFunctionHandler";
    private static final String INS_PARAM = "insert-param";
    private static final String INS_PARAM_HANDLER = "oracle.xml.xsql.actions.XSQLInsertParameterHandler";
    private static final String INC_POSTXML = "include-posted-xml";
    private static final String INC_POSTXML_HANDLER = "oracle.xml.xsql.actions.XSQLIncludePostedXMLHandler";
    private static final String IFPARAM = "if-param";
    private static final String IFPARAM_HANDLER = "oracle.xml.xsql.actions.XSQLIfParamHandler";
    private static Hashtable builtinActions = new Hashtable(19);

    XSQLDocHandler(XSQLPageRequest xSQLPageRequest, XSQLPage xSQLPage, String string, String string2) throws SAXException {
        Object object;
        this.env = xSQLPageRequest;
        this.XSQLDoc = xSQLPage.getDocument();
        Element element = this.XSQLDoc.getDocumentElement();
        if (element != null) {
            this.connectionName = this.valueOfConnectionAttr(element);
            this.errorHandlerClass = this.valueOfErrorHandlerAttr(element);
            object = element.getAttributeNode(ALLOW_CLIENT_STYLE);
            if (object != null) {
                String string3 = object.getNodeValue();
                this.allowXSLOverride = !string3.equalsIgnoreCase("n") && !string3.equalsIgnoreCase("no");
                element.removeAttributeNode((Attr)object);
            }
        }
        object = XSQLConfigManager.getManager();
        this.pageTiming = ((XSQLConfigManager)object).pageTimingInfo();
        this.actionTiming = ((XSQLConfigManager)object).actionTimingInfo();
        if (this.allowXSLOverride && string != null && !string.equals("")) {
            this.requestPI = new XSQLStylesheetPI(string, string2);
        }
        if (this.XSQLDoc == null) {
            System.out.println("Error Parsing the Document");
            return;
        }
    }

    Document getDocument() throws SQLException {
        long l = -1L;
        Element element = null;
        if (this.pageTiming) {
            l = System.currentTimeMillis();
        }
        Vector vector = this.getXSQLActions((XMLDocument)this.XSQLDoc);
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            XSQLActionHandler xSQLActionHandler;
            element = (Element)vector.elementAt(i);
            if (!this.ownedByXSQLDocument(element) || (xSQLActionHandler = this.handlerForAction(element)) == null) continue;
            long l2 = -1L;
            if (this.actionTiming) {
                l2 = System.currentTimeMillis();
            }
            DocumentFragment documentFragment = this.XSQLDoc.createDocumentFragment();
            xSQLActionHandler.handleAction(documentFragment);
            if (this.actionTiming && documentFragment != null) {
                try {
                    long l3 = System.currentTimeMillis() - l2;
                    Comment comment = this.XSQLDoc.createComment(new Long(l3).toString());
                    documentFragment.insertBefore(comment, documentFragment.getFirstChild());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Node node = element.getParentNode();
            if (node instanceof Document) {
                node.removeChild(element);
                if (!documentFragment.hasChildNodes()) {
                    throw new XSQLDOMException("Empty Document");
                }
                node.appendChild(documentFragment);
                continue;
            }
            node.insertBefore(documentFragment, element);
            node.removeChild(element);
            continue;
        }
        this.removeXSQLNamespaces((XMLElement)this.XSQLDoc.getDocumentElement());
        if (this.pageTiming) {
            Element element2;
            long l4 = System.currentTimeMillis() - l;
            if (this.XSQLDoc != null && (element2 = this.XSQLDoc.getDocumentElement()) != null) {
                element2.setAttribute("xsql-timing", new Long(l4).toString());
            }
        }
        return this.XSQLDoc;
    }

    private void removeXSQLNamespaces(XMLElement xMLElement) {
        NamedNodeMap namedNodeMap = xMLElement.getAttributes();
        if (namedNodeMap != null) {
            int n = namedNodeMap.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = namedNodeMap.item(i);
                if (!node.getNodeValue().equals(XSQL_NS_URI)) continue;
                xMLElement.removeAttributeNode((Attr)node);
                --i;
                --n;
            }
        }
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public String getErrorHandlerClass() {
        return this.errorHandlerClass;
    }

    public long getCacheThreshold() {
        return this.cacheSeconds;
    }

    public boolean getAllowClientStyle() {
        return this.allowXSLOverride;
    }

    public Vector getDocumentPIs() {
        if (this.topLevelPIs != null) {
            return this.topLevelPIs;
        }
        this.topLevelPIs = new Vector();
        if (this.requestPI != null) {
            this.topLevelPIs.addElement(this.requestPI);
        }
        NodeList nodeList = this.XSQLDoc.getChildNodes();
        Node node = null;
        if (nodeList != null) {
            int n = 0;
            while (n < nodeList.getLength()) {
                node = nodeList.item(n);
                if (node.getNodeType() == 7 && node.getNodeName().equals(STYLE_PI)) {
                    this.topLevelPIs.addElement(new XSQLStylesheetPI((ProcessingInstruction)node));
                    this.XSQLDoc.removeChild(node);
                    continue;
                }
                ++n;
            }
        }
        return this.topLevelPIs;
    }

    private XSQLActionHandler handlerForAction(Element element) {
        String string = ((XMLElement)element).getLocalName();
        XSQLActionHandler xSQLActionHandler = null;
        boolean bl = true;
        Class clazz = (Class)builtinActions.get(string);
        if (clazz != null) {
            try {
                xSQLActionHandler = (XSQLActionHandler)clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
        } else {
            String string2 = (String)XSQLConfigManager.getManager().getUserDefinedHandlers().get(string);
            if (string2 != null && !string2.equals("")) {
                XSQLExtensionActionHandler xSQLExtensionActionHandler = new XSQLExtensionActionHandler();
                xSQLExtensionActionHandler.init(this.env, element);
                xSQLExtensionActionHandler.setHandlerClass(string2);
                bl = false;
                xSQLActionHandler = xSQLExtensionActionHandler;
            }
        }
        if (xSQLActionHandler != null && bl) {
            xSQLActionHandler.init(this.env, element);
            return xSQLActionHandler;
        }
        return xSQLActionHandler;
    }

    private String resolveConnName(Element element, String string) {
        if (string == null) {
            return null;
        }
        String string2 = string;
        String string3 = null;
        int n = 0;
        int n2 = 0;
        while ((n = string2.indexOf("{@")) >= 0 && (n2 = string2.indexOf("}", n)) != 0) {
            string3 = string2.substring(n + 2, n2);
            String string4 = this.env.getParameter(string3);
            Attr attr = !string3.equals("connection") ? element.getAttributeNode(string3) : null;
            String string5 = null;
            if (string4 != null) {
                string5 = string4;
            } else if (attr != null) {
                string5 = attr.getNodeValue();
            }
            string2 = string2.substring(0, n) + (string5 != null ? string5 : "") + string2.substring(n2 + 1);
        }
        return string2;
    }

    private Vector getXSQLActions(XMLDocument xMLDocument) {
        Vector<Element> vector = new Vector<Element>(10);
        Element element = xMLDocument.getDocumentElement();
        String string = element.getNamespaceURI();
        if (string != null && string.equals(XSQL_NS_URI)) {
            vector.addElement(element);
        }
        this.getXSQLActions(element, vector);
        return vector;
    }

    private void getXSQLActions(Element element, Vector vector) {
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            Element element2 = (Element)node;
            String string = element2.getNamespaceURI();
            if (string != null && string.equals(XSQL_NS_URI)) {
                vector.addElement(element2);
            }
            this.getXSQLActions(element2, vector);
        }
    }

    private static void register(String string, String string2) {
        try {
            builtinActions.put(string, XSQLUtil.classForName(string2));
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println(Res.format(25027, new String[]{string2, string}));
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            System.err.println(Res.format(25027, new String[]{string2, string}));
        }
    }

    private String valueOfErrorHandlerAttr(Element element) {
        NamedNodeMap namedNodeMap = element.getAttributes();
        String string = null;
        Attr attr = null;
        boolean bl = false;
        if (namedNodeMap != null) {
            int n = namedNodeMap.getLength();
            for (int i = 0; i < n; ++i) {
                String string2;
                Attr attr2 = (Attr)namedNodeMap.item(i);
                String string3 = attr2.getNamespaceURI();
                String string4 = attr2.getLocalName();
                if (string4 == null || !string4.equals(ERROR_HANDLER) || string3 != null && !string3.equals("") && !string3.equals(XSQL_NS_URI)) continue;
                if (!bl) {
                    string = attr2.getNodeValue();
                    attr = attr2;
                }
                if ((string2 = attr2.getNamespaceURI()) == null || !string2.equals(XSQL_NS_URI)) continue;
                bl = true;
            }
        }
        if (attr != null) {
            element.removeAttributeNode(attr);
        }
        return string;
    }

    private String valueOfConnectionAttr(Element element) {
        NamedNodeMap namedNodeMap = element.getAttributes();
        String string = null;
        Attr attr = null;
        boolean bl = false;
        if (namedNodeMap != null) {
            int n = namedNodeMap.getLength();
            for (int i = 0; i < n; ++i) {
                String string2;
                Attr attr2 = (Attr)namedNodeMap.item(i);
                String string3 = attr2.getNamespaceURI();
                String string4 = attr2.getLocalName();
                if (string4 == null || !string4.equals("connection") || string3 != null && !string3.equals("") && !string3.equals(XSQL_NS_URI)) continue;
                if (!bl) {
                    string = attr2.getNodeValue();
                    attr = attr2;
                }
                if ((string2 = attr2.getNamespaceURI()) == null || !string2.equals(XSQL_NS_URI)) continue;
                bl = true;
            }
        }
        if (attr != null) {
            element.removeAttributeNode(attr);
        }
        if (string != null) {
            return this.resolveConnName(element, string);
        }
        return null;
    }

    private boolean ownedByXSQLDocument(Element element) {
        Node node = element;
        Node node2 = node.getParentNode();
        while (node2 != null) {
            node = node2;
            node2 = node.getParentNode();
        }
        return node.getNodeType() == 9;
    }

    static {
        XSQLDocHandler.register(QUERY, QUERY_HANDLER);
        XSQLDocHandler.register(PARAM, PARAM_HANDLER);
        XSQLDocHandler.register(INSREQ, INSREQ_HANDLER);
        XSQLDocHandler.register(UPDREQ, UPDREQ_HANDLER);
        XSQLDocHandler.register(DELREQ, DELREQ_HANDLER);
        XSQLDocHandler.register(DML, DML_HANDLER);
        XSQLDocHandler.register(ACTION, ACTION_HANDLER);
        XSQLDocHandler.register(SHEETPARAM, SHEETPARAM_HANDLER);
        XSQLDocHandler.register(INCXML, INCXML_HANDLER);
        XSQLDocHandler.register(INCOWA, INCOWA_HANDLER);
        XSQLDocHandler.register(INCXSQL, INCXSQL_HANDLER);
        XSQLDocHandler.register(INCREQ, INCREQ_HANDLER);
        XSQLDocHandler.register(PAGEPARAM, PAGEPARAM_HANDLER);
        XSQLDocHandler.register(SESSPARAM, SESSPARAM_HANDLER);
        XSQLDocHandler.register(COOKPARAM, COOKPARAM_HANDLER);
        XSQLDocHandler.register(REFCURSOR, REFCURSOR_HANDLER);
        XSQLDocHandler.register(INS_PARAM, INS_PARAM_HANDLER);
        XSQLDocHandler.register(INC_POSTXML, INC_POSTXML_HANDLER);
        XSQLDocHandler.register(IFPARAM, IFPARAM_HANDLER);
    }
}

