/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.library;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import oracle.ide.net.URLPath;
import oracle.ide.util.VersionNumber;
import oracle.jdeveloper.library.AddinJDK;
import oracle.jdeveloper.library.AddinLibrary;
import oracle.jdeveloper.library.ExtensionLibrary;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.LibraryList;
import oracle.jdeveloper.resource.LibraryArb;
import oracle.jdevimpl.library.DependentLibraryInfo;
import oracle.jdevimpl.library.LibrariesHook;

public final class AddinLibraryList
implements LibraryList {
    private final Map<String, JLibrary> extraLibraries = Collections.synchronizedMap(new HashMap());
    private AddinJDK jdk;

    AddinLibraryList() {
    }

    private String resolveAlias(String name) {
        return LibrariesHook.getInstance().resolveAlias(name);
    }

    public void registerLibrary(JLibrary library) {
        if (library == null) {
            throw new NullPointerException("library is null");
        }
        this.extraLibraries.put(library.getName(), library);
    }

    @Deprecated
    public synchronized JDK loadJDK(String name, URLPath clsPath, URLPath srcPath, URLPath docPath, URL exeURL, VersionNumber version, URL sdkBinDir) {
        AddinJDK jdk;
        this.jdk = jdk = new AddinJDK(name, clsPath, srcPath, docPath, exeURL, version, sdkBinDir);
        return jdk;
    }

    @Override
    public JDK findJDK(Object id) {
        JDK jdk;
        block3: {
            LibraryList list;
            if (id == null) {
                return null;
            }
            jdk = this.getJDK();
            if (jdk.getID().equals(id)) {
                return jdk;
            }
            String resolvedId = id.toString();
            LibrariesHook hook = LibrariesHook.getInstance();
            jdk = hook.getJDK(resolvedId);
            if (jdk != null) break block3;
            Iterator<LibraryList> i$ = hook.getExtensionLibraryLists().iterator();
            while (i$.hasNext() && (jdk = (list = i$.next()).findJDK(resolvedId)) == null) {
            }
        }
        return jdk;
    }

    private synchronized JDK getJDK() {
        return this.jdk;
    }

    @Override
    public JLibrary findLibrary(Object id) {
        if (id == null) {
            return null;
        }
        String resolvedId = this.resolveAlias(id.toString());
        JLibrary lib = LibrariesHook.getInstance().getLibrary(resolvedId);
        if (lib == null) {
            LibraryList list;
            Iterator<LibraryList> i$ = LibrariesHook.getInstance().getExtensionLibraryLists().iterator();
            while (i$.hasNext() && (lib = (list = i$.next()).findLibrary(resolvedId)) == null) {
            }
        }
        if (lib == null) {
            lib = this.extraLibraries.get(resolvedId);
        }
        return lib;
    }

    @Override
    public List getJdkList() {
        ArrayList<AddinJDK> jdks = new ArrayList<AddinJDK>(LibrariesHook.getInstance().getJDKs());
        for (LibraryList list : LibrariesHook.getInstance().getExtensionLibraryLists()) {
            for (Object o : list.getJdkList()) {
                jdks.add((AddinJDK)((JDK)o));
            }
        }
        JDK jdk = this.getJDK();
        if (jdk != null) {
            jdks.add((AddinJDK)jdk);
        }
        return jdks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getLibraryList() {
        ArrayList<JLibrary> libraries = new ArrayList<JLibrary>();
        for (AddinLibrary library : LibrariesHook.getInstance().getLibraries()) {
            if (library.isHidden()) continue;
            libraries.add(library);
        }
        for (LibraryList list : LibrariesHook.getInstance().getExtensionLibraryLists()) {
            for (Object o : list.getLibraryList()) {
                JLibrary library = (JLibrary)o;
                if (this.isHidden(library)) continue;
                libraries.add(library);
            }
        }
        Map<String, JLibrary> map = this.extraLibraries;
        synchronized (map) {
            for (JLibrary library : this.extraLibraries.values()) {
                if (this.isHidden(library)) continue;
                libraries.add(library);
            }
        }
        return libraries;
    }

    public Map<String, DependentLibraryInfo> getDependentManifestLibraries() {
        return LibrariesHook.getInstance().getDependentManifestLibraries();
    }

    @Override
    public String getListName() {
        return LibraryArb.getString(4);
    }

    @Override
    public boolean isTransient() {
        return true;
    }

    public String getShortLabel() {
        return this.getListName();
    }

    public String getLongLabel() {
        return this.getShortLabel();
    }

    public Icon getIcon() {
        return LibraryArb.getIcon(13);
    }

    public String getToolTipText() {
        return this.getLongLabel();
    }

    public String toString() {
        return this.getShortLabel();
    }

    private boolean isHidden(JLibrary library) {
        return library instanceof ExtensionLibrary && ((ExtensionLibrary)library).isHidden();
    }
}

