/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.library;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import oracle.ide.model.Locatable;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.DefaultNameGenerator;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.NameGenerator;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.library.ExternalLibrary;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.library.JDKNode;
import oracle.jdeveloper.library.JDKUtil;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.JLibraryNode;
import oracle.jdeveloper.library.Library;
import oracle.jdeveloper.library.MutableLibraryList;
import oracle.jdeveloper.resource.LibraryArb;

public final class JLibraryList
implements MutableLibraryList,
Locatable {
    public static final String SYSTEM_LIBRARIES = LibraryArb.getString(0);
    public static final String USER_LIBRARIES = LibraryArb.getString(1);
    public static final URLFilter JDK_FILTER = new DefaultURLFilter(LibraryArb.getString(11), ".jdk");
    public static final URLFilter LIB_FILTER = new DefaultURLFilter(LibraryArb.getString(10), ".library");
    private URL _url;
    private String _name;

    public JLibraryList(URL url) {
        this._url = url;
    }

    @Override
    public JDK findJDK(Object id) {
        URL url;
        JDKNode jdk = null;
        if (id instanceof URL && (jdk = (JDKNode)NodeFactory.find((URL)(url = (URL)id))) == null && URLFileSystem.exists((URL)url)) {
            try {
                jdk = (JDKNode)NodeFactory.findOrCreate((URL)url);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return jdk;
    }

    @Override
    public JLibrary findLibrary(Object id) {
        URL url;
        JLibraryNode lib = null;
        if (id instanceof URL && (lib = (JLibraryNode)NodeFactory.find((URL)(url = (URL)id))) == null && URLFileSystem.exists((URL)url)) {
            try {
                lib = (JLibraryNode)NodeFactory.findOrCreate((URL)url);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return lib;
    }

    @Override
    public List getJdkList() {
        ArrayList<JDK> list = new ArrayList<JDK>();
        URL[] children = URLFileSystem.list((URL)this.getURL(), (URLFilter)JDK_FILTER);
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                JDK jdk = this.findJDK(children[i]);
                if (jdk == null) continue;
                list.add(jdk);
            }
        }
        return list;
    }

    @Override
    public List getLibraryList() {
        ArrayList<JLibrary> list = new ArrayList<JLibrary>();
        URL[] children = URLFileSystem.list((URL)this.getURL(), (URLFilter)LIB_FILTER);
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                JLibrary lib = this.findLibrary(children[i]);
                if (lib == null) continue;
                list.add(lib);
            }
        }
        return list;
    }

    @Override
    public String getListName() {
        return this._name != null ? this._name : URLFileSystem.getFileName((URL)this.getURL()) + " (" + URLFileSystem.getPlatformPathName((URL)URLFileSystem.getParent((URL)this.getURL())) + ")";
    }

    @Override
    public boolean isTransient() {
        return URLFileSystem.isReadOnly((URL)this.getURL());
    }

    public String getShortLabel() {
        return this.getListName();
    }

    public String getLongLabel() {
        return URLFileSystem.getPlatformPathName((URL)this.getURL());
    }

    public Icon getIcon() {
        return LibraryArb.getIcon(15);
    }

    public String getToolTipText() {
        return this.getLongLabel();
    }

    public String toString() {
        return this.getShortLabel();
    }

    public URL getURL() {
        return this._url;
    }

    public void setURL(URL url) {
    }

    @Override
    public void setJdkList(List jdks) {
    }

    @Override
    public void setLibraryList(List libraries) {
    }

    @Override
    public void setListName(String name) {
        this._name = name;
    }

    public JDK addJDK(String name, URL exeURL, URL location) {
        JDKNode jdk = null;
        if (location != null) {
            try {
                jdk = (JDKNode)NodeFactory.find((URL)location);
                if (jdk == null) {
                    jdk = (JDKNode)NodeFactory.findOrCreate((URL)location);
                }
                jdk.setName(name);
                JDKUtil.initJDK(jdk, exeURL);
                jdk.save();
            }
            catch (Exception e) {
                jdk = null;
            }
        }
        return jdk;
    }

    @Override
    public JDK addJDK(String name, URL exeURL) {
        URL url = this.getUniqueURL(name, true);
        return this.addJDK(name, exeURL, url);
    }

    public JLibrary addLibrary(String name, URL location) {
        JLibraryNode lib = null;
        if (location != null) {
            try {
                lib = (JLibraryNode)NodeFactory.find((URL)location);
                if (lib == null) {
                    int index;
                    lib = (JLibraryNode)NodeFactory.findOrCreate((URL)location);
                    if (name == null && (index = (name = URLFileSystem.getFileName((URL)location)).lastIndexOf(46)) > 0 && !Character.isUpperCase((name = name.substring(0, index)).charAt(0))) {
                        name = Character.toUpperCase(name.charAt(0)) + name.substring(1);
                    }
                    lib.setName(name);
                    lib.save();
                } else {
                    lib.setName(name);
                }
            }
            catch (Exception e) {
                lib = null;
                e.printStackTrace();
            }
        }
        return lib;
    }

    @Override
    public JLibrary addLibrary(String name) {
        URL url = this.getUniqueURL(name, false);
        return this.addLibrary(name, url);
    }

    @Override
    public boolean remove(Library library) {
        URL url;
        if (library instanceof ExternalLibrary && URLFileSystem.delete((URL)(url = ((ExternalLibrary)library).getURL()))) {
            NodeFactory.uncache((URL)url);
            return true;
        }
        return false;
    }

    @Override
    public Object createIDFromName(String name, boolean isJDK) {
        String string = name = name != null ? name.trim() : null;
        if (name != null && name.length() > 0) {
            String invalidChars = "\\/*:|?<>\"|";
            for (char c : invalidChars.toCharArray()) {
                if (name.indexOf(c) < 0) continue;
                return null;
            }
            try {
                URL url = URLFactory.newURL((URL)this.getURL(), (String)name);
                String suffix = isJDK ? ".jdk" : ".library";
                URL uRL = url = url != null ? URLFileSystem.ensureSuffix((URL)url, (String)suffix) : null;
                if (url != null && URLFileSystem.isValid((URL)url)) {
                    return url;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }

    private URL getUniqueURL(String name, boolean isJDK) {
        int index = -1;
        if (name == null || name.length() == 0) {
            name = isJDK ? LibraryArb.getString(11) : LibraryArb.getString(10);
            index = 1;
        }
        String extension = isJDK ? ".jdk" : ".library";
        return URLFactory.newUniqueURL((URL)this.getURL(), (NameGenerator)new DefaultNameGenerator(name, extension, index));
    }

    @Override
    public Icon getDefaultIcon() {
        return OracleIcons.getIcon((String)"library.png");
    }
}

