/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.library;

import java.net.URL;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.util.VersionNumber;
import oracle.ide.xml.XMLUtil;
import oracle.javatools.marshal.AttributeMarker;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.library.ExternalLibrary;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.JLibraryDefinition;
import oracle.jdeveloper.library.Library;

public class JLibraryNode
extends ExternalLibrary
implements JLibrary {
    public static final String NAMESPACE_URI = XMLUtil.toNamespaceURI((String)"jlibrarynode");
    public static final String ROOT_TAG = "JLibraryNode";
    private Boolean _deployed;

    public JLibraryNode() {
    }

    public JLibraryNode(URL url) {
        super(url);
    }

    @Override
    public boolean equivalent(Library lib) {
        JLibrary jlib;
        JLibrary jLibrary = jlib = lib instanceof JLibrary ? (JLibrary)lib : null;
        if (!super.equivalent(jlib)) {
            return false;
        }
        return !ModelUtil.areDifferent((Object)jlib.getDeployedByDefault(), (Object)this.getDeployedByDefault());
    }

    @Override
    public void initFromLibrary(Library lib) {
        if (lib instanceof JLibrary) {
            JLibrary jlib = (JLibrary)lib;
            Boolean deployed = jlib.getDeployedByDefault();
            super.initFromLibrary(jlib);
            if (ModelUtil.areDifferent((Object)deployed, (Object)this.getDeployedByDefault())) {
                this.setDeployedByDefault(deployed);
            }
        }
    }

    @Override
    public Boolean getDeployedByDefault() throws AttributeMarker {
        return this.ensureOpen() ? this._deployed : Boolean.FALSE;
    }

    @Override
    public void setDeployedByDefault(Boolean deploy) {
        if (this.ensureOpen() && ModelUtil.areDifferent((Object)deploy, (Object)this._deployed)) {
            this._deployed = deploy;
            this.markDirty(true);
            this.fireChangeEvent("deployedByDefault", deploy == false, deploy);
        }
    }

    @Override
    @Deprecated
    public JLibraryDefinition getDefaultLibraryDefinition() {
        return this;
    }

    @Override
    @Deprecated
    public JLibraryDefinition getLibraryDefinition(VersionNumber jdkVer) {
        return this;
    }

    @Override
    protected String getExtension() {
        return ".library";
    }

    static {
        Object2Dom.registerNamespaceElem(JLibraryNode.class, (String)NAMESPACE_URI, (String)ROOT_TAG);
    }
}

