/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.buildtools;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.marshal.TransientMarker;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdeveloper.model.TechnologySpecificSupportProvider;

public final class ModuleConfiguration
extends HashStructureAdapter {
    public static final String DATA_KEY = "oracle.jdevimpl.buildtools.ModuleConfiguration";
    public static final String EXTENSION_ID_KEY = "module.extension.id";
    public static final String SIMPLE_JAR_KEY = "module.simplejar.path";
    public static final String OSGI_BUNDLE_JAR_KEY = "module.bundlejar.path";
    public static final String SOURCE_ZIP_KEY = "module.sourcezip.path";
    public static final String SOURCE_ZIP_DEBUGONLY = "module.sourcezip.debugonly";
    public static final String EXTENSION_DIR_KEY = "module.extension.dir";
    public static final String DEPLOY_TYPE_KEY = "module.deploy.type";
    public static final String PRIMARY_CONTACT_KEY = "module.primary.contact";
    public static final String TRANSLATION_LANGUAGES_KEY = "module.translation.languages";
    public static final String BUILD_TIME_ONLY_KEY = "module.dependency.annotations";
    private final Project _project;
    private String extensionId;
    private long manifestTimestamp;

    private ModuleConfiguration(Project project, HashStructure hash) {
        super(hash);
        if (project == null) {
            throw new NullPointerException("project is null");
        }
        this._project = project;
    }

    public static ModuleConfiguration getInstance(Project project) {
        return ModuleConfiguration.getInstance(project, (PropertyStorage)project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModuleConfiguration getInstance(Project project, PropertyStorage ps) {
        Map properties = project.getTransientProperties();
        HashStructure hash = ps.getProperties().getOrCreateHashStructure(DATA_KEY);
        String string = DATA_KEY;
        synchronized (DATA_KEY) {
            ModuleConfiguration mc = (ModuleConfiguration)((Object)properties.get(DATA_KEY));
            if (mc == null) {
                mc = new ModuleConfiguration(project, hash);
                properties.put(DATA_KEY, mc);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return mc;
        }
    }

    public URL getSimpleJarPath() {
        return this._hash.getURL(SIMPLE_JAR_KEY);
    }

    public void setSimpleJarPath(URL simpleZipPath) {
        this._hash.putURL(SIMPLE_JAR_KEY, simpleZipPath, true);
    }

    public URL getOsgiBundleJarPath() {
        return this._hash.getURL(OSGI_BUNDLE_JAR_KEY);
    }

    public void setOsgiBundleJarPath(URL osgiBundleJarPath) {
        this._hash.putURL(OSGI_BUNDLE_JAR_KEY, osgiBundleJarPath, true);
    }

    public URL getSourceZipPath() {
        return this._hash.getURL(SOURCE_ZIP_KEY);
    }

    public void setSourceZipPath(URL sourceZipPath) {
        this._hash.putURL(SOURCE_ZIP_KEY, sourceZipPath, true);
    }

    public boolean getSourceZipDebugOnly() {
        return this._hash.getBoolean(SOURCE_ZIP_DEBUGONLY, false);
    }

    public void setSourceZipDebugOnly(boolean sourceZipDebugOnly) {
        this._hash.putBoolean(SOURCE_ZIP_DEBUGONLY, sourceZipDebugOnly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getExtensionID() {
        String id = this._hash.getString(EXTENSION_ID_KEY);
        if (id != null) {
            return id;
        }
        URL manifest = URLFactory.newURL((URL)URLFileSystem.getParent((URL)this._project.getURL()), (String)"etc/extension.xml");
        long time = URLFileSystem.lastModified((URL)manifest);
        if (time > this.manifestTimestamp) {
            this.manifestTimestamp = time;
            InputStream inputStream = null;
            try {
                inputStream = URLFileSystem.openInputStream((URL)manifest);
                byte[] bytes = new byte[512];
                int bytesRead = inputStream.read(bytes);
                if (bytesRead > 0) {
                    this.extensionId = this.findExtensionID(bytes, bytesRead);
                }
                if (this.extensionId == null) {
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream(8192);
                    if (bytesRead > 0) {
                        outputStream.write(bytes, 0, bytesRead);
                    }
                    bytes = new byte[8192];
                    while ((bytesRead = inputStream.read(bytes)) != -1) {
                        outputStream.write(bytes, 0, bytesRead);
                    }
                    bytes = outputStream.toByteArray();
                    this.extensionId = this.findExtensionID(bytes, bytes.length);
                }
            }
            catch (IOException e) {
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException f) {}
                }
            }
        }
        return this.extensionId;
    }

    private String findExtensionID(byte[] bytes, int length) throws IOException {
        CharsetDecoder decoder = Charset.forName("UTF-8").newDecoder();
        CharBuffer buffer = decoder.decode(ByteBuffer.wrap(bytes, 0, length));
        Matcher matcher = Pattern.compile("<extension(?s:[^>]*\\s)id\\s*=\\s*\"([^\"]*)\"").matcher(buffer);
        return matcher.find() ? matcher.group(1) : null;
    }

    @Deprecated
    public void setExtensionID(String extensionId) {
    }

    public Set<String> getPropertyNames() {
        return this._hash.keySet();
    }

    public URL getURL(String propertyName) {
        return this._hash.getURL(propertyName);
    }

    public void setURL(String propertyName, URL url) {
        this._hash.putURL(propertyName, url);
    }

    public URL getExtensionDir() {
        return this.extensionDir();
    }

    @Deprecated
    public void setExtensionDir(URL extensionDir) {
        this._hash.putURL(EXTENSION_DIR_KEY, extensionDir, true);
    }

    public DeployType getDeployType() {
        String deployTypeAsString = this._hash.getString(DEPLOY_TYPE_KEY);
        if (deployTypeAsString != null && deployTypeAsString.length() > 0) {
            return DeployType.valueOf(deployTypeAsString);
        }
        if (this.getExtensionID() != null && this.getExtensionID().length() > 0) {
            return DeployType.EXTENSION_JAR;
        }
        if (this.getSimpleJarPath() != null) {
            return DeployType.SIMPLE_JAR;
        }
        if (this.getOsgiBundleJarPath() != null) {
            return DeployType.OSGI_BUNDLE_JAR;
        }
        return DeployType.NONE;
    }

    public void setDeployType(DeployType deployType) {
        this._hash.putString(DEPLOY_TYPE_KEY, deployType.toString());
    }

    public URLPath getClassPath() throws TransientMarker {
        URLPath urlPath = new URLPath();
        URL simpleJarPath = this.getSimpleJarPath();
        if (simpleJarPath != null) {
            urlPath.add(URLFactory.intern((URL)URLFactory.newJarURL((URL)simpleJarPath, (String)"")));
        } else {
            String extensionId = this.getExtensionID();
            if (extensionId != null) {
                URL extensionsDir = this.extensionDir();
                URL extensionJar = URLFactory.newJarURL((URL)URLFactory.newURL((URL)extensionsDir, (String)(extensionId + ".jar")), (String)"");
                urlPath.add(URLFactory.intern((URL)extensionJar));
            }
        }
        return urlPath;
    }

    private URL extensionDir() {
        URL url = this._hash.getURL(EXTENSION_DIR_KEY);
        if (url == null) {
            TechnologySpecificSupportProvider provider;
            URL outputDir = null;
            Iterator<TechnologySpecificSupportProvider> i$ = PathsConfiguration.getSupportProviders().iterator();
            while (i$.hasNext() && (outputDir = (provider = i$.next()).getProjectOutputDirectory(this._project)) == null) {
            }
            if (outputDir != null) {
                URL productDir = URLFactory.newDirURL(outputDir, (String)"../../../jdeveloper/");
                String relativeExtensionDir = "jdev/extensions/";
                HashStructure extensionProperties = this._project.getProperties().getOrCreateHashStructure("extensiondtProperties");
                if (extensionProperties != null) {
                    relativeExtensionDir = extensionProperties.getString("extensiondt.deploymentdir", "jdev/extensions/");
                }
                url = URLFactory.newDirURL((URL)productDir, (String)relativeExtensionDir);
            }
        }
        return url;
    }

    public String getPrimaryContact() {
        return this._hash.getString(PRIMARY_CONTACT_KEY);
    }

    public void setPrimaryContact(String contact) {
        this._hash.putString(PRIMARY_CONTACT_KEY, contact);
    }

    public String getTranslationLanguages() {
        return this._hash.getString(TRANSLATION_LANGUAGES_KEY);
    }

    public void setTranslationLanguages(String translationLanguages) {
        this._hash.putString(TRANSLATION_LANGUAGES_KEY, translationLanguages);
    }

    public void setBuildTimeOnlyDependencies(List<String> dependencies) {
        HashStructure buildTimeDependencies = HashStructure.newInstance();
        for (String dependency : dependencies) {
            buildTimeDependencies.putString(dependency, "buildtime");
        }
        this._hash.putHashStructure(BUILD_TIME_ONLY_KEY, buildTimeDependencies);
    }

    public List<String> getBuildTimeOnlyDependencies() {
        ArrayList<String> btNameList = new ArrayList<String>();
        List buildTimeDependencies = this._hash.getAsList(BUILD_TIME_ONLY_KEY);
        if (buildTimeDependencies != null) {
            for (HashStructure btd : buildTimeDependencies) {
                btNameList.addAll(btd.keySet());
            }
        }
        return btNameList;
    }

    public static enum DeployType {
        NONE,
        SIMPLE_JAR,
        BUNDLE_JAR,
        EXTENSION_JAR,
        OSGI_BUNDLE_JAR;

    }
}

