/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.buildtools;

import java.net.URL;
import java.util.Map;
import oracle.ide.Context;
import oracle.ide.model.Element;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.data.HashStructure;

public final class WorkspaceConfiguration {
    public static final String DATA_KEY = "oracle.jdevimpl.buildtools.WorkspaceConfiguration";
    public static final String MODULAR_BUILD_KEY = "modularBuild";
    public static final String MODULAR_BUILD_COMPONENT_KEY = "modularBuildComponent";
    private final boolean modularBuild;
    private final boolean modularBuildComponent;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WorkspaceConfiguration getInstance(Workspace workspace) {
        Map properties = workspace.getTransientProperties();
        String string = DATA_KEY;
        synchronized (DATA_KEY) {
            WorkspaceConfiguration configuration = (WorkspaceConfiguration)properties.get(DATA_KEY);
            if (configuration == null) {
                boolean modularBuildComponent;
                boolean modularBuild;
                HashStructure structure = workspace.getProperties();
                if (structure.containsKey(DATA_KEY)) {
                    HashStructure dataKeyStructure = structure.getHashStructure(DATA_KEY);
                    modularBuild = dataKeyStructure.getBoolean(MODULAR_BUILD_KEY, false);
                    modularBuildComponent = dataKeyStructure.getBoolean(MODULAR_BUILD_COMPONENT_KEY, false);
                } else {
                    modularBuild = false;
                    modularBuildComponent = false;
                }
                configuration = new WorkspaceConfiguration(modularBuild, modularBuildComponent);
                properties.put(DATA_KEY, configuration);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return configuration;
        }
    }

    public static boolean isModularBuildWorkspace(Context context) {
        return context != null && WorkspaceConfiguration.isModularBuildWorkspace((Element)context.getWorkspace());
    }

    public static boolean isModularBuildWorkspace(Element element) {
        return element instanceof Workspace && WorkspaceConfiguration.getInstance((Workspace)element).isModularBuildWorkspace();
    }

    public boolean isModularBuildWorkspace() {
        return this.modularBuild;
    }

    public boolean isModularBuildComponent() {
        return this.modularBuildComponent;
    }

    public static boolean isJdevadfWorkspace(Context context) {
        return context != null && WorkspaceConfiguration.isJdevadfWorkspace((Element)context.getWorkspace());
    }

    public static boolean isJdevadfWorkspace(Element element) {
        return WorkspaceConfiguration.isModularBuildWorkspace(element) && URLFileSystem.getPath((URL)((Workspace)element).getURL()).endsWith("jdevadf/jdevadf.jws");
    }

    private WorkspaceConfiguration(boolean modularBuild, boolean modularBuildComponent) {
        this.modularBuild = modularBuild;
        this.modularBuildComponent = modularBuildComponent;
    }
}

