/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.library;

import java.beans.PropertyChangeEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Logger;
import oracle.ide.Context;
import oracle.ide.adapters.AdapterManager;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeListener;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.jdeveloper.library.LibraryChange;
import oracle.jdeveloper.library.LibraryEvent;
import oracle.jdeveloper.library.LibraryEventSource;
import oracle.jdeveloper.library.LibraryListener;

public class DebugLibraryListener
implements LibraryListener {
    private static final Logger LOGGER = Logger.getLogger(DebugLibraryListener.class.getName());
    private static final String SEPARATOR = System.getProperty("line.separator");
    private static final Collection<String> PROPERTIES = Arrays.asList("classPath", "sourcePath", "docPath", "deployedByDefault", "exportedReferences");

    public static void install() {
        final DebugLibraryListener listener = new DebugLibraryListener();
        NodeListener nodeListener = new NodeListener(){

            public void nodeOpened(NodeEvent e) {
                listener.attach(e.getNode());
            }

            public void nodeClosed(NodeEvent e) {
                listener.detach(e.getNode());
            }
        };
        Node.addNodeListenerForType(Workspace.class, (NodeListener)nodeListener);
        Node.addNodeListenerForType(Project.class, (NodeListener)nodeListener);
        Iterator iterator = NodeFactory.getOpenNodes();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (!(node instanceof Project) && !(node instanceof Workspace)) continue;
            listener.attach(node);
        }
    }

    private DebugLibraryListener() {
    }

    private void attach(Node node) {
        LibraryEventSource source = (LibraryEventSource)AdapterManager.Factory.getAdapterManager().adapt((Object)node, LibraryEventSource.class);
        if (source != null) {
            source.addLibraryListener(this);
        }
    }

    private void detach(Node node) {
        LibraryEventSource source = (LibraryEventSource)AdapterManager.Factory.getAdapterManager().adapt((Object)node, LibraryEventSource.class);
        if (source != null) {
            source.removeLibraryListener(this);
        }
    }

    @Override
    public void librariesChanged(LibraryEvent e) {
        StringBuilder builder = new StringBuilder();
        Context context = e.getContext();
        Project contextNode = context.getProject();
        if (contextNode == null) {
            contextNode = context.getWorkspace();
        }
        if (contextNode != null) {
            builder.append("Library changes in ");
            builder.append(contextNode.getShortLabel());
        }
        for (LibraryChange change : e.getLibraryChanges()) {
            builder.append(SEPARATOR);
            if (change.getType() == LibraryChange.Type.ADDED) {
                builder.append("  ADDED library '");
                builder.append(change.getID());
                builder.append("'");
                continue;
            }
            if (change.getType() == LibraryChange.Type.REMOVED) {
                builder.append("  REMOVED library '");
                builder.append(change.getID());
                builder.append("'");
                continue;
            }
            if (change.getType() == LibraryChange.Type.BROKEN) {
                builder.append("  BROKEN library '");
                builder.append(change.getID());
                builder.append("'");
                continue;
            }
            if (change.getType() == LibraryChange.Type.FIXED) {
                builder.append("  FIXED library '");
                builder.append(change.getID());
                builder.append("'");
                continue;
            }
            if (change.getType() != LibraryChange.Type.PROPERTIES_CHANGED) continue;
            builder.append("  PROPERTIES_CHANGED for library '");
            builder.append(change.getID());
            builder.append("'");
            for (String property : PROPERTIES) {
                PropertyChangeEvent pce = change.getPropertyChangeEvent(property);
                if (pce == null) continue;
                this.append(builder, pce);
            }
        }
        LOGGER.info(builder.toString());
    }

    private void append(StringBuilder builder, PropertyChangeEvent event) {
        builder.append(SEPARATOR);
        builder.append("    ");
        builder.append(event.getPropertyName());
        builder.append(" oldValue=");
        builder.append(event.getOldValue());
        builder.append(" newValue=");
        builder.append(event.getNewValue());
    }
}

