/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.library;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.dialogs.DialogRunnerCallback;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.SizeKeeperCallback;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.IdeUtil;
import oracle.javatools.data.HashStructure;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.JLibraryAdapter;
import oracle.jdeveloper.library.Library;
import oracle.jdeveloper.library.ListWrapper;
import oracle.jdeveloper.library.MutableLibraryList;
import oracle.jdeveloper.model.JLibraryModel;
import oracle.jdevimpl.library.LeafNode;
import oracle.jdevimpl.library.LibraryArb;
import oracle.jdevimpl.library.LibraryEditPanel;
import oracle.jdevimpl.library.LibraryListNode;
import oracle.jdevimpl.library.LibraryNode;
import oracle.jdevimpl.library.ListNode;
import oracle.jdevimpl.library.TreePanel;

public class LibrariesPanel
extends TreePanel {
    private LibraryEditPanel _detailPanel;
    private Library _currentLib;
    protected final LocalChangeListener listener = new LocalChangeListener();
    private List<JLibrary> _existingLibs;

    public LibrariesPanel() {
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, this.getHelpId());
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.getDetailPanel().setLibrary(null);
        this.setDetailPanel(this.getDetailPanel(), this.getDetailTitle());
    }

    protected LibraryEditPanel getDetailPanel() {
        if (this._detailPanel == null) {
            this._detailPanel = new LibraryEditPanel();
        }
        return this._detailPanel;
    }

    protected String getDetailTitle() {
        return LibraryArb.getString(68);
    }

    @Override
    public String getHelpId() {
        if (this.getParent() != null) {
            return "f1_idedmanagelibrarieslibraries_html";
        }
        return "f1_idedaddlibrary_html";
    }

    public void makeDoubleClickCloseDialog() {
        final LibrariesPanel panel = this;
        MouseAdapter l = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Dialog dlg;
                Library[] selLibs;
                if (e.getClickCount() == 2 && (selLibs = LibrariesPanel.this.getSelection()) != null && (dlg = IdeUtil.findDialog((Component)panel)) instanceof JEWTDialog) {
                    JEWTDialog jdlg = (JEWTDialog)dlg;
                    jdlg.closeDialog(false);
                }
            }
        };
        this.addMouseListenerToTree(l);
    }

    public void setExistingLibraries(List<JLibrary> existingLibraries) {
        this._existingLibs = existingLibraries;
    }

    @Override
    protected DefaultTreeModel createTreeModel(ListWrapper[] lists) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        for (int i = lists.length - 1; i >= 0; --i) {
            ListWrapper list = lists[i];
            LibraryListNode listNode = this.buildListNode(list);
            root.add(listNode);
        }
        return new DefaultTreeModel(root);
    }

    @Override
    public boolean commitChanges() {
        ListNode listNode;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.findNode(null, this._currentLib);
        Object[] nodes = node != null ? node.getPath() : null;
        TreePath path = nodes != null && nodes.length > 1 ? new TreePath(nodes) : null;
        ListNode listNode2 = listNode = path != null ? (ListNode)path.getPathComponent(1) : null;
        if (listNode != null) {
            try {
                this._currentLib = this.commitChanges(listNode.getList(), this._currentLib, this.getDetailPanel());
                node.setUserObject(this._currentLib);
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    protected Library commitChanges(MutableLibraryList list, Library lib, LibraryEditPanel panel) throws Exception {
        if (lib == null) {
            return lib;
        }
        JLibraryModel model = new JLibraryModel((JLibrary)lib, list, (Component)panel);
        model.setName(panel.getLibraryName());
        model.setClassPath(panel.getClassPath());
        model.setSourcePath(panel.getSourcePath());
        model.setDocPath(panel.getDocPath());
        model.setDeployedByDefault(panel.isDeployByDefault());
        return model.commit();
    }

    @Override
    protected Library createNewElement(ListWrapper[] wrapper) {
        ListWrapper list = wrapper[0];
        HashStructure hash = HashStructure.newInstance();
        Library lib = new JLibraryAdapter(hash);
        LibraryEditPanel newPanel = new LibraryEditPanel();
        newPanel.setLibrary(lib);
        newPanel.setLibraryLists(this.getLibraryLists());
        newPanel.setListsVisible(true);
        newPanel.setLibraryList(list);
        this.listener.initialize(newPanel, lib);
        if (OnePageWizardDialogFactory.runDialog((Component)this, (Component)newPanel, (Component)newPanel.addBtn, (String)this.getDetailTitle(), (int)7, (VetoableChangeListener)this.listener, (DialogRunnerCallback)new SizeKeeperCallback("new.library"))) {
            lib = this.listener.getLibrary();
            wrapper[0] = (ListWrapper)newPanel.getLibraryList();
        } else {
            lib = null;
        }
        return lib;
    }

    @Override
    protected ListNode addLibraryList(ListWrapper list) {
        LibraryListNode listNode = this.buildListNode(list);
        DefaultTreeModel model = this.getTreeModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
        model.insertNodeInto(listNode, root, root.getChildCount());
        return listNode;
    }

    @Override
    protected void nodeDeleted(LeafNode node) {
        if (node instanceof LibraryNode && ((LibraryNode)node).getLibrary() == this._currentLib) {
            this._currentLib = null;
            this.getDetailPanel().setLibrary(null);
        }
    }

    @Override
    protected boolean updateSelection(Library elem) {
        if (this._currentLib != elem) {
            if (this._currentLib != null && this.isSplit()) {
                try {
                    this.commitChanges();
                }
                catch (Exception e) {
                    return false;
                }
            }
            this._currentLib = elem;
            this.getDetailPanel().setLibrary(elem);
        }
        return true;
    }

    protected LibraryListNode buildListNode(ListWrapper list) {
        ArrayList libs;
        ArrayList arrayList = libs = list != null ? list.getLibraryList() : null;
        if (this._existingLibs != null && libs != null && libs.size() > 0) {
            ArrayList filteredLibs = new ArrayList(libs.size());
            filteredLibs.addAll(libs);
            HashSet<Object> existingIds = new HashSet<Object>();
            for (JLibrary lib : this._existingLibs) {
                existingIds.add(lib.getID());
            }
            Iterator iterator = filteredLibs.iterator();
            while (iterator.hasNext()) {
                JLibrary lib;
                lib = (JLibrary)iterator.next();
                if (!existingIds.contains(lib.getID())) continue;
                iterator.remove();
            }
            libs = filteredLibs.size() > 0 ? filteredLibs : null;
        }
        Iterator i = libs != null ? libs.iterator() : null;
        return new LibrariesPanelLibraryListNode(list, i);
    }

    @Override
    protected LibraryListNode createLibraryListNode(ListWrapper list, Iterator i) {
        return new LibrariesPanelLibraryListNode(list, i);
    }

    protected class LibrariesPanelLibraryListNode
    extends LibraryListNode {
        LibrariesPanelLibraryListNode(ListWrapper list, Iterator i) {
            super(list, i);
        }

        @Override
        void selectNode(DefaultMutableTreeNode node) {
            LibrariesPanel.this.selectNode(node);
        }
    }

    final class LocalChangeListener
    implements VetoableChangeListener {
        private LibraryEditPanel _newPanel;
        private Library _lib;

        LocalChangeListener() {
        }

        public void initialize(LibraryEditPanel panel, Library lib) {
            this._newPanel = panel;
            this._lib = lib;
        }

        public Library getLibrary() {
            return this._lib;
        }

        @Override
        public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
            try {
                this._lib = LibrariesPanel.this.commitChanges((MutableLibraryList)this._newPanel.getLibraryList(), this._lib, this._newPanel);
            }
            catch (Exception x) {
                throw new PropertyVetoException(null, e);
            }
        }
    }
}

