/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.library;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.ide.Context;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.Pair;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdeveloper.model.PathsConfiguration;

public class LibraryConflictDetection {
    private static LibraryConflictDetection INSTANCE = new LibraryConflictDetection();
    private Collection<MutExData> mutExLibrariesData = new ArrayList<MutExData>();

    public static LibraryConflictDetection getInstance() {
        return INSTANCE;
    }

    public void registerMutExtLibraries(Collection<String> mutExLibraries) {
        this.registerMutExtLibraries(mutExLibraries, true, true);
    }

    public void registerMutExtLibraries(Collection<String> mutExLibraries, DeployDetectionContext deployContext) {
        this.registerMutExtLibraries(mutExLibraries, null, deployContext);
    }

    public void registerMutExtLibraries(Collection<String> mutExLibraries, BuildDetectionContext buildContext) {
        this.registerMutExtLibraries(mutExLibraries, buildContext, null);
    }

    public void registerMutExtLibraries(Collection<String> mutExLibraries, boolean checkAtCompileTime, boolean checkAtDeployment) {
        this.registerMutExtLibraries(mutExLibraries, checkAtCompileTime ? MessageLevel.WARNING : null, checkAtDeployment ? MessageLevel.ERROR : null);
    }

    public void registerMutExtLibraries(Collection<String> mutExLibraries, MessageLevel compilationMessageLevel, MessageLevel deploymentMessageLevel) {
        assert (compilationMessageLevel != null || deploymentMessageLevel != null);
        DeployDetectionContext ddContext = deploymentMessageLevel == null ? null : new DeployDetectionContext(deploymentMessageLevel);
        BuildDetectionContext bdContext = compilationMessageLevel == null ? null : new BuildDetectionContext(compilationMessageLevel);
        this.registerMutExtLibraries(mutExLibraries, bdContext, ddContext);
    }

    public void registerMutExtLibraries(Collection<String> mutExLibraries, BuildDetectionContext bdContext, DeployDetectionContext ddContext) {
        assert (bdContext != null || ddContext != null);
        this.mutExLibrariesData.add(new MutExData(mutExLibraries, bdContext, ddContext));
    }

    public List<Message> detectDeploymentConflicts(Project project, Context deploymentContext) {
        ArrayList<Message> messages = new ArrayList<Message>();
        JProjectLibraries projectLibs = JProjectLibraries.getInstance((PropertyStorage)project);
        for (MutExData mutExLibraries : this.mutExLibrariesData) {
            if (mutExLibraries.deploymentContext == null || !mutExLibraries.deploymentContext.detectionCondition.validateContext(deploymentContext)) continue;
            ArrayList<String> foundReferences = new ArrayList<String>();
            for (String libName : mutExLibraries.mutExLibraries) {
                if (!projectLibs.hasLibrary(libName)) continue;
                foundReferences.add(libName);
            }
            if (foundReferences.size() <= 1) continue;
            String msg = LibraryConflictDetection._getMsg(foundReferences);
            Message conflictMessage = new Message(null, project, msg, mutExLibraries.deploymentContext.messageLevel);
            messages.add(conflictMessage);
        }
        return messages;
    }

    public List<Message> detectBuildConflicts(Context context) {
        ArrayList<Message> messages = new ArrayList<Message>();
        Project project = context.getProject();
        if (project != null) {
            JProjectLibraries projectLibs = JProjectLibraries.getInstance((PropertyStorage)project);
            Project[] depProjects = PathsConfiguration.getDependentProjects(context);
            ArrayList<Pair> depProjectLibs = new ArrayList<Pair>(depProjects.length);
            for (Project depProject : depProjects) {
                if (depProject == null) continue;
                depProjectLibs.add(new Pair((Object)depProject, (Object)JProjectLibraries.getInstance((PropertyStorage)depProject)));
            }
            for (MutExData mutExLibraries : this.mutExLibrariesData) {
                if (mutExLibraries.buildContext == null) continue;
                HashMap<String, List<Project>> foundReferences = new HashMap<String, List<Project>>();
                for (String string : mutExLibraries.mutExLibraries) {
                    if (projectLibs.hasLibrary(string)) {
                        LibraryConflictDetection._addRefProject(string, project, foundReferences);
                    }
                    if (!mutExLibraries.buildContext.checkDependencies) continue;
                    for (Pair depProjectLib : depProjectLibs) {
                        boolean depPrjHasLibrary = mutExLibraries.buildContext.checkOnlyExportedLibraries ? ((JProjectLibraries)((Object)depProjectLib.getSecond())).hasExport(string) : ((JProjectLibraries)((Object)depProjectLib.getSecond())).hasLibrary(string);
                        if (!depPrjHasLibrary) continue;
                        LibraryConflictDetection._addRefProject(string, (Project)depProjectLib.getFirst(), foundReferences);
                    }
                }
                if (foundReferences.size() <= 1) continue;
                for (Map.Entry entry : foundReferences.entrySet()) {
                    String msg = LibraryConflictDetection._getMsg((String)entry.getKey(), (List)entry.getValue());
                    Message message = new Message(null, null, msg, MessageLevel.INFO);
                    messages.add(message);
                }
                String msg = LibraryConflictDetection._getMsg(foundReferences.keySet());
                Message message = new Message(context.getWorkspace(), project, msg, mutExLibraries.buildContext.messageLevel);
                messages.add(message);
            }
        }
        return messages;
    }

    private static void _addRefProject(String libName, Project project, Map<String, List<Project>> foundReferences) {
        List<Project> foundProjects = foundReferences.get(libName);
        if (foundProjects == null) {
            foundProjects = new ArrayList<Project>();
            foundReferences.put(libName, foundProjects);
        }
        foundProjects.add(project);
    }

    private static String _getMsg(String libName, List<Project> projects) {
        StringBuffer prjNames = new StringBuffer();
        for (int i = 0; i < projects.size() - 1; ++i) {
            prjNames.append(projects.get(i).getShortLabel() + ", ");
        }
        prjNames.append(projects.get(projects.size() - 1).getShortLabel() + ".\n");
        return "Library '" + libName + "' used in project(s): " + prjNames;
    }

    private static String _getMsg(Collection<String> libs) {
        StringBuffer libNames = new StringBuffer();
        Iterator<String> libIter = libs.iterator();
        while (libIter.hasNext()) {
            libNames.append(libIter.next());
            if (libIter.hasNext()) {
                libNames.append(", ");
                continue;
            }
            libNames.append(".\n");
        }
        return "Must choose only one of libraries: " + libNames;
    }

    private static class MutExData {
        public final Collection<String> mutExLibraries;
        public final BuildDetectionContext buildContext;
        public final DeployDetectionContext deploymentContext;

        private MutExData(Collection<String> mutExLibraries, BuildDetectionContext bdContext, DeployDetectionContext ddContext) {
            this.mutExLibraries = mutExLibraries;
            this.buildContext = bdContext;
            this.deploymentContext = ddContext;
        }
    }

    public static class BuildDetectionContext {
        private final MessageLevel messageLevel;
        private final boolean checkDependencies;
        private final boolean checkOnlyExportedLibraries;

        public BuildDetectionContext(MessageLevel messageLevel) {
            this(messageLevel, true);
        }

        public BuildDetectionContext(MessageLevel messageLevel, boolean checkDependencies) {
            this(messageLevel, checkDependencies, true);
        }

        public BuildDetectionContext(MessageLevel messageLevel, boolean checkDependencies, boolean checkOnlyExportedLibraries) {
            this.messageLevel = messageLevel;
            this.checkDependencies = checkDependencies;
            this.checkOnlyExportedLibraries = checkOnlyExportedLibraries;
        }
    }

    public static class DeployDetectionContext {
        private final MessageLevel messageLevel;
        private final DetectionCondition detectionCondition;

        public DeployDetectionContext(MessageLevel messageLevel) {
            this(messageLevel, new DetectionCondition());
        }

        public DeployDetectionContext(MessageLevel messageLevel, DetectionCondition detectionCondition) {
            this.messageLevel = messageLevel;
            this.detectionCondition = detectionCondition;
        }
    }

    public static class DetectionCondition {
        public boolean validateContext(Context context) {
            return true;
        }
    }

    public static class Message {
        private Workspace ws;
        private Project prj;
        private String msg;
        private MessageLevel level;

        private Message(Workspace ws, Project prj, String msg, MessageLevel level) {
            this.ws = ws;
            this.prj = prj;
            this.msg = msg;
            this.level = level;
        }

        public Workspace getWorkspace() {
            return this.ws;
        }

        public Project getProject() {
            return this.prj;
        }

        public String getMessage() {
            return this.msg;
        }

        public MessageLevel getLevel() {
            return this.level;
        }
    }

    public static enum MessageLevel {
        INFO,
        WARNING,
        ERROR;

    }
}

