/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.library;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.LibraryOverride;
import oracle.jdeveloper.library.LibraryOverrideContext;

public class LibraryProxy
implements InvocationHandler {
    private final LibraryOverrideContext context;
    private final Object override;

    public static JLibrary get(Workspace workspace, Project project, JLibrary original, Object override) {
        assert (override != null);
        return (JLibrary)Proxy.newProxyInstance(original.getClass().getClassLoader(), LibraryProxy.getProxyInterfaces(original.getClass()), (InvocationHandler)new LibraryProxy(new LibraryOverrideContext(workspace, project, original), override));
    }

    private static Class<?>[] getProxyInterfaces(Class<?> c) {
        LinkedHashSet interfaces = new LinkedHashSet();
        Class<?> current = c;
        do {
            for (Class<?> i : current.getInterfaces()) {
                if (!Modifier.isPublic(i.getModifiers())) continue;
                interfaces.add(i);
            }
        } while ((current = current.getSuperclass()) != null);
        return interfaces.toArray(new Class[interfaces.size()]);
    }

    public static boolean isProxyLibrary(Object o) {
        if (Proxy.isProxyClass(o.getClass())) {
            return Proxy.getInvocationHandler(o) instanceof LibraryProxy;
        }
        return false;
    }

    public static JLibrary getProxiedLibrary(Object o) {
        if (Proxy.isProxyClass(o.getClass())) {
            JLibrary proxied = (JLibrary)o;
            do {
                InvocationHandler handler;
                if (!((handler = Proxy.getInvocationHandler(proxied)) instanceof LibraryProxy)) continue;
                proxied = ((LibraryProxy)handler).getProxiedLibrary();
            } while (Proxy.isProxyClass(proxied.getClass()));
            return proxied;
        }
        return null;
    }

    private LibraryProxy(LibraryOverrideContext context, Object override) {
        this.context = context;
        this.override = override;
    }

    public JLibrary getProxiedLibrary() {
        return this.context.getOverriddenLibrary();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        ArrayList params = new ArrayList(Arrays.asList(method.getParameterTypes()));
        params.add(0, LibraryOverrideContext.class);
        try {
            LibraryOverride annotation;
            Method m = this.override.getClass().getMethod(method.getName(), params.toArray(new Class[params.size()]));
            if (m != null && method.getReturnType().isAssignableFrom(m.getReturnType()) && (annotation = m.getAnnotation(LibraryOverride.class)) != null && annotation.declaredBy().equals(method.getDeclaringClass())) {
                Object[] copy;
                if (args == null) {
                    copy = new Object[]{this.context};
                } else {
                    copy = args == null ? new Object[1] : new Object[args.length + 1];
                    System.arraycopy(args, 0, copy, 1, args.length);
                    copy[0] = this.context;
                }
                m.setAccessible(true);
                try {
                    return m.invoke(this.override, copy);
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
            }
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        try {
            return method.invoke((Object)this.context.getOverriddenLibrary(), args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }
}

