/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.library;

import oracle.ide.Context;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectChangeEvent;
import oracle.ide.model.ProjectChangeListener;
import oracle.javatools.data.StructureChangeEvent;
import oracle.jdevimpl.library.LibraryContainerEventSource;
import oracle.jdevimpl.library.ProjectLibraryContainer;

public final class ProjectLibraryEventSource
extends LibraryContainerEventSource {
    private static int counter;
    private static final ProjectChangeListener definitionListener;
    private static final ProjectChangeListener referenceListener;
    private static final ProjectChangeListener exportListener;
    private final Project project;

    public static synchronized LibraryContainerEventSource getInstance(Project project) {
        return ProjectLibraryEventSource.getInstance(project, true);
    }

    private static synchronized LibraryContainerEventSource getInstance(Project project, boolean create) {
        ProjectLibraryContainer container = ProjectLibraryContainer.getInstance(project);
        LibraryContainerEventSource instance = ProjectLibraryEventSource.getCachedInstance(container);
        if (create && instance == null) {
            instance = new ProjectLibraryEventSource(container);
            ProjectLibraryEventSource.putCachedInstance(container, instance);
        }
        return instance;
    }

    private ProjectLibraryEventSource(ProjectLibraryContainer container) {
        super(container);
        this.project = container.getProject();
    }

    @Override
    public void attach() {
        super.attach();
        ProjectLibraryEventSource.attachProjectListener();
    }

    @Override
    public void detach() {
        ProjectLibraryEventSource.detachProjectListener();
        super.detach();
    }

    @Override
    protected Context getContext() {
        Context context = Context.newIdeContext();
        context.setWorkspace(this.project.getWorkspace());
        context.setProject(this.project);
        return context;
    }

    private static synchronized void attachProjectListener() {
        if (counter++ == 0) {
            Project.addProjectChangeListener((String)"oracle.jdevimpl.config.JProjectLibraries/libraryReferences", (ProjectChangeListener)referenceListener);
            Project.addProjectChangeListener((String)"oracle.jdevimpl.config.JProjectLibraries/internalDefinitions", (ProjectChangeListener)definitionListener);
            Project.addProjectChangeListener((String)"oracle.jdevimpl.config.JProjectLibraries/exportedReferences", (ProjectChangeListener)exportListener);
        }
    }

    private static synchronized void detachProjectListener() {
        if (--counter == 0) {
            Project.removeProjectChangeListener((String)"oracle.jdevimpl.config.JProjectLibraries/libraryReferences", (ProjectChangeListener)referenceListener);
            Project.removeProjectChangeListener((String)"oracle.jdevimpl.config.JProjectLibraries/internalDefinitions", (ProjectChangeListener)definitionListener);
            Project.removeProjectChangeListener((String)"oracle.jdevimpl.config.JProjectLibraries/exportedReferences", (ProjectChangeListener)exportListener);
        }
    }

    static {
        definitionListener = new ProjectListenerAdapter(new LibraryContainerEventSource.DefinitionListener());
        referenceListener = new ProjectListenerAdapter(new LibraryContainerEventSource.ReferenceListener());
        exportListener = new ProjectListenerAdapter(new LibraryContainerEventSource.ExportListener());
    }

    private static class ProjectListenerAdapter
    extends ProjectChangeListener {
        private final LibraryContainerEventSource.LibraryContainerListener adapted;

        ProjectListenerAdapter(LibraryContainerEventSource.LibraryContainerListener adapted) {
            this.adapted = adapted;
        }

        public void projectPropertiesChanged(ProjectChangeEvent event) {
            LibraryContainerEventSource source;
            Project project;
            if (event.hasNonPlaceholderChange() && (project = event.getProject()) != null && (source = ProjectLibraryEventSource.getInstance(project, false)) != null) {
                this.adapted.containerPropertiesChanged(source, (StructureChangeEvent)event);
            }
        }
    }
}

