/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.migration.applications.recognisers;

import java.util.ArrayList;
import oracle.dbtools.raptor.migration.applications.recognisers.FileRecognizer;
import oracle.dbtools.raptor.utils.XMLHelper;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Recognizer
extends FileRecognizer {
    private String type = "";
    private ArrayList<String> extensions = new ArrayList();
    private ArrayList<String> strings = new ArrayList();
    private String startComment = "";
    private String endComment = "";
    private String singleLineComment = "";
    private boolean m_enabled = false;
    private String m_description = "";

    public Recognizer(Node node) {
        this.setType(XMLHelper.getAttributeNode((Node)node, (String)"name"));
        this.setDescription(XMLHelper.getAttributeNode((Node)node, (String)"description"));
        this.setEnabled(XMLHelper.getAttributeNode((Node)node, (String)"enable"));
        this.setExtensions(node);
        this.setExpressions(node);
    }

    public String getDescription() {
        return this.m_description;
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getStartComment() {
        return this.startComment;
    }

    @Override
    public String getEndComment() {
        return this.endComment;
    }

    @Override
    public String[] getStrings() {
        return this.strings.toArray(new String[this.strings.size()]);
    }

    @Override
    public String[] getExtensions() {
        return this.extensions.toArray(new String[this.extensions.size()]);
    }

    @Override
    public String getSingleLineComment() {
        return this.singleLineComment;
    }

    private void setEnabled(String string) {
        this.m_enabled = Boolean.getBoolean(string);
    }

    private void setDescription(String string) {
        this.m_description = string;
    }

    public void setType(String string) {
        this.type = string.toLowerCase();
    }

    public void addFileExpression(String string) {
        this.strings.add(string);
    }

    public void addExtenstion(String string) {
        this.extensions.add(string);
    }

    public void setSingleLineComment(String string) {
        this.singleLineComment = string;
    }

    public void setStartComment(String string) {
        this.startComment = string;
    }

    public void setEndComment(String string) {
        this.endComment = string;
    }

    private void setExpressions(Node node) {
        if (node.hasChildNodes() && XMLHelper.getChildNode((Node)node, (String)"expression") != null) {
            NodeList nodeList = XMLHelper.getChildNode((Node)node, (String)"expression").getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                this.strings.add(nodeList.item(i).getNodeValue());
            }
        }
    }

    private void setExtensions(Node node) {
        if (XMLHelper.getChildNode((Node)node, (String)"fileExtension") != null) {
            Node node2 = XMLHelper.getChildNode((Node)node, (String)"fileExtension");
            String string = XMLHelper.getAttributeNode((Node)node2, (String)"extension");
            String[] stringArray = string.split("(?<!\\\\),");
            for (int i = 0; i < stringArray.length; ++i) {
                this.extensions.add(stringArray[i]);
            }
        }
    }
}

