/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.migration.applications.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.sql.Connection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.metadata.createRepository.RunRepositoryScripts;
import oracle.dbtools.metadata.persistence.MdProject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.navigator.MigrationProjectNavigatorManager;
import oracle.dbtools.migration.workbench.core.navigator.nodes.MigrationProjectsFolderNode;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.migration.applications.AppScanArb;
import oracle.dbtools.raptor.migration.applications.cmdline.ScannerDetails;
import oracle.dbtools.raptor.migration.applications.report.ReportEngineFactory;
import oracle.dbtools.raptor.migration.applications.scanner.FileProcessor;
import oracle.dbtools.raptor.migration.applications.scanner.FileProcessorListener;
import oracle.dbtools.raptor.migration.applications.ui.OnlineScannerDetails;
import oracle.dbtools.raptor.migration.applications.ui.SummaryTreeModel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.model.Element;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.icons.OracleIcons;

public class AppScanTreeSummary
extends DefaultTraversablePanel {
    private static Logger LOGGER = Logger.getLogger(AppScanTreeSummary.class.getName());
    private static final long serialVersionUID = 1L;
    protected JTree summary = new JTree();
    private TraversableContext m_ctx;

    protected static void log(Throwable throwable) {
        String string = throwable.getMessage() + " - " + throwable.getStackTrace()[0].toString();
        LOGGER.log(Level.WARNING, string, throwable);
    }

    public AppScanTreeSummary() {
        this.setLayout(new GridBagLayout());
        JScrollPane jScrollPane = new JScrollPane();
        this.summary.setCellRenderer(new NodeRenderer());
        jScrollPane.setViewportView(this.summary);
        this.add(jScrollPane, new GridBagConstraints(0, 0, 5, 5, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void onEntry(TraversableContext traversableContext) {
        this.m_ctx = traversableContext;
        SummaryTreeModel summaryTreeModel = new SummaryTreeModel(traversableContext);
        this.summary.setModel(summaryTreeModel.getTreeModel());
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (traversableContext.getDirection() == 1) {
            try {
                DatabaseQueryTask<Boolean> databaseQueryTask = new DatabaseQueryTask<Boolean>(AppScanArb.getString("APPSCAN_SCANNING_APPLICATION"), IRaptorTaskRunMode.MODAL_OPTIONAL, false, false){

                    public String getConnectionName() {
                        return MigrationAddin.getDefaultMigrationRepository();
                    }

                    public String getQuery() {
                        return AppScanArb.getString("APPSCAN_SCANNING_APPLICATION");
                    }

                    protected Boolean doWork() throws TaskException {
                        try {
                            Object object;
                            Object object2;
                            if (AppScanTreeSummary.this.m_ctx.get("nodeToRefresh") == null) {
                                Object object3;
                                object2 = (String)AppScanTreeSummary.this.m_ctx.get("MIGR_REPOSITORY");
                                boolean bl = (Boolean)AppScanTreeSummary.this.m_ctx.get("TRUNCATE_REPOSITORY");
                                if (bl) {
                                    this.setMessage(MigrationAddinArb.getString((String)"MIGRATION_TRUNCATE_REPOSITORY_TEXT"));
                                    object = Connections.getInstance().getConnection((String)object2);
                                    object3 = new RunRepositoryScripts((Connection)object);
                                    object3.setUpdater(this.getRaptorTaskProgressUpdater());
                                    object3.setMode(4);
                                    object3.setScript("purgeRepository.sql");
                                    object3.run();
                                }
                                if (AppScanTreeSummary.this.m_ctx.get("project") == null || ((String)AppScanTreeSummary.this.m_ctx.get("project")).equals("")) {
                                    boolean bl2 = (Boolean)AppScanTreeSummary.this.m_ctx.get("NEW_PROJ_MODE");
                                    if (bl2) {
                                        object3 = this.createProject();
                                        if (object3 != null) {
                                            AppScanTreeSummary.this.m_ctx.put("project", (Object)String.valueOf(object3.getKey().getId()));
                                        }
                                    } else {
                                        object3 = (String)AppScanTreeSummary.this.m_ctx.get("EXISTING_PROJ_ID");
                                        if (object3 != null) {
                                            AppScanTreeSummary.this.m_ctx.put("project", object3);
                                        }
                                    }
                                }
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        MigrationProjectNavigatorManager.getInstance().refreshElement((Element)MigrationProjectsFolderNode.getInstance());
                                    }
                                });
                            }
                            object2 = new OnlineScannerDetails(AppScanTreeSummary.this.m_ctx);
                            FileProcessor fileProcessor = new FileProcessor((ScannerDetails)object2);
                            object = ReportEngineFactory.getEngine((ScannerDetails)object2);
                            fileProcessor.addListener((FileProcessorListener)object);
                            fileProcessor.process();
                            fileProcessor.removeListener((FileProcessorListener)object);
                        }
                        catch (Exception exception) {
                            AppScanTreeSummary.log(exception);
                        }
                        return Boolean.TRUE;
                    }

                    private MdProject createProject() throws Exception {
                        MdProject mdProject = null;
                        String string = (String)AppScanTreeSummary.this.m_ctx.get("PROJ_NAME");
                        String string2 = (String)AppScanTreeSummary.this.m_ctx.get("PROJ_DESC");
                        String string3 = (String)AppScanTreeSummary.this.m_ctx.get("PROJ_OUTDIR");
                        PersistenceManager persistenceManager = MigrationAddin.getPersistenceManager();
                        PersistenceUtility persistenceUtility = PersistenceUtility.getInstance((PersistenceManager)persistenceManager);
                        try {
                            this.setMessage(MigrationAddinArb.getString((String)"FULLMIGRATION_TOOLTIP_CREATEPROJECT"));
                            mdProject = persistenceUtility.getNamedProject(string);
                            if (mdProject == null) {
                                mdProject = new MdProject(string);
                                mdProject.setComments(string2);
                                mdProject.save(persistenceManager);
                                this.setProjectOutputDir(string3);
                                this.setMessage(MigrationAddinArb.getString((String)"FULLMIGRATION_TOOLTIP_PROJECTBUILD"));
                            }
                        }
                        catch (PersistenceException persistenceException) {
                            AppScanTreeSummary.log(persistenceException);
                        }
                        return mdProject;
                    }

                    private void setProjectOutputDir(String string) {
                        String string2 = (String)AppScanTreeSummary.this.m_ctx.get("PROJ_NAME");
                        String string3 = string2 != null ? string2 : "UnknownProject";
                        MigrationAddin.getMigrationConfig().setStringProperty(string3 + "_" + "outdir", string);
                    }
                };
                final Element element = (Element)this.m_ctx.get("nodeToRefresh");
                if (element != null) {
                    databaseQueryTask.getDescriptor().addListener(new IRaptorTaskListener(){

                        public void stateChanged(RaptorTaskEvent raptorTaskEvent) {
                            switch (raptorTaskEvent.getTaskDescriptor().getStatus()) {
                                case FINISHED: 
                                case FAILED: {
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            try {
                                                MigrationProjectNavigatorManager.getInstance().refreshElement(element);
                                            }
                                            catch (Exception exception) {
                                                AppScanTreeSummary.log(exception);
                                            }
                                        }
                                    });
                                    break;
                                }
                            }
                        }

                        public void progressChanged(RaptorTaskEvent raptorTaskEvent) {
                        }

                        public void messageChanged(RaptorTaskEvent raptorTaskEvent) {
                        }
                    });
                }
                RaptorTaskManager.getInstance().addTask((RaptorTask)databaseQueryTask);
            }
            catch (Exception exception) {
                ExceptionHandler.handleException((Throwable)exception);
            }
        }
    }

    public class NodeRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            JLabel jLabel = (JLabel)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
            if (object2 instanceof String) {
                jLabel.setText((String)object2);
                if (bl3) {
                    jLabel.setIcon(OracleIcons.getIcon((String)"attribute.png"));
                }
                if (jLabel.getText().equals(AppScanArb.get("APPSCAN_SUMMARY_TITLE"))) {
                    jLabel.setIcon(OracleIcons.getIcon((String)"application.png"));
                } else if (StringUtils.stripMnemonic((String)jLabel.getText()).equals(StringUtils.stripMnemonic((String)AppScanArb.get("APPSCAN_DATABASE_TYPE")))) {
                    jLabel.setIcon(OracleIcons.getIcon((String)"database.png"));
                } else if (jLabel.getText().equals(AppScanArb.get("APPSCAN_DETAILS"))) {
                    jLabel.setIcon(OracleIcons.getIcon((String)"detail.gif"));
                } else if (jLabel.getText().equals(AppScanArb.get("APPSCAN_ACTIONS"))) {
                    jLabel.setIcon(OracleIcons.getIcon((String)"action.png"));
                } else if (StringUtils.stripMnemonic((String)jLabel.getText()).equals(StringUtils.stripMnemonic((String)AppScanArb.get("APPSCAN_APP_DIR")))) {
                    jLabel.setIcon(OracleIcons.getIcon((String)"directorytreeview.png"));
                }
                return jLabel;
            }
            return (Component)object2;
        }
    }
}

