/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.persistence;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import net.jcip.annotations.GuardedBy;
import oracle.ide.Ide;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.model.WorkspaceChangeEvent;
import oracle.ide.model.WorkspaceChangeListener;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLKey;
import oracle.ide.persistence.ApplicationCacheSettings;
import oracle.ide.persistence.NameSpace;
import oracle.ide.persistence.SecondaryKeyProvider;
import oracle.ide.persistence.Storage;
import oracle.javatools.annotations.NotNull;
import oracle.javatools.data.ChangeInfo;
import oracle.javatools.util.Maps;
import oracle.javatools.util.NullArgumentException;

public final class Storages {
    @GuardedBy(value="itself")
    private static final Map<ProjectStorageKey, ProjectStorage> PROJECT_STORAGES = new Maps.CacheMap(Maps.CacheMap.WEAK);
    @GuardedBy(value="itself")
    private static final Map<URLKey, ApplicationStorage> APPLICATION_STORAGES = new Maps.CacheMap(Maps.CacheMap.WEAK);
    private static final Collection<AbstractStorage> LOCKED_STORAGES = Collections.synchronizedSet(new HashSet());
    private static final String STORAGE_DIRECTORY_NAME = ".data";
    private static final String JAR_RELATIVE_PATH_PREFIX = "jar$";
    private static final String JAR_RELATIVE_PATH_SEPARATOR = "!/";
    private static final Logger LOGGER = Logger.getLogger(Storages.class.getName());
    private static final int MAX_DATABASE_NAME_LENGTH = 25;

    public static Storage getProjectStorage(@NotNull Workspace workspace, @NotNull Project project) {
        if (workspace == null) {
            throw new NullArgumentException("null workspace");
        }
        if (project == null) {
            throw new NullArgumentException("null project");
        }
        return Storages.getProjectStorageImpl(workspace, project);
    }

    @Deprecated
    public static Storage getProjectStorage(@NotNull Project project) {
        return Storages.getProjectStorageImpl(Ide.getActiveWorkspace(), project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Storage getProjectStorageImpl(Workspace workspace, Project project) {
        URL location = Storages.getProjectStorageLocation(workspace, project.getURL());
        Map<ProjectStorageKey, ProjectStorage> map = PROJECT_STORAGES;
        synchronized (map) {
            ProjectStorageKey key = new ProjectStorageKey(workspace, project);
            ProjectStorage storage = PROJECT_STORAGES.get(key);
            if (storage == null) {
                key = key.intern();
                storage = new ProjectStorage(key.getWorkspaceUrl(), key.getProjectUrl(), location);
                PROJECT_STORAGES.put(key, storage);
            }
            return storage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Storage getApplicationStorage(@NotNull Workspace application) {
        if (application == null) {
            throw new NullArgumentException("null application");
        }
        URL location = Storages.getApplicationStorageLocation(application);
        Map<URLKey, ApplicationStorage> map = APPLICATION_STORAGES;
        synchronized (map) {
            URL url = application.getURL();
            URLKey key = URLKey.getInstance((URL)url);
            ApplicationStorage storage = APPLICATION_STORAGES.get(key);
            if (storage == null) {
                key = key.intern();
                storage = new ApplicationStorage(key.toURL(), location);
                APPLICATION_STORAGES.put(key, storage);
            }
            return storage;
        }
    }

    private static URL getApplicationStorageLocation(Workspace application) {
        URL appCache = ApplicationCacheSettings.getInstance(application).getStorageURL();
        if (appCache != null) {
            return URLFactory.newDirURL((URL)appCache, (String)STORAGE_DIRECTORY_NAME);
        }
        return null;
    }

    private static URL getProjectStorageLocation(Workspace workspace, URL project) {
        if (workspace != null) {
            URL appCache = Storages.getApplicationStorageLocation(workspace);
            if (project == null) {
                return appCache;
            }
            String projectName = URLFileSystem.getName((URL)project);
            return URLFactory.newDirURL((URL)appCache, (String)projectName);
        }
        return null;
    }

    private static Node findNode(URL url) {
        Node node = NodeFactory.find((URL)url);
        if (node == null) {
            LOGGER.warning("Access to storage for uncached Node: " + url);
        }
        return node;
    }

    private Storages() {
    }

    static {
        Workspace.addWorkspaceChangeListener((String)"application-storage-directory", (WorkspaceChangeListener)new WorkspaceListener());
    }

    private static final class WorkspaceListener
    implements WorkspaceChangeListener {
        private WorkspaceListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void workspacePropertiesChanged(WorkspaceChangeEvent event) {
            Workspace workspace = event.getWorkspace();
            for (ChangeInfo change : event.getChangeDetails()) {
                URL oldURL = change.getOldValueAsURL();
                if (oldURL == null) {
                    oldURL = ApplicationCacheSettings.getInstance(workspace).getDefaultApplicationStorageURL();
                }
                Set<Storage> storages = this.lockStoragesClosed(workspace);
                try {
                    if (oldURL != null) {
                        URL location = URLFactory.newDirURL((URL)oldURL, (String)Storages.STORAGE_DIRECTORY_NAME);
                        this.deleteOldStorageFiles(location);
                    }
                    this.refreshStorageLocations(storages);
                }
                finally {
                    this.allowStoragesOpen(storages);
                }
            }
        }

        private Set<Storage> lockStoragesClosed(Workspace workspace) {
            HashSet<Storage> storages = new HashSet<Storage>();
            Storage appStorage = Storages.getApplicationStorage(workspace);
            appStorage.lockClosed();
            storages.add(appStorage);
            for (Project project : workspace.projects()) {
                Storage projectStorage = Storages.getProjectStorage(workspace, project);
                if (!storages.add(projectStorage)) continue;
                projectStorage.lockClosed();
            }
            return storages;
        }

        private void allowStoragesOpen(Set<Storage> storages) {
            for (Storage storage : storages) {
                storage.allowOpen();
            }
        }

        private void refreshStorageLocations(Collection<Storage> storages) {
            for (Storage storage : storages) {
                ((AbstractStorage)storage).refreshStorageLocation();
            }
        }

        private void deleteOldStorageFiles(URL directory) {
            URLFileSystem.FileInfo[] infos = URLFileSystem.ls((URL)directory);
            if (infos != null) {
                for (URLFileSystem.FileInfo info : infos) {
                    if (info.isDirectory()) {
                        this.deleteOldStorageFiles(info.getURL());
                        continue;
                    }
                    URL url = info.getURL();
                    if (!this.isStorageFile(url)) continue;
                    URLFileSystem.delete((URL)url);
                }
                URLFileSystem.delete((URL)directory);
            }
        }

        private boolean isStorageFile(URL url) {
            String suffix = URLFileSystem.getSuffix((URL)url);
            return ".lck".equals(suffix) || ".jdb".equals(suffix);
        }
    }

    private static final class ProjectStorageKey {
        private final URLKey workspace;
        private final URLKey project;

        ProjectStorageKey(Workspace workspace, Project project) {
            this(URLKey.getInstance((URL)(workspace == null ? null : workspace.getURL())), URLKey.getInstance((URL)(project == null ? null : project.getURL())));
        }

        ProjectStorageKey(URLKey workspace, URLKey project) {
            this.workspace = workspace;
            this.project = project;
        }

        public ProjectStorageKey intern() {
            URLKey internedWorkspace = this.workspace.intern();
            URLKey internedProject = this.project.intern();
            if (internedWorkspace == this.workspace && internedProject == this.project) {
                return this;
            }
            return new ProjectStorageKey(internedWorkspace, internedProject);
        }

        public URL getWorkspaceUrl() {
            return this.workspace.toURL();
        }

        public URL getProjectUrl() {
            return this.project.toURL();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProjectStorageKey)) {
                return false;
            }
            ProjectStorageKey other = (ProjectStorageKey)o;
            return this.project.equals((Object)other.project) && this.workspace.equals((Object)other.workspace);
        }

        public int hashCode() {
            int hashCode = 21;
            hashCode = 31 * hashCode + this.project.hashCode();
            hashCode = 31 * hashCode + this.workspace.hashCode();
            return hashCode;
        }
    }

    private static final class ApplicationStorage
    extends AbstractStorage {
        private final URL application;
        private NameSpace nameNameSpace;

        public ApplicationStorage(URL application, URL storageLocation) {
            super(storageLocation);
            this.application = application;
        }

        @Override
        protected URL getStorageLocation() {
            try {
                Node node = Storages.findNode(this.application);
                if (node instanceof Workspace) {
                    return Storages.getApplicationStorageLocation((Workspace)node);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        @Override
        String getPathString() {
            return URLFileSystem.getPlatformPathName((URL)this.application);
        }

        @Override
        String getSharedNameSpaceName(String name) {
            return this.application.toExternalForm() + "-" + name;
        }

        @Override
        String getLocalNameSpaceName(String name) {
            return name;
        }

        public int hashCode() {
            return URLFileSystem.hashCode((URL)this.application);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ApplicationStorage)) {
                return false;
            }
            ApplicationStorage other = (ApplicationStorage)o;
            return URLFileSystem.equals((URL)this.application, (URL)other.application);
        }

        @Override
        protected NameSpace getNameSpaceImpl(String name, int type) {
            return super.getNameSpaceImpl(this.getShortName(name), type);
        }

        @Override
        protected synchronized void closeImpl() {
            if (this.nameNameSpace != null) {
                this.nameNameSpace.close();
                this.nameNameSpace = null;
            }
            super.closeImpl();
        }

        @Override
        protected void deleteNameSpaceImpl(String name) {
            super.deleteNameSpaceImpl(this.getShortName(name));
        }

        @Override
        protected void deleteNameSpaceImpl(String name, Collection<String> secondaryKeys) {
            super.deleteNameSpaceImpl(this.getShortName(name), secondaryKeys);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getShortName(String name) {
            if (name.length() > 25) {
                try {
                    int hash = name.hashCode();
                    String shortName = Integer.toString(hash, 36);
                    ApplicationStorage applicationStorage = this;
                    synchronized (applicationStorage) {
                        block10: {
                            if (this.nameNameSpace == null) {
                                this.nameNameSpace = this.getNameSpace("namespace-names");
                            }
                            if (this.nameNameSpace != null) {
                                byte[] record;
                                while ((record = this.nameNameSpace.getRecord(shortName)) != null) {
                                    String recordName = new String(record, "UTF-8");
                                    if (name.equals(recordName)) {
                                        name = shortName;
                                        break block10;
                                    }
                                    shortName = Integer.toString(++hash, 36);
                                }
                                this.nameNameSpace.putRecord(shortName, name.getBytes("UTF-8"));
                                name = shortName;
                            }
                        }
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            return name;
        }
    }

    private static final class ProjectStorage
    extends AbstractStorage {
        private final URL workspace;
        private final URL project;

        public ProjectStorage(URL workspace, URL project, URL storageLocation) {
            super(storageLocation);
            this.workspace = workspace;
            this.project = project;
        }

        @Override
        protected URL getStorageLocation() {
            if (this.workspace != null) {
                try {
                    Node node = Storages.findNode(this.workspace);
                    if (node instanceof Workspace) {
                        return Storages.getProjectStorageLocation((Workspace)node, this.project);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        @Override
        String getPathString() {
            return URLFileSystem.getPlatformPathName((URL)this.project);
        }

        @Override
        String getSharedNameSpaceName(String name) {
            if (this.project != null) {
                return this.project.toExternalForm() + "-" + name;
            }
            return name;
        }

        @Override
        String getLocalNameSpaceName(String name) {
            if (this.project != null) {
                return this.getRelativePath(this.project) + name;
            }
            return name;
        }

        public int hashCode() {
            int hash = 17;
            if (this.project != null) {
                hash = 31 * hash + URLFileSystem.hashCode((URL)this.project);
            }
            if (this.workspace != null) {
                hash = 31 * hash + URLFileSystem.hashCode((URL)this.workspace);
            }
            return hash;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProjectStorage)) {
                return false;
            }
            ProjectStorage other = (ProjectStorage)o;
            return (this.project == null ? other.project == null : URLFileSystem.equals((URL)this.project, (URL)other.project)) && (this.workspace == null ? other.workspace == null : URLFileSystem.equals((URL)this.workspace, (URL)other.workspace));
        }
    }

    private static abstract class AbstractStorage
    implements Storage {
        @GuardedBy(value="this")
        private int openCount;
        @GuardedBy(value="this")
        private int pinCount;
        @GuardedBy(value="this")
        private String location;
        @GuardedBy(value="this")
        private URL baseURL;
        @GuardedBy(value="this")
        private final Collection<Thread> lockThreads = new HashSet<Thread>(3);
        @GuardedBy(value="this")
        private URL storageLocation;

        abstract String getPathString();

        abstract String getSharedNameSpaceName(String var1);

        abstract String getLocalNameSpaceName(String var1);

        protected abstract URL getStorageLocation();

        protected AbstractStorage(URL storageLocation) {
            this.storageLocation = storageLocation;
        }

        protected synchronized void refreshStorageLocation() {
            this.storageLocation = this.getStorageLocation();
        }

        @Override
        public NameSpace getNameSpace(String name) {
            return this.getNameSpace(name, 0);
        }

        @Override
        public synchronized boolean isOpen() {
            return this.openCount > 0;
        }

        @Override
        public synchronized void open() {
            if (this.lockThreads.contains(Thread.currentThread())) {
                throw new IllegalStateException("Cannot open storage that has been locked closed by the calling thread.");
            }
            while (!this.lockThreads.isEmpty()) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.openCount++ == 0) {
                this.openImpl(this.storageLocation);
            }
        }

        protected void openImpl(URL storageLocation) {
            LOGGER.fine("Opening storage for " + this.getPathString());
            if (storageLocation != null) {
                if ("file".equals(storageLocation.getProtocol())) {
                    String path = storageLocation.getPath();
                    File file = new File(path);
                    if (file.exists()) {
                        if (file.canWrite()) {
                            if (NameSpace.canOpen(path)) {
                                this.baseURL = storageLocation;
                                this.location = path;
                                return;
                            }
                            LOGGER.fine("Storage directory cannot be used for " + this.getPathString());
                        } else {
                            LOGGER.fine("Storage directory exists but is not writable for " + this.getPathString());
                        }
                    } else if (file.mkdirs()) {
                        if (NameSpace.canOpen(path)) {
                            this.baseURL = storageLocation;
                            this.location = path;
                            return;
                        }
                        LOGGER.fine("Storage directory cannot be used for " + this.getPathString());
                    } else {
                        LOGGER.fine("Unable to create storage directory for " + this.getPathString());
                    }
                } else {
                    LOGGER.fine("Storage directory is not a file URL for " + this.getPathString());
                }
            }
            this.baseURL = null;
            this.location = null;
        }

        @Override
        public synchronized void close() {
            if (this.openCount <= 0) {
                throw new IllegalStateException("Mismatched open/close on storage for " + this.getPathString());
            }
            if (--this.openCount == 0) {
                this.closeImpl();
            }
        }

        protected synchronized void closeImpl() {
            LOGGER.fine("Closing storage for " + this.getPathString());
            NameSpace.closeStorage(this.location);
            this.notifyAll();
            this.location = null;
        }

        @Override
        public synchronized String getRelativePath(URL url) {
            if (url == null) {
                throw new NullArgumentException("null url");
            }
            this.checkOpen();
            if (this.baseURL == null) {
                return url.toString();
            }
            if (JarUtil.isJarURL((URL)url)) {
                URL jarFile = JarUtil.getJarFileURL((URL)url);
                String entry = JarUtil.getJarEntry((URL)url);
                return Storages.JAR_RELATIVE_PATH_PREFIX + this.getRelativePath(jarFile) + Storages.JAR_RELATIVE_PATH_SEPARATOR + entry;
            }
            String relativePath = URLFileSystem.toRelativeSpec((URL)url, (URL)this.baseURL, (boolean)false);
            if (relativePath.startsWith("/")) {
                return url.toExternalForm();
            }
            return relativePath;
        }

        @Override
        public synchronized URL getURL(String relativePath) {
            if (relativePath == null) {
                throw new NullArgumentException("null relative path");
            }
            this.checkOpen();
            if (this.baseURL == null) {
                return URLFactory.newURL((String)relativePath);
            }
            if (relativePath.startsWith(Storages.JAR_RELATIVE_PATH_PREFIX)) {
                int separator = relativePath.indexOf(Storages.JAR_RELATIVE_PATH_SEPARATOR);
                String jarPath = relativePath.substring(Storages.JAR_RELATIVE_PATH_PREFIX.length(), separator);
                String entry = relativePath.substring(separator + Storages.JAR_RELATIVE_PATH_SEPARATOR.length());
                return URLFactory.newJarURL((URL)this.getURL(jarPath), (String)entry);
            }
            int endOfProtocol = relativePath.indexOf(":");
            int firstSlash = relativePath.indexOf("/");
            if (endOfProtocol >= 0 && endOfProtocol < firstSlash) {
                try {
                    return new URL(relativePath);
                }
                catch (MalformedURLException e) {
                    return URLFactory.newURL((URL)this.baseURL, (String)relativePath);
                }
            }
            return URLFactory.newURL((URL)this.baseURL, (String)relativePath);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public NameSpace getNameSpace(String name, SecondaryKeyProvider secondaryKeyProvider) {
            if (name == null) {
                throw new NullArgumentException("null name");
            }
            if (secondaryKeyProvider == null) {
                throw new NullArgumentException("null secondary key provider");
            }
            String localLocation = null;
            AbstractStorage abstractStorage = this;
            synchronized (abstractStorage) {
                this.checkOpen();
                localLocation = this.location;
            }
            return localLocation == null ? NameSpace.getNameSpace(this.getSharedNameSpaceName(name), secondaryKeyProvider) : NameSpace.getLocalNameSpace(localLocation, this.getLocalNameSpaceName(name), secondaryKeyProvider);
        }

        @Override
        public NameSpace getNameSpace(String name, int type) {
            if (name == null) {
                throw new NullArgumentException("null name");
            }
            if (type != 1 && type != 0) {
                throw new IllegalArgumentException("invalid type");
            }
            return this.getNameSpaceImpl(name, type);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected NameSpace getNameSpaceImpl(String name, int type) {
            String localLocation = null;
            AbstractStorage abstractStorage = this;
            synchronized (abstractStorage) {
                this.checkOpen();
                localLocation = this.location;
            }
            return localLocation == null ? NameSpace.getNameSpace(this.getSharedNameSpaceName(name), type) : NameSpace.getLocalNameSpace(localLocation, this.getLocalNameSpaceName(name), type);
        }

        @Override
        public void deleteNameSpace(String name) {
            if (name == null) {
                throw new NullArgumentException("null name");
            }
            this.deleteNameSpaceImpl(name);
        }

        @Override
        public void deleteNameSpace(String name, Collection<String> secondaryKeys) {
            if (name == null) {
                throw new NullArgumentException("null name");
            }
            if (secondaryKeys == null) {
                throw new NullArgumentException("null secondary keys");
            }
            this.deleteNameSpaceImpl(name, secondaryKeys);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void deleteNameSpaceImpl(String name) {
            String localLocation = null;
            AbstractStorage abstractStorage = this;
            synchronized (abstractStorage) {
                this.checkOpen();
                localLocation = this.location;
            }
            if (localLocation == null) {
                NameSpace.deleteNameSpace(this.getSharedNameSpaceName(name));
            } else {
                NameSpace.deleteLocalNameSpace(localLocation, this.getLocalNameSpaceName(name));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void deleteNameSpaceImpl(String name, Collection<String> secondaryKeys) {
            String localLocation = null;
            AbstractStorage abstractStorage = this;
            synchronized (abstractStorage) {
                this.checkOpen();
                localLocation = this.location;
            }
            if (localLocation == null) {
                NameSpace.deleteNameSpace(this.getSharedNameSpaceName(name), secondaryKeys);
            } else {
                NameSpace.deleteLocalNameSpace(localLocation, this.getLocalNameSpaceName(name), secondaryKeys);
            }
        }

        private synchronized void checkOpen() {
            if (this.openCount == 0) {
                throw new IllegalStateException("Storage not open for " + this.getPathString());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void runWhileOpen(Runnable r) {
            if (r == null) {
                throw new NullArgumentException("null Runnable");
            }
            this.open();
            try {
                r.run();
            }
            finally {
                this.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T runWhileOpen(Callable<T> c) throws Exception {
            if (c == null) {
                throw new NullArgumentException("null Callable");
            }
            this.open();
            try {
                T t = c.call();
                return t;
            }
            finally {
                this.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void runWhileClosed(Runnable r) {
            if (r == null) {
                throw new NullArgumentException("null Runnable");
            }
            this.lockClosed();
            try {
                r.run();
            }
            finally {
                this.allowOpen();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T runWhileClosed(Callable<T> c) throws Exception {
            if (c == null) {
                throw new NullArgumentException("null Callable");
            }
            this.lockClosed();
            try {
                T t = c.call();
                return t;
            }
            finally {
                this.allowOpen();
            }
        }

        @Override
        public synchronized void lockClosed() {
            if (this.lockThreads.isEmpty()) {
                LOGGER.finer("Locking storage for " + this.getPathString());
            }
            this.lockThreads.add(Thread.currentThread());
            LOCKED_STORAGES.add(this);
            if (this.pinCount > 0) {
                this.close();
            }
            while (this.openCount > 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        @Override
        public synchronized void allowOpen() {
            if (!this.lockThreads.remove(Thread.currentThread())) {
                throw new IllegalStateException("Unmatched call to allowOpen for " + this.getPathString());
            }
            if (this.lockThreads.isEmpty()) {
                LOGGER.finer("Unlocking storage for " + this.getPathString());
                LOCKED_STORAGES.remove(this);
                if (this.pinCount > 0) {
                    this.open();
                }
                this.notifyAll();
            }
        }

        public String toString() {
            return this.location;
        }

        @Override
        public synchronized void pin() {
            if (this.pinCount++ == 0 && this.lockThreads.isEmpty()) {
                this.open();
            }
        }

        @Override
        public synchronized void unpin() {
            if (--this.pinCount == 0 && this.lockThreads.isEmpty()) {
                this.close();
            }
        }

        @Override
        public synchronized boolean isPinned() {
            return this.pinCount > 0;
        }
    }
}

