/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.persistence;

import com.sleepycat.je.CheckpointConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DatabaseNotFoundException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.RunRecoveryException;
import com.sleepycat.je.SecondaryConfig;
import com.sleepycat.je.SecondaryDatabase;
import com.sleepycat.je.SecondaryMultiKeyCreator;
import com.sleepycat.je.log.DbChecksumException;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import net.jcip.annotations.GuardedBy;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.persistence.SecondaryKeyProvider;
import oracle.ideimpl.persistence.BerkeleyDBNameSpace;
import oracle.ideimpl.persistence.BerkeleyDBOperation;
import oracle.ideimpl.persistence.PersistenceLogger;
import oracle.ideimpl.persistence.SecondaryKeyCreatorAdapter;
import oracle.javatools.annotations.NotNull;
import oracle.javatools.annotations.Nullable;

final class BerkeleyDBEnvironment {
    static final boolean USE_DEFERRED_WRITE = false;
    static final Iterator<String> EMPTY_ITERATOR = new Iterator<String>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public String next() {
            throw new NoSuchElementException("This iterator does not support element retrieval.");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("This iterator does not support removal of elements.");
        }
    };
    private static final boolean BATCH_MODE = Boolean.getBoolean("ide.persistence.batch.mode");
    @NotNull
    private static final EnvironmentConfig ENVIRONMENT_CONFIG = new EnvironmentConfig();
    @NotNull
    private static final DatabaseConfig DATABASE_CONFIG = new DatabaseConfig();
    private static final int MAX_RETRIES = 5;
    @NotNull
    private final String location;
    @GuardedBy(value="this")
    @Nullable
    private Environment environment;
    @GuardedBy(value="this")
    @NotNull
    private final Map<String, BerkeleyDBNameSpace> namespaces = new HashMap<String, BerkeleyDBNameSpace>();

    @NotNull
    private static final void initConfig() {
        ENVIRONMENT_CONFIG.setAllowCreate(true);
        boolean useDefaultSize = true;
        try {
            String property = System.getProperty("ide.persistence.cache.percent");
            if (property != null) {
                int percent = Integer.parseInt(property);
                if (percent >= 0) {
                    ENVIRONMENT_CONFIG.setCachePercent(percent);
                    useDefaultSize = false;
                    PersistenceLogger.getLogger().config("Persistence cache size is " + percent + "% of total memory");
                }
            } else {
                long size;
                property = System.getProperty("ide.persistence.cache.size");
                if (property != null && (size = Long.parseLong(property)) >= 98304L) {
                    ENVIRONMENT_CONFIG.setCacheSize(size);
                    useDefaultSize = false;
                    PersistenceLogger.getLogger().config("Persistence cache size is " + size + " bytes");
                }
            }
        }
        catch (NumberFormatException e) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (useDefaultSize) {
            ENVIRONMENT_CONFIG.setCachePercent(5);
            PersistenceLogger.getLogger().config("Using default persistence cache size (5% of heap)");
        }
        ENVIRONMENT_CONFIG.setConfigParam("je.env.runCleaner", "false");
        ENVIRONMENT_CONFIG.setConfigParam("je.env.runCheckpointer", "false");
        ENVIRONMENT_CONFIG.setConfigParam("je.env.runINCompressor", "false");
        ENVIRONMENT_CONFIG.setConfigParam("je.log.fileMax", "2000000");
        ENVIRONMENT_CONFIG.setConfigParam("je.cleaner.minUtilization", "65");
        ENVIRONMENT_CONFIG.setConfigParam("je.cleaner.minFileUtilization", "10");
        ENVIRONMENT_CONFIG.setSharedCache(true);
        ENVIRONMENT_CONFIG.setLockTimeout(0L);
        ENVIRONMENT_CONFIG.setConfigParam("java.util.logging.level", Level.OFF.toString());
        ENVIRONMENT_CONFIG.setConfigParam("java.util.logging.DbLogHandler.on", Boolean.FALSE.toString());
        DATABASE_CONFIG.setDeferredWrite(false);
        DATABASE_CONFIG.setAllowCreate(true);
    }

    public BerkeleyDBEnvironment(String location) {
        this.location = location;
    }

    @NotNull
    public String getLocation() {
        return this.location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        if (this.environment != null) {
            try {
                for (BerkeleyDBNameSpace namespace : this.namespaces.values()) {
                    namespace.closeDatabase();
                }
                if (BATCH_MODE) {
                    this.cleanEnvironment(true);
                }
            }
            catch (DatabaseException e) {
            }
            finally {
                try {
                    this.environment.close();
                }
                catch (DatabaseException e) {}
                this.namespaces.clear();
                this.environment = null;
            }
        }
    }

    @Nullable
    public synchronized BerkeleyDBNameSpace getNameSpace(String name, SecondaryKeyProvider provider) {
        BerkeleyDBNameSpace namespace = this.namespaces.get(name);
        if (namespace == null) {
            try {
                this.openEnvironment();
            }
            catch (DatabaseException e) {
                PersistenceLogger.getLogger().log(Level.SEVERE, "Unable to open environment " + this, e);
            }
            if (this.environment != null) {
                namespace = new BerkeleyDBNameSpace(name, this, provider);
                this.namespaces.put(name, namespace);
            }
        } else {
            SecondaryKeyProvider oldProvider = namespace.getSecondaryKeyProvider();
            if (provider == null && oldProvider != null || provider != null && oldProvider == null || provider != null && oldProvider != null && !oldProvider.equals(provider)) {
                throw new IllegalArgumentException("NameSpace already opened with a different secondary key provider");
            }
        }
        if (namespace != null) {
            ++namespace.refCount;
        }
        return namespace;
    }

    public synchronized void closeNameSpace(final BerkeleyDBNameSpace namespace) {
        if (--namespace.refCount == 0) {
            try {
                this.run(new BerkeleyDBOperation<Void>(){

                    @Override
                    public Void run() throws DatabaseException {
                        namespace.closeDatabase();
                        BerkeleyDBEnvironment.this.namespaces.remove(namespace.getName());
                        BerkeleyDBEnvironment.this.cleanUpMemory();
                        BerkeleyDBEnvironment.this.cleanEnvironment(false);
                        return null;
                    }
                });
            }
            catch (DatabaseException e) {
                PersistenceLogger.getLogger().log(Level.SEVERE, "Unable to close namespace " + namespace, e);
            }
        }
    }

    public synchronized void deleteNameSpace(final String name) {
        try {
            this.openEnvironment();
        }
        catch (DatabaseException e) {
            PersistenceLogger.getLogger().log(Level.SEVERE, "Unable to open environment " + this, e);
        }
        if (this.environment != null) {
            try {
                this.run(new BerkeleyDBOperation<Void>(){

                    @Override
                    public Void run() throws DatabaseException {
                        BerkeleyDBNameSpace namespace = (BerkeleyDBNameSpace)BerkeleyDBEnvironment.this.namespaces.get(name);
                        if (namespace != null) {
                            namespace.closeDatabase();
                        }
                        BerkeleyDBEnvironment.this.environment.removeDatabase(null, name);
                        return null;
                    }
                });
            }
            catch (DatabaseNotFoundException e) {
            }
            catch (DatabaseException e) {
                PersistenceLogger.getLogger().log(Level.SEVERE, "Unable to remove database " + name + " from " + this, e);
            }
        }
    }

    public synchronized void deleteNameSpace(final String name, final Collection<String> secondaryKeys) {
        try {
            this.openEnvironment();
        }
        catch (DatabaseException e) {
            PersistenceLogger.getLogger().log(Level.SEVERE, "Unable to open environment " + this, e);
        }
        if (this.environment != null) {
            try {
                this.run(new BerkeleyDBOperation<Void>(){

                    @Override
                    public Void run() throws DatabaseException {
                        for (String secondaryKey : secondaryKeys) {
                            try {
                                BerkeleyDBEnvironment.this.environment.removeDatabase(null, name + secondaryKey);
                            }
                            catch (DatabaseNotFoundException databaseNotFoundException) {}
                        }
                        try {
                            BerkeleyDBEnvironment.this.environment.removeDatabase(null, name);
                        }
                        catch (DatabaseNotFoundException databaseNotFoundException) {
                            // empty catch block
                        }
                        return null;
                    }
                });
            }
            catch (DatabaseException e) {
                PersistenceLogger.getLogger().log(Level.SEVERE, "Unable to remove database " + name + " from " + this, e);
            }
        }
    }

    @NotNull
    public synchronized Iterator<String> getNameSpaceIterator(final String prefix, final boolean ignorecase, final boolean reverse) {
        try {
            this.openEnvironment();
        }
        catch (DatabaseException e) {
            PersistenceLogger.getLogger().log(Level.SEVERE, "Unable to open environment " + this, e);
        }
        if (this.environment != null) {
            try {
                return this.run(new BerkeleyDBOperation<Iterator<String>>(){

                    @Override
                    public Iterator<String> run() throws DatabaseException {
                        List dbNamesUnchecked = BerkeleyDBEnvironment.this.environment.getDatabaseNames();
                        ArrayList dbNames = new ArrayList(dbNamesUnchecked);
                        if (reverse) {
                            Collections.reverse(dbNames);
                        }
                        if (prefix.length() == 0) {
                            return dbNames.iterator();
                        }
                        ArrayList<String> names = new ArrayList<String>();
                        if (ignorecase) {
                            int prefixLength = prefix.length();
                            for (String name : dbNames) {
                                if (name.length() < prefixLength || !name.substring(0, prefixLength).equalsIgnoreCase(prefix)) continue;
                                names.add(name);
                            }
                        } else {
                            for (String name : dbNames) {
                                if (!name.startsWith(prefix)) continue;
                                names.add(name);
                            }
                        }
                        names.trimToSize();
                        return names.iterator();
                    }
                });
            }
            catch (DatabaseException e) {
                PersistenceLogger.getLogger().log(Level.SEVERE, "Unable to iterate databases in " + this, e);
            }
        }
        return EMPTY_ITERATOR;
    }

    public synchronized String toString() {
        if (this.environment != null) {
            try {
                return this.environment.getHome().toString();
            }
            catch (DatabaseException databaseException) {
                // empty catch block
            }
        }
        return this.location;
    }

    synchronized <T> T run(BerkeleyDBOperation<T> operation) throws DatabaseException {
        boolean wasInterrupted = Thread.interrupted();
        try {
            int numRetries = 0;
            Throwable lastException = null;
            while (numRetries <= 5) {
                T t;
                try {
                    t = operation.run();
                }
                catch (IllegalStateException e) {
                    try {
                        Throwable cause = e.getCause();
                        if (cause instanceof DatabaseException) {
                            throw (DatabaseException)cause;
                        }
                        throw e;
                    }
                    catch (AssertionError e2) {
                        lastException = new DatabaseException((Throwable)((Object)e2));
                        if (numRetries++ >= 5) continue;
                        this.recover(true);
                        continue;
                    }
                    catch (DbChecksumException e3) {
                        lastException = e3;
                        if (numRetries++ >= 5) continue;
                        this.recover(true);
                        continue;
                    }
                    catch (RunRecoveryException e4) {
                        wasInterrupted = Thread.interrupted() || wasInterrupted;
                        this.recover(false);
                        continue;
                    }
                    catch (DatabaseException e5) {
                        lastException = e5;
                        if (numRetries++ >= 5) continue;
                        this.recover(true);
                        continue;
                    }
                }
                return t;
            }
            throw lastException;
        }
        finally {
            if (wasInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void recover(boolean delete) throws DatabaseException {
        PersistenceLogger.getLogger().fine("Recovering " + this.environment);
        File home = null;
        if (this.environment != null) {
            try {
                try {
                    home = this.environment.getHome();
                }
                catch (DatabaseException e) {
                    // empty catch block
                }
                for (BerkeleyDBNameSpace namespace : this.namespaces.values()) {
                    try {
                        namespace.closeDatabase();
                    }
                    catch (DatabaseException e) {}
                }
            }
            finally {
                try {
                    this.environment.close();
                }
                catch (DatabaseException e) {}
                for (BerkeleyDBNameSpace namespace : this.namespaces.values()) {
                    namespace.clearDatabase();
                }
                this.environment = null;
            }
        }
        if (delete && home != null) {
            this.deleteEnvironment(home);
        }
        this.openEnvironment();
    }

    /*
     * Exception decompiling
     */
    synchronized void openEnvironment() throws DatabaseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private synchronized boolean deleteEnvironment(File home) {
        PersistenceLogger.getLogger().fine("Deleting " + this);
        File lockFile = new File(home, "je.lck");
        if (lockFile.isFile() && !lockFile.delete()) {
            PersistenceLogger.getLogger().fine("Unable to delete " + lockFile);
            return false;
        }
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jdb");
            }
        };
        boolean success = true;
        File[] files = home.listFiles(filter);
        if (files != null) {
            for (File file : files) {
                if (!file.isFile() || file.delete()) continue;
                PersistenceLogger.getLogger().fine("Unable to delete " + file);
                success = false;
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void cleanEnvironment(boolean full) throws DatabaseException {
        if (this.environment != null) {
            PerformanceLogger.get().startTiming("BerkeleyDBEnvironment.cleanEnvironment");
            long cleanLogTime = 0L;
            long checkpointTime = 0L;
            try {
                if (full) {
                    this.environment.compress();
                }
                long cleanLogStart = System.nanoTime();
                boolean cleaned = false;
                while (this.environment.cleanLog() > 0) {
                    cleaned = true;
                    if (full) continue;
                }
                cleanLogTime = (System.nanoTime() - cleanLogStart) / 1000000L;
                if (cleaned) {
                    long checkpointStart = System.nanoTime();
                    CheckpointConfig config = new CheckpointConfig();
                    config.setForce(full);
                    config.setMinimizeRecoveryTime(full);
                    this.environment.checkpoint(config);
                    checkpointTime = (System.nanoTime() - checkpointStart) / 1000000L;
                }
            }
            finally {
                PerformanceLogger.get().stopTiming("BerkeleyDBEnvironment.cleanEnvironment", "Cleaned Berkeley DB environment for " + this + " (" + cleanLogTime + "ms cleanLog, " + checkpointTime + "ms checkpoint)", 200);
            }
        }
    }

    synchronized void cleanUpMemory() throws DatabaseException {
        if (this.environment != null) {
            this.environment.compress();
            this.environment.evictMemory();
        }
    }

    @NotNull
    synchronized Database openDatabase(final String name) throws DatabaseException {
        if (this.environment != null) {
            return this.run(new BerkeleyDBOperation<Database>(){

                @Override
                public Database run() throws DatabaseException {
                    return BerkeleyDBEnvironment.this.environment.openDatabase(null, name, DATABASE_CONFIG);
                }
            });
        }
        throw new DatabaseException("Environment " + this + " not open");
    }

    @NotNull
    synchronized SecondaryDatabase openSecondaryDatabase(final String primaryName, final String secondaryName, final Database primaryDatabase, final SecondaryKeyProvider provider) throws DatabaseException {
        if (this.environment != null) {
            return this.run(new BerkeleyDBOperation<SecondaryDatabase>(){

                @Override
                public SecondaryDatabase run() throws DatabaseException {
                    SecondaryConfig config = new SecondaryConfig();
                    config.setAllowCreate(true);
                    config.setSortedDuplicates(true);
                    config.setMultiKeyCreator((SecondaryMultiKeyCreator)new SecondaryKeyCreatorAdapter(provider, secondaryName));
                    return BerkeleyDBEnvironment.this.environment.openSecondaryDatabase(null, primaryName + secondaryName, primaryDatabase, config);
                }
            });
        }
        throw new DatabaseException("Environment " + this + " not open");
    }

    synchronized void flush() throws DatabaseException {
        if (this.environment != null) {
            this.run(new BerkeleyDBOperation<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void run() throws DatabaseException {
                    PerformanceLogger.get().startTiming("BerkeleyDBEnvironment.flush");
                    try {
                        BerkeleyDBEnvironment.this.environment.sync();
                        Void void_ = null;
                        return void_;
                    }
                    finally {
                        PerformanceLogger.get().stopTiming("BerkeleyDBEnvironment.flush", "Flushed Berkeley DB environment " + this, 200);
                    }
                }
            });
        }
    }

    static {
        BerkeleyDBEnvironment.initConfig();
    }
}

