/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.persistence;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.SecondaryCursor;
import com.sleepycat.je.SecondaryDatabase;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TimerTask;
import java.util.logging.Level;
import net.jcip.annotations.GuardedBy;
import oracle.ide.persistence.NameSpace;
import oracle.ide.persistence.NameSpaceVisitor;
import oracle.ide.persistence.SecondaryKeyProvider;
import oracle.ideimpl.persistence.BerkeleyDBEnvironment;
import oracle.ideimpl.persistence.BerkeleyDBOperation;
import oracle.ideimpl.persistence.PersistenceLogger;
import oracle.javatools.annotations.NotNull;
import oracle.javatools.annotations.Nullable;
import oracle.javatools.util.NamedTimer;

final class BerkeleyDBNameSpace
extends NameSpace {
    @GuardedBy(value="BerkeleyDBNameSpace.class")
    private static NamedTimer flushTimer;
    @NotNull
    private final BerkeleyDBEnvironment environment;
    @GuardedBy(value="environment")
    @Nullable
    private Database database;
    @NotNull
    @GuardedBy(value="environment")
    private Map<String, SecondaryDatabase> secondaryDatabases = new HashMap<String, SecondaryDatabase>();
    @Nullable
    private final SecondaryKeyProvider secondaryKeyProvider;
    @GuardedBy(value="environment")
    int refCount;
    @GuardedBy(value="this")
    private long flushDelay;
    @GuardedBy(value="this")
    private TimerTask flushTask;
    @GuardedBy(value="this")
    private int purgeCounter;

    private static DatabaseEntry getDatabaseKey(String key) {
        try {
            return new DatabaseEntry(key.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    private static String getString(DatabaseEntry key) {
        try {
            byte[] data = key.getData();
            return data == null ? null : new String(key.getData(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    private static synchronized NamedTimer getAutoFlushTimer() {
        if (flushTimer == null) {
            flushTimer = new NamedTimer("Persistence Auto Flusher", 5, true);
        }
        return flushTimer;
    }

    public BerkeleyDBNameSpace(String name, BerkeleyDBEnvironment environment, SecondaryKeyProvider secondaryKeyProvider) {
        super(name);
        this.environment = environment;
        this.secondaryKeyProvider = secondaryKeyProvider;
    }

    public SecondaryKeyProvider getSecondaryKeyProvider() {
        return this.secondaryKeyProvider;
    }

    @Override
    public void close() {
        this.environment.closeNameSpace(this);
    }

    @Override
    public boolean checkRecord(String key) {
        return this.getRecord(key) != null;
    }

    @Override
    public void delRecord(final String key) {
        try {
            this.run(new BerkeleyDBOperation<Void>(){

                @Override
                public Void run() throws DatabaseException {
                    BerkeleyDBNameSpace.this.database.delete(null, BerkeleyDBNameSpace.getDatabaseKey(key));
                    return null;
                }
            });
            this.restartAutoFlushTimer();
        }
        catch (DatabaseException e) {
            PersistenceLogger.getLogger().log(Level.SEVERE, "Unable to delete record " + key + " from database " + this, e);
        }
    }

    @Override
    public void flush() {
        try {
            this.run(new BerkeleyDBOperation<Void>(){

                @Override
                public Void run() throws DatabaseException {
                    BerkeleyDBNameSpace.this.environment.flush();
                    BerkeleyDBNameSpace.this.environment.cleanUpMemory();
                    BerkeleyDBNameSpace.this.environment.cleanEnvironment(false);
                    return null;
                }
            });
        }
        catch (DatabaseException e) {
            PersistenceLogger.getLogger().log(Level.SEVERE, "Unable to flush database " + this, e);
        }
    }

    @Override
    public Iterator<String> getKeyIterator(String prefix, boolean ignorecase) {
        return this.getKeyIteratorImpl(prefix, ignorecase, false);
    }

    @Override
    public Iterator<String> getReverseKeyIterator(String prefix, boolean ignorecase) {
        return this.getKeyIteratorImpl(prefix, ignorecase, true);
    }

    @Override
    public byte[] getRecord(final String key) {
        try {
            return this.run(new BerkeleyDBOperation<byte[]>(){

                @Override
                public byte[] run() throws DatabaseException {
                    DatabaseEntry dbData = new DatabaseEntry();
                    BerkeleyDBNameSpace.this.database.get(null, BerkeleyDBNameSpace.getDatabaseKey(key), dbData, LockMode.DEFAULT);
                    return dbData.getData();
                }
            });
        }
        catch (DatabaseException e) {
            PersistenceLogger.getLogger().log(Level.SEVERE, "Unable to get record " + key + " from database " + this, e);
            return null;
        }
    }

    @Override
    public byte[] getRecord(final String secondaryKeyName, final String secondaryKey) {
        try {
            return this.run(new BerkeleyDBOperation<byte[]>(){

                @Override
                public byte[] run() throws DatabaseException {
                    DatabaseEntry dbData = new DatabaseEntry();
                    SecondaryDatabase secondary = (SecondaryDatabase)BerkeleyDBNameSpace.this.secondaryDatabases.get(secondaryKeyName);
                    secondary.get(null, BerkeleyDBNameSpace.getDatabaseKey(secondaryKey), dbData, LockMode.DEFAULT);
                    return dbData.getData();
                }
            });
        }
        catch (DatabaseException e) {
            PersistenceLogger.getLogger().log(Level.SEVERE, "Unable to get record for secondary key " + secondaryKeyName + "=" + secondaryKey + " from database " + this, e);
            return null;
        }
    }

    @Override
    public Collection<byte[]> getRecords(final String secondaryKeyName, final String secondaryKey) {
        try {
            return this.run(new BerkeleyDBOperation<Collection<byte[]>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Collection<byte[]> run() throws DatabaseException {
                    ArrayList<byte[]> records = new ArrayList<byte[]>();
                    DatabaseEntry primaryKey = new DatabaseEntry();
                    DatabaseEntry dbData = new DatabaseEntry();
                    SecondaryDatabase secondary = (SecondaryDatabase)BerkeleyDBNameSpace.this.secondaryDatabases.get(secondaryKeyName);
                    SecondaryCursor cursor = secondary.openSecondaryCursor(null, null);
                    cursor.setCacheMode(CacheMode.UNCHANGED);
                    try {
                        OperationStatus rc = cursor.getSearchKey(BerkeleyDBNameSpace.getDatabaseKey(secondaryKey), primaryKey, dbData, LockMode.DEFAULT);
                        while (rc == OperationStatus.SUCCESS) {
                            records.add(dbData.getData());
                            rc = cursor.getNextDup(BerkeleyDBNameSpace.getDatabaseKey(secondaryKey), primaryKey, dbData, LockMode.DEFAULT);
                        }
                        ArrayList<byte[]> arrayList = records;
                        return arrayList;
                    }
                    finally {
                        cursor.close();
                    }
                }
            });
        }
        catch (DatabaseException e) {
            PersistenceLogger.getLogger().log(Level.SEVERE, "Unable to get primary key for secondary key " + secondaryKeyName + "=" + secondaryKey + " from database " + this, e);
            return Collections.emptySet();
        }
    }

    @Override
    public String getPrimaryKey(final String secondaryKeyName, final String secondaryKey) {
        try {
            return this.run(new BerkeleyDBOperation<String>(){

                @Override
                public String run() throws DatabaseException {
                    DatabaseEntry primaryKey = new DatabaseEntry();
                    DatabaseEntry dbData = new DatabaseEntry();
                    SecondaryDatabase secondary = (SecondaryDatabase)BerkeleyDBNameSpace.this.secondaryDatabases.get(secondaryKeyName);
                    secondary.get(null, BerkeleyDBNameSpace.getDatabaseKey(secondaryKey), primaryKey, dbData, LockMode.DEFAULT);
                    return BerkeleyDBNameSpace.getString(primaryKey);
                }
            });
        }
        catch (DatabaseException e) {
            PersistenceLogger.getLogger().log(Level.SEVERE, "Unable to get primary key for secondary key " + secondaryKeyName + "=" + secondaryKey + " from database " + this, e);
            return null;
        }
    }

    @Override
    public Collection<String> getPrimaryKeys(final String secondaryKeyName, final String secondaryKey) {
        try {
            return this.run(new BerkeleyDBOperation<Collection<String>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Collection<String> run() throws DatabaseException {
                    ArrayList<String> keys = new ArrayList<String>();
                    DatabaseEntry primaryKey = new DatabaseEntry();
                    DatabaseEntry dbData = new DatabaseEntry();
                    SecondaryDatabase secondary = (SecondaryDatabase)BerkeleyDBNameSpace.this.secondaryDatabases.get(secondaryKeyName);
                    SecondaryCursor cursor = secondary.openSecondaryCursor(null, null);
                    try {
                        OperationStatus rc = cursor.getSearchKey(BerkeleyDBNameSpace.getDatabaseKey(secondaryKey), primaryKey, dbData, LockMode.DEFAULT);
                        while (rc == OperationStatus.SUCCESS) {
                            String str = BerkeleyDBNameSpace.getString(primaryKey);
                            if (str != null) {
                                keys.add(str);
                            }
                            rc = cursor.getNextDup(BerkeleyDBNameSpace.getDatabaseKey(secondaryKey), primaryKey, dbData, LockMode.DEFAULT);
                        }
                    }
                    finally {
                        cursor.close();
                    }
                    return keys;
                }
            });
        }
        catch (DatabaseException e) {
            PersistenceLogger.getLogger().log(Level.SEVERE, "Unable to get primary key for secondary key " + secondaryKeyName + "=" + secondaryKey + " from database " + this, e);
            return Collections.emptySet();
        }
    }

    @Override
    public InputStream getRecordStream(String key) {
        return new ByteArrayInputStream(this.getRecord(key));
    }

    @Override
    public synchronized void putRecord(String key, byte[] data) {
        DatabaseEntry dbData = data == null ? new DatabaseEntry(new byte[0]) : new DatabaseEntry(data);
        this.putRecordImpl(key, dbData);
    }

    @Override
    public synchronized void putRecord(String key, byte[] data, int offset, int size) {
        DatabaseEntry dbData = data == null ? new DatabaseEntry(new byte[0]) : new DatabaseEntry(data, offset, size);
        this.putRecordImpl(key, dbData);
    }

    private void putRecordImpl(final String key, final DatabaseEntry entry) {
        try {
            this.run(new BerkeleyDBOperation<Void>(){

                @Override
                public Void run() throws DatabaseException {
                    BerkeleyDBNameSpace.this.database.put(null, BerkeleyDBNameSpace.getDatabaseKey(key), entry);
                    return null;
                }
            });
            this.restartAutoFlushTimer();
        }
        catch (DatabaseException e) {
            PersistenceLogger.getLogger().log(Level.SEVERE, "Unable to put record " + key + " in database " + this, e);
        }
    }

    @Override
    public OutputStream putRecordStream(final String key) {
        return new ByteArrayOutputStream(){

            @Override
            public void close() throws IOException {
                BerkeleyDBNameSpace.this.putRecord(key, this.toByteArray());
            }
        };
    }

    @Override
    public void visitRecords(final NameSpaceVisitor visitor) throws Exception {
        try {
            Exception e = this.run(new BerkeleyDBOperation<Exception>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Exception run() throws DatabaseException {
                    Cursor cursor = BerkeleyDBNameSpace.this.database.openCursor(null, null);
                    cursor.setCacheMode(CacheMode.UNCHANGED);
                    try {
                        DatabaseEntry key = new DatabaseEntry();
                        DatabaseEntry value = new DatabaseEntry();
                        while (cursor.getNext(key, value, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                            String keyStr = new String(key.getData(), "UTF-8");
                            if (visitor.visit(keyStr, value.getData()) == NameSpaceVisitor.Status.CONTINUE) continue;
                            break;
                        }
                    }
                    catch (UnsupportedEncodingException e) {
                        PersistenceLogger.getLogger().log(Level.SEVERE, "Exception while visiting records in database " + this, e);
                    }
                    catch (Exception e) {
                        Exception exception = e;
                        return exception;
                    }
                    finally {
                        cursor.close();
                    }
                    return null;
                }
            });
            if (e != null) {
                throw e;
            }
        }
        catch (DatabaseException e) {
            PersistenceLogger.getLogger().log(Level.SEVERE, "Exception while visiting records in database " + this, e);
        }
    }

    @Override
    public synchronized void setAutoFlush(long delay) {
        this.flushDelay = delay;
    }

    @Override
    public synchronized void cancelAutoFlush() {
        if (this.flushTask != null) {
            this.flushTask.cancel();
            this.flushTask = null;
            BerkeleyDBNameSpace.getAutoFlushTimer().purge();
        }
        this.flushDelay = 0L;
    }

    private synchronized void restartAutoFlushTimer() {
        if (this.flushDelay > 0L) {
            if (this.flushTask != null) {
                this.flushTask.cancel();
                this.flushTask = null;
                if (this.purgeCounter++ % 500 == 0) {
                    BerkeleyDBNameSpace.getAutoFlushTimer().purge();
                }
            }
            this.flushTask = new TimerTask(){

                @Override
                public void run() {
                    BerkeleyDBNameSpace.this.flush();
                }
            };
            BerkeleyDBNameSpace.getAutoFlushTimer().schedule(this.flushTask, this.flushDelay);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this._name);
        builder.append(" in ");
        builder.append(this.environment);
        return builder.toString();
    }

    @NotNull
    private Iterator<String> getKeyIteratorImpl(final String prefix, final boolean ignorecase, final boolean reverse) {
        try {
            return this.run(new BerkeleyDBOperation<Iterator<String>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Iterator<String> run() throws DatabaseException {
                    Iterator<String> iterator;
                    ArrayList<String> keys = new ArrayList<String>();
                    Cursor cursor = BerkeleyDBNameSpace.this.database.openCursor(null, null);
                    cursor.setCacheMode(CacheMode.UNCHANGED);
                    try {
                        DatabaseEntry key = BerkeleyDBNameSpace.getDatabaseKey(prefix);
                        DatabaseEntry data = new DatabaseEntry();
                        while (cursor.getNext(key, data, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                            keys.add(new String(key.getData(), "UTF-8"));
                        }
                        if (reverse) {
                            Collections.reverse(keys);
                        }
                        if (prefix.length() > 0) {
                            Iterator iterator2 = keys.iterator();
                            if (ignorecase) {
                                int prefixLength = prefix.length();
                                while (iterator2.hasNext()) {
                                    String name = (String)iterator2.next();
                                    if (name.length() >= prefixLength && name.substring(0, prefixLength).equalsIgnoreCase(prefix)) continue;
                                    iterator2.remove();
                                }
                            } else {
                                while (iterator2.hasNext()) {
                                    String name = (String)iterator2.next();
                                    if (name.startsWith(prefix)) continue;
                                    iterator2.remove();
                                }
                            }
                        }
                        keys.trimToSize();
                        iterator = keys.iterator();
                    }
                    catch (Throwable throwable) {
                        try {
                            cursor.close();
                            BerkeleyDBNameSpace.this.environment.cleanUpMemory();
                            throw throwable;
                        }
                        catch (UnsupportedEncodingException e) {
                            PersistenceLogger.getLogger().log(Level.SEVERE, "Unable to iterate database " + this, e);
                            return BerkeleyDBEnvironment.EMPTY_ITERATOR;
                        }
                    }
                    cursor.close();
                    BerkeleyDBNameSpace.this.environment.cleanUpMemory();
                    return iterator;
                }
            });
        }
        catch (DatabaseException e) {
            PersistenceLogger.getLogger().log(Level.SEVERE, "Unable to iterate database " + this, e);
            return BerkeleyDBEnvironment.EMPTY_ITERATOR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openDatabase() throws DatabaseException {
        BerkeleyDBEnvironment berkeleyDBEnvironment = this.environment;
        synchronized (berkeleyDBEnvironment) {
            if (this.database == null) {
                this.database = this.environment.openDatabase(this._name);
                if (this.secondaryKeyProvider != null) {
                    for (String name : this.secondaryKeyProvider.getSecondaryKeyNames()) {
                        SecondaryDatabase secondary = this.environment.openSecondaryDatabase(this._name, name, this.database, this.secondaryKeyProvider);
                        this.secondaryDatabases.put(name, secondary);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeDatabase() throws DatabaseException {
        BerkeleyDBEnvironment berkeleyDBEnvironment = this.environment;
        synchronized (berkeleyDBEnvironment) {
            if (this.database != null) {
                try {
                    for (SecondaryDatabase secondary : this.secondaryDatabases.values()) {
                        secondary.close();
                    }
                    this.database.close();
                }
                finally {
                    this.secondaryDatabases.clear();
                    this.database = null;
                }
            }
        }
    }

    void clearDatabase() {
        this.secondaryDatabases.clear();
        this.database = null;
    }

    private <T> T run(final BerkeleyDBOperation<T> operation) throws DatabaseException {
        BerkeleyDBOperation wrapper = new BerkeleyDBOperation<T>(){

            @Override
            public T run() throws DatabaseException {
                BerkeleyDBNameSpace.this.openDatabase();
                return operation.run();
            }
        };
        return this.environment.run(wrapper);
    }
}

