/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.persistence;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.RunRecoveryException;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.jcip.annotations.GuardedBy;
import oracle.ide.persistence.NameSpace;
import oracle.ide.persistence.NameSpaceFactory;
import oracle.ide.persistence.SecondaryKeyProvider;
import oracle.ideimpl.persistence.BerkeleyDBEnvironment;
import oracle.javatools.annotations.NotNull;
import oracle.javatools.util.Maps;

public final class BerkeleyDBNameSpaceFactory
implements NameSpaceFactory {
    @GuardedBy(value="this")
    @NotNull
    private final Map<String, BerkeleyDBEnvironment> environments = new HashMap<String, BerkeleyDBEnvironment>();
    @GuardedBy(value="this")
    @NotNull
    private final Map<String, Boolean> lockingSupported = new Maps.CacheMap(100, Maps.CacheMap.Canonicity.NOT_CANONICAL);

    @Override
    public NameSpace getNameSpace(String location, String name, int type, SecondaryKeyProvider provider) {
        return this.getOrCreateEnvironment(location).getNameSpace(name, provider);
    }

    @Override
    public Iterator<String> getNameSpaceIterator(String location, String prefix, boolean ignorecase) {
        return this.getNameSpaceIteratorImpl(location, prefix, ignorecase, false);
    }

    @Override
    public Iterator<String> getReverseNameSpaceIterator(String location, String prefix, boolean ignorecase) {
        return this.getNameSpaceIteratorImpl(location, prefix, ignorecase, true);
    }

    @Override
    public void deleteNameSpace(String location, String name) {
        this.getOrCreateEnvironment(location).deleteNameSpace(name);
    }

    @Override
    public void deleteNameSpace(String location, String name, Collection<String> secondaryKeys) {
        this.getOrCreateEnvironment(location).deleteNameSpace(name, secondaryKeys);
    }

    @Override
    public boolean canOpen(String location) {
        if (!this.isLockingSupported(location)) {
            return false;
        }
        BerkeleyDBEnvironment environment = this.getOrCreateEnvironment(location);
        try {
            environment.openEnvironment();
            return true;
        }
        catch (DatabaseException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isLockingSupported(String location) {
        boolean supported;
        block18: {
            BerkeleyDBNameSpaceFactory berkeleyDBNameSpaceFactory = this;
            synchronized (berkeleyDBNameSpaceFactory) {
                Boolean b = this.lockingSupported.get(location);
                if (b != null) {
                    return b;
                }
            }
            supported = false;
            try {
                File directory = new File(location, "00000000");
                if (!directory.exists() && !directory.mkdirs()) break block18;
                RandomAccessFile lockFile = new RandomAccessFile(new File(directory, "je.lck"), "rw");
                try {
                    FileChannel channel = lockFile.getChannel();
                    try {
                        FileLock lock = channel.tryLock(0L, 1L, false);
                        if (lock != null) {
                            lock.release();
                        }
                        supported = true;
                    }
                    catch (OverlappingFileLockException e) {
                        supported = true;
                    }
                    finally {
                        channel.close();
                    }
                }
                finally {
                    lockFile.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        BerkeleyDBNameSpaceFactory berkeleyDBNameSpaceFactory = this;
        synchronized (berkeleyDBNameSpaceFactory) {
            this.lockingSupported.put(location, supported);
        }
        return supported;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeStorage(String location) {
        BerkeleyDBEnvironment environment;
        BerkeleyDBNameSpaceFactory berkeleyDBNameSpaceFactory = this;
        synchronized (berkeleyDBNameSpaceFactory) {
            environment = this.environments.remove(location);
        }
        if (environment != null) {
            environment.close();
        }
    }

    @NotNull
    private synchronized BerkeleyDBEnvironment getOrCreateEnvironment(String location) {
        BerkeleyDBEnvironment environment = this.environments.get(location);
        if (environment == null) {
            environment = new BerkeleyDBEnvironment(location);
            this.environments.put(location, environment);
        }
        return environment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void shutdown() {
        for (Map.Entry<String, BerkeleyDBEnvironment> entry : this.environments.entrySet()) {
            BerkeleyDBEnvironment environment;
            BerkeleyDBEnvironment berkeleyDBEnvironment = environment = entry.getValue();
            synchronized (berkeleyDBEnvironment) {
                try {
                    try {
                        environment.flush();
                    }
                    catch (RunRecoveryException e) {
                        environment.recover(false);
                    }
                }
                catch (DatabaseException e) {
                    // empty catch block
                }
            }
        }
    }

    @NotNull
    private Iterator<String> getNameSpaceIteratorImpl(String location, String prefix, boolean ignorecase, boolean reverse) {
        return this.getOrCreateEnvironment(location).getNameSpaceIterator(prefix, ignorecase, reverse);
    }
}

