/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.Extension;
import javax.ide.extension.ExtensionHook;
import javax.ide.extension.spi.DefaultExtension;
import javax.ide.extension.spi.JARExtensionSource;
import javax.ide.net.URIFactory;
import javax.ide.net.VirtualFileSystem;
import javax.ide.util.Version;
import oracle.ide.Ide;
import oracle.ide.IdeHook;
import oracle.ide.extension.Role;
import oracle.ide.extension.RoleManager;
import oracle.ide.extension.feature.FeatureRegistry;

public abstract class ExtensionRegistry
extends javax.ide.extension.ExtensionRegistry {
    public static final String EDT_HOT_CLASSES = "edt.hot.classes";
    public static final String EDT_HOT_MANIFEST = "edt.hot.manifest";
    public static final String EDT_HOT_DEPLOY_DIR = "edt.hot.deploydir";
    public static final String EDT_EXTENSION_ID = "edt.extension.id";
    protected static final String EXTENSIONS_DIR = "extensions";
    public static final String DEFAULT_PROCESSOR_PLUGINS_DIR = "ide/macros";
    public static final String PRODUCT_PROCESSOR_PLUGINS_DIR = "macros";
    private static final Logger _extensionLogger = Logger.getLogger(ExtensionRegistry.class.getName());
    private final Map _ideHooksByElementName = new HashMap();
    private final RoleManager _roleManager = this.createRoleManager();

    public static boolean isCustomizationContext(ElementContext context) {
        boolean override = Boolean.valueOf((String)context.getScopeData().get("unittest.customization.context"));
        if (override) {
            return true;
        }
        Extension extension = context.getExtension();
        if (extension == null) {
            return false;
        }
        return ExtensionRegistry.isRole(extension) || ExtensionRegistry.isProduct(extension);
    }

    private static boolean isRole(Extension extension) {
        String extensionId = extension.getID();
        if (extensionId == null) {
            return false;
        }
        return extensionId.startsWith("_role");
    }

    private static boolean isProduct(Extension extension) {
        String productId = System.getProperty("ide.product");
        if (productId == null) {
            return false;
        }
        return productId.equals(extension.getID());
    }

    public abstract Collection<File> getExtensionSearchPath();

    public static final ExtensionRegistry getExtensionRegistry() {
        return (ExtensionRegistry)javax.ide.extension.ExtensionRegistry.getExtensionRegistry();
    }

    public static final ExtensionRegistry getOracleRegistry() {
        return (ExtensionRegistry)javax.ide.extension.ExtensionRegistry.getExtensionRegistry();
    }

    public RoleManager getRoleManager() {
        return this._roleManager;
    }

    protected RoleManager createRoleManager() {
        return new RoleManager(){

            @Override
            public Role getActiveRole() {
                return NO_ROLE;
            }

            @Override
            public boolean canSwitchRoles() {
                return false;
            }
        };
    }

    public abstract String getNotLoadedReason(String var1);

    public final Logger getLogger() {
        return _extensionLogger;
    }

    public final Logger getManifestLogger() {
        return this.createExtensionLogger();
    }

    public final boolean isLoaded(String extensionId) {
        return this.findExtension(extensionId) != null;
    }

    public abstract boolean isUserExtension(String var1);

    public abstract boolean isNewlyInstalled(String var1);

    public abstract URL getSystemDirectory(String var1);

    public abstract URL getSystemDirectory(String var1, Version var2);

    public final URI getInstallRoot(Extension extension) {
        File installDir = this.getInstallDirectory(extension);
        if (installDir == null) {
            return null;
        }
        return URIFactory.newDirURI((File)installDir);
    }

    public final String getInstallDirectory(String extensionId) {
        return this.getInstallDirectory(extensionId, null);
    }

    public final String getInstallDirectory(String extensionId, Version version) {
        Extension extension = this.findExtension(extensionId);
        if (extension == null) {
            throw new IllegalArgumentException("Unable to find extension " + extensionId);
        }
        File installDir = this.getInstallDirectory(extension);
        if (installDir != null) {
            return installDir.getAbsolutePath();
        }
        return "";
    }

    public final File getInstallDirectory(Extension extension) {
        File extensionDir;
        File extensionJAR = this.getExtensionJAR(extension);
        if (extensionJAR == null) {
            String hotId = System.getProperty(EDT_EXTENSION_ID);
            if (!extension.getID().equals(hotId)) {
                return null;
            }
            String hotDir = System.getProperty(EDT_HOT_DEPLOY_DIR);
            extensionDir = new File(Ide.getOracleHomeDirectory() + "/" + hotDir);
        } else {
            extensionDir = extensionJAR.getParentFile();
        }
        StringBuffer directory = new StringBuffer(extensionDir.getAbsolutePath() + "/");
        directory.append(extension.getID());
        directory.append('.');
        String versionNum = extension.getVersion().toCanonicalString();
        while (true) {
            File path;
            if ((path = new File(directory.toString() + versionNum)).isDirectory()) {
                return path;
            }
            int lastDot = versionNum.lastIndexOf(46);
            if (lastDot < 1) break;
            versionNum = versionNum.substring(0, lastDot);
        }
        File noVersionDir = new File(directory.substring(0, directory.length() - 1));
        if (noVersionDir.isDirectory()) {
            return noVersionDir;
        }
        return new File(directory.toString() + versionNum);
    }

    protected String getExtensionJAR(String extensionId, Version version, boolean userDirOk) {
        return this.getExtensionJAR(extensionId, version);
    }

    public String getExtensionJAR(String extensionId, Version version) {
        File jarFile;
        Extension extension = this.findExtension(extensionId);
        if (extension != null && (jarFile = this.getExtensionJAR(extension)) != null) {
            return jarFile.getAbsolutePath();
        }
        return null;
    }

    public File getExtensionJAR(Extension extension) {
        DefaultExtension defaultExtension;
        if (extension == null) {
            throw new NullPointerException("extension is null");
        }
        if (extension instanceof DefaultExtension && (defaultExtension = (DefaultExtension)extension).getSource() instanceof JARExtensionSource) {
            URI jarUri = ((JARExtensionSource)defaultExtension.getSource()).getURI();
            return new File(VirtualFileSystem.getVirtualFileSystem().getPlatformPathName(jarUri));
        }
        return null;
    }

    public IdeHook getIdeHook(ElementName elementName) {
        return (IdeHook)this.getHook(elementName);
    }

    public ExtensionHook getHook(ElementName elementName) {
        ExtensionHook hook = super.getHook(elementName);
        if (hook == null) {
            hook = (ExtensionHook)this._ideHooksByElementName.get(elementName);
        }
        return hook;
    }

    protected final void registerIdeHook(ElementName elementName, ExtensionHook hook) {
        this._ideHooksByElementName.put(elementName, hook);
    }

    protected final boolean isIdeHookRegistered(ElementName elementName) {
        return this._ideHooksByElementName.containsKey(elementName);
    }

    public Collection<String> getDisabledExtensions() {
        return Collections.emptyList();
    }

    public abstract ClassLoader getClassLoader(String var1);

    public Collection<ExtensionHook> getAllHooks() {
        return Collections.emptyList();
    }

    public abstract boolean isFullyLoaded(Extension var1);

    public abstract boolean isFullyLoaded(String var1);

    public abstract void fullyLoadExtension(Extension var1);

    public abstract void fullyLoadExtension(Extension var1, String var2);

    public abstract void fullyLoadExtensions(Map<Extension, String> var1);

    public abstract FeatureRegistry getFeatureRegistry();

    public abstract Extension findExtensionByClassLoader(ClassLoader var1);

    public abstract void invokeAfterExtensionLoading(Runnable var1, boolean var2);
}

