/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide;

import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.clipboard.ClipboardStack;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EmacsAction;
import org.openide.util.Lookup;

public class IdeClipboard {
    private static final Logger LOG = Logger.getLogger(IdeClipboard.class.getName());
    private static boolean nbClipboardEnabled = System.getProperty("ide.nbclipboard.enabled", "true").equals("true") && IdeClipboard.isJdevNbMode();
    private static boolean useLocalClipboard = System.getProperty("ide.clipboard.local", "false").equals("true");
    private static Clipboard nbClipboard = IdeClipboard.nbClipboard();
    private static Class bundleClass = null;

    private IdeClipboard() {
    }

    public static Clipboard getClipboard() throws HeadlessException {
        if (nbClipboard == null) {
            throw new HeadlessException();
        }
        return nbClipboard;
    }

    private static ClassLoader findClassLoader() {
        if (bundleClass == null) {
            try {
                ClassLoader l = Thread.currentThread().getContextClassLoader();
                bundleClass = Class.forName("org.osgi.framework.Bundle", true, l);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return bundleClass.getClassLoader();
    }

    private static Clipboard nbClipboard() {
        Clipboard clipboard = null;
        if (!GraphicsEnvironment.isHeadless()) {
            if (nbClipboardEnabled && !useLocalClipboard) {
                try {
                    clipboard = (Clipboard)Lookup.getDefault().lookup(Clipboard.class);
                }
                catch (Exception ex) {
                    IdeClipboard.logException(ex);
                }
            }
            if (clipboard == null) {
                clipboard = useLocalClipboard ? new Clipboard("local-testing-only") : Toolkit.getDefaultToolkit().getSystemClipboard();
            }
        }
        return clipboard;
    }

    static SecurityManager createSecurityManagerForSystemClipboard() {
        SecurityManager manager = null;
        if (nbClipboardEnabled) {
            try {
                ClassLoader classLoader = IdeClipboard.findClassLoader();
                Class<?> tsmClass = classLoader.loadClass("org.netbeans.TopSecurityManager");
                manager = (SecurityManager)tsmClass.newInstance();
            }
            catch (Exception ex) {
                IdeClipboard.logException(ex);
            }
        }
        return manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void installIdeClipboardIntoSwingComponents() {
        if (nbClipboardEnabled && !GraphicsEnvironment.isHeadless()) {
            SecurityManager oldSM = System.getSecurityManager();
            try {
                ClassLoader classLoader = IdeClipboard.findClassLoader();
                Class<?> manager = classLoader.loadClass("org.netbeans.TopSecurityManager");
                Method install = manager.getMethod("install", new Class[0]);
                Method uninstall = manager.getDeclaredMethod("uninstall", new Class[0]);
                uninstall.setAccessible(true);
                install.invoke(null, new Object[0]);
                Method clipboardMethod = manager.getMethod("makeSwingUseSpecialClipboard", Clipboard.class);
                clipboardMethod.invoke(null, IdeClipboard.getClipboard());
                uninstall.invoke(null, new Object[0]);
            }
            catch (Exception ex) {
                IdeClipboard.logException(ex);
            }
            finally {
                if (oldSM != null && oldSM != System.getSecurityManager()) {
                    System.setSecurityManager(oldSM);
                }
            }
        }
    }

    static void installIdeClipboardIntoJavatools() {
        if (nbClipboardEnabled && !GraphicsEnvironment.isHeadless()) {
            Clipboard clipboard = IdeClipboard.nbClipboard();
            BasicEditorPane.setClipboard((Clipboard)clipboard);
            ClipboardStack.setClipboard((Clipboard)clipboard);
            EmacsAction.setSystemClipboard((Clipboard)clipboard);
        }
    }

    private static boolean isJdevNbMode() {
        return System.getProperty("netbeans.home") != null;
    }

    private static void logException(Exception ex) {
        LOG.log(Level.WARNING, ex.getMessage(), ex);
    }
}

