/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.cmd;

import java.awt.Component;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.cmd.NewWorkspaceCommand;
import oracle.ide.cmd.OpenCommand;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.editor.EditorUtil;
import oracle.ide.layout.URL2String;
import oracle.ide.model.HashStructureNode;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeListener;
import oracle.ide.model.NodeMigrationTracker;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.NewWorkspacePanel;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.HistoryList;
import oracle.javatools.icons.OracleIcons;

public final class FileOpenHistory
implements Controller {
    public static final String OPENED_FILES_NAME = "OpenedFiles";
    public static final String OPENED_PROJECTS_NAME = "OpenedProjects";
    public static final String OPENED_WORKSPACES_NAME = "OpenedWorkspaces";
    private static FileOpenHistory instance = new FileOpenHistory();
    private HistoryList openedFiles;
    private HistoryList openedProjects;
    private HistoryList openedWorkspaces;
    private JMenu reopenMenu;
    private JMenuItem EMPTY_ITEM;
    private int historyCount = 4;
    private Map menuCache = new HashMap();
    private EventListenerList listenerList = new EventListenerList();
    private ChangeEvent changeEvent = null;
    private static IdeAction GLOBAL_REOPEN_ACTION;

    private FileOpenHistory() {
        this.initialize();
    }

    public static FileOpenHistory getInstance() {
        return instance;
    }

    @Deprecated
    public void updateFileHistory(URL url) {
        this.updateHistory(url, this.getOpenedFiles());
    }

    private void updateFileHistory(Node node) {
        this.updateHistory(node, this.getOpenedFiles());
    }

    @Deprecated
    public void updateProjectHistory(URL url) {
        this.updateHistory(url, this.getOpenedProjects());
    }

    private void updateProjectHistory(Node node) {
        this.updateHistory(node, this.getOpenedProjects());
    }

    @Deprecated
    public void updateWorkspaceHistory(URL url) {
        this.updateHistory(url, this.getOpenedWorkspaces());
    }

    private void updateWorkspaceHistory(Node node) {
        this.updateHistory(node, this.getOpenedWorkspaces());
    }

    private void updateHistory(URL url, HistoryList historyList) {
        historyList.update(URL2String.toString(url));
        this.fireChangeEvent();
    }

    private void updateHistory(final Node node, final HistoryList historyList) {
        final String historyString = URL2String.toString(node.getURL());
        if (historyList.remove(historyString)) {
            this.fireChangeEvent();
        }
        node.addNodeListener(new NodeListener(){

            @Override
            public void nodeClosed(NodeEvent e) {
                node.removeNodeListener(this);
                historyList.update(historyString);
                FileOpenHistory.this.fireChangeEvent();
            }
        });
    }

    public void updateHistory(Node node) {
        if (node instanceof Workspace) {
            this.updateWorkspaceHistory(node);
        } else if (node instanceof Project) {
            this.updateProjectHistory(node);
        } else {
            this.updateFileHistory(node);
        }
    }

    public void removeHistory(Node node) {
        if (node instanceof Workspace) {
            this.getOpenedWorkspaces().remove(URL2String.toString(node.getURL()));
        } else if (node instanceof Project) {
            this.getOpenedProjects().remove(URL2String.toString(node.getURL()));
        } else {
            this.getOpenedFiles().remove(URL2String.toString(node.getURL()));
        }
        this.fireChangeEvent();
    }

    public String[] getFileHistory() {
        return this.getOpenedFiles().getHistory();
    }

    public String[] getProjectHistory() {
        return this.getOpenedProjects().getHistory();
    }

    public String[] getWorkspaceHistory() {
        return this.getOpenedWorkspaces().getHistory();
    }

    public int getHistoryCount() {
        return this.historyCount;
    }

    public void setHistoryCount(int count) {
        this.historyCount = count;
    }

    public void save() {
        if (this.openedFiles != null) {
            this.openedFiles.save();
        }
        if (this.openedProjects != null) {
            this.openedProjects.save();
        }
        if (this.openedWorkspaces != null) {
            this.openedWorkspaces.save();
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    protected void fireChangeEvent() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
        }
    }

    @Override
    public boolean handleEvent(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == 10) {
            this.reopen(action, context);
            return true;
        }
        return false;
    }

    @Override
    public boolean update(IdeAction action, Context context) {
        return false;
    }

    protected void initialize() {
        String historyCountProp = Ide.getProperty("Ide.DefaultReopenHistoryCount");
        if (historyCountProp != null) {
            try {
                this.historyCount = Integer.parseInt(historyCountProp);
                this.setHistoryCount(this.historyCount);
            }
            catch (NumberFormatException ex) {
                Logger.getAnonymousLogger().log(Level.FINE, "Unable to load file history count property", ex);
            }
        }
        this.reopenMenu = MenuManager.getJMenu("FileReopen");
        if (this.reopenMenu != null) {
            this.reopenMenu.add(this.getEmptyItem());
            this.reopenMenu.addMenuListener(new MenuListener(){

                @Override
                public void menuSelected(MenuEvent e) {
                    FileOpenHistory.this.callPoppingUp();
                }

                @Override
                public void menuDeselected(MenuEvent e) {
                }

                @Override
                public void menuCanceled(MenuEvent e) {
                }
            });
        }
    }

    protected HistoryList getOpenedFiles() {
        if (this.openedFiles == null) {
            this.openedFiles = Ide.loadHistoryList(OPENED_FILES_NAME);
            this.openedFiles.setMaxHistorySize(this.getHistoryCount());
        }
        return this.openedFiles;
    }

    protected HistoryList getOpenedProjects() {
        if (this.openedProjects == null) {
            this.openedProjects = Ide.loadHistoryList(OPENED_PROJECTS_NAME);
            this.openedProjects.setMaxHistorySize(this.getHistoryCount());
        }
        return this.openedProjects;
    }

    protected HistoryList getOpenedWorkspaces() {
        if (this.openedWorkspaces == null) {
            this.openedWorkspaces = Ide.loadHistoryList(OPENED_WORKSPACES_NAME);
            this.openedWorkspaces.setMaxHistorySize(this.getHistoryCount());
        }
        return this.openedWorkspaces;
    }

    private void callPoppingUp() {
        String[] files = this.getFileHistory();
        String[] projects = this.getProjectHistory();
        String[] workspaces = this.getWorkspaceHistory();
        this.reopenMenu.removeAll();
        if (files.length == 0 && projects.length == 0 && workspaces.length == 0) {
            this.reopenMenu.add(this.getEmptyItem());
            return;
        }
        int count = 0;
        count = this.addMenuItems(files, count);
        count = this.addMenuItems(projects, count);
        this.addMenuItems(workspaces, count);
    }

    private int addMenuItems(String[] items, int count) {
        if (items.length > 0) {
            if (count > 0) {
                this.reopenMenu.add(new JSeparator());
            }
            count = 0;
            for (int i = 0; i < items.length; ++i) {
                JMenuItem menuItem = this.getMenuItem(items[i]);
                if (menuItem == null) continue;
                this.reopenMenu.add(menuItem);
                ++count;
            }
        }
        return count;
    }

    private JMenuItem getEmptyItem() {
        if (this.EMPTY_ITEM == null) {
            this.EMPTY_ITEM = new JMenuItem(IdeArb.getString(527));
            this.EMPTY_ITEM.setEnabled(false);
        }
        return this.EMPTY_ITEM;
    }

    private JMenuItem getMenuItem(String urlString) {
        JMenuItem menuItem = (JMenuItem)this.menuCache.get(urlString);
        if (menuItem != null) {
            try {
                URL url = URL2String.toURL(urlString);
                if (!URLFileSystem.exists((URL)url)) {
                    this.menuCache.remove(urlString);
                    return null;
                }
            }
            catch (Exception e) {
                Logger.getAnonymousLogger().log(Level.FINE, e.getMessage(), e);
            }
            return menuItem;
        }
        try {
            URL url = URL2String.toURL(urlString);
            if (url == null || !URLFileSystem.exists((URL)url)) {
                return null;
            }
            IdeAction action = FileOpenHistory.getNewReopenAction(url);
            menuItem = Ide.getMenubar().createMenuItem(action);
            this.menuCache.put(urlString, menuItem);
            return menuItem;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static IdeAction getNewReopenAction(URL url) {
        Icon icon = null;
        try {
            Node node = NodeFactory.find(url);
            icon = node.getIcon();
        }
        catch (Exception e) {
            icon = OracleIcons.getIcon((String)"file.png");
        }
        IdeAction localAction = FileOpenHistory.getGlobalReopenAction().newLocalAction(null);
        localAction.putValue("Name", URLFileSystem.getPlatformPathName((URL)url));
        localAction.putValue("SmallIcon", icon);
        localAction.putValue("UserData", url);
        return localAction;
    }

    public static IdeAction getGlobalReopenAction() {
        if (GLOBAL_REOPEN_ACTION == null) {
            GLOBAL_REOPEN_ACTION = IdeAction.get(10, AddinManager.getAddinManager().getCommand(10, "oracle.ide.cmd.NotImplementedCommand"), null, IdeMainWindow.ACTION_CATEGORY_FILE, null, null, null, true);
            GLOBAL_REOPEN_ACTION.addController(FileOpenHistory.getInstance());
        }
        return GLOBAL_REOPEN_ACTION;
    }

    private void reopen(IdeAction action, Context context) {
        URL url = (URL)action.getValue("UserData");
        String urlString = URL2String.toString(url);
        if (this.getOpenedFiles().remove(urlString) || this.getOpenedProjects().remove(urlString) || this.getOpenedWorkspaces().remove(urlString)) {
            this.fireChangeEvent();
        }
        try {
            Node node = NodeFactory.findOrCreate(url);
            Icon icon = node.getIcon();
            if (icon != null) {
                action.putValueDirectly("SmallIcon", icon);
            }
            if (node instanceof HashStructureNode && NodeMigrationTracker.getInstance().needsMigration(node.getURL())) {
                OpenCommand oc = new OpenCommand();
                oc.setContext(context);
                oc.openURL(url);
                return;
            }
            if (this.tryWorkspacesFolder(Ide.getWorkspaces(), node, context)) {
                return;
            }
            if (this.tryWorkspaceFolder(context.getWorkspace(), node, context)) {
                return;
            }
            if (this.tryProjectFolder(context.getProject(), node)) {
                return;
            }
            if (node instanceof Project) {
                NewWorkspacePanel workspacePanel = new NewWorkspacePanel(false, false, true);
                if (!workspacePanel.runDialog()) {
                    return;
                }
                URL workspaceURL = workspacePanel.getFileURL();
                Workspace workspace = NewWorkspaceCommand.createEmptyWorkspace(context, workspaceURL);
                Ide.setActiveWorkspace(workspace);
                if (this.tryWorkspaceFolder(workspace, node, context)) {
                    return;
                }
            }
            if (URLFileSystem.exists((URL)url)) {
                this.openEditor(node, true);
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.showErrorDialog(url);
    }

    private boolean tryWorkspacesFolder(Workspaces folder, Node node, Context context) {
        if (folder == null) {
            return false;
        }
        if (folder.canAdd(node)) {
            if (folder.containsChild(node)) {
                if (node instanceof Workspace) {
                    Workspace workspace = (Workspace)node;
                    Context newContext = Context.newIdeContext(workspace);
                    newContext.setWorkspace(workspace);
                    newContext.setProject(workspace.currentActiveProject());
                    NavigatorManager.getWorkspaceNavigatorManager().openNavigator(newContext);
                }
                return true;
            }
            try {
                OpenCommand oc = new OpenCommand();
                oc.setContext(context);
                oc.openURL(node.getURL());
                return true;
            }
            catch (Exception ex) {
                return false;
            }
        }
        return false;
    }

    private boolean tryWorkspaceFolder(Workspace folder, Node node, Context context) {
        if (folder == null) {
            return false;
        }
        if (folder.canAdd(node)) {
            if (folder.containsChild(node)) {
                if (node instanceof Project) {
                    Project project = (Project)node;
                    Context newContext = Context.newIdeContext(project);
                    newContext.setWorkspace(folder);
                    newContext.setProject(project);
                    NavigatorManager.getWorkspaceNavigatorManager().openNavigator(newContext);
                }
                return true;
            }
            try {
                OpenCommand oc = new OpenCommand();
                oc.setContext(context);
                oc.openURL(node.getURL());
                return true;
            }
            catch (Exception ex) {
                return false;
            }
        }
        return false;
    }

    private boolean tryProjectFolder(Project folder, Node node) {
        if (folder != null && folder.canAdd(node)) {
            boolean updateHistory = !folder.containsChild(node);
            this.openEditor(node, updateHistory);
            return true;
        }
        return false;
    }

    private void openEditor(final Node node, boolean updateHistory) {
        if (updateHistory) {
            this.updateHistory(node);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditorUtil.openDefaultEditorInFrame(node);
            }
        });
    }

    private void showErrorDialog(URL url) {
        String name = URLFileSystem.getPlatformPathName((URL)url);
        String msg = IdeArb.format(292, name);
        JOptionPane.showMessageDialog((Component)((Object)Ide.getMainWindow()), msg, IdeArb.getString(293), 0);
    }
}

