/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.cmd;

import java.awt.Component;
import java.awt.Window;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.cmd.FileOpenHistory;
import oracle.ide.cmd.NewWorkspaceCommand;
import oracle.ide.cmd.OpenCommandData;
import oracle.ide.controller.Command;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.docking.DockUtil;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.EditorUtil;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.migration.MigrationInfo;
import oracle.ide.migration.NodeMigrator;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.HashStructureNode;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeMigrationTracker;
import oracle.ide.model.Project;
import oracle.ide.model.TextNode;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.NewWorkspacePanel;
import oracle.ide.panels.Traversable;
import oracle.ide.resource.IdeArb;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.ListUtil;
import oracle.javatools.util.SwingUtils;

public class OpenCommand
extends Command {
    private Project project;
    private Workspace workspace;
    private Workspaces workspaces;
    private List addFiles = new ArrayList();
    private List addToWorkspace = new ArrayList();
    private List addToWorkspaces = new ArrayList();
    private boolean hasWarnedAboutMultipleWorkspaces;

    public OpenCommand() {
        super(9);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int openURL(URL url) throws Exception {
        boolean suppressCursorChanges = Ide.isStarting() || !Ide.getIdeArgs().getCreateUI();
        try {
            if (!suppressCursorChanges) {
                Ide.getWaitCursor().show(0);
            }
            int n = this.open(URLFileSystem.canonicalize((URL)url));
            return n;
        }
        finally {
            if (!suppressCursorChanges) {
                Ide.getWaitCursor().hide();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int doit() throws Exception {
        boolean suppressCursorChanges = Ide.isStarting() || !Ide.getIdeArgs().getCreateUI();
        try {
            if (!suppressCursorChanges) {
                Ide.getWaitCursor().show(0);
            }
            int n = this.open(null);
            return n;
        }
        finally {
            if (!suppressCursorChanges) {
                Ide.getWaitCursor().hide();
            }
        }
    }

    private int open(URL optionalURL) throws Exception {
        block17: {
            block16: {
                AddInfo info2;
                int returnVal;
                Context context = this.getContext();
                this.project = context.getProject();
                if (this.project == null && optionalURL == null) {
                    this.project = Ide.getActiveProject();
                }
                OpenCommandData data = (OpenCommandData)this.getData();
                this.workspace = context.getWorkspace();
                this.workspaces = Ide.getWorkspaces();
                String dialogTitle = IdeArb.getString(298);
                if (optionalURL != null) {
                    this.hasWarnedAboutMultipleWorkspaces = false;
                    if (this.checkAddURL(optionalURL) != 0) {
                        return 0;
                    }
                    returnVal = 0;
                } else {
                    OpenURLChooser chooser = new OpenURLChooser();
                    DialogUtil.initURLChooser(chooser, context);
                    chooser.setSelectionScope(0);
                    if (data != null) {
                        dialogTitle = data.dialogTitle;
                        chooser.clearChooseableURLFilters();
                        chooser.setURLFilter(data.urlFilter);
                        if (data.directoryURL != null && URLFileSystem.exists((URL)data.directoryURL)) {
                            chooser.setSelectedURL(data.directoryURL);
                        }
                    }
                    OpenURLChooser content = chooser;
                    returnVal = chooser.showOpenDialog((Component)((Object)Ide.getMainWindow()), (Traversable)content, dialogTitle);
                    context.setProperty("selected-urls", chooser.getSelectedURLs());
                }
                if (returnVal != 0) break block16;
                OpenCommand.ensureNavigatorOpened(this.addToWorkspaces, this.addToWorkspace);
                ArrayList<Node> childrenAdded = new ArrayList<Node>(1);
                for (AddInfo info2 : this.addToWorkspaces) {
                    if (!this.workspaces.containsChild(info2.node)) {
                        this.checkWorkspaceOpen(info2, this.workspaces, childrenAdded);
                        continue;
                    }
                    if (!(info2.node instanceof Workspace)) continue;
                    Ide.setActiveWorkspace((Workspace)info2.node);
                    childrenAdded.add(info2.node);
                }
                if (childrenAdded.size() > 0) {
                    UpdateMessage.fireChildrenAdded(this.workspaces, childrenAdded);
                }
                childrenAdded.clear();
                for (AddInfo info2 : this.addToWorkspace) {
                    if (this.workspace.containsChild(info2.node)) continue;
                    this.checkProjectOpen(info2, this.workspace, childrenAdded);
                }
                if (childrenAdded.size() > 0) {
                    UpdateMessage.fireChildrenAdded(this.workspace, childrenAdded);
                }
                info2 = null;
                if (data != null) break block17;
                for (AddInfo info2 : this.addFiles) {
                    final Node node = info2.node;
                    if (this.shouldAddToMRU(node)) {
                        FileOpenHistory.getInstance().updateHistory(node);
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (OpenCommand.this.project == null || !OpenCommand.this.project.containsChild(node)) {
                                OpenCommand.this.openWithNoProject(node);
                            } else {
                                EditorUtil.openExplicitDefaultEditorInFrame(node);
                            }
                            if (node.isNew()) {
                                try {
                                    node.save();
                                    if (OpenCommand.this.project != null && OpenCommand.this.project.isOpen()) {
                                        UpdateMessage.fireChildAdded(OpenCommand.this.project, node);
                                    }
                                }
                                catch (IOException ex) {
                                    String fileName = URLFileSystem.getPlatformPathName((URL)node.getURL());
                                    String msg = IdeArb.format(238, fileName);
                                    JOptionPane.showMessageDialog((Component)((Object)Ide.getMainWindow()), msg, IdeArb.getString(240), 0);
                                }
                            }
                        }
                    });
                }
                break block17;
            }
            Iterator iter = this.addToWorkspaces.iterator();
            while (iter.hasNext()) {
                this.remove((AddInfo)iter.next());
            }
            iter = this.addToWorkspace.iterator();
            while (iter.hasNext()) {
                this.remove((AddInfo)iter.next());
            }
            iter = this.addFiles.iterator();
            while (iter.hasNext()) {
                this.remove((AddInfo)iter.next());
            }
        }
        return 0;
    }

    private void openWithNoProject(Node node) {
        URL url = node.getURL();
        try {
            Node newNode = NodeFactory.findOrCreate(url);
            Context context = Context.newIdeContext(newNode);
            EditorManager editorManager = EditorManager.getEditorManager();
            OpenEditorOptions openEditorOptions = new OpenEditorOptions(context);
            editorManager.openEditor(openEditorOptions);
        }
        catch (Exception e) {
            IdeMainWindow mainWindow = Ide.getMainWindow();
            ExceptionDialog.showExceptionDialog((Window)((Object)mainWindow), (Exception)e);
        }
    }

    private void remove(AddInfo info) {
        if (info.newNode) {
            NodeFactory.uncache(info.node.getURL());
        }
    }

    /*
     * Unable to fully structure code
     */
    private int checkAddURL(URL url) {
        fileName = URLFileSystem.getPlatformPathName((URL)url);
        newNode = false;
        node = NodeFactory.find(url);
        if (node == null) {
            newNode = true;
            try {
                node = NodeFactory.findOrCreate(url);
                node = this.checkOpenAsText(node, newNode);
                if (node == null) {
                    return 1;
                }
                if (!node.isNew()) ** GOTO lbl20
                node.markDirty(true);
            }
            catch (Exception e) {
                msg = IdeArb.format(292, fileName);
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), msg, IdeArb.getString(293), 0);
                return 1;
            }
        } else if ((node = this.checkOpenAsText(node, newNode)) == null) {
            return 1;
        }
lbl20:
        // 4 sources

        info = new AddInfo(node, newNode);
        status = 0;
        if (this.workspace != null && this.workspace.canAdd(node)) {
            if (!this.hasWarnedAboutMultipleWorkspaces && node instanceof Project && (existing = ((Project)node).getWorkspace()) != null && !existing.equals(this.workspace)) {
                this.showProjectAlreadyOpenDialog((Project)node, existing, this.workspace);
                this.hasWarnedAboutMultipleWorkspaces = true;
            }
            this.addToWorkspace.add(info);
        } else if (this.workspaces != null && this.workspaces.canAdd(node)) {
            if (!this.hasWarnedAboutMultipleWorkspaces) {
                for (Project project : ((Workspace)node).projects()) {
                    existing = project.getWorkspace();
                    if (existing == null || existing.equals(node)) continue;
                    this.showProjectAlreadyOpenDialog(project, project.getWorkspace(), (Workspace)node);
                    this.hasWarnedAboutMultipleWorkspaces = true;
                    break;
                }
            }
            this.addToWorkspaces.add(info);
        } else if (node instanceof Project) {
            status = this.createWorkspaceForProject(node, info, newNode);
        } else {
            this.addFiles.add(info);
        }
        return status;
    }

    private void showProjectAlreadyOpenDialog(Project project, Workspace existing, Workspace attempted) {
        String title = IdeArb.getString(533);
        String message = IdeArb.format(534, project.getShortLabel(), existing.getShortLabel(), attempted.getShortLabel());
        MessageDialog.optionalInformation((String)"oracle.ide.project.in.multiple.workspaces", (Component)((Object)Ide.getMainWindow()), (Object)message, (String)title, null);
    }

    private String generateApplicationName(Node projectNode) {
        URL parent = URLFileSystem.getParent((URL)projectNode.getURL());
        String applicationName = URLFileSystem.getName((URL)projectNode.getURL()) + "Application";
        URL applicationURL = URLFactory.newURL((URL)parent, (String)(applicationName + ".jws"));
        int i = 0;
        while (URLFileSystem.exists((URL)applicationURL)) {
            applicationURL = URLFactory.newURL((URL)parent, (String)(applicationName + ++i + ".jws"));
        }
        return URLFileSystem.getFileName((URL)applicationURL);
    }

    private int createWorkspaceForProject(Node projectNode, AddInfo info, boolean newNode) {
        int status = 0;
        NewWorkspacePanel wspPanel = new NewWorkspacePanel(false, false, true, IdeArb.getString(276));
        wspPanel.setSupportsAutoFill(false);
        wspPanel.setDirectoryURL(URLFileSystem.getParent((URL)projectNode.getURL()));
        wspPanel.setFileName(this.generateApplicationName(projectNode));
        if (wspPanel.runDialog(IdeArb.getString(257))) {
            URL workspaceURL = wspPanel.getFileURL();
            try {
                this.workspace = NewWorkspaceCommand.createEmptyWorkspace(this.getContext(), workspaceURL);
                if (this.workspace != null && this.workspace.canAdd(projectNode)) {
                    this.addToWorkspace.add(info);
                    Ide.setActiveWorkspace(this.workspace);
                }
            }
            catch (Exception e) {
                status = 1;
            }
        } else {
            status = 2;
        }
        if (status == 1) {
            if (newNode) {
                NodeFactory.uncache(projectNode.getURL());
            }
            status = 0;
        }
        return status;
    }

    private Node checkOpenAsText(Node node, boolean newNode) {
        if (node.getAttributes().isSet(ElementAttributes.OPEN_AS_TEXT)) {
            URL url = node.getURL();
            try {
                URL newURL = URLFactory.newIdeURL((String)"ide.text", (URL)url);
                node = NodeFactory.find(newURL);
                if (node == null) {
                    node = new TextNode();
                    node.setURL(newURL);
                }
                if (newNode) {
                    NodeFactory.uncache(url);
                }
            }
            catch (Exception e) {
                String msg = IdeArb.format(292, URLFileSystem.getPlatformPathName((URL)url));
                JOptionPane.showMessageDialog((Component)((Object)Ide.getMainWindow()), msg, IdeArb.getString(293), 0);
                return null;
            }
        }
        return node;
    }

    private void checkProjectOpen(AddInfo info, Workspace workspace, List childrenAdded) {
        NodeMigrator migrator;
        boolean skipMigration = Boolean.getBoolean("ide.skipmigration");
        if (!skipMigration && (migrator = NodeMigrator.getNodeMigrator(NodeMigrator.getLookupKey(info.node))) != null) {
            MigrationInfo migInfo = migrator.getMigrationInfo(info.node);
            MigrationInfo.Status nodeMigrationInfoStatus = migInfo.getVersionStatus();
            if (!this.displayMigrationErrors(migInfo, IdeArb.getString(506)) || migInfo.getMigrationStatus() == MigrationInfo.MIGRATION_NOT_POSSIBLE) {
                this.remove(info);
                return;
            }
            if (nodeMigrationInfoStatus != MigrationInfo.VERSION_CURRENT) {
                if (migInfo.getMigrationStatus().equals(MigrationInfo.MIGRATION_CANCELED) || migrator.migrate(migInfo).getMigrationStatus() != MigrationInfo.MIGRATION_DONE) {
                    this.remove(info);
                    return;
                }
                if (NodeMigrationTracker.getInstance().needsMigration(info.node.getURL())) {
                    NodeMigrationTracker.getInstance().startTracking(workspace.getURL());
                }
            } else {
                NodeMigrationTracker.getInstance().stopTracking(info.node.getURL());
            }
        }
        workspace.add(info.node);
        childrenAdded.add(info.node);
        if (this.shouldAddToMRU(info.node)) {
            FileOpenHistory.getInstance().updateHistory(info.node);
        }
    }

    private boolean checkWorkspaceOpen(AddInfo info, Workspaces workspaces, List childrenAdded) {
        NodeMigrator migrator;
        boolean skipMigration = Boolean.getBoolean("ide.skipmigration");
        if (!skipMigration && (migrator = NodeMigrator.getNodeMigrator(NodeMigrator.getLookupKey(info.node))) != null) {
            MigrationInfo migInfo = migrator.getMigrationInfo(info.node);
            MigrationInfo.Status nodeMigrationInfoStatus = migInfo.getVersionStatus();
            MigrationInfo.MigrationStatus nodeMigStatus = migInfo.getMigrationStatus();
            if (!this.displayMigrationErrors(migInfo, IdeArb.getString(505)) || migInfo.getMigrationStatus() == MigrationInfo.MIGRATION_NOT_POSSIBLE) {
                this.remove(info);
                return false;
            }
            if (nodeMigrationInfoStatus != MigrationInfo.VERSION_CURRENT || nodeMigrationInfoStatus == MigrationInfo.VERSION_CURRENT && nodeMigStatus == MigrationInfo.MIGRATION_PENDING) {
                if (migrator.migrate(migInfo).getMigrationStatus() != MigrationInfo.MIGRATION_DONE) {
                    this.remove(info);
                    return false;
                }
            } else {
                NodeMigrationTracker.getInstance().stopTracking(info.node.getURL());
            }
        }
        workspaces.add(info.node);
        URL dirURL = info.node.getURL();
        if (dirURL != null && URLFileSystem.exists((URL)dirURL)) {
            dirURL = URLFileSystem.getParent((URL)dirURL);
        }
        if (dirURL != null && URLFileSystem.exists((URL)dirURL)) {
            dirURL = URLFileSystem.getParent((URL)dirURL);
        }
        Ide.getDTCache().putURL("oracle.ide.cmd.OpenCommand.last-opened-workspace-dir", dirURL);
        childrenAdded.add(info.node);
        if (this.shouldAddToMRU(info.node)) {
            FileOpenHistory.getInstance().updateHistory(info.node);
        }
        return true;
    }

    private boolean shouldAddToMRU(Node node) {
        if (node instanceof HashStructureNode) {
            return !NodeMigrationTracker.getInstance().needsMigration(node.getURL());
        }
        return !node.isDirty();
    }

    private boolean displayMigrationErrors(MigrationInfo migInfo, String baseMessage) {
        Iterator<MigrationInfo.ErrorInformation> errors = migInfo.getErrors();
        ArrayList<String> abortMsgs = new ArrayList<String>();
        ArrayList<String> continueMsgs = new ArrayList<String>();
        ArrayList<String> promptMsgs = new ArrayList<String>();
        while (errors.hasNext()) {
            MigrationInfo.ErrorInformation error = errors.next();
            switch (error.getActionType()) {
                case ABORT: {
                    abortMsgs.add(error.getMessage());
                    break;
                }
                case CONTINUE: {
                    continueMsgs.add(error.getMessage());
                    break;
                }
                case PROMPT: {
                    promptMsgs.add(error.getMessage());
                }
            }
        }
        if (!abortMsgs.isEmpty()) {
            MessageDialog.error((Component)SwingUtils.getToplevelWindow(), (Object)(baseMessage + ListUtil.join(abortMsgs, (String)"")), (String)IdeArb.getString(419), null);
            migInfo.setMigrationStatus(MigrationInfo.MIGRATION_NOT_POSSIBLE);
            return false;
        }
        if (!promptMsgs.isEmpty()) {
            for (String prompt : promptMsgs) {
                if (MessageDialog.confirm((Component)SwingUtils.getToplevelWindow(), (Object)prompt, (String)IdeArb.getString(419), null)) continue;
                migInfo.setMigrationStatus(MigrationInfo.MIGRATION_CANCELED);
                return false;
            }
        }
        if (!continueMsgs.isEmpty()) {
            MessageDialog.error((Component)SwingUtils.getToplevelWindow(), (Object)(baseMessage + ListUtil.join(continueMsgs, (String)"")), (String)IdeArb.getString(419), null);
        }
        return true;
    }

    private static void ensureNavigatorOpened(List<AddInfo> workspaceList, List<AddInfo> projectList) {
        if (workspaceList.isEmpty() && projectList.isEmpty()) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DockUtil.showDockableWindow(NavigatorManager.getApplicationNavigatorManager().getNavigatorWindow());
            }
        });
    }

    private class OpenURLChooser
    extends URLChooser {
        private static final String HELP_TOPIC_OPEN = "f1_idedopenorcreatefile_html";

        OpenURLChooser() {
            this.setSelectionScope(2);
            this.setHelpID(HELP_TOPIC_OPEN);
        }

        @Override
        public boolean approveSelection() {
            if (!super.approveSelection()) {
                return false;
            }
            OpenCommand.this.addFiles.clear();
            OpenCommand.this.addToWorkspace.clear();
            OpenCommand.this.addToWorkspaces.clear();
            URL[] selectedURLs = this.getSelectedURLs();
            int addCtr = 0;
            if (selectedURLs != null && selectedURLs.length > 0) {
                URL url;
                if (!(selectedURLs.length != 1 || URLFileSystem.isBound((URL)(url = selectedURLs[0])) && URLFileSystem.exists((URL)url))) {
                    String filename = URLFileSystem.getPlatformPathName((URL)url);
                    String msg = IdeArb.format(429, filename);
                    if (!MessageDialog.confirm((Component)((Object)Ide.getMainWindow()), (Object)msg, (String)IdeArb.getString(428), null)) {
                        if (!URLFileSystem.exists((URL)url)) {
                            NodeFactory.uncache(url);
                        }
                        return false;
                    }
                }
                OpenCommand.this.hasWarnedAboutMultipleWorkspaces = false;
                for (int i = 0; i < selectedURLs.length; ++i) {
                    if (OpenCommand.this.checkAddURL(selectedURLs[i]) != 0) continue;
                    ++addCtr;
                }
            }
            return addCtr > 0;
        }
    }

    private static class AddInfo {
        final Node node;
        final boolean newNode;

        AddInfo(Node node, boolean newNode) {
            this.node = node;
            this.newNode = newNode;
        }
    }
}

