/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.cmd;

import java.awt.Component;
import java.net.URL;
import java.util.ArrayList;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.FileOpenHistory;
import oracle.ide.cmd.RemoveFileCommand;
import oracle.ide.controller.IdeActions;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.RelativeDirectoryContextFolder;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.refactoring.DeleteActionHandler;
import oracle.ide.refactoring.DeleteHandlerService;
import oracle.ide.resource.DeleteDialogArb;
import oracle.ideimpl.navigator.delete.model.DeleteFileVisitor;
import oracle.ideimpl.navigator.delete.model.FileSystemModelUtils;
import oracle.javatools.dialogs.MessageDialog;

public class RemoveFromDiskCommand
extends RemoveFileCommand {
    private boolean _silently = false;

    public RemoveFromDiskCommand() {
        super(47, 2);
    }

    public void setSilently(boolean silently) {
        this._silently = silently;
    }

    @Override
    public int doit() throws Exception {
        int ret = 1;
        Context context = this.getContext();
        ArrayList<Element> elements = new ArrayList<Element>();
        boolean areAllLocatables = true;
        Element[] selectedElements = context.getSelection();
        int elementCount = selectedElements.length;
        if (elementCount > 0) {
            ArrayList<URL> urlList = new ArrayList<URL>(elementCount);
            for (int i = 0; i < elementCount; ++i) {
                Element element = selectedElements[i];
                elements.add(element);
                if (element instanceof Locatable) {
                    Locatable locatable = (Locatable)((Object)element);
                    URL url = locatable.getURL();
                    urlList.add(url);
                    continue;
                }
                if (element instanceof RelativeDirectoryContextFolder) {
                    RelativeDirectoryContextFolder rdcf = (RelativeDirectoryContextFolder)element;
                    URLPath rootURLs = rdcf.getRootDirectories();
                    String relPath = rdcf.getRelativePath();
                    for (URL rootURL : rootURLs) {
                        URL folderURL = URLFactory.newDirURL((URL)rootURL, (String)relPath);
                        urlList.add(folderURL);
                    }
                    continue;
                }
                areAllLocatables = false;
            }
            if (context.containsProperty(DeleteActionHandler.class.getName())) {
                DeleteActionHandler deleteActionHandler = (DeleteActionHandler)context.getProperty(DeleteActionHandler.class.getName());
                deleteActionHandler.doit();
            } else {
                DeleteActionHandler deleteHandler = DeleteHandlerService.createDeleteHandler(context);
                if (deleteHandler != null) {
                    if (this._silently) {
                        deleteHandler.doit();
                    } else {
                        DeleteActionHandler.DeleteOption deleteOption = deleteHandler.clarifyToDeleteOrToRemoveFromParentContainer((Component)((Object)Ide.getMainWindow()));
                        if (deleteOption.equals((Object)DeleteActionHandler.DeleteOption.EraseFromDisk)) {
                            deleteHandler.doit();
                        } else if (deleteOption.equals((Object)DeleteActionHandler.DeleteOption.RemoveFromParent)) {
                            IdeActions.getFileRemoveFromIDEAction().performAction(context);
                        }
                    }
                } else {
                    Element[] selection = context.getSelection();
                    if (selection != null && selection.length > 0) {
                        if (selection.length == 1) {
                            Element element = selection[0];
                            if (MessageDialog.confirm((Component)((Object)Ide.getMainWindow()), (Object)DeleteDialogArb.format(35, element.getShortLabel()), (String)DeleteDialogArb.getString(32), null) && element instanceof Locatable) {
                                URL urlToBeDeleted = ((Locatable)((Object)element)).getURL();
                                DeleteFileVisitor deletor = new DeleteFileVisitor();
                                FileSystemModelUtils.deleteRecursively(new URL[]{urlToBeDeleted}, deletor);
                                if (deletor.getUndeleted().size() > 0) {
                                    DeleteActionHandler.raiseDeletionFailedDialog(deletor.getUndeleted());
                                }
                            }
                        } else if (MessageDialog.confirm((Component)((Object)Ide.getMainWindow()), (Object)DeleteDialogArb.format(35, "these " + selection.length + " selected files"), (String)DeleteDialogArb.getString(32), null)) {
                            ArrayList<URL> urlsToBeDeleted = new ArrayList<URL>(selection.length);
                            for (Element elem : selection) {
                                if (!(elem instanceof Locatable)) continue;
                                urlsToBeDeleted.add(((Locatable)((Object)elem)).getURL());
                            }
                            if (urlsToBeDeleted.size() > 0) {
                                DeleteFileVisitor deletor = new DeleteFileVisitor();
                                FileSystemModelUtils.deleteRecursively(urlsToBeDeleted.toArray(new URL[urlsToBeDeleted.size()]), deletor);
                                if (deletor.getUndeleted().size() > 0) {
                                    DeleteActionHandler.raiseDeletionFailedDialog(deletor.getUndeleted());
                                }
                            }
                        }
                    }
                }
            }
        }
        return ret;
    }

    @Override
    protected boolean remove(Node node, Folder owner) {
        boolean result = false;
        boolean remove = false;
        if (node.isNew()) {
            remove = true;
        } else if (URLFileSystem.canDelete((URL)node.getURL())) {
            node.delete();
            remove = true;
        }
        if (remove) {
            result = owner != null ? (!owner.containsChild(node) ? true : owner.remove(node)) : true;
            if (result) {
                FileOpenHistory.getInstance().removeHistory(node);
                NodeFactory.uncache(node.getURL());
            }
        }
        return result;
    }

    @Override
    protected UpdateMessage createUpdateMessage() {
        UpdateMessage message = new UpdateMessage(UpdateMessage.CHILD_REMOVED, null);
        message.setProperty("Message.COMMAND_ID_PROP", 47);
        return message;
    }

    @Override
    protected boolean isNeedConfirmClose() {
        return false;
    }
}

