/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.cmd;

import java.awt.Component;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import oracle.ide.Ide;
import oracle.ide.cmd.SaveCommandsManger;
import oracle.ide.controller.Command;
import oracle.ide.controls.WaitCursor;
import oracle.ide.controls.checkboxlist.CheckBoxListModel;
import oracle.ide.dialogs.SelectFilesPanel;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.IdeArb;
import oracle.ideimpl.cmd.SaveSystemFilesUtil;
import org.netbeans.api.progress.ProgressHandle;

public class SaveAllCommand
extends Command {
    int currentProgress = 0;

    public SaveAllCommand() {
        super(13);
    }

    public static int saveAll() throws Exception {
        return SaveAllCommand.saveAll(false);
    }

    public static int saveAll(boolean silent) throws Exception {
        SaveAllCommand cmd = new SaveAllCommand();
        return cmd._saveAll(silent);
    }

    public int _saveAll(boolean silent) throws Exception {
        if (SwingUtilities.isEventDispatchThread() || this.getProgressHandle() != null) {
            return this.saveAllOnCurrentThread(silent);
        }
        return this.saveAllOnWorkerThread(silent);
    }

    private int saveAllOnCurrentThread(boolean silent) {
        int[] counts = new int[]{0, 0};
        Map<Node, String> errors = this.saveFiles(counts);
        if (!silent) {
            SaveAllCommand.showErrorDialog(errors);
        }
        SaveAllCommand.updateStatusBar(counts[0], counts[1]);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Node, String> saveFiles(int[] counts) {
        LinkedHashMap<Node, String> errors = null;
        WaitCursor wc = new WaitCursor((Component)((Object)Ide.getMainWindow()));
        try {
            wc.show();
            Iterator<Node> nodes = NodeFactory.getCachedNodes();
            while (nodes.hasNext()) {
                Node node = nodes.next();
                if (node.isOpen()) {
                    counts[0] = counts[0] + 1;
                    if (node.isDirty()) {
                        URL url = node.getURL();
                        try {
                            SaveCommandsManger.fireEvent(node);
                            node.save();
                            counts[1] = counts[1] + 1;
                        }
                        catch (Exception e) {
                            String err = IdeArb.format(304, URLFileSystem.getPlatformPathName((URL)url), e.getLocalizedMessage());
                            if (errors == null) {
                                errors = new LinkedHashMap<Node, String>();
                            }
                            errors.put(node, err);
                        }
                    }
                }
                this.incrementProgress();
            }
        }
        finally {
            wc.hide();
        }
        return errors;
    }

    private static void updateStatusBar(int openNodesCount, int savedNodes) {
        String statusText = IdeArb.format(301, openNodesCount, savedNodes);
        Ide.getStatusBar().setText(statusText);
    }

    private static void showErrorDialog(Map<Node, String> errors) {
        if (errors != null && errors.size() > 0) {
            CheckBoxListModel listModel = new CheckBoxListModel();
            for (Map.Entry<Node, String> error : errors.entrySet()) {
                listModel.addElement((Object)error.getKey(), error.getKey().getIcon(), true, true, error.getValue());
            }
            SelectFilesPanel.showDialog(IdeArb.getString(288), IdeArb.format(303, listModel.findTextForElement(0)), IdeArb.getString(302), listModel, false, -1, "f1_idedunabletosavefiles_html");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int saveAllOnWorkerThread(final boolean silent) throws InterruptedException {
        SwingWorker worker;
        SwingWorker swingWorker = worker = new SwingWorker(){
            private Map<Node, String> errors;
            private int[] fileCounts = new int[]{0, 0};

            protected Object doInBackground() {
                this.errors = SaveAllCommand.this.saveFiles(this.fileCounts);
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void done() {
                try {
                    if (!silent) {
                        SaveAllCommand.showErrorDialog(this.errors);
                    }
                    SaveAllCommand.updateStatusBar(this.fileCounts[0], this.fileCounts[1]);
                }
                finally {
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        this.notify();
                    }
                }
            }
        };
        synchronized (swingWorker) {
            worker.execute();
            worker.wait();
        }
        return 0;
    }

    @Override
    public int doit() throws Exception {
        ProgressHandle ph = this.getProgressHandle();
        if (ph != null) {
            ph.switchToDeterminate(NodeFactory.getCachedNodeCount() + 1);
        }
        this._saveAll(false);
        this._saveSystemFiles();
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _saveSystemFiles() {
        if (SwingUtilities.isEventDispatchThread()) {
            SaveSystemFilesUtil.saveSystemFiles();
        } else {
            try {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SaveSystemFilesUtil.saveSystemFiles();
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.incrementProgress();
            }
        }
    }

    public static void saveSystemFiles() {
        SaveAllCommand cmd = new SaveAllCommand();
        cmd._saveSystemFiles();
    }

    private void incrementProgress() {
        if (this.getProgressHandle() != null) {
            this.getProgressHandle().progress(++this.currentProgress);
        }
    }
}

