/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.config;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.ide.util.MetaClass;
import javax.swing.Icon;
import oracle.ide.Ide;
import oracle.ide.IdeAdapter;
import oracle.ide.IdeEvent;
import oracle.ide.config.FileTypesRecognizer;
import oracle.ide.dialogs.filter.ExcludeFilterSettings;
import oracle.ide.model.ContentType;
import oracle.ide.model.DocumentInfo;
import oracle.ide.model.Recognizer;
import oracle.javatools.marshal.TransientMarker;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.ModelUtil;

@Deprecated
public class DocumentExtensions
implements Copyable {
    public static final String KEY_SETTINGS = "document-extensions-options";
    private final ConcurrentMap<MetaClass<?>, DocRecord> _documentMap = new ConcurrentHashMap();
    private final ConcurrentMap<String, DocRecord> _declarativeDocumentMap = new ConcurrentHashMap<String, DocRecord>();
    private ExcludeFilterSettings _excludeFilterSettings;
    private Map _defaultEditorMap;
    private Map _associationMap;
    private ConcurrentMap<MetaClass<?>, DocRecord> _hiddenMap = new ConcurrentHashMap();
    private final ConcurrentMap<String, DocRecord> _declarativeHiddenMap = new ConcurrentHashMap<String, DocRecord>();

    public DocRecord[] getUserExtensionList() {
        Collection documents = this.getDocuments();
        return documents.toArray(new DocRecord[documents.size()]);
    }

    public void setUserExtensionList(DocRecord[] records) {
        if (records == null) {
            return;
        }
        this.initDocumentMap();
        for (int i = 0; i < records.length; ++i) {
            DocRecord docRecord;
            MetaClass<?> docMetaClass = records[i].getDocMetaClass();
            if (docMetaClass == null || (docRecord = this._documentMap.putIfAbsent(docMetaClass, records[i])) == null) continue;
            for (ExtInfo extInfo : records[i].getUserExtensions()) {
                ExtInfo createdExtInfo = docRecord.addUserExtension(extInfo.getExtension());
                createdExtInfo.setLocked(extInfo.isLocked());
            }
        }
        this.mapExtensionsToClasses(records);
    }

    void mapExtensionsToClasses(DocRecord[] records) {
        for (int i = 0; i < records.length; ++i) {
            DocRecord record = records[i];
            List extensions = record.getUserExtensions();
            for (int j = 0; j < extensions.size(); ++j) {
                ExtInfo info = (ExtInfo)extensions.get(j);
                MetaClass<?> docClass = record.getDocMetaClass();
                if (docClass == null || "oracle.ide.config.RegisteredDynamicNode".equals(docClass.getClassName())) continue;
                Recognizer.mapExtensionToMetaClass(info.getExtension(), docClass);
            }
        }
    }

    @Deprecated
    public ExcludeFilterSettings getExcludeFilterSettings() {
        return this._excludeFilterSettings;
    }

    @Deprecated
    public void setExcludeFilterSettings(ExcludeFilterSettings settings) {
        this._excludeFilterSettings = settings;
    }

    public Map getExtensionToContentTypeMap() {
        HashMap contentTypeMap = new HashMap();
        this.getExtensionToContentTypeMapImpl(contentTypeMap);
        return contentTypeMap;
    }

    public void setExtensionToContentTypeMap(final Map contentTypeMap) {
        if (!Ide.isStarting()) {
            this.setExtensionToContentTypeMapImpl(contentTypeMap);
        } else {
            Ide.addIdeListener(new IdeAdapter(){

                @Override
                public void mainWindowOpened(IdeEvent e) {
                    DocumentExtensions.this.setExtensionToContentTypeMapImpl(contentTypeMap);
                    Ide.removeIdeListener(this);
                }
            });
        }
    }

    public Map getDefaultEditorMap() {
        return this._defaultEditorMap;
    }

    public void setDefaultEditorMap(Map defaultEditorMap) {
        this._defaultEditorMap = defaultEditorMap;
    }

    public Map getAssociationMap() throws TransientMarker {
        return this._associationMap;
    }

    public void setAssociationMap(Map associationMap) {
        this._associationMap = associationMap;
    }

    private Collection<DocRecord> getDocRecords() {
        this.initDocumentMap();
        return this._documentMap.values();
    }

    public Collection getDocuments() {
        ArrayList<DocRecord> docRecords = new ArrayList<DocRecord>();
        docRecords.addAll(this.getDocRecords());
        docRecords.addAll(this._declarativeDocumentMap.values());
        return docRecords;
    }

    public Object copyTo(Object target) {
        DocumentExtensions copy = target != null ? (DocumentExtensions)target : new DocumentExtensions();
        this.copyToImpl(copy);
        return copy;
    }

    protected final void copyToImpl(DocumentExtensions copy) {
        this.initDocumentMap();
        ModelUtil.deepCopy(this._documentMap, copy._documentMap);
        copy._hiddenMap = this._hiddenMap;
        copy._defaultEditorMap = this._defaultEditorMap;
        copy._associationMap = this._associationMap;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DocumentExtensions)) {
            return false;
        }
        DocumentExtensions other = (DocumentExtensions)object;
        if (!(this._defaultEditorMap != null ? this._defaultEditorMap.equals(other._defaultEditorMap) : other._defaultEditorMap == null)) {
            return false;
        }
        if (!(this._associationMap != null ? this._associationMap.equals(other._associationMap) : other._associationMap == null)) {
            return false;
        }
        return this.getDocuments() != null ? this.getDocuments().equals(other.getDocuments()) : other.getDocuments() == null;
    }

    public int hashCode() {
        int PRIME = 37;
        int result = 1;
        result = 37 * result + (this._defaultEditorMap == null ? 0 : this._defaultEditorMap.hashCode());
        result = 37 * result + (this._associationMap == null ? 0 : this._associationMap.hashCode());
        result = 37 * result + (this.getDocuments() == null ? 0 : this.getDocuments().hashCode());
        return result;
    }

    @Deprecated
    public Set getNodeExtensions(Class nodeClass, boolean matchIfEqual) {
        return FileTypesRecognizer.getNodeExtensions(nodeClass);
    }

    @Deprecated
    public Set getNodeExtensions(Class[] nodeClasses, boolean matchIfEqual) {
        return FileTypesRecognizer.getNodeExtensions(nodeClasses);
    }

    public DocRecord findDocumentFromExtension(String ext) {
        for (DocRecord dr : this.getDocuments()) {
            if (!dr.isExtensionInUse(ext)) continue;
            return dr;
        }
        for (DocRecord dr : this._hiddenMap.values()) {
            if (!dr.isExtensionInUse(ext)) continue;
            return dr;
        }
        for (DocRecord dr : this._declarativeHiddenMap.values()) {
            if (!dr.isExtensionInUse(ext)) continue;
            return dr;
        }
        return null;
    }

    private void initDocumentMap() {
        this.addRecognizerDocuments(this._documentMap);
        this.addRecognizerDeclarativeDocuments(this._declarativeDocumentMap);
    }

    private void addRecognizerDocuments(ConcurrentMap<MetaClass<?>, DocRecord> documentMap) {
        Map<File, MetaClass> docMap = Recognizer.getExtensionToMetaClassMap();
        if (docMap == null) {
            return;
        }
        for (Map.Entry<File, MetaClass> entry : docMap.entrySet()) {
            File ext = entry.getKey();
            MetaClass type = entry.getValue();
            DocRecord record = (DocRecord)documentMap.get(type);
            if (record == null) {
                DocRecord hiddenRec;
                DocumentInfo info = Recognizer.getDocumentInfo(type.getClassName());
                if (info == null) {
                    info = this.defaultInfo(type);
                } else if (!info.isIconSpecified()) {
                    info.setIconMetaClass(type);
                }
                record = new DocRecord(type, info);
                if (!info.isHidden()) {
                    DocRecord oldRecord = documentMap.putIfAbsent(type, record);
                    if (oldRecord != null) {
                        record = oldRecord;
                    }
                } else if (this._hiddenMap != null && (hiddenRec = this._hiddenMap.putIfAbsent(type, record)) != null) {
                    record = hiddenRec;
                }
            }
            record.addIdeExtension(ext.getName());
        }
    }

    private void addRecognizerDeclarativeDocuments(ConcurrentMap<String, DocRecord> documentMap) {
        Map<File, MetaClass<?>> docMap = Recognizer.getDeclarativeExtensionToClassMap();
        if (docMap == null) {
            return;
        }
        for (Map.Entry<File, MetaClass<?>> entry : docMap.entrySet()) {
            File ext = entry.getKey();
            MetaClass<?> type = entry.getValue();
            DocRecord record = (DocRecord)documentMap.get(type.getClassName());
            if (record == null) {
                DocRecord hiddenRec;
                DocumentInfo info = Recognizer.getDocumentInfoForDeclarativeEntries(type.getClassName());
                if (info == null) {
                    info = this.defaultInfo(type.getClassName());
                }
                record = new DocRecord(type, info);
                if (!info.isHidden()) {
                    DocRecord oldRecord = documentMap.putIfAbsent(type.getClassName(), record);
                    if (oldRecord != null) {
                        record = oldRecord;
                    }
                } else if (this._declarativeHiddenMap != null && (hiddenRec = this._declarativeHiddenMap.putIfAbsent(type.getClassName(), record)) != null) {
                    record = hiddenRec;
                }
            }
            record.addIdeExtension(ext.getName());
        }
    }

    private DocumentInfo defaultInfo(MetaClass type) {
        String name = this.shortLabel(type.getClassName());
        DocumentInfo defaultDocumentInfo = new DocumentInfo(name);
        defaultDocumentInfo.setIconMetaClass(type);
        return defaultDocumentInfo;
    }

    private DocumentInfo defaultInfo(String type) {
        String name = this.shortLabel(type);
        DocumentInfo defaultDocumentInfo = new DocumentInfo(name);
        return defaultDocumentInfo;
    }

    private String shortLabel(String label) {
        int index = label.lastIndexOf(46);
        if (index < 0) {
            return label;
        }
        return label.substring(index + 1, label.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getExtensionToContentTypeMapImpl(Map ctMap) {
        Map extensionToContentTypeMap;
        Map map = extensionToContentTypeMap = Recognizer.getExtensionToContentTypeMap();
        synchronized (map) {
            for (Map.Entry entry : extensionToContentTypeMap.entrySet()) {
                File fileExtension = (File)entry.getKey();
                ContentType contentType = (ContentType)entry.getValue();
                if (fileExtension == null || contentType == null || ctMap.containsKey(fileExtension.getPath())) continue;
                ctMap.put(fileExtension.getPath(), contentType.name());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setExtensionToContentTypeMapImpl(Map ctMap) {
        if (ctMap == null) {
            return;
        }
        for (Map.Entry entry : ctMap.entrySet()) {
            Map extensionToContentTypeMap;
            File fileExtension = Recognizer.sanitizeExtension((String)entry.getKey());
            String contentType = (String)entry.getValue();
            if (fileExtension == null || contentType == null) continue;
            Map map = extensionToContentTypeMap = Recognizer.getExtensionToContentTypeMap();
            synchronized (map) {
                extensionToContentTypeMap.put(fileExtension, ContentType.valueOf(contentType));
            }
        }
    }

    @Deprecated
    public static final DocumentInfo findRecognizerDocumentInfo(Class docClass) {
        return Recognizer.getDocumentInfo(docClass);
    }

    @Deprecated
    public static final ContentType findContentTypeFromExtension(String ext) {
        return FileTypesRecognizer.getNonNullContentTypeForExtension(ext);
    }

    @Deprecated
    public static final ContentType findRecognizerContentType(String ext) {
        return Recognizer.getContentTypeForExtension(ext);
    }

    public static class ExtInfo
    implements Copyable {
        private boolean _locked;
        private String _extension;
        private boolean _associated;

        public ExtInfo() {
        }

        public ExtInfo(String extension) {
            this(extension, false);
        }

        public ExtInfo(String extension, boolean locked) {
            this._extension = DocRecord.sanitizeExtensionAsString(extension);
            this._locked = locked;
            this._associated = false;
        }

        public void setLocked(boolean locked) {
            this._locked = locked;
        }

        public boolean isLocked() {
            return this._locked;
        }

        public boolean isAssociated() {
            return this._associated;
        }

        public String getExtension() {
            return this._extension;
        }

        public void setExtension(String extension) {
            this._extension = extension;
        }

        public void setAssociated(boolean associated) {
            this._associated = associated;
        }

        public Object copyTo(Object target) {
            ExtInfo copy = target != null ? (ExtInfo)target : new ExtInfo();
            this.copyToImpl(copy);
            return copy;
        }

        protected final void copyToImpl(ExtInfo copy) {
            copy._extension = this._extension;
            copy._locked = this._locked;
            copy._associated = this._associated;
        }

        public String toString() {
            return this._extension;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object o) {
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            return this.equalsImpl((ExtInfo)o);
        }

        protected final boolean equalsImpl(ExtInfo other) {
            return other._extension.equals(this._extension);
        }
    }

    public static class DocRecord
    implements Copyable {
        private Class _docClass;
        private MetaClass<?> _docMetaClass;
        private String _docClassName;
        private Icon _icon;
        private DocumentInfo _info;
        private String _label;
        private final List<ExtInfo> _ideExtensions = Collections.synchronizedList(new ArrayList());
        private final List<ExtInfo> _userExtensions = Collections.synchronizedList(new ArrayList());
        private boolean _isDocClassInitialized;

        boolean isDocClassInitialized() {
            return this._isDocClassInitialized;
        }

        public DocRecord() {
        }

        public DocRecord(Class docClass, DocumentInfo info) {
            this._docClass = docClass;
            this._docClassName = docClass.getName();
            this._isDocClassInitialized = true;
            this._info = info;
            if (info != null) {
                this._label = info.getLabel();
            }
            if (this._label == null) {
                this._label = docClass.getName();
            }
        }

        DocRecord(MetaClass<?> docMetaClass, DocumentInfo info) {
            this._docMetaClass = docMetaClass;
            this._docClassName = docMetaClass.getClassName();
            this._info = info;
            if (info != null) {
                this._label = info.getLabel();
            }
            if (this._label == null) {
                this._label = docMetaClass.getClassName();
            }
        }

        public static String sanitizeExtensionAsString(String extension) {
            return Recognizer.sanitizeExtension(extension).getPath();
        }

        public ExtInfo addIdeExtension(String extension) {
            ExtInfo extInfo = new ExtInfo(extension, true);
            int index = this._ideExtensions.indexOf(extInfo);
            if (index < 0) {
                this._ideExtensions.add(extInfo);
                return extInfo;
            }
            return this._ideExtensions.get(index);
        }

        public ExtInfo addUserExtension(String extension) {
            ExtInfo extInfo = new ExtInfo(extension, false);
            int index = this._userExtensions.indexOf(extInfo);
            if (index < 0) {
                this._userExtensions.add(extInfo);
                return extInfo;
            }
            return this._userExtensions.get(index);
        }

        public ExtInfo removeUserExtension(String extension) {
            ExtInfo extInfo = new ExtInfo(extension);
            int index = this._userExtensions.indexOf(extInfo);
            if (index < 0) {
                return null;
            }
            extInfo = this._userExtensions.get(index);
            this._userExtensions.remove(index);
            return extInfo;
        }

        public Icon getIcon() {
            if (this._info != null) {
                this._icon = this._info.getIcon();
                this._info = null;
            }
            return this._icon;
        }

        public String getLabel() {
            return this._label;
        }

        public Class getDocClass() {
            if (!this._isDocClassInitialized) {
                this._isDocClassInitialized = true;
                try {
                    MetaClass<?> docMetaClass = this.getDocMetaClass();
                    if (docMetaClass != null) {
                        this._docClass = docMetaClass.toClass();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return this._docClass;
        }

        MetaClass<?> getDocMetaClass() {
            MetaClass<?> metaClass = this._docMetaClass;
            try {
                if (metaClass == null) {
                    for (MetaClass<?> mc : Recognizer.getDeclarativeExtensionToClassMap().values()) {
                        if (!mc.getClassName().equals(this._docClassName)) continue;
                        metaClass = mc;
                        break;
                    }
                }
                if (metaClass == null) {
                    metaClass = MetaClass.newMetaClass(Class.forName(this._docClassName));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return metaClass;
        }

        public List getExtensions() {
            ArrayList<ExtInfo> extensions = new ArrayList<ExtInfo>();
            extensions.addAll(this._userExtensions);
            extensions.addAll(this._ideExtensions);
            return extensions;
        }

        public boolean isExtensionInUse(String ext) {
            ExtInfo extInfo = new ExtInfo(ext);
            return this._userExtensions.contains(extInfo) || this._ideExtensions.contains(extInfo);
        }

        public List getUserExtensions() {
            return new ArrayList<ExtInfo>(this._userExtensions);
        }

        public void setUserExtensions(List extensions) {
            this._userExtensions.clear();
            this._userExtensions.addAll(extensions);
        }

        public String getDocClassName() {
            return this._docClassName;
        }

        public void setDocClassName(String docClassName) {
            this._docClassName = docClassName;
        }

        public Object copyTo(Object target) {
            DocRecord copy = target != null ? (DocRecord)target : new DocRecord();
            this.copyToImpl(copy);
            return copy;
        }

        protected final void copyToImpl(DocRecord copy) {
            copy._docClass = this._docClass;
            copy._docClassName = this._docClassName;
            copy._icon = this._icon;
            copy._label = this._label;
            copy._info = this._info;
            copy._ideExtensions.clear();
            ModelUtil.deepCopy(this._ideExtensions, copy._ideExtensions);
            copy._userExtensions.clear();
            ModelUtil.deepCopy(this._userExtensions, copy._userExtensions);
        }

        public String toString() {
            return this._label;
        }

        public boolean equals(Object o) {
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            return this.equalsImpl((DocRecord)o);
        }

        protected final boolean equalsImpl(DocRecord other) {
            return other._docClass == this._docClass && ModelUtil.areEqual(other._userExtensions, this._userExtensions);
        }
    }
}

