/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.config;

import java.awt.Color;
import java.net.URL;
import javax.ide.util.Version;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.config.ChangeEventSource;
import oracle.ide.migration.MigrationManager;
import oracle.ide.resource.EnvironOptionsArb;
import oracle.ide.util.Encodings;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.marshal.TransientMarker;
import oracle.javatools.util.Copyable;

public final class EnvironOptions
extends ChangeEventSource
implements Copyable {
    public static final String KEY_SETTINGS = "environment-options";
    private static final String LOG_FILE_PREFIX = "logFilePrefix";
    private static final String SAVE_LOG_TO_FILE = "saveLogToFile";
    private static final String WRAP_LOG_LINES = "wrapLogLines";
    private static final String AUTO_RELOAD_EXT_MOD = "autoReloadExtMod";
    private static final String SILENT_RELOAD = "silentReload";
    private static final String UNDO_LEVEL = "undoLevel";
    private static final String NAVIGATION_LEVEL = "navigationLevel";
    private static final String MAX_LOG_LINES = "maxLogLines";
    private static final String LAF_CLASS = "lafClass";
    private static final String LAF_THEME_CLASS = "lafThemeClass";
    private static final String SAVE_BEFORE_COMPILE = "saveBeforeCompile";
    private static final String CLEAR_COMPILER_LOG_BEFORE_COMPILE = "clearCompilerLogBeforeCompile";
    private static final String SAVE_ON_DEACTIVATION = "saveOnDeactivation";
    private static final String SHOW_COMPILE_PROGRESS = "showCompileProgress";
    private static final String CLEAN_PROJECT_BEFORE_REBUILD = "cleanProjectBeforeRebuild";
    private static final String BUILD_AFTER_SAVE = "buildAfterSave";
    private static final String BUILD_DEPENDENTS_AFTER_SAVE = "buildDependentsAfterSave";
    private static final String FLOAT_ON_TOP = "floatOnTop";
    private static final String REMEMBER_NAVIGATOR_EXPANSION_STATE = "rememberNavigatorExpansionState";
    private static final String INTERNAL_ENCODING = "internalEncoding";
    private static final String LINE_TERMINATOR = "lineTerminator";
    public static final int EOL_PLATFORM = 0;
    public static final int EOL_WINDOWS = 1;
    public static final int EOL_UNIX = 2;
    public static final int EOL_MACINTOSH = 3;
    private static final String LOG_HREF_COLOR = "logHrefColor";
    private static final String VERIFY_CACHED_FILE_DATA = "verifyICachedFileData";
    private static final String LOG_SYSTEM_OUT_COLOR = "logSystemOutColor";
    private static final String LOG_SYSTEM_ERR_COLOR = "logSystemErrColor";
    private static final String LOG_SYSTEM_IN_COLOR = "logSystemInColor";

    public EnvironOptions() {
    }

    private EnvironOptions(HashStructure hash) {
        super(hash);
    }

    public static EnvironOptions getInstance(PropertyStorage prefs) {
        return new EnvironOptions(prefs.getProperties().getOrCreateHashStructure(KEY_SETTINGS));
    }

    public void adjustAfterMigration() {
        Version sourceVersion;
        MigrationManager manager;
        if (this.getUndoLevel() == 500) {
            this._hash.remove(UNDO_LEVEL);
        }
        if (this.getNavigationLevel() == 100) {
            this._hash.remove(NAVIGATION_LEVEL);
        }
        if ((manager = MigrationManager.getMigrationManager()) != null && (sourceVersion = manager.getSourceVersion()) != null && sourceVersion.compareTo(new Version("11.1.2.0.0")) < 0 && this._hash.getObject(VERIFY_CACHED_FILE_DATA) == null) {
            this._hash.putBoolean(VERIFY_CACHED_FILE_DATA, true);
        }
    }

    public URL getLogFilePrefix() {
        return this._hash.getURL(LOG_FILE_PREFIX, null);
    }

    public void setLogFilePrefix(URL logFilePrefix) {
        this._hash.putURL(LOG_FILE_PREFIX, logFilePrefix);
    }

    public boolean isSaveLogToFile() {
        return this._hash.getBoolean(SAVE_LOG_TO_FILE, false);
    }

    public void setSaveLogToFile(boolean saveLogToFile) {
        this._hash.putBoolean(SAVE_LOG_TO_FILE, saveLogToFile);
    }

    public boolean isWrapLogLines() {
        return this._hash.getBoolean(WRAP_LOG_LINES, false);
    }

    public void setWrapLogLines(boolean wrapLogLines) {
        this._hash.putBoolean(WRAP_LOG_LINES, wrapLogLines);
    }

    public boolean getAutoReloadExtMod() {
        return this._hash.getBoolean(AUTO_RELOAD_EXT_MOD, true);
    }

    public void setAutoReloadExtMod(boolean autoReloadExtMod) {
        this._hash.putBoolean(AUTO_RELOAD_EXT_MOD, autoReloadExtMod);
    }

    public boolean getSilentReload() {
        return this._hash.getBoolean(SILENT_RELOAD, true);
    }

    public void setSilentReload(boolean silentReload) {
        this._hash.putBoolean(SILENT_RELOAD, silentReload);
    }

    public int getUndoLevel() {
        return this._hash.getInt(UNDO_LEVEL, 50);
    }

    public void setUndoLevel(int undoLevel) {
        this._hash.putInt(UNDO_LEVEL, undoLevel);
    }

    public int getNavigationLevel() {
        return this._hash.getInt(NAVIGATION_LEVEL, 20);
    }

    public void setNavigationLevel(int navigationLevel) {
        this._hash.putInt(NAVIGATION_LEVEL, navigationLevel);
    }

    public int getMaxLogLines() {
        return this._hash.getInt(MAX_LOG_LINES, 3000);
    }

    public void setMaxLogLines(int maxLogLines) {
        this._hash.putInt(MAX_LOG_LINES, maxLogLines);
    }

    public String getLafClass() {
        return this._hash.getString(LAF_CLASS, "");
    }

    public void setLafClass(String lafClass) {
        this._hash.putString(LAF_CLASS, lafClass);
    }

    public String getLafThemeClass() {
        return this._hash.getString(LAF_THEME_CLASS, "");
    }

    public void setLafThemeClass(String lafThemeClass) {
        this._hash.putString(LAF_THEME_CLASS, lafThemeClass);
    }

    public boolean getSaveBeforeCompile() {
        return this._hash.getBoolean(SAVE_BEFORE_COMPILE, true);
    }

    public void setSaveBeforeCompile(boolean saveBeforeCompile) {
        this._hash.putBoolean(SAVE_BEFORE_COMPILE, saveBeforeCompile);
    }

    public boolean getClearCompilerLogBeforeCompile() {
        return this._hash.getBoolean(CLEAR_COMPILER_LOG_BEFORE_COMPILE, true);
    }

    public void setClearCompilerLogBeforeCompile(boolean clearLog) {
        this._hash.putBoolean(CLEAR_COMPILER_LOG_BEFORE_COMPILE, clearLog);
    }

    public boolean getSaveOnDeactivation() {
        return this._hash.getBoolean(SAVE_ON_DEACTIVATION, false);
    }

    public void setSaveOnDeactivation(boolean saveOnDeactivation) {
        this._hash.putBoolean(SAVE_ON_DEACTIVATION, saveOnDeactivation);
    }

    public boolean getShowCompileProgress() {
        return this._hash.getBoolean(SHOW_COMPILE_PROGRESS, true);
    }

    public void setShowCompileProgress(boolean showCompileProgress) {
        this._hash.putBoolean(SHOW_COMPILE_PROGRESS, showCompileProgress);
    }

    public boolean getCleanProjectBeforeRebuild() {
        return this._hash.getBoolean(CLEAN_PROJECT_BEFORE_REBUILD, true);
    }

    public void setCleanProjectBeforeRebuild(boolean cleanProjectBeforeRebuild) {
        this._hash.putBoolean(CLEAN_PROJECT_BEFORE_REBUILD, cleanProjectBeforeRebuild);
    }

    @Deprecated
    public boolean getBuildAfterSave() {
        return this._hash.getBoolean(BUILD_AFTER_SAVE, true);
    }

    @Deprecated
    public void setBuildAfterSave(boolean buildAfterSave) {
        this._hash.putBoolean(BUILD_AFTER_SAVE, buildAfterSave);
    }

    @Deprecated
    public boolean getBuildDependentsAfterSave() {
        return this._hash.getBoolean(BUILD_DEPENDENTS_AFTER_SAVE, false);
    }

    @Deprecated
    public void setBuildDependentsAfterSave(boolean buildDependentsAfterSave) {
        this._hash.putBoolean(BUILD_DEPENDENTS_AFTER_SAVE, buildDependentsAfterSave);
    }

    public boolean isFloatOnTop() {
        return this._hash.getBoolean(FLOAT_ON_TOP, true);
    }

    public void setFloatOnTop(boolean floatOnTop) {
        this._hash.putBoolean(FLOAT_ON_TOP, floatOnTop);
    }

    public boolean isRememberNavigatorExpansionState() {
        return this._hash.getBoolean(REMEMBER_NAVIGATOR_EXPANSION_STATE, true);
    }

    public void setRememberNavigatorExpansionState(boolean expand) {
        this._hash.putBoolean(REMEMBER_NAVIGATOR_EXPANSION_STATE, expand);
    }

    public String getEncoding() throws TransientMarker {
        String encoding = this.getInternalEncoding();
        return encoding != null ? encoding : Encodings.getDefaultEncoding();
    }

    public void setEncoding(String encoding) {
        this.setInternalEncoding(encoding);
    }

    public String getInternalEncoding() {
        return this._hash.getString(INTERNAL_ENCODING, null);
    }

    public void setInternalEncoding(String encoding) {
        this._hash.putString(INTERNAL_ENCODING, encoding);
    }

    public int getLineTerminator() {
        return EnvironOptions.sanitizeLineTerminator(this._hash.getInt(LINE_TERMINATOR, 0));
    }

    public String getLineBreakSequence() {
        switch (this.getLineTerminator()) {
            case 1: {
                return "\r\n";
            }
            case 2: {
                return "\n";
            }
            case 3: {
                return "\r";
            }
        }
        return System.getProperty("line.separator");
    }

    public void setLineTerminator(int lineTerminator) {
        this._hash.putInt(LINE_TERMINATOR, EnvironOptions.sanitizeLineTerminator(lineTerminator));
    }

    private static int sanitizeLineTerminator(int lineTerminator) {
        return lineTerminator >= 0 && lineTerminator <= 3 ? lineTerminator : 0;
    }

    public int getLogHrefColor() {
        return this._hash.getInt(LOG_HREF_COLOR, Color.blue.getRGB());
    }

    public void setLogHrefColor(int logHrefColor) {
        this._hash.putInt(LOG_HREF_COLOR, logHrefColor);
    }

    public boolean getVerifyCachedFileData() {
        return this._hash.getBoolean(VERIFY_CACHED_FILE_DATA, false);
    }

    public void setVerifyCachedFileData(boolean verify) {
        this._hash.putBoolean(VERIFY_CACHED_FILE_DATA, verify);
    }

    public int getLogSystemOutColor() {
        return this._hash.getInt(LOG_SYSTEM_OUT_COLOR, -16777012);
    }

    public void setLogSystemOutColor(int logSystemOutColor) {
        this._hash.putInt(LOG_SYSTEM_OUT_COLOR, logSystemOutColor);
    }

    public int getLogSystemErrColor() {
        return this._hash.getInt(LOG_SYSTEM_ERR_COLOR, -3407872);
    }

    public void setLogSystemErrColor(int logSystemErrColor) {
        this._hash.putInt(LOG_SYSTEM_ERR_COLOR, logSystemErrColor);
    }

    public int getLogSystemInColor() {
        return this._hash.getInt(LOG_SYSTEM_IN_COLOR, -16738048);
    }

    public void setLogSystemInColor(int logSystemInColor) {
        this._hash.putInt(LOG_SYSTEM_IN_COLOR, logSystemInColor);
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        return this.equalsImpl((EnvironOptions)((Object)o));
    }

    protected final boolean equalsImpl(EnvironOptions opts) {
        return this._hash.equals((Object)opts._hash);
    }

    @Deprecated
    public URL getLogFilePreffix() {
        return this.getLogFilePrefix();
    }

    @Deprecated
    public void setLogFilePreffix(URL logFilePreffix) {
        this.setLogFilePrefix(logFilePreffix);
    }

    @Deprecated
    public static String getLabelLogPreffix() {
        return EnvironOptionsArb.getString(9);
    }

    @Deprecated
    public static String getLabelBrowse() {
        return EnvironOptionsArb.getString(10);
    }

    @Deprecated
    public static String getLabelSaveLogToFile() {
        return EnvironOptionsArb.getString(8);
    }

    @Deprecated
    public static String getLabelShowSplashScreen() {
        return EnvironOptionsArb.getString(2);
    }

    @Deprecated
    public static String getLabelAutoReloadExtMod() {
        return EnvironOptionsArb.getString(3);
    }

    @Deprecated
    public static String getLabelSilentReload() {
        return EnvironOptionsArb.getString(4);
    }

    @Deprecated
    public static String getLabelUndoLevel() {
        return EnvironOptionsArb.getString(12);
    }

    @Deprecated
    public static String getLabelNavigationLevel() {
        return EnvironOptionsArb.getString(32);
    }

    @Deprecated
    public static String getLabelMaxLogLines() {
        return EnvironOptionsArb.getString(11);
    }

    @Deprecated
    public static String getLabelLookAndFeel() {
        return EnvironOptionsArb.getString(5);
    }

    @Deprecated
    public static String getLabelTheme() {
        return EnvironOptionsArb.getString(6);
    }

    @Deprecated
    public static String getLabelFloatOnTop() {
        return EnvironOptionsArb.getString(17);
    }

    @Deprecated
    public static String getLabelSaveBeforeCompile() {
        return EnvironOptionsArb.getString(13);
    }

    @Deprecated
    public static String getLabelClearCompilerLogBeforeCompile() {
        return EnvironOptionsArb.getString(14);
    }

    @Deprecated
    public static String getLabelSaveOnDeactivation() {
        return EnvironOptionsArb.getString(15);
    }

    @Deprecated
    public static String getLabelShowCompileProgress() {
        return EnvironOptionsArb.getString(16);
    }

    @Deprecated
    public static String getLabelEncoding() {
        return EnvironOptionsArb.getString(18);
    }

    @Deprecated
    public static String getLabelUseDefaultEncoding() {
        return EnvironOptionsArb.format(19, Encodings.getDefaultEncoding());
    }

    @Deprecated
    public static String getLabelLogHrefColor() {
        return EnvironOptionsArb.getString(26);
    }

    @Deprecated
    public static String getLabelLogSystemOutColor() {
        return EnvironOptionsArb.getString(27);
    }

    @Deprecated
    public static String getLabelLogSystemErrColor() {
        return EnvironOptionsArb.getString(28);
    }

    @Deprecated
    public static String getLabelLogSystemInColor() {
        return EnvironOptionsArb.getString(29);
    }

    @Deprecated
    public static String getLabelResetSkippedMessages() {
        return EnvironOptionsArb.getString(33);
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        this._hash.addStructureChangeListener((StructureChangeListener)new ChangeToStructureChangeListenerAdaptor(l));
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        this._hash.removeStructureChangeListener((StructureChangeListener)new ChangeToStructureChangeListenerAdaptor(l));
    }

    private class ChangeToStructureChangeListenerAdaptor
    extends StructureChangeListener {
        private final ChangeListener _listener;

        private ChangeToStructureChangeListenerAdaptor(ChangeListener l) {
            this._listener = l;
        }

        public void structureValuesChanged(StructureChangeEvent e) {
            this._listener.stateChanged(new ChangeEvent((Object)EnvironOptions.this));
        }
    }
}

