/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.config;

import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.ide.util.MetaClass;
import oracle.ide.config.Preferences;
import oracle.ide.model.ContentType;
import oracle.ide.model.Node;
import oracle.ide.model.Recognizer;
import oracle.ide.net.URLFileSystem;
import oracle.ideimpl.config.FileTypesClosure;
import oracle.ideimpl.config.FileTypesPrefs;

public final class FileTypesRecognizer
extends Recognizer {
    public static final Collection<File> allMappedExtensionsToNodes() {
        HashSet<File> allExtensions = new HashSet<File>();
        allExtensions.addAll(Recognizer.getExtensionToMetaClassMap().keySet());
        allExtensions.addAll(Recognizer.getDeclarativeExtensionToClassMap().keySet());
        for (String extension : FileTypesPrefs.getInstance(Preferences.getPreferences()).getFileExtensions()) {
            allExtensions.add(FileTypesRecognizer.sanitizeExtension(extension));
        }
        return Collections.unmodifiableCollection(allExtensions);
    }

    public static final boolean isCustomMappedExtension(String extension) {
        FileTypesPrefs fileTypes = FileTypesPrefs.getInstance(Preferences.getPreferences());
        return fileTypes.getFileExtensions().contains(extension);
    }

    public static final void mapCustomExtensionToClass(String extension, String nodeClassName) {
        if (extension.equals("")) {
            return;
        }
        FileTypesPrefs fileTypes = FileTypesPrefs.getInstance(Preferences.getPreferences());
        fileTypes.setNodeType(Recognizer.sanitizeExtension(extension).getPath(), nodeClassName);
    }

    public static final void mapCustomExtensionToContentType(String extension, ContentType contentType) {
        if (extension.equals("")) {
            return;
        }
        FileTypesPrefs fileTypes = FileTypesPrefs.getInstance(Preferences.getPreferences());
        fileTypes.setContentType(Recognizer.sanitizeExtension(extension).getPath(), contentType.name());
    }

    public static final Set<String> getNodeExtensions(Class[] nodeClasses) {
        HashSet<String> extensions = new HashSet<String>();
        for (int i = 0; i < nodeClasses.length; ++i) {
            extensions.addAll(FileTypesRecognizer.getNodeExtensions(nodeClasses[i]));
        }
        return Collections.unmodifiableSet(extensions);
    }

    public static final Set<String> getNodeExtensions(Class nodeClass) {
        return FileTypesRecognizer.getNodeExtensions(nodeClass.getName());
    }

    public static final Set<String> getNodeExtensions(final String nodeClass) {
        final HashSet<String> extensions = new HashSet<String>();
        new FileTypesClosure(Preferences.getPreferences()){

            @Override
            protected void runImpl(String ext, String docClass, boolean custom) {
                if (nodeClass.equals(docClass)) {
                    extensions.add(ext);
                }
            }
        }.run();
        return extensions;
    }

    public static final String getClassNameForExtension(String extension) {
        if (extension == null || extension.length() <= 0) {
            throw new IllegalArgumentException();
        }
        File fileExtension = FileTypesRecognizer.sanitizeExtension(extension);
        String nodeType = FileTypesPrefs.getInstance(Preferences.getPreferences()).getNodeType(fileExtension.getPath());
        if (nodeType != null) {
            return nodeType;
        }
        MetaClass<?> nodeMetaType = Recognizer.getDeclarativeExtensionToClassMap().get(fileExtension);
        if (nodeMetaType != null) {
            return nodeMetaType.getClassName();
        }
        Map<File, MetaClass> extensionToClassMap = Recognizer.getExtensionToMetaClassMap();
        MetaClass nodeType2 = extensionToClassMap.get(fileExtension);
        return nodeType2 != null ? nodeType2.getClassName() : null;
    }

    public static final ContentType getNonNullContentTypeForExtension(String extension) {
        ContentType contentType = FileTypesRecognizer.getContentTypeForExtension(extension);
        return contentType != null ? contentType : ContentType.TEXT;
    }

    public static final ContentType getContentTypeForExtension(String extension) {
        if (extension == null || extension.length() <= 0) {
            return null;
        }
        File fileExtension = FileTypesRecognizer.sanitizeExtension(extension);
        Object contentType = FileTypesPrefs.getInstance(Preferences.getPreferences()).getContentType(fileExtension.getPath());
        if (contentType != null) {
            return ContentType.valueOf((String)contentType);
        }
        contentType = Recognizer.getDeclarativeExtensionToContentTypeMap().get(fileExtension);
        if (contentType != null) {
            return contentType;
        }
        Map extensionToContentTypeMap = Recognizer.getExtensionToContentTypeMap();
        return (ContentType)extensionToContentTypeMap.get(fileExtension);
    }

    @Override
    public final Class<? extends Node> recognize(URL url) {
        String nodeType;
        String extension = URLFileSystem.getSuffix((URL)url);
        File fileExtension = new File(extension);
        if (extension != null && extension.length() > 0 && (nodeType = FileTypesPrefs.getInstance(Preferences.getPreferences()).getNodeType(fileExtension.getPath())) != null) {
            MetaClass<?> nodeMetaType = null;
            for (MetaClass<?> currentNodeMetaType : Recognizer.getDeclarativeExtensionToClassMap().values()) {
                if (!currentNodeMetaType.getClassName().equals(nodeType)) continue;
                nodeMetaType = currentNodeMetaType;
                break;
            }
            try {
                return nodeMetaType != null ? nodeMetaType.toClass() : Class.forName(nodeType);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }
}

