/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.config;

import java.awt.Component;
import java.awt.Frame;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.config.ClientSetting;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.ExtensionNavigable;
import oracle.ide.config.ExtensionSettingsPage;
import oracle.ide.config.GlobalIgnoreList;
import oracle.ide.config.Preferences;
import oracle.ide.config.SettingsUIRegistry;
import oracle.ide.dialogs.DialogRunnerCallback;
import oracle.ide.dialogs.SizeKeeperCallback;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.MDDPanel;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.NavigableRegistry;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.resource.EnvironOptionsArb;
import oracle.ide.resource.ExtensionBundle;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.Assert;
import oracle.ide.util.Namespace;
import oracle.ide.xml.XMLUtil;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.marshal.TransientMarker;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.PlatformUtils;

public class IdeSettings
implements Copyable {
    public static final String FILENAME = "settings.xml";
    public static final String DATA_KEY = "ide-options";
    public static final String NAMESPACE_URI = XMLUtil.toNamespaceURI((String)"ide-preferences");
    public static final String ROOT_TAG = "ide-settings";
    private static final NavigableRegistry _registry = new NavigableRegistry();
    private HashMap _configData = new HashMap();
    private HashMap _clientSettings = new HashMap();
    private HashMap _legacyConfigData = new HashMap();
    private static String[] _oldPath = null;
    private transient boolean _askExit;
    private static final String EXTENSION_DIALOG_ID = "/preferences";
    private static final String ENVIRONMENT_PAGE_ID = "environment";
    private static boolean _loadedExtensionPages = false;
    private static Navigable _environNavigable = null;
    private static boolean _dialogShowing = false;

    public IdeSettings() {
    }

    public IdeSettings(IdeSettings ideSettings) {
        if (ideSettings != null) {
            ideSettings.copyToImpl(this);
        }
    }

    private IdeSettings(boolean initialize) {
        if (initialize) {
            this.init();
        }
    }

    public void register() {
    }

    public void init() {
        Preferences prefs = Preferences.getPreferences();
        this.putLegacyData("environment-options", EnvironOptions.getInstance(prefs));
        if (this.getData(KeyStrokeOptions.KEY_SETTINGS) == null) {
            this.setData(KeyStrokeOptions.KEY_SETTINGS, new KeyStrokeOptions());
        }
        if (this.getData("global-ignore-list") == null) {
            this.setData("global-ignore-list", new GlobalIgnoreList());
        }
    }

    public Object copyTo(Object target) {
        IdeSettings copy = target != null ? (IdeSettings)target : new IdeSettings(true);
        this.copyToImpl(copy);
        return copy;
    }

    protected final void copyToImpl(IdeSettings copy) {
        ModelUtil.deepCopy((Map)this._configData, (Map)copy._configData);
        ModelUtil.deepCopy((Map)this._clientSettings, (Map)copy._clientSettings);
        ModelUtil.deepCopy((Map)this._legacyConfigData, (Map)copy._legacyConfigData);
    }

    public static void registerUI(Navigable ui) {
        _registry.registerUI(ui);
    }

    public static void deregisterUI(Navigable ui) {
        _registry.deregisterUI(ui);
    }

    public static Navigable[] getNavigables() {
        return IdeSettings.getNavigablesInternal();
    }

    private static Navigable[] getNavigablesInternal() {
        if (!_loadedExtensionPages) {
            IdeSettings.loadExtensionPages();
        }
        return _registry.getNavigables();
    }

    private static void loadExtensionPages() {
        _loadedExtensionPages = true;
        Collection<Navigable> navigables = SettingsUIRegistry.getExtensionNavigables(EXTENSION_DIALOG_ID);
        for (Navigable n : navigables) {
            ExtensionSettingsPage page = ((ExtensionNavigable)n).getPage();
            if (ENVIRONMENT_PAGE_ID.equals(page.getId())) {
                _environNavigable = n;
            }
            IdeSettings.registerUI(n);
        }
    }

    public boolean isAskExit() {
        return this._askExit;
    }

    public void setAskExit(boolean askExit) {
        this._askExit = askExit;
    }

    public Navigable getEnvironNavigable() {
        if (_environNavigable == null) {
            IdeSettings.getNavigablesInternal();
        }
        if (_environNavigable == null) {
            return new Navigable(null, null);
        }
        return _environNavigable;
    }

    public boolean hasData(String dataKey) {
        if (this._legacyConfigData.get(dataKey) != null) {
            return true;
        }
        Object data = this._configData.get(dataKey);
        if (data instanceof URL) {
            return URLFileSystem.exists((URL)((URL)data));
        }
        return data != null;
    }

    public ClientSetting getClientSetting(String dataKey) throws TransientMarker {
        Object data = this._legacyConfigData.get(dataKey);
        if (data == null && (data = this._configData.get(dataKey)) instanceof URL) {
            ClientSetting setting = this.findClientSetting((URL)data);
            if (setting == null) {
                setting = new ClientSetting((URL)data);
                this._clientSettings.put(setting.getURL(), setting);
            }
            return setting;
        }
        return null;
    }

    public Object getData(String dataKey) throws TransientMarker {
        Object data = this._legacyConfigData.get(dataKey);
        if (data == null && (data = this._configData.get(dataKey)) instanceof URL) {
            ClientSetting setting = this.findClientSetting((URL)data);
            if (setting == null) {
                setting = new ClientSetting((URL)data);
                this._clientSettings.put(setting.getURL(), setting);
            }
            data = setting.getData(dataKey);
        }
        return data;
    }

    public Object getClass(String className, ClassLoader classloader) throws TransientMarker {
        Object data = this._legacyConfigData.get(className);
        if (data == null && (data = this._configData.get(className)) instanceof URL) {
            ClientSetting setting = this.findClientSetting((URL)data);
            if (setting == null) {
                setting = new ClientSetting((URL)data);
                this._clientSettings.put(setting.getURL(), setting);
            }
            setting.setClassLoader(classloader);
            data = setting.getData(className);
        }
        return data;
    }

    public void putData(String dataKey, Copyable data) {
        this.setData(dataKey, data);
    }

    public void putLegacyData(String dataKey, Copyable data) {
        if (data != null) {
            Object existingData = this.getData(dataKey);
            if (existingData != null) {
                try {
                    Map clientMap;
                    ClientSetting setting;
                    ((Copyable)existingData).copyTo((Object)data);
                    Object oldData = this._configData.get(dataKey);
                    if (oldData instanceof URL && (setting = this.findClientSetting((URL)oldData)) != null && (clientMap = setting.getClientData()) != null) {
                        clientMap.remove(dataKey);
                    }
                    this._configData.remove(dataKey);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this._legacyConfigData.put(dataKey, data);
        }
    }

    public void removeLegacyData(String dataKey) {
        this._legacyConfigData.remove(dataKey);
    }

    public KeyStrokeOptions getKeyStrokeOptions() {
        return (KeyStrokeOptions)((Object)this.getData(KeyStrokeOptions.KEY_SETTINGS));
    }

    public boolean save() {
        Assert.startTiming((String)(this.getClass().getName() + ".save"), null, (boolean)false);
        boolean result = false;
        try {
            URL url = IdeSettings.getConfigURL();
            Object2Dom o2d = Object2Dom.newInstance();
            o2d.setNamespaceURI(NAMESPACE_URI);
            o2d.toDocument((Object)this._configData, ROOT_TAG, url);
            this.saveClientSettings();
            result = true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Assert.endTiming((String)(this.getClass().getName() + ".save"), (String)"IdeSettings.save()", null, (boolean)false);
        return result;
    }

    public boolean load() {
        PerformanceLogger log = PerformanceLogger.get();
        log.startTiming("IdeSettings.load");
        boolean result = false;
        try {
            URL url = IdeSettings.getConfigURL();
            Object2Dom o2d = Object2Dom.newInstance();
            this._configData = (HashMap)o2d.toObject(url, this.getClass().getClassLoader());
            result = true;
        }
        catch (FileNotFoundException ex) {
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        log.stopTiming("IdeSettings.load", "IdeSettings.load()");
        return result;
    }

    public void showDialog(Frame parent) {
        IdeSettings.showDialog(parent, IdeSettings.createMDDPanel(), this, null);
    }

    public void showDialog(Frame parent, String[] selectionPath) {
        IdeSettings.showDialog(parent, IdeSettings.createMDDPanel(), this, selectionPath);
    }

    public void showDialog(Frame parent, MDDPanel panel, String[] selectionPath) {
        IdeSettings.showDialog(parent, panel, this, selectionPath);
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((IdeSettings)o);
    }

    protected final boolean equalsImpl(IdeSettings opt) {
        return ModelUtil.areEqual((Object)this._configData, (Object)opt._configData) && ModelUtil.areEqual((Object)this._clientSettings, (Object)opt._clientSettings) && ModelUtil.areEqual((Object)this._legacyConfigData, (Object)opt._legacyConfigData);
    }

    protected final void addClientSetting(ClientSetting setting) {
        this._clientSettings.put(setting.getURL(), setting);
    }

    void setData(String dataKey, Copyable data) {
        if (data == null) {
            throw new IllegalArgumentException();
        }
        if (data instanceof ClientSetting) {
            ClientSetting setting = (ClientSetting)data;
            this._configData.put(dataKey, setting.getURL());
            if (this.findClientSetting(setting.getURL()) == null) {
                this._clientSettings.put(setting.getURL(), setting);
            }
        } else {
            this._configData.put(dataKey, data);
            Assert.println((!"environment-options".equals(dataKey) && !KeyStrokeOptions.KEY_SETTINGS.equals(dataKey) && !"global-ignore-list".equals(dataKey) ? 1 : 0) != 0, (String)("Should use a ClientSetting object for SETTINGS CLASS: " + data.getClass().getName() + " KEY: " + dataKey));
        }
    }

    ClientSetting findClientSetting(URL url) {
        return (ClientSetting)this._clientSettings.get(url);
    }

    private void saveClientSettings() {
        for (ClientSetting setting : this._clientSettings.values()) {
            try {
                setting.save();
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
            }
        }
    }

    private static URL getConfigURL() {
        ExtensionRegistry er = ExtensionRegistry.getExtensionRegistry();
        URL url = er.getSystemDirectory("oracle.ide");
        return URLFactory.newURL((URL)url, (String)FILENAME);
    }

    private ClientSetting getClientSetting(URL url) {
        ClientSetting setting = this.findClientSetting(url);
        if (setting == null) {
            setting = new ClientSetting();
            setting.setURL(url);
            this._clientSettings.put(url, setting);
        }
        return setting;
    }

    private static Map getAllSettingsMap(IdeSettings ideSettings) {
        HashMap map = ideSettings._configData;
        HashSet<Object> set = new HashSet<Object>(map.size());
        Iterator entries = map.entrySet().iterator();
        HashMap rtn = new HashMap(map.size());
        rtn.putAll(ideSettings._legacyConfigData);
        set.addAll(ideSettings._legacyConfigData.keySet());
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            Object value = entry.getValue();
            if (value instanceof URL) {
                if (set.contains(value)) continue;
                ClientSetting clientSetting = ideSettings.getClientSetting((URL)value);
                rtn.putAll(clientSetting.getClientData());
                set.add(value);
                continue;
            }
            rtn.put(entry.getKey(), entry.getValue());
        }
        return rtn;
    }

    private static boolean showDialog(Frame parent, MDDPanel mddPanel, final IdeSettings ideSettings, String[] selectionPath) {
        if (_dialogShowing && PlatformUtils.isMac()) {
            return false;
        }
        _dialogShowing = true;
        mddPanel.setChildComparator((Comparator)new Navigable.NavigableComparator(ExtensionBundle.get("ENVIRONMENT_SETTINGS")));
        mddPanel.setDefaultChildComparator(Navigable.NAVIGABLE_COMPARATOR);
        mddPanel.setTitleDepth(2);
        IdeSettings copy = (IdeSettings)ideSettings.copyTo(null);
        final Namespace data = new Namespace();
        data.put(DATA_KEY, (Object)copy);
        final Preferences prefsCopy = (Preferences)((Object)Preferences.getPreferences().copyTo(null));
        StructureChangeListener scl = new StructureChangeListener(){

            public void structureValuesChanged(StructureChangeEvent e) {
                prefsCopy.getProperties().applyChanges(e.getChangeDetails());
            }
        };
        Preferences.getPreferences().addStructureChangeListener(scl);
        data.put("generic-PropertyStorage", (Object)prefsCopy);
        String title = EnvironOptionsArb.getString(0);
        TDialogLauncher launcher = new TDialogLauncher((Component)parent, title, (Traversable)mddPanel, data, (DialogRunnerCallback)new SizeKeeperCallback("panel.idesettings"));
        if (selectionPath != null) {
            String[] path = IdeSettings.convertIdToPath(selectionPath);
            if (path != null) {
                mddPanel.setTree1SelectionPath(path, true);
            }
        } else if (_oldPath == null) {
            mddPanel.setTree1SelectionRow(0);
        } else {
            mddPanel.setTree1SelectionPath(_oldPath);
        }
        boolean isOkResponse = launcher.showDialog();
        _oldPath = mddPanel.getTree1SelectionPath();
        Preferences.getPreferences().removeStructureChangeListener(scl);
        if (isOkResponse) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    boolean needsSave = false;
                    IdeSettings editedCopy = (IdeSettings)data.get(IdeSettings.DATA_KEY);
                    editedCopy.copyTo(ideSettings);
                    ideSettings.save();
                    needsSave = true;
                    Preferences editedPrefsCopy = (Preferences)((Object)data.get("generic-PropertyStorage"));
                    if (editedPrefsCopy.isDirty()) {
                        Preferences realPrefs = Preferences.getPreferences();
                        editedPrefsCopy.copyTo((Object)realPrefs);
                        needsSave = true;
                    }
                    if (needsSave) {
                        try {
                            Preferences.getPreferences().save();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (editedCopy.isAskExit() && IdeSettings.confirmRestart()) {
                        try {
                            Ide.restart();
                        }
                        catch (UnsupportedOperationException uoe) {
                            MessageDialog.error((Component)((Object)Ide.getMainWindow()), (Object)IdeArb.getString(452), (String)IdeArb.getString(451), null);
                        }
                    }
                }
            });
        }
        _dialogShowing = false;
        return isOkResponse;
    }

    private static void convertIdToPathInternal(Navigable[] navigables, List<String> paths, int index) {
        if (index < paths.size()) {
            String item = paths.get(index);
            for (Navigable navigable : navigables) {
                ExtensionSettingsPage page = ((ExtensionNavigable)navigable).getPage();
                String id = page.getId();
                String label = page.getLabel();
                if (item != id && item != label) continue;
                paths.set(index, page.getLabel());
                Navigable[] children = navigable.getChildren();
                if (children == null) break;
                IdeSettings.convertIdToPathInternal(children, paths, index + 1);
                break;
            }
        }
    }

    private static String[] convertIdToPath(String[] paths) {
        String[] result = null;
        Collection<Navigable> navigables = SettingsUIRegistry.getExtensionNavigables(EXTENSION_DIALOG_ID);
        if (navigables != null) {
            Navigable[] lnavigables = new Navigable[navigables.size()];
            navigables.toArray(lnavigables);
            LinkedList<String> lpaths = new LinkedList<String>();
            for (String item : paths) {
                lpaths.add(item);
            }
            IdeSettings.convertIdToPathInternal(lnavigables, lpaths, 0);
            if (lpaths.size() > 0) {
                result = new String[lpaths.size()];
                lpaths.toArray(result);
            }
        }
        return result;
    }

    private static boolean confirmRestart() {
        return MessageDialog.confirm((Component)((Object)Ide.getMainWindow()), (Object)IdeArb.getString(450), (String)IdeArb.getString(449), null);
    }

    private static MDDPanel createMDDPanel() {
        return new MDDPanel(IdeSettings.getNavigablesInternal());
    }
}

