/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controller;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.Extension;
import javax.ide.menu.ActionRegistry;
import javax.ide.menu.ItemFactory;
import javax.ide.menu.spi.Item;
import javax.ide.menu.spi.MenuHook;
import javax.ide.menu.spi.MenuModel;
import javax.ide.menu.spi.Section;
import javax.ide.menu.spi.ToolbarVisitorListener;
import javax.ide.util.MetaClass;
import javax.ide.view.GUIPanel;
import javax.naming.Context;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import oracle.ide.Addin;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.controller.ActionFilter;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.MenuToolButton;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.view.View;
import oracle.ide.view.ViewEvent;
import oracle.ide.view.ViewListener;
import oracle.javatools.jndi.Names;

public abstract class ToolbarManager
implements Addin {
    private static final String TOOLBAR_MGR_NAME = "ide/toolbar-manager";
    private static final String DECLARATIVE_BUTTON_KEY = "declarative-button";
    private TBRegHandler _tbRegHandler;
    private final ArrayList<ActionFilter> _filters = new ArrayList();
    private boolean _reportItemFactoryUsageErrors = true;
    private static final Logger LOGGER = Logger.getLogger(ToolbarManager.class.getName());

    public static ToolbarManager getToolbarManager() {
        return (ToolbarManager)Names.lookup((Context)Names.newInitialContext(), (String)TOOLBAR_MGR_NAME);
    }

    public static void setToolbarManager(ToolbarManager manager) {
        Names.bind((Context)Names.newInitialContext(), (String)TOOLBAR_MGR_NAME, (Object)manager);
    }

    public void registerOnDemandToolbar(final String toolbarId, final Toolbar toolbar, final View view) {
        TBRegHandler internalListener = this.getTBRegHandler();
        internalListener.register(toolbarId, toolbar, view);
        this.installToolbarImpl(toolbarId, toolbar, view);
        if (view != null) {
            view.addViewListener(new ViewListener(){

                @Override
                public void viewActivated(ViewEvent e) {
                }

                @Override
                public void viewDeactivated(ViewEvent e) {
                }

                @Override
                public void viewClosed(ViewEvent e) {
                    ToolbarManager.this.unRegisterOnDemandToolbar(toolbarId, toolbar);
                    view.removeViewListener(this);
                }
            });
        }
    }

    public void unRegisterOnDemandToolbar(String toolbarId, Toolbar toolbar) {
        this.getTBRegHandler().unRegister(toolbarId, toolbar);
    }

    @Deprecated
    public void installToolbar(String toolbarId, Toolbar toolbar, View view) {
        this.registerOnDemandToolbar(toolbarId, toolbar, view);
    }

    protected abstract IdeAction getAction(String var1);

    private Component getCustomComponent(Collection itemFactories, String path) {
        for (ItemFactory factory : itemFactories) {
            GUIPanel component = factory.createItem(path);
            if (component == null) continue;
            Component tbComponent = (Component)component.getRootComponent();
            this.ensureToolbarComponentIsNamed(tbComponent, path);
            return tbComponent;
        }
        return null;
    }

    private void addToolbarItem(Collection itemFactories, String toolbarId, String sectionId, View view, Toolbar toolbar, String cmdId, Map buttonGroupMap, boolean addSeparator) {
        Component c;
        if (addSeparator) {
            JToolBar.Separator separator = toolbar.newSeparator();
            toolbar.add(separator);
            this.storeProperties(null, separator);
        }
        IdeAction action = null;
        ToggleAction[] actionGroup = null;
        Integer cmdIntegerID = Ide.findCmdID(cmdId);
        if (cmdIntegerID != null) {
            action = this.getAction(cmdId);
        }
        if ((c = this.getCustomComponent(itemFactories, toolbarId + '/' + sectionId + '/' + cmdId)) != null) {
            this.storeProperties(cmdId, c);
            toolbar.add(c);
            return;
        }
        if (action == null && (actionGroup = IdeAction.findGroup(cmdId)) == null) {
            ExtensionRegistry.getExtensionRegistry().getLogger().warning("Cannot add action-ref '" + cmdId + "' to toolbar '" + toolbarId + "'.");
        }
        if (actionGroup != null) {
            if (view != null) {
                for (int j = 0; j < actionGroup.length; ++j) {
                    ToggleAction oldAction = actionGroup[j];
                    IdeAction newAction = ((IdeAction)oldAction).newLocalAction(view);
                    actionGroup[j] = newAction;
                }
            }
            this.storeProperties(cmdId, toolbar.addMenuButton(actionGroup));
        } else if (action != null) {
            action.putValue("cmdId", cmdId);
            if (view != null) {
                action = action.newLocalAction(view);
            }
            if (action.isToggle()) {
                this.storeProperties(cmdId, toolbar.addToggleButton(action));
            } else if (action.isRadio()) {
                ButtonGroup buttonGroup;
                String btnGroupName = (String)action.getValue("RadioGroupName");
                if (btnGroupName == null) {
                    btnGroupName = "UnknownButtonGroup";
                }
                if ((buttonGroup = (ButtonGroup)buttonGroupMap.get(btnGroupName)) == null) {
                    buttonGroup = new ButtonGroup();
                    buttonGroupMap.put(btnGroupName, buttonGroup);
                }
                this.storeProperties(cmdId, toolbar.addRadioButton(action, buttonGroup));
            } else if (action.isActionMenu()) {
                Object hasDefaultAction = action.getValue("ActionMenuHasDefaultAction");
                if (hasDefaultAction instanceof Boolean && !((Boolean)hasDefaultAction).booleanValue()) {
                    this.storeProperties(cmdId, toolbar.add(this.newMenuToolButton(action)));
                } else {
                    this.storeProperties(cmdId, toolbar.addActionMenuButton(action));
                }
            } else {
                this.storeProperties(cmdId, toolbar.add(action));
            }
        }
    }

    private MenuToolButton newMenuToolButton(IdeAction action) {
        Action[] menuActions;
        MenuToolButton button = new MenuToolButton(new NonAction(action));
        for (Action a : menuActions = (Action[])action.getValue("ActionMenuActions")) {
            if (!(a instanceof ToggleAction)) continue;
            button.addPopupItem((ToggleAction)a);
        }
        return button;
    }

    @Override
    public void initialize() {
        ActionRegistry.getActionRegistry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installToolbarImpl(String toolbarId, Toolbar toolbar, View view) {
        List sections;
        ExtensionRegistry er = ExtensionRegistry.getExtensionRegistry();
        MenuHook mh = (MenuHook)er.getHook(MenuHook.ELEMENT);
        javax.ide.menu.spi.Toolbar modelToolbar = (javax.ide.menu.spi.Toolbar)mh.getModel().getToolbars().get(toolbarId);
        if (modelToolbar == null) {
            return;
        }
        boolean needSeparator = false;
        HashMap buttonGroupMap = new HashMap();
        Collection itemFactories = this.getItemFactoriesForLoadedExtensions(mh.getModel());
        List list = sections = modelToolbar.getSections();
        synchronized (list) {
            for (Section section : sections) {
                List items = section.getContent();
                for (Item item : items) {
                    String cmdID = item.getActionID();
                    if (!this.isActionAccepted(cmdID) || this.toolbarHasAction(toolbar, cmdID)) continue;
                    this.addToolbarItem(itemFactories, toolbarId, section.getID(), view, toolbar, cmdID, buttonGroupMap, needSeparator);
                    needSeparator = true;
                    if (!IdeAction.DEBUG) continue;
                    System.out.println("ide.IdeAction.debug info: Adding toolbar action " + cmdID);
                }
            }
        }
    }

    private boolean toolbarHasAction(Toolbar toolbar, String cmdId) {
        Action[] actions;
        for (Action a : actions = toolbar.getActions()) {
            Integer cmdIntegerID;
            if (!(a instanceof IdeAction) || (cmdIntegerID = Ide.findCmdID(cmdId)) == null || !cmdIntegerID.equals(((IdeAction)a).getCommandId())) continue;
            return true;
        }
        return false;
    }

    public synchronized void addActionFilter(ActionFilter filter) {
        if (filter == null) {
            throw new NullPointerException("ActionFilter is null");
        }
        this._filters.add(filter);
    }

    public synchronized void removeActionFilter(ActionFilter filter) {
        this._filters.remove(filter);
    }

    public void refilterActions() {
        this.getTBRegHandler().refilterToolbars();
    }

    private boolean isActionAccepted(String cmdID) {
        if (!this._filters.isEmpty()) {
            for (ActionFilter filter : this._filters) {
                if (filter.accept(cmdID)) continue;
                return false;
            }
        }
        return true;
    }

    private void storeProperties(String cmdId, Component c) {
        JComponent jc = (JComponent)c;
        this.ensureToolbarComponentIsNamed(jc, cmdId);
        jc.putClientProperty(DECLARATIVE_BUTTON_KEY, Boolean.TRUE);
        jc.putClientProperty("cmdId", cmdId);
    }

    private void ensureToolbarComponentIsNamed(Component tbComponent, String name) {
        if (tbComponent != null && tbComponent.getName() == null) {
            tbComponent.setName(name);
        }
    }

    private boolean isDeclarative(Component c) {
        return ((JComponent)c).getClientProperty(DECLARATIVE_BUTTON_KEY) != null;
    }

    TBRegHandler getTBRegHandler() {
        if (this._tbRegHandler == null) {
            this._tbRegHandler = new TBRegHandler();
            ExtensionRegistry er = ExtensionRegistry.getExtensionRegistry();
            MenuHook menuHook = (MenuHook)er.getHook(MenuHook.ELEMENT);
            menuHook.addToolbarRegListener((ToolbarVisitorListener)this._tbRegHandler);
        }
        return this._tbRegHandler;
    }

    private Collection getItemFactoriesForLoadedExtensions(MenuModel menuModel) {
        Collection classes = menuModel.getItemFactoryClasses();
        if (classes.isEmpty()) {
            return Collections.emptySet();
        }
        ExtensionRegistry extRegistry = ExtensionRegistry.getExtensionRegistry();
        HashSet<ItemFactory> factories = new HashSet<ItemFactory>();
        for (MetaClass mc : classes) {
            Extension extension = extRegistry.findExtensionByClassLoader(mc.getClassLoader());
            if (!extRegistry.isFullyLoaded(extension)) {
                if (!this._reportItemFactoryUsageErrors) continue;
                LOGGER.log(Level.SEVERE, String.format("ItemFactory must not be loaded as trigger hook; extension: %s, class name: %s", extension.getName(), mc.getClassName()));
                continue;
            }
            ItemFactory factory = menuModel.getItemFactory(mc.getClassName());
            if (factory == null) continue;
            factories.add(factory);
        }
        this._reportItemFactoryUsageErrors = false;
        return Collections.unmodifiableCollection(factories);
    }

    private static class NonAction
    extends ToggleAction {
        private NonAction(IdeAction action) {
            super(action);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    private static class TbView {
        final Toolbar _toolbar;
        final View _view;

        public TbView(Toolbar toolbar, View view) {
            this._toolbar = toolbar;
            this._view = view;
        }
    }

    private class TBRegHandler
    implements ToolbarVisitorListener {
        private String _extensionId;
        final HashSet<String> _ids = new HashSet();
        final HashMap<String, List<TbView>> _tbMap = new HashMap();

        private TBRegHandler() {
        }

        void register(String toolbarId, Toolbar toolbar, View view) {
            ArrayList list;
            if (!this._tbMap.containsKey(toolbarId)) {
                list = new ArrayList();
                this._tbMap.put(toolbarId, list);
            } else {
                list = (ArrayList)this._tbMap.get(toolbarId);
            }
            list.add(new TbView(toolbar, view));
        }

        void unRegister(String toolbarId, Toolbar toolbar) {
            if (this._tbMap.containsKey(toolbarId)) {
                List<TbView> list = this._tbMap.get(toolbarId);
                Iterator<TbView> iterator = list.iterator();
                while (iterator.hasNext()) {
                    TbView tbv = iterator.next();
                    if (!toolbar.equals(tbv._toolbar)) continue;
                    iterator.remove();
                    break;
                }
                if (list.isEmpty()) {
                    this._tbMap.remove(toolbarId);
                }
            }
        }

        public void starting(String extensionId) {
            if (this._extensionId != null && !this._extensionId.equals(extensionId)) {
                this._ids.clear();
            }
            this._extensionId = extensionId;
        }

        public void ended(String extensionId) {
            if (this._tbMap.isEmpty()) {
                return;
            }
            for (final String toolbarId : this._tbMap.keySet()) {
                if (!this._ids.contains(toolbarId)) continue;
                List<TbView> list = this._tbMap.get(toolbarId);
                for (TbView tbv : list) {
                    final Toolbar toolbar = tbv._toolbar;
                    final View view = tbv._view;
                    if (SwingUtilities.isEventDispatchThread()) {
                        this.updateToolbar(toolbar, toolbarId, view);
                        continue;
                    }
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            TBRegHandler.this.updateToolbar(toolbar, toolbarId, view);
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                }
            }
        }

        void refilterToolbars() {
            if (SwingUtilities.isEventDispatchThread()) {
                this.updateAllToolbars();
            } else {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        TBRegHandler.this.updateAllToolbars();
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        }

        private void updateAllToolbars() {
            for (String id : this._tbMap.keySet()) {
                List<TbView> list = this._tbMap.get(id);
                for (TbView tbv : list) {
                    this.updateToolbar(tbv._toolbar, id, tbv._view);
                }
            }
        }

        private void updateToolbar(Toolbar toolbar, String toolbarId, View view) {
            if (Boolean.FALSE.equals(toolbar.getClientProperty("updateToolbar"))) {
                ToolbarManager.this.installToolbarImpl(toolbarId, toolbar, view);
                return;
            }
            Set<Component> components = this.removeDeclarativeComponents(toolbar);
            ToolbarManager.this.installToolbarImpl(toolbarId, toolbar, view);
            for (Component c : components) {
                toolbar.add(c);
            }
        }

        public void addedToToolbar(String toolbarId) {
            if (!this._tbMap.isEmpty()) {
                this._ids.add(toolbarId);
            }
        }

        private Set<Component> removeDeclarativeComponents(Toolbar toolbar) {
            int componentCount = toolbar.getComponentCount();
            if (componentCount == 0) {
                return Collections.emptySet();
            }
            LinkedHashSet<Component> set = new LinkedHashSet<Component>();
            for (int i = 0; i < componentCount; ++i) {
                Component component = toolbar.getComponent(0);
                toolbar.remove(0);
                if (ToolbarManager.this.isDeclarative(component)) continue;
                set.add(component);
            }
            return set;
        }
    }
}

