/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import oracle.javatools.util.SwingUtils;

public class FocusableLabel
extends JComponent
implements MouseListener,
Accessible {
    private String _sText;
    private Rectangle2D _rText;

    public FocusableLabel() {
        this.init(null);
    }

    public FocusableLabel(String sText) {
        this.init(sText);
    }

    private void init(String sText) {
        this.setFont(new JLabel().getFont());
        this.setText(sText);
        this.setBackground((Color)UIManager.get("window"));
        this.setForeground((Color)UIManager.get("textText"));
        this.addMouseListener(this);
    }

    public void setText(String sText) {
        String oldAccessibleName = null;
        if (this.accessibleContext != null) {
            oldAccessibleName = this.accessibleContext.getAccessibleName();
        }
        String oldValue = this._sText;
        this._sText = sText;
        this._rText = null;
        this.firePropertyChange("text", oldValue, sText);
        if (this.accessibleContext != null && this.accessibleContext.getAccessibleName() != oldAccessibleName) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", oldAccessibleName, this.accessibleContext.getAccessibleName());
        }
        this.revalidate();
        this.repaint();
    }

    public String getText() {
        return this._sText;
    }

    @Override
    public Dimension getPreferredSize() {
        if (!this.isPreferredSizeSet()) {
            Font font = this.getFont();
            FontMetrics fontMetrics = this.getFontMetrics(font);
            String text = this.getText();
            int width = fontMetrics.stringWidth(text);
            int height = fontMetrics.getHeight();
            Insets ins = this.getInsets();
            Dimension d = new Dimension(ins.left + width + ins.right, ins.top + height + ins.bottom);
            this.setPreferredSize(d);
        }
        return super.getPreferredSize();
    }

    @Override
    public void addNotify() {
        super.addNotify();
    }

    @Override
    protected void setUI(ComponentUI newUI) {
        super.setUI(newUI);
    }

    private Rectangle2D getTextBounds(Graphics2D g) {
        if (this._rText == null) {
            Font font = g.getFont();
            FontRenderContext frc = g.getFontRenderContext();
            TextLayout tl = new TextLayout(this._sText, font, frc);
            this._rText = tl.getBounds();
        }
        return this._rText;
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleFocusableLabel();
        }
        return this.accessibleContext;
    }

    @Override
    protected void paintComponent(Graphics g1) {
        Graphics2D g = (Graphics2D)g1;
        Dimension d = this.getSize();
        Insets ins = this.getInsets();
        d.width -= ins.left + ins.right;
        d.height -= ins.top + ins.bottom;
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(ins.left, ins.top, d.width, d.height);
        }
        g.setFont(this.getFont());
        Rectangle2D rText = this.getTextBounds(g);
        float dX = (float)(((double)d.width - rText.getWidth()) / 2.0);
        float dY = (float)(((double)d.height - rText.getHeight()) / 2.0 - rText.getY());
        g.setColor(this.getBackground().darker());
        SwingUtils.drawString((Graphics2D)g, (String)this._sText, (float)(dX + (float)ins.left), (float)(dY + (float)ins.right));
    }

    @Override
    public void mousePressed(MouseEvent me) {
        if (this.isFocusable()) {
            this.requestFocus();
            me.consume();
        }
    }

    @Override
    public void mouseClicked(MouseEvent me) {
    }

    @Override
    public void mouseReleased(MouseEvent me) {
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    protected class AccessibleFocusableLabel
    extends JComponent.AccessibleJComponent {
        protected AccessibleFocusableLabel() {
            super(FocusableLabel.this);
        }

        @Override
        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            if (FocusableLabel.this.getText() == null) {
                return super.getAccessibleName();
            }
            return FocusableLabel.this.getText();
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LABEL;
        }
    }
}

