/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.bali.ewt.util.MenuUtils;
import oracle.ide.controls.Toolbar;
import oracle.ide.util.AddinPolicyUtils;
import oracle.javatools.controls.PropertyChangeAdapter;
import oracle.javatools.icons.OracleIcons;

public class ToolButton
extends JButton {
    protected static final String uiClassID = "ToolButtonUI";
    protected JPopupMenu popup;
    private boolean iconVisible = true;
    private boolean menuStyle;
    private boolean checkedForIcon;
    private boolean checkedForDisabledIcon;
    private boolean painting;
    private PopupMenuListener popupMenuListener;

    public ToolButton(Action action) {
        super((Action)null);
        AddinPolicyUtils.creatingAbstractButtonLeakPolicyCheck((AbstractButton)this);
        this.putClientProperty("hideActionText", Boolean.TRUE);
        this.setHorizontalAlignment(0);
        this.setFocusable(false);
        this.setFocusPainted(false);
        this.setAction(action);
    }

    @Deprecated
    public static String buildToolTip(Action action) {
        return Toolbar.buildToolTip(action);
    }

    public JMenuItem addPopupItem(String label) {
        JMenuItem item;
        if (this.popup == null) {
            this.createPopupMenu();
        }
        if ((item = this._findPopupItem(label)) == null) {
            item = this.popup.add(label);
            this.layoutToolbar();
        }
        return item;
    }

    public void removePopupItem(String label) {
        JMenuItem item = this._findPopupItem(label);
        if (item != null) {
            this.popup.remove(item);
            this.layoutToolbar();
        }
    }

    public JMenuItem findPopupItem(String label) {
        return this._findPopupItem(label);
    }

    public final void setLabelVisible(boolean visible) {
        this.putClientProperty("hideActionText", visible);
        this.repaint();
    }

    public final boolean getLabelVisible() {
        return ToolButton.isLabelVisible(this);
    }

    public final void setIconVisible(boolean visible) {
        if (visible == this.iconVisible) {
            return;
        }
        this.iconVisible = visible;
        Icon icon = this.getIcon();
        if (icon != null) {
            this.setIcon(icon);
            this.setPressedIcon(icon);
            this.setSelectedIcon(icon);
        }
    }

    public final boolean getIconVisible() {
        return this.iconVisible;
    }

    public void setMenuStyle(boolean menuStyle) {
        this.menuStyle = menuStyle;
    }

    public boolean isMenuStyle() {
        return this.menuStyle;
    }

    protected void init() {
    }

    protected JPopupMenu createPopupMenu() {
        if (this.popup != null) {
            this.releasePopupMenu();
        }
        this.popup = new JPopupMenu();
        this.popupMenuListener = new ButtonPopupMenuListener(this);
        this.popup.addPopupMenuListener(this.popupMenuListener);
        this.invalidate();
        return this.popup;
    }

    protected void releasePopupMenu() {
        if (this.popup != null && this.popupMenuListener != null) {
            this.popup.removePopupMenuListener(this.popupMenuListener);
        }
        this.popup = null;
        this.invalidate();
    }

    protected static boolean isLabelVisible(AbstractButton button) {
        Boolean hide = (Boolean)button.getClientProperty("hideActionText");
        return hide == null || hide == false;
    }

    Toolbar getToolbar() {
        Container parent = this.getParent();
        return parent instanceof Toolbar ? (Toolbar)parent : null;
    }

    boolean hasPopup() {
        return this.popup != null;
    }

    boolean isPopupVisible() {
        return this.popup != null && this.popup.isVisible();
    }

    void togglePopup() {
        if (this.popup == null) {
            return;
        }
        if (!this.popup.isVisible()) {
            MenuUtils.showPopupMenu((JPopupMenu)this.popup, (Component)this, (int)0, (int)this.getHeight());
        } else {
            this.popup.setVisible(false);
        }
    }

    private JMenuItem _findPopupItem(String label) {
        if (this.popup != null) {
            MenuElement[] elements = this.popup.getSubElements();
            for (int i = 0; i < elements.length; ++i) {
                JMenuItem item;
                Component c = elements[i].getComponent();
                if (!(c instanceof JMenuItem) || !(item = (JMenuItem)c).getText().equals(label)) continue;
                return item;
            }
        }
        return null;
    }

    protected final void layoutToolbar() {
        Toolbar toolbar = this.getToolbar();
        if (toolbar != null) {
            toolbar.validate();
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.popup != null) {
            SwingUtilities.updateComponentTreeUI(this.popup);
        }
    }

    @Override
    protected void configurePropertiesFromAction(Action a) {
        this.checkedForIcon = false;
        this.checkedForDisabledIcon = false;
        this.setText(a != null && ToolButton.isLabelVisible(this) ? (String)a.getValue("Name") : null);
        this.setToolTipText(a != null ? Toolbar.buildToolTip(a) : null);
        this.setEnabled(a != null ? a.isEnabled() : true);
    }

    @Override
    protected PropertyChangeListener createActionPropertyChangeListener(Action a) {
        return new DefaultActionPropertyChangeListener(this, a);
    }

    @Override
    public Icon getIcon() {
        if (!this.checkedForIcon) {
            Action a = this.getAction();
            this.checkedForIcon = true;
            Icon icon = null;
            if (a != null && (icon = (Icon)a.getValue("SmallIcon")) == null) {
                icon = OracleIcons.getIcon((String)"warning.png");
            }
            this.setIcon(icon);
        }
        return super.getIcon();
    }

    @Override
    public void setIcon(Icon icon) {
        this.checkedForIcon = true;
        super.setIcon(icon);
    }

    @Override
    public void setPressedIcon(Icon icon) {
        if (!this.checkedForIcon) {
            this.getIcon();
        }
        super.setPressedIcon(icon);
    }

    @Override
    public Icon getDisabledIcon() {
        if (!this.checkedForIcon) {
            this.getIcon();
        }
        if (!this.checkedForDisabledIcon) {
            Action a = this.getAction();
            this.checkedForDisabledIcon = true;
            this.setDisabledIcon((Icon)a.getValue("DisabledIcon"));
        }
        return super.getDisabledIcon();
    }

    @Override
    public void setDisabledIcon(Icon icon) {
        this.checkedForDisabledIcon = true;
        super.setDisabledIcon(icon);
    }

    @Override
    public void repaint() {
        if (this.painting) {
            return;
        }
        super.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        this.painting = true;
        super.paintComponent(g);
        this.painting = false;
    }

    private static final class ButtonPopupMenuListener
    implements PopupMenuListener {
        ToolButton button;

        ButtonPopupMenuListener(ToolButton b) {
            this.button = b;
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            this.updateForPopup(true);
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            this.updateForPopup(false);
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        private void updateForPopup(final boolean visible) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ButtonModel m = ButtonPopupMenuListener.this.button.getModel();
                    if (ButtonPopupMenuListener.this.button.isMenuStyle()) {
                        m.setPressed(visible);
                    }
                    m.setRollover(false);
                    Toolbar toolbar = ButtonPopupMenuListener.this.button.getToolbar();
                    if (toolbar != null) {
                        toolbar.setOver(null);
                    }
                    ButtonPopupMenuListener.this.button.repaint();
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    protected static class DefaultActionPropertyChangeListener
    extends PropertyChangeAdapter {
        public DefaultActionPropertyChangeListener(AbstractButton adaptee, Action action) {
            super(adaptee, action);
        }

        protected void nameChanged(PropertyChangeEvent e) {
            AbstractButton button = this.getAdaptee();
            if (ToolButton.isLabelVisible(button)) {
                button.setText((String)e.getNewValue());
            }
            this.tooltipChanged(e);
        }

        protected void tooltipChanged(PropertyChangeEvent e) {
            AbstractButton button = this.getAdaptee();
            button.setToolTipText(Toolbar.buildToolTip(button.getAction()));
        }
    }
}

