/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import javax.swing.JTable;
import oracle.ide.controls.TableTransformer;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.ControlsArb;
import oracle.ide.util.Assert;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class XMLTableTransformer
implements TableTransformer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean write(JTable table, URL url, String tableName) throws IOException {
        PrintWriter out = null;
        try {
            out = new PrintWriter(URLFileSystem.openOutputStream((URL)url));
            boolean bl = this.write(table, out, tableName);
            return bl;
        }
        finally {
            try {
                out.close();
                out = null;
            }
            catch (Exception ex) {}
        }
    }

    @Override
    public boolean write(JTable table, PrintWriter out, String tableName) {
        try {
            int numRows = table.getSelectedRowCount();
            int numCols = table.getSelectedColumnCount();
            int[] rows = table.getSelectedRows();
            int[] cols = table.getSelectedColumns();
            XMLDocument doc = new XMLDocument();
            doc.setVersion("1.0");
            doc.setDoctype(tableName, null, null);
            Element root = doc.createElement(tableName);
            String rowLabel = ControlsArb.getString(12);
            for (int i = 0; i < numRows; ++i) {
                Element rowElement = doc.createElement(rowLabel);
                for (int j = 0; j < numCols; ++j) {
                    Element element = doc.createElement(table.getColumnName(cols[j]));
                    Text text = doc.createTextNode((String)table.getValueAt(rows[i], cols[j]));
                    element.appendChild(text);
                    rowElement.appendChild(element);
                }
                root.appendChild(rowElement);
            }
            doc.appendChild((Node)root);
            doc.print(out);
            out.flush();
            doc = null;
            root = null;
            return true;
        }
        catch (Exception ex) {
            Assert.printStackTrace((Throwable)ex);
            return false;
        }
    }
}

