/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.dialogs;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.ide.Ide;
import oracle.ide.config.DTCache;
import oracle.ide.panels.ActionDescriptionPanel;
import oracle.ide.resource.DeleteDialogArb;
import oracle.ide.resource.DialogsArb;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.DetailDialog;
import oracle.javatools.ui.Colors;

public class BaseUsageDialog
implements ActionListener {
    private ActionDescriptionPanel m_actionDescriptionPanel;
    private final JLabel m_statusLabel = new JLabel();
    private JButton m_btnPreview;
    private JComboBox m_scopeCombo;
    private boolean m_hasPreview;
    private boolean m_isPreviewEnabled = true;
    private DetailDialog m_detailDialog;
    private static final String DEFAULT_SCOPE_KEY = "SEARCH_DEFAULT_SCOPE";

    public DetailDialog createUsageDialog(Component dialogOwner, String title, String header, String description, String[] options, String showDetailsText, String hideDetailsText, String helpTopicId, Component detailsComponent, JComboBox scopeCombo, JButton workingSetButton, boolean hasPreviewButton) {
        DetailDialog dialog = DetailDialog.createDetailDialog((Component)dialogOwner, (String)title, (int)23);
        JPanel scopePanel = null;
        if (scopeCombo != null) {
            scopePanel = new JPanel(new GridBagLayout());
            Insets insets = new Insets(2, 2, 2, 2);
            JLabel label = new JLabel();
            ResourceUtils.resLabel((JLabel)label, (Component)scopeCombo, (String)DeleteDialogArb.getString(43));
            scopePanel.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
            scopePanel.add((Component)scopeCombo, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 1, insets, 0, 0));
            scopePanel.add((Component)workingSetButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
            this.m_scopeCombo = scopeCombo;
        }
        this.m_actionDescriptionPanel = ActionDescriptionPanel.build(null, (JComponent)scopePanel, header, description, options);
        dialog.setContent((Component)this.m_actionDescriptionPanel);
        dialog.setResizable(true);
        if (options != null && options.length > 0) {
            dialog.setMinimumSize(530, 200);
        }
        dialog.setOKButtonText(DialogsArb.getString(2));
        dialog.setCancelButtonText(DialogsArb.getString(4));
        dialog.setButtonTextWhenDetailsHidden(showDetailsText, true);
        dialog.setButtonTextWhenDetailsShown(hideDetailsText, false);
        dialog.setButtonAlignment(2);
        dialog.setDetailContent(detailsComponent);
        this.initStatusLabel();
        dialog.setDetailsStatusLabel(this.m_statusLabel);
        dialog.setDetailVisible(false);
        dialog.setDetailsButtonEnabled(false);
        if (hasPreviewButton) {
            this.m_btnPreview = new JButton();
            ResourceUtils.resButton((AbstractButton)this.m_btnPreview, (String)DeleteDialogArb.getString(44));
            dialog.addCustomButton((Component)this.m_btnPreview);
            this.m_btnPreview.addActionListener(this);
        }
        dialog.setHelpTopicId(helpTopicId);
        this.m_detailDialog = dialog;
        dialog.pack();
        return dialog;
    }

    public DetailDialog createBaseDialog(JFrame dialogOwner, String dialogTitle, JPanel dialogContent, Component detailsComponent, boolean hasPreviewButton) {
        int detailsMask = detailsComponent != null ? 16 : 0;
        DetailDialog dialog = new DetailDialog((Frame)dialogOwner, dialogTitle, 7 | detailsMask);
        dialog.setContent((Component)dialogContent);
        dialog.setResizable(true);
        dialog.setOKButtonEnabled(false);
        if (detailsComponent != null) {
            dialog.setDetailContent(detailsComponent);
            this.initStatusLabel();
            dialog.setDetailsStatusLabel(this.m_statusLabel);
            dialog.setDetailVisible(false);
            dialog.setDetailsButtonEnabled(false);
        }
        if (hasPreviewButton) {
            this.m_btnPreview = new JButton();
            ResourceUtils.resButton((AbstractButton)this.m_btnPreview, (String)DeleteDialogArb.getString(44));
            dialog.addCustomButton((Component)this.m_btnPreview);
            this.m_btnPreview.addActionListener(this);
            this.m_btnPreview.setEnabled(this.m_isPreviewEnabled);
        }
        dialog.pack();
        this.m_detailDialog = dialog;
        return dialog;
    }

    public void addPanelSelectionListener(ActionDescriptionPanel.OptionSelectionChangedListener listener) {
        this.m_actionDescriptionPanel.addSelectionChangedListener(listener);
    }

    public DetailDialog getDetailDialog() {
        return this.m_detailDialog;
    }

    public JComboBox getScopeCombo() {
        return this.m_scopeCombo;
    }

    public int getSelectedOptionIndex() {
        return this.m_actionDescriptionPanel.getSelectedOptionIndex();
    }

    public void setSelectedOption(int index) {
        this.m_actionDescriptionPanel.setSelectedOption(index);
    }

    public void detailsAvailable(boolean detailsAvailable) {
        this.m_detailDialog.setDetailsButtonEnabled(detailsAvailable);
    }

    public void setPreviewButtonEnabled(boolean enabled) {
        this.m_isPreviewEnabled = enabled;
        if (this.m_btnPreview != null) {
            this.m_btnPreview.setEnabled(enabled);
        }
    }

    public final void setStatus(String text, Icon icon) {
        this.m_statusLabel.setText(text);
        this.m_statusLabel.setIcon(icon);
        Container parent = this.m_statusLabel.getParent();
        if (parent != null) {
            parent.repaint();
        }
    }

    private final void initStatusLabel() {
        this.m_statusLabel.setText("");
        this.m_statusLabel.setIcon(null);
        this.m_statusLabel.setForeground(Colors.HINT_TEXT);
    }

    public void saveSettings() {
        Object selectedItem;
        if (this.m_scopeCombo != null && (selectedItem = this.m_scopeCombo.getSelectedItem()) != null) {
            Object[] objects = (Object[])selectedItem;
            String label = (String)objects[0];
            DTCache dtCache = Ide.getDTCache();
            dtCache.putString(DEFAULT_SCOPE_KEY, label);
        }
    }

    public boolean hasPreview() {
        return this.m_hasPreview;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.m_btnPreview) {
            this.m_hasPreview = true;
            this.m_detailDialog.closeDialog(false);
        }
    }
}

