/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.dialogs;

import com.sleepycat.je.log.LogException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.jcip.annotations.GuardedBy;
import oracle.ide.Ide;
import oracle.ide.resource.DialogsArb;
import oracle.ide.util.Assert;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.RichHintLabel;

public final class OutOfFileHandlesDialog {
    private static final int RECOMMENDED_FILE_HANDLE_LIMIT = 4096;
    private static final String DOCUMENTATION_LINK = "http://www.oracle.com/technology/documentation/jdev.html";
    @GuardedBy(value="OutOfFileHandlesDialog.class")
    private static boolean hasBeenShown;
    private static final boolean TEST_DIALOG;
    private static Collection<InputStream> testStreams;

    public static synchronized void show() {
        if (Ide.getIdeArgs().getCreateUI() && !Boolean.getBoolean("ide.suppress.file.handle.dialog") && !hasBeenShown) {
            hasBeenShown = true;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    String title = DialogsArb.getString(40);
                    String message = DialogsArb.format(41, Ide.getProgramName(), 4096);
                    MessageDialog.error((Component)((Object)Ide.getMainWindow()), (Object)message, (String)title, null);
                    RichHintLabel label = new RichHintLabel();
                    label.setForeground(Color.BLACK);
                    label.setHtmlText(message);
                    label.registerAction("documentation", (Action)new AbstractAction(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            try {
                                Desktop.getDesktop().browse(URI.create(OutOfFileHandlesDialog.DOCUMENTATION_LINK));
                            }
                            catch (IOException ioe) {
                            }
                            catch (UnsupportedOperationException unsupportedOperationException) {
                                // empty catch block
                            }
                        }
                    });
                    int limitedWidth = 400;
                    label.setSize(400, Integer.MAX_VALUE);
                    label.setPreferredSize(new Dimension(400, label.getPreferredSize().height));
                    JOptionPane.showMessageDialog((Component)((Object)Ide.getMainWindow()), label, title, 0, null);
                }
            });
        }
    }

    public static boolean isOutOfFileHandlesError(Throwable t) {
        if ((t instanceof LogException || t instanceof FileNotFoundException) && OutOfFileHandlesDialog.hasOutOfFileHandlesMessage(t)) {
            return true;
        }
        Throwable cause = t.getCause();
        return cause == null ? false : OutOfFileHandlesDialog.isOutOfFileHandlesError(cause);
    }

    private static boolean hasOutOfFileHandlesMessage(Throwable t) {
        String message = t.getMessage();
        return message != null && message.contains("(Too many open files)");
    }

    public static void startTesting() {
        Assert.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                if (TEST_DIALOG) {
                    testStreams = new ArrayList();
                    try {
                        for (int i = 0; i < 70000; ++i) {
                            File f = File.createTempFile("filehandle", ".test");
                            testStreams.add(new FileInputStream(f));
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public static void finishTesting() {
        Assert.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                if (testStreams != null) {
                    for (InputStream stream : testStreams) {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        });
    }

    static {
        TEST_DIALOG = Boolean.getBoolean("ide.test.file.handle.dialog");
    }
}

