/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.docking;

import oracle.ide.docking.DockableWindow;
import oracle.ide.docking.DrawerConfig;
import oracle.ide.docking.DrawerUI;
import oracle.ide.docking.DrawerWindow;
import oracle.ide.util.BitField;
import oracle.ide.util.PropertyAccess;
import oracle.ide.util.StructuredPropertyAccess;
import oracle.ide.view.View;

class Drawer {
    private static final String STATE_PROPERTY = "State";
    private static final String TAB_NAME_PROPERTY = "TabName";
    private static final String UNIQUE_NAME_PROPERTY = "UniqueName";
    private static final String CAN_HIDE_HANDLE_PROPERTY = "CanHideHandle";
    private static final String CAN_BE_CLOSED = "CanBeClosed";
    private static final String WEIGHT = "weight";
    private final DrawerWindow drawerWindow;
    private DockableWindow view;
    private DrawerUI drawerUI;
    private DrawerConfig.State state;
    private boolean canHideHandle;
    private boolean canBeClosed;
    private float weight;

    static DrawerConfig loadConfig(PropertyAccess p) {
        DrawerConfig c = new DrawerConfig();
        String stateValue = p.getProperty(STATE_PROPERTY, DrawerConfig.State.defaultState().name());
        c.state(DrawerConfig.State.valueOf(stateValue));
        c.tabName(p.getProperty(TAB_NAME_PROPERTY, null));
        c.uniqueName(p.getProperty(UNIQUE_NAME_PROPERTY, null));
        String weightValue = p.getProperty(WEIGHT, null);
        if (weightValue != null) {
            c.weight(Float.valueOf(weightValue).floatValue());
        }
        return c;
    }

    Drawer(DockableWindow view, DrawerConfig config, DrawerWindow drawerWindow) {
        this.view = view;
        this.drawerWindow = drawerWindow;
        this.state(config.state());
        this.weight = config.weight();
    }

    void canHideHandle() {
        this.canHideHandle = true;
        if (this.drawerUI != null) {
            this.drawerUI.canHideHandle();
        }
    }

    void beClosable() {
        this.canBeClosed = true;
    }

    boolean canBeClosed() {
        return this.canBeClosed;
    }

    boolean visible() {
        return this.stateEqualsTo(DrawerConfig.State.VISIBLE);
    }

    boolean minimizedButVisible() {
        return this.stateEqualsTo(DrawerConfig.State.MINIMIZED);
    }

    boolean minimized() {
        return this.stateEqualsTo(DrawerConfig.State.MINIMIZED, DrawerConfig.State.HIDDEN_AND_MINIMIZED);
    }

    private boolean stateEqualsTo(DrawerConfig.State ... states) {
        for (DrawerConfig.State state : states) {
            if (!this.state().equals((Object)state)) continue;
            return true;
        }
        return false;
    }

    DrawerConfig.State state() {
        return this.state;
    }

    void state(DrawerConfig.State state) {
        this.state = state;
    }

    String uniqueName() {
        return this.view.getUniqueName();
    }

    String tabName() {
        return this.view.getTabName();
    }

    DrawerUI drawerUI() {
        if (this.drawerUI == null) {
            this.createDrawerUI();
        }
        return this.drawerUI;
    }

    private void createDrawerUI() {
        this.drawerUI = new DrawerUI(this.tabName(), this.view);
        if (this.canHideHandle) {
            this.drawerUI.canHideHandle();
        }
    }

    void hideHandle() {
        this.drawerUI().hideHandle();
    }

    void showHandle() {
        this.drawerUI().showHandle();
    }

    void loadLayout(StructuredPropertyAccess p) {
        if (p.getBooleanProperty(CAN_HIDE_HANDLE_PROPERTY, false)) {
            this.canHideHandle();
        }
        if (p.getBooleanProperty(CAN_BE_CLOSED, false)) {
            this.canBeClosed();
        }
    }

    void saveLayout(StructuredPropertyAccess p) {
        p.setProperty(STATE_PROPERTY, this.state().name());
        p.setProperty(TAB_NAME_PROPERTY, this.tabName());
        p.setProperty(UNIQUE_NAME_PROPERTY, this.uniqueName());
        p.setBooleanProperty(CAN_HIDE_HANDLE_PROPERTY, this.canHideHandle);
        p.setBooleanProperty(CAN_BE_CLOSED, this.canBeClosed);
        p.setProperty(WEIGHT, Float.toString(this.weight));
        if (this.view != null) {
            this.view.saveLayout(p);
        }
    }

    DockableWindow view() {
        return this.view;
    }

    View viewWithoutDecoration() {
        return this.view != null ? this.view.getViewWithoutDecoration() : null;
    }

    boolean hasView(View view) {
        if (view.equals(this.view())) {
            return true;
        }
        return view.equals(this.viewWithoutDecoration());
    }

    void disposeComponent() {
        this.view = null;
    }

    void clientVisible(boolean visible, int flags) {
        if (visible) {
            this.drawerWindow.show(this.view);
        } else {
            this.drawerWindow.hide(this.view);
        }
    }

    void detach() {
        this.drawerWindow.model().removeDrawer(this.view);
    }

    int dockableStatus() {
        if (this.minimized()) {
            return this.minimizedStatus();
        }
        if (this.visible()) {
            return this.visibleStatus();
        }
        return this.activeStatus(0);
    }

    private int minimizedStatus() {
        return this.activeStatus(12);
    }

    private int visibleStatus() {
        return this.activeStatus(40);
    }

    private int activeStatus(int currentStatus) {
        if (this.drawerUI != null && this.drawerUI.active()) {
            return currentStatus | 0x10;
        }
        return currentStatus;
    }

    boolean accessible() {
        return BitField.isSet(this.dockableStatus(), 8);
    }
}

