/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.docking;

import com.jgoodies.looks.plastic.PlasticToolBarUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonModel;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ToolBarUI;
import javax.swing.plaf.basic.BasicButtonUI;
import oracle.ide.controls.MenuToolButton;
import oracle.ide.controls.RotatingIcon;
import oracle.ide.controls.Toolbar;
import oracle.ide.docking.DrawerBundle;
import oracle.ide.docking.DrawerDecorator;
import oracle.ide.docking.DrawerFocusListener;
import oracle.ide.docking.DrawerLabel;
import oracle.ide.docking.DrawerWindowUI;
import oracle.ide.resource.IdeIcons;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.view.View;
import oracle.ideimpl.docking.DockStationImpl;
import oracle.ideimpl.docking.ProxyDockable;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.themes.Painter;
import oracle.javatools.ui.themes.ThemeProperties;
import oracle.javatools.ui.themes.Themes;
import oracle.javatools.util.PlatformUtils;

final class DrawerUI
extends JPanel {
    private static final int MIN_TITLE_HEIGHT = 18;
    private static final Border TITLE_BORDER = BorderFactory.createEmptyBorder(0, 5, 0, 2);
    private static final int CURSOR_EDGE_THRESHOLD = 3;
    private boolean mouseOver = false;
    private boolean menuRaised = false;
    private final Subcomponents subcomponents;
    private View view;
    private Component hosted;
    private double ratio = 1.0;
    private double expansionRatio = 0.0;
    private boolean active;
    private boolean shouldRotateIcon = true;
    private MenuToolButton dropDownButton;
    private final DropDownMouseOver dropDownMouseOver = new DropDownMouseOver();
    private Map<JComponent, DrawerFocusListener> focusListeners = new WeakHashMap<JComponent, DrawerFocusListener>();
    private boolean canHideHandle;
    private Separator _separator;

    DrawerUI(String text, View view) {
        super(new GridBagLayout());
        this.makeDebuggingEasier(text);
        this.view = view;
        Toolbar customToolbar = view.getToolbar();
        this.forceCustomToolbarToHaveNoVisualStyles(customToolbar);
        this.subcomponents = new Subcomponents(text, customToolbar);
        this.init();
        Component gui = view.getGUI();
        if (view instanceof ProxyDockable) {
            ((ProxyDockable)view).markAsDrawer();
            view = (View)((Object)DockStationImpl.getInstance().swapDockable((ProxyDockable)view));
            gui = view.getGUI();
        }
        if (gui == null) {
            throw new IllegalStateException(view.getClass().getName() + "(" + text + ") should have a GUI");
        }
        this.hostComponent(gui);
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                if (event.getSource() == DrawerUI.this) {
                    DrawerUI.this.addActivationFocusListener();
                }
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                if (event.getSource() == DrawerUI.this) {
                    DrawerUI.this.removeActivationFocusListeners();
                }
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }
        });
    }

    private void makeDebuggingEasier(String drawerText) {
        this.setName("DrawerUI: " + drawerText);
    }

    private void forceCustomToolbarToHaveNoVisualStyles(Toolbar customToolbar) {
        if (customToolbar != null) {
            customToolbar.forcePrimaryViewToolbar(false);
        }
    }

    void shouldRotateIcon() {
        this.shouldRotateIcon = true;
    }

    void shouldNotRotateIcon() {
        this.shouldRotateIcon = false;
    }

    private void init() {
        this.addSubcomponents();
        this.initBackgroundColor();
        this.addMouseListener(this.dropDownMouseOver);
    }

    private void addSubcomponents() {
        this.showComponents();
    }

    private GridBagConstraints constraintsForTitle() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.anchor = 17;
        c.fill = 1;
        return c;
    }

    private GridBagConstraints constraintsForCustomToolbar() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 0;
        c.weighty = 0.0;
        return c;
    }

    private GridBagConstraints constraintsForButtons() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = this.subcomponents.customToolbar != null ? 2 : 1;
        c.gridy = 0;
        c.weightx = 0.04;
        c.weighty = 0.0;
        c.fill = 1;
        return c;
    }

    private void initBackgroundColor() {
        this.setOpaque(false);
    }

    void canHideHandle() {
        this.canHideHandle = true;
    }

    void hideHandle() {
        if (!this.canHideHandle) {
            return;
        }
        this.hideComponents();
    }

    void showHandle() {
        this.showComponents();
    }

    private void showComponents() {
        this.add((Component)this.subcomponents.title, this.constraintsForTitle());
        if (this.subcomponents.customToolbar != null) {
            this.add((Component)this.subcomponents.customToolbar, this.constraintsForCustomToolbar());
        }
        this.add(this.subcomponents.buttons);
        this.updateLabelIcon();
    }

    private void hideComponents() {
        this.remove(this.subcomponents.title);
        if (this.subcomponents.customToolbar != null) {
            this.remove(this.subcomponents.customToolbar);
        }
        this.remove(this.subcomponents.buttons);
    }

    Component hostedComponent() {
        return this.hosted;
    }

    void hostComponent(Component toHost) {
        if (this.hosted == toHost) {
            return;
        }
        if (this.hosted != null) {
            this.remove(this.hosted);
        }
        this.hosted = toHost;
        this.addHostedComponent();
    }

    private void addActivationFocusListener() {
        JComponent focusable;
        if (this.hosted == null) {
            return;
        }
        if (this.subcomponents.title != null) {
            this.subcomponents.title.addFocusListener(this.subcomponents.title);
        }
        if ((focusable = this.focusableFromHosted()) == null) {
            return;
        }
        DrawerUIFocusListener focusListener = new DrawerUIFocusListener(true, this.hosted);
        focusable.addPropertyChangeListener(focusListener);
        this.focusListeners.put(focusable, focusListener);
        focusListener.start();
    }

    private void removeActivationFocusListeners() {
        for (JComponent c : this.focusListeners.keySet()) {
            DrawerFocusListener fl;
            if (c == null || (fl = this.focusListeners.get(c)) == null) continue;
            fl.stop();
            c.removePropertyChangeListener(fl);
        }
        if (this.subcomponents.title != null) {
            this.subcomponents.title.removeFocusListener(this.subcomponents.title);
        }
    }

    private void ensureSomethingIsSelected(Component c) {
        if (!(c instanceof JTree)) {
            return;
        }
        JTree tree = (JTree)c;
        int count = tree.getSelectionCount();
        if (count == 0 && tree.getRowCount() > 0) {
            tree.setSelectionRow(0);
        }
    }

    private void addHostedComponent() {
        if (this.hosted == null) {
            return;
        }
        this.add(this.hosted, this.constraintsForHostedComponent());
    }

    private GridBagConstraints constraintsForHostedComponent() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 99;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets = new Insets(0, 0, 0, 0);
        return c;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (Themes.isThemed()) {
            this.paintWithTheme(graphics);
        } else {
            this.paintWithoutTheme(graphics);
        }
    }

    private Painter getThemePainter(String base, String state) {
        ThemeProperties properties = Themes.getActiveTheme().getStateProperties(base, state);
        return properties.getPainter("bg");
    }

    private void paintWithTheme(Graphics graphics) {
        Insets insets = this.getInsets();
        int width = this.widthForPainting();
        int height = this.heightForPainting();
        String state = this.mouseOver ? "mouseover" : "inactive";
        Painter painter = this.getThemePainter("accordion", state);
        painter.paint(graphics, insets.left, insets.top, width, height);
        painter = this.getThemePainter("accordionedge1", state);
        painter.paint(graphics, insets.left, insets.top, width, height);
        painter = this.getThemePainter("accordionedge2", state);
        painter.paint(graphics, insets.left, insets.top, width, height);
    }

    private void paintWithoutTheme(Graphics graphics) {
        String state;
        super.paintComponent(graphics);
        Insets insets = this.getInsets();
        int height = this.heightForPainting();
        int width = this.widthForPainting();
        Graphics2D g2d = (Graphics2D)graphics;
        String string = this.mouseOver ? "mouseover" : (state = this.active ? "active" : "inactive");
        if (this.dropDownButton != null) {
            this.dropDownButton.setVisible(true);
        }
        if (state.equals("mouseover")) {
            g2d.setColor(UIManager.getColor("TextPane.selectionBackground"));
        } else {
            g2d.setPaint(UIManager.getColor("Panel.background"));
        }
        g2d.fillRect(insets.left, insets.top + 1, width, height - 1);
    }

    public void updateLabelIcon() {
        DrawerLabel label = this.subcomponents.title;
        if (Themes.isThemed()) {
            String state = this.mouseOver ? "mouseover" : "default";
            String icon = label.isExpanded() ? "accordion.collapse" : "accordion.expand";
            ThemeProperties properties = Themes.getActiveTheme().getStateProperties(icon, state);
            this.subcomponents.title.setIcon(properties.getIcon("icon"));
        } else if (this.shouldRotateIcon) {
            RotatingIcon rotatingIcon = (RotatingIcon)this.subcomponents.title.getIcon();
            rotatingIcon.setRotation(Math.PI * this.expansionRatio / 2.0);
        }
    }

    private int heightForPainting() {
        Insets insets = this.getInsets();
        return this.hosted.getHeight() > 0 ? this.hosted.getY() - insets.top : this.getHeight() - insets.top - insets.bottom;
    }

    private int widthForPainting() {
        Insets insets = this.getInsets();
        return this.getWidth() - (insets.left + insets.right);
    }

    private boolean isTopDrawer() {
        return this.parent().visibleDrawers().indexOf(this) == 0;
    }

    private void expand(MouseEvent event) {
        if (event.isControlDown() && !this.expanded()) {
            this.parent().expand(this);
            return;
        }
        if (!this.ensureRealHostedComponent()) {
            this.parent().toggleVisibility(this);
        }
    }

    private boolean ensureRealHostedComponent() {
        if (!(this.view instanceof DrawerDecorator)) {
            return false;
        }
        DrawerDecorator decorator = (DrawerDecorator)this.view;
        return decorator.replaceProxyDrawer();
    }

    private DrawerWindowUI parent() {
        return (DrawerWindowUI)this.getParent();
    }

    boolean expanded() {
        return this.expansionRatio > 0.0;
    }

    private void minimize() {
        this.parent().minimizeWithAnimation(this);
    }

    private void maximize() {
        this.parent().maximize(this);
    }

    void activate() {
        this.active = true;
        this.repaintTitle();
    }

    JComponent focusableFromHosted() {
        return GraphicsUtils.getFocusableComponentOrChild((Component)this.hostedComponent(), (boolean)true);
    }

    void deactivate() {
        this.active = false;
        this.repaintTitle();
    }

    private void repaintTitle() {
        this.repaint(0, 0, this.getWidth(), this.getHeight() - this.hosted.getHeight());
    }

    boolean active() {
        return this.active;
    }

    void minimizable(boolean minimizable) {
    }

    void updateDropDownButton(MenuToolButton button) {
        this.dropDownButton = button;
        this.dropDownMouseOver.hideIcon();
        button.addMouseListener(this.dropDownMouseOver);
        button.getPopupMenu().addPopupMenuListener(this.dropDownMouseOver);
        if (this.subcomponents.customToolbar instanceof Toolbar) {
            this._separator = new Separator();
            this._separator.setOrientation(((Toolbar)this.subcomponents.customToolbar).getOrientation() == 1 ? 0 : 1);
            this._separator.setMinimumSize(this._separator.getPreferredSize());
            this.subcomponents.buttons.add(this._separator);
        }
        this.addButton(button);
    }

    void addButton(JComponent button) {
        button.setRequestFocusEnabled(false);
        this.subcomponents.buttons.add(button);
        this.subcomponents.buttons.validate();
        this.validate();
    }

    void expanded(boolean expanded) {
        this.expansionRatio(expanded ? 1.0 : 0.0);
    }

    double expansionRatio() {
        return this.expansionRatio;
    }

    void expansionRatio(double expansionRatio) {
        double oldExpansionRatio = this.expansionRatio;
        this.expansionRatio = expansionRatio;
        if (this.shouldRotateIcon) {
            this.updateLabelIcon();
        }
        if (oldExpansionRatio == 0.0 && this.expansionRatio != 0.0) {
            if (!this.ensureRealHostedComponent()) {
                this.view.fireViewExpanded();
            }
        } else if (oldExpansionRatio != 0.0 && this.expansionRatio == 0.0) {
            this.view.fireViewCollapsed();
        }
        this.updateAccessibleName(this.subcomponents.title);
    }

    double ratio() {
        return this.ratio * this.expansionRatio;
    }

    void ratio(double ratio) {
        this.ratio = ratio;
    }

    int titlebarHeight() {
        int h = this.getPreferredSize().height;
        if (this.hosted != null && this.hosted.isVisible()) {
            h -= this.hosted.getPreferredSize().height;
        }
        return Math.max(h, 18);
    }

    void focusDrawerLabel() {
        this.subcomponents.title.requestFocus();
    }

    void focusToolbar() {
        if (this.subcomponents.customToolbar != null) {
            this.subcomponents.customToolbar.requestFocus();
        }
    }

    View getView() {
        return this.view;
    }

    private void setComponentsNamesInToolbar(Component[] components) {
        for (int i = 0; i < components.length; ++i) {
            Component component = components[i];
            if (component != null && component.getName() == null) {
                String drawerName = this.getName();
                if (drawerName == null) {
                    drawerName = drawerName.getClass().getName();
                }
                component.setName(drawerName + component.getClass().getName() + i);
            }
            if (!PlatformUtils.isMac() || Themes.isThemed() || !(component instanceof AbstractButton)) continue;
            AbstractButton b = (AbstractButton)component;
            MyBasicButtonUI bbui = new MyBasicButtonUI();
            b.setUI(bbui);
            ((ComponentUI)bbui).installUI(b);
            b.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
            b.setRolloverEnabled(true);
        }
    }

    private void updateAccessibleName(JLabel title) {
        if (title == null) {
            return;
        }
        String state = this.expanded() ? DrawerBundle.get("DRAWER_STATE_DESCRIPTION_OPEN") : DrawerBundle.get("DRAWER_STATE_DESCRIPTION_CLOSED");
        title.getAccessibleContext().setAccessibleName(title.getText() + " " + DrawerBundle.get("DRAWER_NAME") + " " + state);
    }

    public class MyBasicButtonUI
    extends BasicButtonUI {
        @Override
        protected void paintIcon(Graphics g, JComponent c, Rectangle iconRect) {
            AbstractButton b = (AbstractButton)c;
            ButtonModel model = b.getModel();
            if (b.isRolloverEnabled() && model.isRollover()) {
                g.setColor(c.getBackground().darker());
                g.fillRect(0, 0, b.getWidth(), b.getHeight());
                super.paintIcon(g, c, iconRect);
                g.setColor(Color.lightGray);
                g.drawLine(0, 0, b.getWidth() - 1, 0);
                g.drawLine(0, b.getHeight() - 2, b.getWidth() - 1, b.getHeight() - 2);
                g.drawLine(0, 0, 0, b.getHeight() - 2);
                g.drawLine(b.getWidth() - 1, 0, b.getWidth() - 1, b.getHeight() - 2);
            } else {
                super.paintIcon(g, c, iconRect);
            }
        }
    }

    public class MyToolbar
    extends Toolbar {
        public MyToolbar() {
            this.updateUI();
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        }

        @Override
        public void updateUI() {
            this.setUI((ToolBarUI)new PlasticToolBarUI());
        }
    }

    private class DrawerUIFocusListener
    extends DrawerFocusListener {
        private boolean expandDrawer;

        DrawerUIFocusListener(boolean expandDrawer, Component c) {
            super(c);
            this.expandDrawer = expandDrawer;
        }

        @Override
        public void focusGained() {
            DrawerWindowUI parent = DrawerUI.this.parent();
            if (parent == null) {
                return;
            }
            parent.activate(DrawerUI.this);
            if (this.expandDrawer) {
                parent.expandIfNecessary(DrawerUI.this);
                DrawerUI.this.ensureSomethingIsSelected(FocusManager.getCurrentManager().getPermanentFocusOwner());
            }
        }

        @Override
        public void focusLost() {
            DrawerWindowUI parent = DrawerUI.this.parent();
            if (parent != null) {
                parent.deactivate(DrawerUI.this);
            }
        }
    }

    private class Separator
    extends JToolBar.Separator {
        private boolean _showSeparator;

        @Override
        public void paintComponent(Graphics g) {
            if (this._showSeparator) {
                super.paintComponent(g);
            }
        }

        public void showSeparator(boolean b) {
            this._showSeparator = b;
        }
    }

    private final class Subcomponents {
        final JLabel handle = new JLabel(IdeIcons.getIcon((int)11));
        final Toolbar buttons;
        final DrawerLabel title;
        final JComponent customToolbar;

        Subcomponents(String text, Toolbar customToolbar) {
            Icon icon;
            Color fg = null;
            if (Themes.isThemed()) {
                this.buttons = new Toolbar();
                ThemeProperties properties = Themes.getActiveTheme().getStateProperties("accordion.expand", "default");
                icon = properties.getIcon("icon");
                properties = Themes.getActiveTheme().getStateProperties("accordion", "default");
                fg = properties.getColor("foreground");
            } else {
                this.buttons = new MyToolbar();
                icon = this.rotatingIcon();
            }
            this.title = new DrawerLabel(text, icon, 10);
            DrawerUI.this.updateAccessibleName(this.title);
            if (fg != null) {
                this.title.setForeground(fg);
            }
            this.title.setBorder(TITLE_BORDER);
            JComponent jComponent = this.customToolbar = this.visibleToolbar(customToolbar) ? customToolbar : this.fakeToolbar();
            if (customToolbar != null && customToolbar.getComponents() != null) {
                DrawerUI.this.setComponentsNamesInToolbar(customToolbar.getComponents());
            }
            this.init();
        }

        private JComponent fakeToolbar() {
            return (JComponent)Box.createVerticalStrut(18);
        }

        private boolean visibleToolbar(Toolbar customToolbar) {
            return customToolbar != null && customToolbar.isVisible();
        }

        private Icon rotatingIcon() {
            return new RotatingIcon(OracleIcons.getIcon((String)"extras/accordion_open.png"));
        }

        private void init() {
            this.setUpDropDownButtons();
            this.disableRequestForFocus();
            this.registerMouseAdapter();
            this.setUpCustomToolbar();
        }

        private void setUpDropDownButtons() {
            this.buttons.setOpaque(false);
            this.buttons.setBorderPainted(false);
        }

        private void disableRequestForFocus() {
            this.handle.setRequestFocusEnabled(false);
            this.title.setRequestFocusEnabled(false);
        }

        private void registerMouseAdapter() {
            MouseAdapter mouseAdapter = new MouseAdapter();
            mouseAdapter.registerWith(this.handle);
            mouseAdapter.registerWith(this.title);
            DrawerUI.this.dropDownMouseOver.registerWith(this.handle);
            DrawerUI.this.dropDownMouseOver.registerWith(this.title);
        }

        private void setUpCustomToolbar() {
            if (this.customToolbar == null) {
                return;
            }
            this.customToolbar.setOpaque(false);
            this.customToolbar.setBorder(BorderFactory.createEmptyBorder());
            if (this.customToolbar instanceof Toolbar) {
                ((Toolbar)this.customToolbar).setPrimaryViewToolbar(false);
            }
        }
    }

    private final class MouseAdapter
    implements MouseListener,
    MouseMotionListener,
    ActionListener {
        private MouseAdapter() {
        }

        void registerWith(Component host) {
            host.addMouseListener(this);
            host.addMouseMotionListener(this);
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            if (((DrawerUI)DrawerUI.this).subcomponents.title == event.getSource()) {
                DrawerUI.this.expand(event);
            }
        }

        @Override
        public void mousePressed(MouseEvent event) {
            DrawerUI.this.parent().mousePressed(DrawerUI.this, event);
            DrawerUI.this.parent().activate(DrawerUI.this);
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            DrawerUI.this.parent().mouseReleased(DrawerUI.this, event);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent event) {
            DrawerUI.this.parent().mouseDragged(DrawerUI.this, event);
        }

        @Override
        public void mouseMoved(MouseEvent event) {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (this.minimizeHandled(event.getActionCommand())) {
                return;
            }
            this.maximizeHandled(event.getActionCommand());
        }

        private boolean minimizeHandled(String actionCommand) {
            if (!"Minimize".equals(actionCommand)) {
                return false;
            }
            DrawerUI.this.minimize();
            return true;
        }

        private boolean maximizeHandled(String actionCommand) {
            if (!"Maximize".equals(actionCommand)) {
                return false;
            }
            DrawerUI.this.maximize();
            return true;
        }
    }

    private final class DropDownMouseOver
    extends java.awt.event.MouseAdapter
    implements MouseMotionListener,
    PopupMenuListener {
        private boolean canHideIcon = true;

        private DropDownMouseOver() {
        }

        private void registerWith(Component c) {
            c.addMouseListener(this);
            c.addMouseMotionListener(this);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.updateCursor(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.showIcon();
            this.updateCursor(e);
            DrawerUI.this.mouseOver = true;
            if (DrawerUI.this.subcomponents != null) {
                ((DrawerUI)DrawerUI.this).subcomponents.title.setMouseOver(DrawerUI.this.mouseOver);
            }
            DrawerUI.this.updateLabelIcon();
            DrawerUI.this.repaint();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.hideIcon();
            this.updateCursor(e);
            DrawerUI.this.mouseOver = false;
            if (DrawerUI.this.subcomponents != null) {
                ((DrawerUI)DrawerUI.this).subcomponents.title.setMouseOver(DrawerUI.this.mouseOver);
            }
            DrawerUI.this.updateLabelIcon();
            DrawerUI.this.repaint();
            this.canHideIcon = true;
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            this.showIcon();
            this.canHideIcon = false;
            DrawerUI.this.menuRaised = true;
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            DrawerUI.this.menuRaised = false;
            this.hideIcon();
            this.canHideIcon = true;
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
            this.canHideIcon = true;
            DrawerUI.this.menuRaised = false;
        }

        void showIcon() {
            if (DrawerUI.this.dropDownButton == null) {
                return;
            }
            if (!Themes.isThemed()) {
                DrawerUI.this.dropDownButton.setIcon(OracleIcons.getIcon((String)"accordion_dropdown_mouseover.png"));
            } else {
                ThemeProperties properties = Themes.getActiveTheme().getStateProperties("accordion.dropdown", "inactive");
                DrawerUI.this.dropDownButton.setIcon(properties.getIcon("icon"));
                properties = Themes.getActiveTheme().getStateProperties("accordion.dropdown", "active");
                DrawerUI.this.dropDownButton.setRolloverIcon(properties.getIcon("icon"));
            }
            if (DrawerUI.this._separator != null) {
                DrawerUI.this._separator.showSeparator(true);
            }
        }

        void hideIcon() {
            if (DrawerUI.this.dropDownButton == null || !this.canHideIcon || DrawerUI.this.menuRaised) {
                return;
            }
            if (!Themes.isThemed()) {
                DrawerUI.this.dropDownButton.setIcon(OracleIcons.getIcon((String)"accordion_dropdown_invisible.png"));
            } else {
                ThemeProperties properties = Themes.getActiveTheme().getStateProperties("accordion.dropdown", "invisible");
                DrawerUI.this.dropDownButton.setIcon(properties.getIcon("icon"));
            }
            if (DrawerUI.this._separator != null) {
                DrawerUI.this._separator.showSeparator(false);
            }
        }

        void updateCursor(MouseEvent e) {
            int y;
            if (e.getID() == 505) {
                this.hideMoveCursor();
            }
            if ((y = e.getY()) >= 0 && y < 3 || y > DrawerUI.this.heightForPainting() - 3 && y < DrawerUI.this.heightForPainting()) {
                this.showMoveCursor();
            } else {
                this.hideMoveCursor();
            }
        }

        void hideMoveCursor() {
            DrawerUI.this.setCursor(Cursor.getDefaultCursor());
        }

        void showMoveCursor() {
            if (DrawerUI.this.isTopDrawer()) {
                return;
            }
            DrawerUI.this.setCursor(Cursor.getPredefinedCursor(9));
        }
    }
}

