/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.editor;

import java.awt.Component;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorInfo;
import oracle.ide.editor.EditorListener;
import oracle.ide.editor.EditorPath;
import oracle.ide.editor.EditorUtil;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.layout.BaseLayoutListener;
import oracle.ide.layout.PreferredLayoutListener;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.javatools.jndi.Names;
import org.openide.util.Lookup;

public abstract class EditorManager
implements Controller,
Addin {
    public static final int SHOW_DROPDOWN_CMD_ID = Ide.findOrCreateCmdID("SHOW_DROPDOWN_CMD_ID");
    private static final String EDITOR_MANAGER_NAME = "ide/editor-manager";
    private static NullEditorManager nullEditorManager = null;

    public static EditorManager getEditorManager() {
        if (Boolean.getBoolean("editor.manager.test.mode")) {
            return (EditorManager)Lookup.getDefault().lookup(EditorManager.class);
        }
        if (!Ide.getIdeArgs().getCreateUI()) {
            if (nullEditorManager == null) {
                nullEditorManager = new NullEditorManager();
            }
            return nullEditorManager;
        }
        EditorManager em = (EditorManager)Lookup.getDefault().lookup(EditorManager.class);
        if (em != null) {
            return em;
        }
        return (EditorManager)Names.lookup((javax.naming.Context)Names.newInitialContext(), (String)EDITOR_MANAGER_NAME);
    }

    public static void setEditorManager(EditorManager editorManager) {
        Names.bind((javax.naming.Context)Names.newInitialContext(), (String)EDITOR_MANAGER_NAME, (Object)editorManager);
    }

    public abstract void register(EditorAddin var1, Class[] var2);

    public abstract void unregister(EditorAddin var1);

    public abstract void registerDynamic(EditorAddin var1);

    public abstract void unregisterDynamic(EditorAddin var1);

    public abstract void extend(EditorAddin var1, Class[] var2);

    public abstract boolean isEditorRegistered(Class var1);

    public abstract EditorAddin getEditorAddin(Class var1);

    public abstract EditorAddin getBestEditorAddin(Node var1);

    public abstract EditorAddin getBestEditorAddin(Context var1);

    public abstract EditorAddin getDefaultAddin(Element var1);

    public abstract EditorAddin getDefaultAddin(Context var1);

    @Deprecated
    public abstract EditorAddin[] getStaticAddins(Class var1);

    public abstract EditorAddin[] getStaticAddins(String var1);

    @Deprecated
    public abstract Class[] getStaticElementTypes();

    public abstract String[] getStaticElementClassNames();

    public abstract void addEditorListener(EditorListener var1);

    public abstract void removeEditorListener(EditorListener var1);

    public abstract void activateCurrentEditorFrame();

    public Editor openDefaultEditorInFrame(URL url) {
        return EditorUtil.openDefaultEditorInFrame(url);
    }

    public abstract Editor openDefaultEditorInFrame(Context var1);

    public abstract Editor openEditorInFrame(Class var1, Context var2);

    public abstract Editor openEditor(OpenEditorOptions var1);

    public abstract void replaceEditors(Context var1, Context var2);

    public abstract List<Editor> findEditors(Context var1);

    public abstract Editor findEditor(EditorPath var1);

    public abstract List<Editor> getAllEditors();

    public abstract JComponent getDesktopComponent();

    public abstract Editor getCurrentEditor();

    public abstract void requestAttention(Editor var1, boolean var2);

    public abstract void cancelRequestAttention(Editor var1);

    public abstract void makeBusy(Editor var1, boolean var2);

    @Override
    public abstract void initialize();

    public abstract void addLayoutListener(String var1, BaseLayoutListener var2);

    public abstract void removeLayoutListener(String var1);

    public abstract ContextMenu getContextMenu();

    public abstract void closeEditors(List var1);

    public abstract List<EditorInfo> getEditorsInfo();

    public abstract void activateEditor(EditorInfo var1);

    public abstract void setExplicit(Editor var1, boolean var2);

    public abstract void registerPreferredLayoutListener(Class var1, Class var2, String var3, PreferredLayoutListener var4);

    public abstract EditorPath searchEditor(Node var1);

    public void setEditorFloating(Editor editor, boolean floating) {
        throw new IllegalStateException("Method not implemented in this window manager");
    }

    @Deprecated
    public boolean hasEditors(Element element) {
        return false;
    }

    public boolean hasEditors(Context context) {
        return false;
    }

    public boolean activateEditorHasComponent(Component comp) {
        return false;
    }

    public abstract void refreshEditorUI(Editor var1);

    private static class NullEditorManager
    extends EditorManager {
        private NullEditorManager() {
        }

        @Override
        public void register(EditorAddin addin, Class[] types) {
        }

        @Override
        public void unregister(EditorAddin editorAddin) {
        }

        @Override
        public void registerDynamic(EditorAddin editorAddin) {
        }

        @Override
        public void unregisterDynamic(EditorAddin editorAddin) {
        }

        @Override
        public void extend(EditorAddin addin, Class[] types) {
        }

        @Override
        public boolean isEditorRegistered(Class cls) {
            return false;
        }

        @Override
        public EditorAddin getEditorAddin(Class cls) {
            return null;
        }

        @Override
        public EditorAddin getBestEditorAddin(Node node) {
            return null;
        }

        @Override
        public EditorAddin getDefaultAddin(Element element) {
            return null;
        }

        @Override
        public EditorAddin[] getStaticAddins(Class elementClass) {
            return new EditorAddin[0];
        }

        @Override
        public EditorAddin[] getStaticAddins(String elementClassName) {
            return new EditorAddin[0];
        }

        @Override
        public Class[] getStaticElementTypes() {
            return new Class[0];
        }

        @Override
        public String[] getStaticElementClassNames() {
            return new String[0];
        }

        @Override
        public void addEditorListener(EditorListener listener) {
        }

        @Override
        public void removeEditorListener(EditorListener listener) {
        }

        @Override
        public void activateCurrentEditorFrame() {
        }

        @Override
        public Editor openDefaultEditorInFrame(Context context) {
            return null;
        }

        @Override
        public Editor openEditorInFrame(Class editorClass, Context context) {
            return null;
        }

        @Override
        public Editor openEditor(OpenEditorOptions openEditorOptions) {
            return null;
        }

        @Override
        public void replaceEditors(Context oldContext, Context newContext) {
        }

        @Override
        public List<Editor> findEditors(Context context) {
            return Collections.emptyList();
        }

        @Override
        public List<Editor> getAllEditors() {
            return Collections.emptyList();
        }

        @Override
        public JComponent getDesktopComponent() {
            return null;
        }

        @Override
        public Editor getCurrentEditor() {
            return null;
        }

        @Override
        public void initialize() {
        }

        @Override
        public void addLayoutListener(String editorId, BaseLayoutListener listener) {
        }

        @Override
        public void removeLayoutListener(String editorId) {
        }

        @Override
        public ContextMenu getContextMenu() {
            return null;
        }

        @Override
        public void closeEditors(List listEditors) {
        }

        @Override
        public List<EditorInfo> getEditorsInfo() {
            return Collections.emptyList();
        }

        @Override
        public void activateEditor(EditorInfo editorInfo) {
        }

        @Override
        public void setExplicit(Editor editor, boolean bExplicit) {
        }

        @Override
        public void registerPreferredLayoutListener(Class nodeClass, Class editorClass, String preferredLayoutBaseName, PreferredLayoutListener listener) {
        }

        @Override
        public EditorPath searchEditor(Node node) {
            return null;
        }

        @Override
        public boolean handleEvent(IdeAction action, Context context) {
            return false;
        }

        @Override
        public boolean update(IdeAction action, Context context) {
            return false;
        }

        @Override
        public EditorAddin getBestEditorAddin(Context context) {
            return null;
        }

        @Override
        public EditorAddin getDefaultAddin(Context context) {
            return null;
        }

        @Override
        public Editor findEditor(EditorPath path) {
            return null;
        }

        @Override
        public void requestAttention(Editor editor, boolean brief) {
        }

        @Override
        public void cancelRequestAttention(Editor editor) {
        }

        @Override
        public void makeBusy(Editor editor, boolean busy) {
        }

        @Override
        public void setEditorFloating(Editor editor, boolean floating) {
        }

        @Override
        public void refreshEditorUI(Editor editor) {
        }
    }
}

