/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.editor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.ide.editor.RecentFile;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.Copyable;

public class EditorsOptions
extends HashStructureAdapter
implements Copyable {
    public static final String KEY_SETTINGS = "editors-options";
    private static final String LRU_FILES = "lruFiles";
    private static final String RECENT_FILES_SHOW_ALL = "recentFilesShowAll";
    private static final String RECENT_FILES_SHOW_CLOSED_ONLY = "recentFilesShowClosedOnly";

    public EditorsOptions() {
        this(HashStructure.newInstance());
    }

    public EditorsOptions(HashStructure hash) {
        super(hash);
    }

    public static EditorsOptions getInstance(PropertyStorage prefs) {
        return new EditorsOptions(EditorsOptions.findOrCreate((PropertyStorage)prefs, (String)KEY_SETTINGS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<RecentFile> getLruFiles() {
        ArrayList<RecentFile> ret = new ArrayList<RecentFile>();
        ListStructure list = this._hash.getListStructure(LRU_FILES);
        if (list != null) {
            Object object = list.iteratorLock();
            synchronized (object) {
                for (Object next : list) {
                    if (!(next instanceof HashStructure)) continue;
                    ret.add(new RecentFile((HashStructure)next));
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLruFiles(ArrayList lruFiles) {
        ListStructure newList = ListStructure.newInstance();
        if (lruFiles != null) {
            for (Object next : lruFiles) {
                if (!(next instanceof RecentFile)) continue;
                HashStructure hash = HashStructure.newInstance();
                newList.add((Object)hash);
                RecentFile recentFile = new RecentFile(hash);
                ((RecentFile)((Object)next)).copyTo((Object)recentFile);
            }
        }
        ListStructure realList = this._hash.getOrCreateListStructure(LRU_FILES);
        Object object = realList.iteratorLock();
        synchronized (object) {
            realList.mirror((List)newList);
        }
    }

    public boolean isRecentFilesShowAll() {
        return this._hash.getBoolean(RECENT_FILES_SHOW_ALL);
    }

    public void setRecentFilesShowAll(boolean showAll) {
        this._hash.putBoolean(RECENT_FILES_SHOW_ALL, showAll);
    }

    public boolean isRecentFilesShowClosedOnly() {
        return this._hash.getBoolean(RECENT_FILES_SHOW_CLOSED_ONLY, true);
    }

    public void setRecentFilesShowClosedOnly(boolean showClosedOnly) {
        this._hash.putBoolean(RECENT_FILES_SHOW_CLOSED_ONLY, showClosedOnly);
    }

    public Map getEditorsData() {
        return null;
    }

    public void setEditorsData(Map map) {
    }
}

